/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.explorer.ExplorerComponent;
import org.graalvm.visualvm.core.explorer.ExplorerExpansionListener;
import org.graalvm.visualvm.core.explorer.ExplorerModelBuilder;
import org.graalvm.visualvm.core.explorer.ExplorerNode;
import org.graalvm.visualvm.core.explorer.ExplorerSelectionListener;
import org.openide.windows.WindowManager;

public final class ExplorerSupport {
    private static ExplorerSupport sharedInstance;
    private JTree mainTree;
    private Set<ExplorerSelectionListener> selectionListeners = Collections.synchronizedSet(new HashSet());
    private Set<ExplorerExpansionListener> expansionListeners = Collections.synchronizedSet(new HashSet());

    public static synchronized ExplorerSupport sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ExplorerSupport();
        }
        return sharedInstance;
    }

    public int getDataSourcePosition(DataSource dataSource) {
        ExplorerNode node = this.getNode(dataSource);
        if (node == null) {
            return -1;
        }
        ExplorerNode parentNode = (ExplorerNode)node.getParent();
        if (parentNode == null) {
            return -1;
        }
        return parentNode.getIndex(node);
    }

    public void selectDataSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        this.selectDataSources(Collections.singleton(dataSource));
    }

    public void selectDataSources(final Set<DataSource> dataSources) {
        if (dataSources.isEmpty()) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
                for (DataSource dataSource : dataSources) {
                    ExplorerNode node = ExplorerSupport.this.getNode(dataSource);
                    if (node == null) continue;
                    selectedPaths.add(ExplorerSupport.this.getPath(node));
                }
                ExplorerSupport.this.mainTree.setSelectionPaths(selectedPaths.isEmpty() ? null : selectedPaths.toArray(new TreePath[selectedPaths.size()]));
            }
        });
    }

    public void clearSelection() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ExplorerSupport.this.mainTree.clearSelection();
            }
        });
    }

    public Set<DataSource> getSelectedDataSources() {
        if (this.mainTree == null) {
            return Collections.EMPTY_SET;
        }
        TreePath[] selectedPaths = this.mainTree.getSelectionPaths();
        if (selectedPaths == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DataSource> selectedDataSources = new HashSet<DataSource>();
        for (TreePath treePath : selectedPaths) {
            DataSource dataSource = this.getDataSource(treePath);
            if (dataSource == null) continue;
            selectedDataSources.add(dataSource);
        }
        return selectedDataSources;
    }

    public void addSelectionListener(ExplorerSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ExplorerSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void expandDataSource(DataSource dataSource) {
        this.expandNode(this.getNode(dataSource));
    }

    void expandNode(final ExplorerNode node) {
        if (node == null) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                TreePath path = ExplorerSupport.this.getPath(node);
                ExplorerSupport.this.mainTree.expandPath(path);
                ExplorerSupport.this.mainTree.expandPath(path);
            }
        });
    }

    public void collapseDataSource(DataSource dataSource) {
        this.collapseNode(this.getNode(dataSource));
    }

    void collapseNode(final ExplorerNode node) {
        if (node == null) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ExplorerSupport.this.mainTree.collapsePath(ExplorerSupport.this.getPath(node));
            }
        });
    }

    public void addExpansionListener(ExplorerExpansionListener listener) {
        this.expansionListeners.add(listener);
    }

    public void removeExpansionListener(ExplorerExpansionListener listener) {
        this.expansionListeners.remove(listener);
    }

    DataSource getDataSource(TreePath path) {
        if (path == null) {
            return null;
        }
        ExplorerNode node = (ExplorerNode)path.getLastPathComponent();
        return node.getUserObject();
    }

    ExplorerNode getNode(DataSource dataSource) {
        return ExplorerModelBuilder.getInstance().getNodeFor(dataSource);
    }

    TreePath getPath(ExplorerNode node) {
        return new TreePath(node.getPath());
    }

    private ExplorerSupport() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ExplorerSupport.this.mainTree = ExplorerComponent.instance().getTree();
                ExplorerSupport.this.mainTree.addTreeSelectionListener(new ExplorerTreeSelectionListener());
                ExplorerSupport.this.mainTree.addTreeExpansionListener(new ExplorerTreeExpansionListener());
            }
        });
    }

    private class ExplorerTreeExpansionListener
    implements TreeExpansionListener {
        private ExplorerTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            DataSource expandedDataSource = ExplorerSupport.this.getDataSource(event.getPath());
            if (expandedDataSource != null) {
                HashSet listeners = new HashSet(ExplorerSupport.this.expansionListeners);
                for (ExplorerExpansionListener listener : listeners) {
                    listener.dataSourceExpanded(expandedDataSource);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            DataSource collapsedDataSource = ExplorerSupport.this.getDataSource(event.getPath());
            if (collapsedDataSource != null) {
                HashSet listeners = new HashSet(ExplorerSupport.this.expansionListeners);
                for (ExplorerExpansionListener listener : listeners) {
                    listener.dataSourceCollapsed(collapsedDataSource);
                }
            }
        }
    }

    private class ExplorerTreeSelectionListener
    implements TreeSelectionListener {
        private ExplorerTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Set<DataSource> selectedDataSources = ExplorerSupport.this.getSelectedDataSources();
            HashSet listeners = new HashSet(ExplorerSupport.this.selectionListeners);
            for (ExplorerSelectionListener listener : listeners) {
                listener.selectionChanged(selectedDataSources);
            }
        }
    }
}

