/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.GeneratedPlugin;
import org.graalvm.compiler.replacements.processor.InjectedDependencies;

public abstract class GeneratedNodeIntrinsicPlugin
extends GeneratedPlugin {
    private final TypeMirror[] signature;

    public GeneratedNodeIntrinsicPlugin(ExecutableElement intrinsicMethod, TypeMirror[] signature) {
        super(intrinsicMethod);
        this.signature = signature;
    }

    @Override
    protected TypeElement getAnnotationClass(AbstractProcessor processor) {
        return processor.getTypeElement("org.graalvm.compiler.graph.Node.NodeIntrinsic");
    }

    protected abstract List<? extends VariableElement> getParameters();

    protected abstract void factoryCall(AbstractProcessor var1, PrintWriter var2, InjectedDependencies var3, int var4);

    @Override
    protected InjectedDependencies createExecute(AbstractProcessor processor, PrintWriter out) {
        VariableElement param;
        int idx;
        InjectedDependencies deps = new InjectedDependencies();
        List<? extends VariableElement> params = this.getParameters();
        for (idx = 0; idx < params.size() && processor.getAnnotation((Element)(param = params.get(idx)), processor.getType("org.graalvm.compiler.graph.Node.InjectedNodeParameter")) != null; ++idx) {
            out.printf("        %s arg%d = %s;\n", param.asType(), idx, deps.use(processor, (DeclaredType)param.asType()));
        }
        int i = 0;
        while (i < this.signature.length) {
            if (processor.getAnnotation((Element)this.intrinsicMethod.getParameters().get(i), processor.getType("org.graalvm.compiler.graph.Node.ConstantNodeParameter")) != null) {
                GeneratedNodeIntrinsicPlugin.constantArgument(processor, out, deps, idx, this.signature[i], i);
            } else if (this.signature[i].equals(processor.getType("org.graalvm.compiler.nodes.ValueNode"))) {
                out.printf("        ValueNode arg%d = args[%d];\n", idx, i);
            } else {
                out.printf("        %s arg%d = (%s) args[%d];\n", this.signature[i], idx, this.signature[i], i);
            }
            ++i;
            ++idx;
        }
        this.factoryCall(processor, out, deps, idx);
        return deps;
    }

    public static class CustomFactoryPlugin
    extends GeneratedNodeIntrinsicPlugin {
        private final ExecutableElement customFactory;

        public CustomFactoryPlugin(ExecutableElement intrinsicMethod, ExecutableElement customFactory, TypeMirror[] signature) {
            super(intrinsicMethod, signature);
            this.customFactory = customFactory;
        }

        @Override
        public void extraImports(Set<String> imports) {
        }

        @Override
        protected List<? extends VariableElement> getParameters() {
            List<? extends VariableElement> ret = this.customFactory.getParameters();
            return ret.subList(2, ret.size());
        }

        @Override
        protected void factoryCall(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argCount) {
            out.printf("        return %s.%s(b, targetMethod", this.customFactory.getEnclosingElement(), this.customFactory.getSimpleName());
            for (int i = 0; i < argCount; ++i) {
                out.printf(", arg%d", i);
            }
            out.printf(");\n", new Object[0]);
        }
    }

    public static class ConstructorPlugin
    extends GeneratedNodeIntrinsicPlugin {
        private final ExecutableElement constructor;

        public ConstructorPlugin(ExecutableElement intrinsicMethod, ExecutableElement constructor, TypeMirror[] signature) {
            super(intrinsicMethod, signature);
            this.constructor = constructor;
        }

        @Override
        public void extraImports(Set<String> imports) {
            if (this.intrinsicMethod.getReturnType().getKind() != TypeKind.VOID) {
                imports.add("jdk.vm.ci.meta.JavaKind");
            }
        }

        @Override
        protected List<? extends VariableElement> getParameters() {
            return this.constructor.getParameters();
        }

        @Override
        protected void factoryCall(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argCount) {
            out.printf("        %s node = new %s(", this.constructor.getEnclosingElement(), this.constructor.getEnclosingElement());
            if (argCount > 0) {
                out.printf("arg0", new Object[0]);
                for (int i = 1; i < argCount; ++i) {
                    out.printf(", arg%d", i);
                }
            }
            out.printf(");\n", new Object[0]);
            if (this.intrinsicMethod.getReturnType().getKind() == TypeKind.VOID) {
                out.printf("        b.add(node);\n", new Object[0]);
            } else {
                out.printf("        b.addPush(JavaKind.%s, node);\n", ConstructorPlugin.getReturnKind(this.intrinsicMethod));
            }
            out.printf("        return true;\n", new Object[0]);
        }
    }
}

