/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.GeneratedPlugin;
import org.graalvm.compiler.replacements.processor.ReplacementsAnnotationProcessor;

public class PluginGenerator {
    private final Map<Element, List<GeneratedPlugin>> plugins = new HashMap<Element, List<GeneratedPlugin>>();

    public void addPlugin(GeneratedPlugin plugin) {
        Element topLevel = PluginGenerator.getTopLevelClass(plugin.intrinsicMethod);
        List<GeneratedPlugin> list = this.plugins.get(topLevel);
        if (list == null) {
            list = new ArrayList<GeneratedPlugin>();
            this.plugins.put(topLevel, list);
        }
        list.add(plugin);
    }

    public void generateAll(AbstractProcessor processor) {
        for (Map.Entry<Element, List<GeneratedPlugin>> entry : this.plugins.entrySet()) {
            PluginGenerator.disambiguateNames(entry.getValue());
            PluginGenerator.createPluginFactory(processor, entry.getKey(), entry.getValue());
        }
    }

    private static Element getTopLevelClass(Element element) {
        Element prev = element;
        for (Element enclosing = element.getEnclosingElement(); enclosing != null && enclosing.getKind() != ElementKind.PACKAGE; enclosing = enclosing.getEnclosingElement()) {
            prev = enclosing;
        }
        return prev;
    }

    private static void disambiguateWith(List<GeneratedPlugin> plugins, Function<GeneratedPlugin, String> genName) {
        plugins.sort(Comparator.comparing(GeneratedPlugin::getPluginName));
        GeneratedPlugin current = plugins.get(0);
        String currentName = current.getPluginName();
        for (int i = 1; i < plugins.size(); ++i) {
            GeneratedPlugin next = plugins.get(i);
            if (currentName.equals(next.getPluginName())) {
                if (current != null) {
                    current.setPluginName(genName.apply(current));
                    current = null;
                }
                next.setPluginName(genName.apply(next));
                continue;
            }
            current = next;
            currentName = current.getPluginName();
        }
    }

    private static void disambiguateNames(List<GeneratedPlugin> plugins) {
        int[] nextId = new int[]{0};
        PluginGenerator.disambiguateWith(plugins, plugin -> {
            int n = nextId[0];
            nextId[0] = n + 1;
            return plugin.getPluginName() + "__" + n;
        });
    }

    private static void createPluginFactory(AbstractProcessor processor, Element topLevelClass, List<GeneratedPlugin> plugins) {
        PackageElement pkg = (PackageElement)topLevelClass.getEnclosingElement();
        String genClassName = "PluginFactory_" + topLevelClass.getSimpleName();
        String qualifiedGenClassName = pkg.getQualifiedName() + "." + genClassName;
        try {
            JavaFileObject factory = processor.env().getFiler().createSourceFile(qualifiedGenClassName, topLevelClass);
            try (PrintWriter out = new PrintWriter(factory.openWriter());){
                out.printf("// CheckStyle: stop header check\n", new Object[0]);
                out.printf("// CheckStyle: stop line length check\n", new Object[0]);
                out.printf("// GENERATED CONTENT - DO NOT EDIT\n", new Object[0]);
                out.printf("// GENERATORS: %s, %s\n", ReplacementsAnnotationProcessor.class.getName(), PluginGenerator.class.getName());
                out.printf("package %s;\n", pkg.getQualifiedName());
                out.printf("\n", new Object[0]);
                PluginGenerator.createImports(out, plugins);
                out.printf("\n", new Object[0]);
                for (GeneratedPlugin plugin : plugins) {
                    plugin.generate(processor, out);
                    out.printf("\n", new Object[0]);
                }
                out.printf("public class %s implements NodeIntrinsicPluginFactory {\n", genClassName);
                PluginGenerator.createPluginFactoryMethod(out, plugins);
                out.printf("}\n", new Object[0]);
            }
        }
        catch (IOException e) {
            processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        processor.createProviderFile(qualifiedGenClassName, "org.graalvm.compiler.nodes.graphbuilderconf.NodeIntrinsicPluginFactory", new Element[]{topLevelClass});
    }

    protected static void createImports(PrintWriter out, List<GeneratedPlugin> plugins) {
        out.printf("import jdk.vm.ci.meta.ResolvedJavaMethod;\n", new Object[0]);
        out.printf("\n", new Object[0]);
        out.printf("import java.lang.annotation.Annotation;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.ValueNode;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;\n", new Object[0]);
        out.printf("import org.graalvm.compiler.nodes.graphbuilderconf.NodeIntrinsicPluginFactory;\n", new Object[0]);
        HashSet<String> extra = new HashSet<String>();
        for (GeneratedPlugin plugin : plugins) {
            plugin.extraImports(extra);
        }
        if (!extra.isEmpty()) {
            out.printf("\n", new Object[0]);
            for (String i : extra) {
                out.printf("import %s;\n", i);
            }
        }
    }

    private static void createPluginFactoryMethod(PrintWriter out, List<GeneratedPlugin> plugins) {
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public void registerPlugins(InvocationPlugins plugins, NodeIntrinsicPluginFactory.InjectionProvider injection) {\n", new Object[0]);
        for (GeneratedPlugin plugin : plugins) {
            plugin.register(out);
        }
        out.printf("    }\n", new Object[0]);
    }
}

