/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.llvm.LLVMUtils;

public class LLVMStackMapInfo {
    private StackMap stackMap;
    private Map<Long, Function> patchpointToFunction = new HashMap<Long, Function>();
    private Map<Long, Set<Record>> patchpointsByID = new HashMap<Long, Set<Record>>();
    private static final int STATEPOINT_HEADER_LOCATION_COUNT = 3;
    private static final int STATEPOINT_DEOPT_COUNT_LOCATION_INDEX = 2;

    public LLVMStackMapInfo(ByteBuffer buffer) {
        int i;
        this.stackMap = new StackMap();
        int offset = 0;
        this.stackMap.version = buffer.get(offset);
        ++offset;
        ++offset;
        this.stackMap.functions = new Function[buffer.getInt(offset += 2)];
        this.stackMap.constants = new long[buffer.getInt(offset += 4)];
        int numRecords = buffer.getInt(offset += 4);
        offset += 4;
        long totalNumRecords = 0L;
        for (i = 0; i < this.stackMap.functions.length; ++i) {
            Function function = new Function();
            function.address = buffer.getLong(offset);
            function.stackSize = buffer.getLong(offset += 8);
            function.records = new Record[NumUtil.safeToInt((long)buffer.getLong(offset += 8))];
            offset += 8;
            this.stackMap.functions[i] = function;
            totalNumRecords += (long)function.records.length;
        }
        for (i = 0; i < this.stackMap.constants.length; ++i) {
            this.stackMap.constants[i] = buffer.getLong(offset);
            offset += 8;
        }
        int fun = 0;
        int rec = 0;
        assert ((long)numRecords == totalNumRecords);
        int i2 = 0;
        while (i2 < numRecords) {
            int j;
            while (rec == this.stackMap.functions[fun].records.length) {
                ++fun;
                rec = 0;
            }
            Function function = this.stackMap.functions[fun];
            Record record = new Record();
            record.patchpointID = buffer.getLong(offset);
            record.instructionOffset = buffer.getInt(offset += 8);
            record.flags = buffer.getShort(offset += 4);
            record.locations = new Location[buffer.getShort(offset += 2)];
            offset += 2;
            for (j = 0; j < record.locations.length; ++j) {
                Location location = new Location();
                location.type = Location.Type.decode(buffer.get(offset));
                ++offset;
                location.size = buffer.getShort(++offset);
                location.regNum = buffer.getShort(offset += 2);
                offset += 2;
                location.offset = buffer.getInt(offset += 2);
                offset += 4;
                record.locations[j] = location;
            }
            if (offset % 8 != 0) {
                offset += 4;
            }
            record.liveOuts = new LiveOut[buffer.getShort(offset += 2)];
            offset += 2;
            for (j = 0; j < record.liveOuts.length; ++j) {
                LiveOut liveOut = new LiveOut();
                liveOut.regNum = buffer.getShort(offset);
                offset += 2;
                liveOut.size = buffer.get(++offset);
                ++offset;
                record.liveOuts[j] = liveOut;
            }
            if (offset % 8 != 0) {
                offset += 4;
            }
            function.records[rec] = record;
            if (this.patchpointToFunction.containsKey(record.patchpointID)) assert (record.patchpointID == 2882400000L || this.patchpointToFunction.get(record.patchpointID) == function);
            this.patchpointToFunction.put(record.patchpointID, function);
            this.patchpointsByID.computeIfAbsent(record.patchpointID, v -> new HashSet()).add(record);
            ++i2;
            ++rec;
        }
    }

    public long getFunctionStackSize(long startPatchpointID) {
        assert (this.patchpointToFunction.containsKey(startPatchpointID));
        return this.patchpointToFunction.get((Object)Long.valueOf((long)startPatchpointID)).stackSize;
    }

    private long getFunctionOffset(long startPatchpointID) {
        assert (this.patchpointToFunction.containsKey(startPatchpointID));
        return this.patchpointToFunction.get((Object)Long.valueOf((long)startPatchpointID)).address;
    }

    public int[] getPatchpointOffsets(long patchpointID) {
        if (this.patchpointsByID.containsKey(patchpointID)) {
            return this.patchpointsByID.get(patchpointID).stream().mapToInt(r -> r.instructionOffset).toArray();
        }
        return new int[0];
    }

    public void forEachStatepointOffset(long patchpointID, int instructionOffset, BiConsumer<Integer, Integer> callback) {
        Location[] locations = this.patchpointsByID.get((Object)Long.valueOf((long)patchpointID)).stream().filter((Predicate<Record>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$forEachStatepointOffset$2(int com.oracle.svm.core.graal.llvm.LLVMStackMapInfo$Record ), (Lcom/oracle/svm/core/graal/llvm/LLVMStackMapInfo$Record;)Z)((int)instructionOffset)).findFirst().orElseThrow((Supplier<RuntimeException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, shouldNotReachHere(), ()Ljava/lang/RuntimeException;)()).locations;
        assert (locations.length >= 3);
        Location deoptCountLocation = locations[2];
        assert (deoptCountLocation.type == Location.Type.Constant);
        int deoptCount = deoptCountLocation.offset;
        assert (3 + deoptCount <= locations.length);
        HashSet<Integer> seenOffsets = new HashSet<Integer>();
        HashSet<Integer> seenBases = new HashSet<Integer>();
        for (int i = 3 + deoptCount; i < locations.length; i += 2) {
            assert (i + 1 < locations.length);
            Location base = locations[i];
            Location ref = locations[i + 1];
            if (base.type == Location.Type.Constant || ref.type == Location.Type.Constant) {
                assert (base.type == ref.type && base.offset == ref.offset);
                if (base.offset == 0) continue;
                seenBases.add((int)((long)base.offset - this.getFunctionOffset(patchpointID)));
                seenOffsets.add((int)((long)ref.offset - this.getFunctionOffset(patchpointID)));
                continue;
            }
            assert (base.type == Location.Type.Indirect);
            int baseOffset = this.getStackOffset(patchpointID, base);
            seenBases.add(baseOffset);
            assert (ref.type == Location.Type.Indirect);
            int derivedOffset = this.getStackOffset(patchpointID, ref);
            if (seenOffsets.contains(derivedOffset)) continue;
            seenOffsets.add(derivedOffset);
            callback.accept(derivedOffset, baseOffset);
        }
        assert (seenOffsets.containsAll(seenBases));
    }

    public int getAllocaOffset(long startPatchPointId) {
        Set<Record> startRecords = this.patchpointsByID.get(startPatchPointId);
        assert (startRecords.size() == 1);
        Record startRecord = (Record)startRecords.stream().findAny().orElseThrow(VMError::shouldNotReachHere);
        assert (startRecord.locations.length == 1);
        Location alloca = startRecord.locations[0];
        assert (alloca.type == Location.Type.Direct);
        return this.getStackOffset(startPatchPointId, alloca);
    }

    private int getStackOffset(long patchpointID, Location location) {
        int offset;
        assert (location.size == 8);
        if (location.regNum == LLVMUtils.TargetSpecific.get().getStackPointerDwarfRegNum()) {
            offset = location.offset;
        } else if (location.regNum == LLVMUtils.TargetSpecific.get().getFramePointerDwarfRegNum()) {
            offset = location.offset + NumUtil.safeToInt((long)this.getFunctionStackSize(patchpointID)) + LLVMUtils.TargetSpecific.get().getFramePointerOffset();
        } else {
            throw VMError.shouldNotReachHere((String)("found other register " + patchpointID + " " + location.regNum));
        }
        assert (offset >= 0 && (long)offset < this.getFunctionStackSize(patchpointID) - (long)FrameAccess.wordSize());
        return offset;
    }

    private static /* synthetic */ boolean lambda$forEachStatepointOffset$2(int instructionOffset, Record r) {
        return r.instructionOffset == instructionOffset;
    }

    static class LiveOut {
        short regNum;
        byte size;

        LiveOut() {
        }
    }

    static class Location {
        Type type;
        short size;
        short regNum;
        int offset;

        Location() {
        }

        static enum Type {
            Register(1),
            Direct(2),
            Indirect(3),
            Constant(4),
            ConstantIndex(5);

            private final byte encoding;

            private Type(int encoding) {
                this.encoding = (byte)encoding;
            }

            static Type decode(byte encoding) {
                for (Type type : Type.values()) {
                    if (type.encoding != encoding) continue;
                    return type;
                }
                return null;
            }
        }
    }

    static class Record {
        long patchpointID;
        int instructionOffset;
        short flags;
        Location[] locations;
        LiveOut[] liveOuts;

        Record() {
        }
    }

    static class Function {
        long address;
        long stackSize;
        Record[] records;

        Function() {
        }
    }

    static class StackMap {
        byte version;
        Function[] functions;
        long[] constants;

        StackMap() {
        }
    }
}

