/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayLazyList;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayValuesLazyList;

class ObjectArrayDump
extends ArrayDump
implements ObjectArrayInstance {
    ObjectArrayDump(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public long getSize() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return (long)(this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD) + (long)idSize * (long)this.getLength();
    }

    @Override
    public List getValues() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap heap = this.dumpClass.getHprof();
        return new ObjectArrayLazyList(heap, dumpBuffer, this.getLength(), this.getOffset());
    }

    @Override
    public List getItems() {
        return new ObjectArrayValuesLazyList(this.dumpClass, this.getLength(), this.fileOffset);
    }

    long getOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)idSize + 4L + 4L + (long)idSize;
    }
}

