/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hotspot.libgraal.OptionDescriptorsFilter;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.jni.hosted.JNIFeature;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.HotSpotCodeCacheListener;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.phases.common.jmx.HotSpotMBeanOperationProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleInvocationPluginProvider;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class LibGraalFeature
implements GraalFeature {
    private HotSpotReplacementsImpl hotSpotSubstrateReplacements;
    private EconomicSet<AnnotatedElement> visitedElements = EconomicSet.create();

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (!LibGraal.isSupported()) {
            throw new InternalError("LibGraalFeature is not supported by the current JDK");
        }
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIFeature.class, com.oracle.svm.graal.hosted.GraalFeature.class, ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(MethodAnnotationSupport.class, (Object)new MethodAnnotationSupport());
        JNIRuntimeAccess.JNIRuntimeAccessibilitySupport registry = (JNIRuntimeAccess.JNIRuntimeAccessibilitySupport)ImageSingletons.lookup(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport.class);
        ImageClassLoader imageClassLoader = ((FeatureImpl.DuringSetupAccessImpl)access).getImageClassLoader();
        LibGraalFeature.registerJNIConfiguration(registry, imageClassLoader);
        ArrayList descriptors = new ArrayList();
        for (Class optionsClass : imageClassLoader.findSubclasses(OptionDescriptors.class, false)) {
            if (!OptionDescriptorsFilter.shouldIncludeDescriptors(optionsClass) || Modifier.isAbstract(optionsClass.getModifiers())) continue;
            try {
                descriptors.add(optionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere((Throwable)ex);
            }
        }
        OptionsParser.setCachedOptionDescriptors(descriptors);
    }

    private static void registerJNIConfiguration(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport registry, ImageClassLoader loader) {
        try (JNIConfigSource source = new JNIConfigSource(loader);){
            HashMap classes = new HashMap();
            block25: for (String line : source.lines) {
                ++source.lineNo;
                String[] tokens = line.split(" ");
                source.check(tokens.length >= 2, "Expected at least 2 tokens", new Object[0]);
                String className = tokens[1].replace('/', '.');
                Class<?> clazz = (Class<?>)classes.get(className);
                if (clazz == null) {
                    clazz = source.findClass(className);
                    registry.register(new Class[]{clazz});
                    registry.register(new Class[]{Array.newInstance(clazz, 0).getClass()});
                    classes.put(className, clazz);
                }
                switch (tokens[0]) {
                    case "field": {
                        source.check(tokens.length == 4, "Expected 4 tokens for a field", new Object[0]);
                        String fieldName = tokens[2];
                        try {
                            registry.register(false, false, new Field[]{clazz.getDeclaredField(fieldName)});
                            break;
                        }
                        catch (NoSuchFieldException e) {
                            throw source.error("Field %s.%s not found", clazz.getTypeName(), fieldName);
                        }
                        catch (NoClassDefFoundError e) {
                            throw source.error("Could not register field %s.%s: %s", clazz.getTypeName(), fieldName, e);
                        }
                    }
                    case "method": {
                        source.check(tokens.length == 4, "Expected 4 tokens for a method", new Object[0]);
                        String methodName = tokens[2];
                        HotSpotSignature descriptor = new HotSpotSignature(HotSpotJVMCIRuntime.runtime(), tokens[3]);
                        Class[] parameters = Arrays.asList(descriptor.toParameterTypes(null)).stream().map(JavaType::toClassName).map(source::findClass).collect(Collectors.toList()).toArray(new Class[descriptor.getParameterCount(false)]);
                        try {
                            if ("<init>".equals(methodName)) {
                                Constructor<?> cons = clazz.getDeclaredConstructor(parameters);
                                registry.register(new Executable[]{cons});
                                if (!Throwable.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || !LibGraalFeature.usedInTranslatedException(parameters)) continue block25;
                                RuntimeReflection.register((Class[])new Class[]{clazz});
                                RuntimeReflection.register((Executable[])new Executable[]{cons});
                                break;
                            }
                            registry.register(new Executable[]{clazz.getDeclaredMethod(methodName, parameters)});
                            break;
                        }
                        catch (NoSuchMethodException e) {
                            throw source.error("Method %s.%s%s not found: %e", clazz.getTypeName(), methodName, descriptor, e);
                        }
                        catch (NoClassDefFoundError e) {
                            throw source.error("Could not register method %s.%s%s: %e", clazz.getTypeName(), methodName, descriptor, e);
                        }
                    }
                    case "class": {
                        source.check(tokens.length == 2, "Expected 2 tokens for a class", new Object[0]);
                        break;
                    }
                    default: {
                        throw source.error("Unexpected token: " + tokens[0], new Object[0]);
                    }
                }
            }
        }
    }

    private static boolean usedInTranslatedException(Class<?>[] parameters) {
        return parameters.length == 0 || parameters.length == 1 && parameters[0] == String.class;
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers substrateProviders, SnippetReflectionProvider substrateSnippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        this.hotSpotSubstrateReplacements = LibGraalFeature.getReplacements();
    }

    private void registerMethodSubstitutions(DebugContext debug, InvocationPlugins invocationPlugins, MetaAccessProvider metaAccess) {
        MapCursor cursor = invocationPlugins.getBindings(true).getEntries();
        while (cursor.advance()) {
            String className = (String)cursor.getKey();
            for (InvocationPlugins.Binding binding : (List)cursor.getValue()) {
                if (!(binding.plugin instanceof MethodSubstitutionPlugin)) continue;
                MethodSubstitutionPlugin plugin = (MethodSubstitutionPlugin)binding.plugin;
                ResolvedJavaMethod original = plugin.getOriginalMethod(metaAccess);
                if (original != null) {
                    ResolvedJavaMethod method = plugin.getSubstitute(metaAccess);
                    debug.log("Method substitution %s %s", (Object)method, (Object)original);
                    this.hotSpotSubstrateReplacements.checkRegistered(plugin);
                    continue;
                }
                throw new GraalError("Can't find original method for " + plugin + " with class " + className);
            }
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        GraalServices.load(TruffleCallBoundaryInstrumentationFactory.class);
        GraalServices.load(TruffleInvocationPluginProvider.class);
        GraalServices.load(HotSpotCodeCacheListener.class);
        GraalServices.load(HotSpotMBeanOperationProvider.class);
        FeatureImpl.BeforeAnalysisAccessImpl impl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        DebugContext debug = impl.getBigBang().getDebug();
        try (DebugContext.Scope scope = debug.scope((Object)"SnippetSupportEncode");){
            InvocationPlugins compilerPlugins = this.hotSpotSubstrateReplacements.getGraphBuilderPlugins().getInvocationPlugins();
            MetaAccessProvider metaAccess = this.hotSpotSubstrateReplacements.getProviders().getMetaAccess();
            this.registerMethodSubstitutions(debug, compilerPlugins, metaAccess);
            TruffleCompilerImpl truffleCompiler = (TruffleCompilerImpl)GraalTruffleRuntime.getRuntime().newTruffleCompiler();
            InvocationPlugins trufflePlugins = truffleCompiler.getPartialEvaluator().getConfigForParsing().getPlugins().getInvocationPlugins();
            this.registerMethodSubstitutions(debug, trufflePlugins, metaAccess);
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        AnalysisUniverse universe = accessImpl.getUniverse();
        int numTypes = universe.getTypes().size();
        int numMethods = universe.getMethods().size();
        int numFields = universe.getFields().size();
        universe.getTypes().stream().filter(AnalysisType::isAnnotation).filter(AnalysisType::isInTypeCheck).map(type -> universe.lookup((JavaType)type.getWrapped()).getArrayClass()).filter(annotationArray -> !annotationArray.isInstantiated()).forEach(annotationArray -> {
            accessImpl.registerAsInHeap(annotationArray);
            access.requireAnalysisIteration();
        });
        for (ResolvedJavaMethod method : this.hotSpotSubstrateReplacements.getSnippetMethods()) {
            if (!this.visitedElements.add((Object)method)) continue;
            ((MethodAnnotationSupport)ImageSingletons.lookup(MethodAnnotationSupport.class)).setParameterAnnotations(method, method.getParameterAnnotations());
            ((MethodAnnotationSupport)ImageSingletons.lookup(MethodAnnotationSupport.class)).setMethodAnnotation(method, method.getAnnotations());
        }
        if (numTypes != universe.getTypes().size() || numMethods != universe.getMethods().size() || numFields != universe.getFields().size()) {
            access.requireAnalysisIteration();
        }
        if (this.hotSpotSubstrateReplacements.encode(accessImpl.getBigBang().getOptions())) {
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.visitedElements.clear();
    }

    static HotSpotReplacementsImpl getReplacements() {
        HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        HotSpotProviders originalProvider = compiler.getGraalRuntime().getHostProviders();
        return (HotSpotReplacementsImpl)originalProvider.getReplacements();
    }

    static class MethodAnnotationSupport {
        private Map<String, Annotation[]> classAnnotationMap = new HashMap<String, Annotation[]>();
        private Map<String, Annotation[][]> parameterAnnotationMap = new HashMap<String, Annotation[][]>();
        private Map<String, Annotation[]> methodAnnotationMap = new HashMap<String, Annotation[]>();
        static final Annotation[][] NO_PARAMETER_ANNOTATIONS = new Annotation[0][];
        static final Annotation[] NO_ANNOTATIONS = new Annotation[0];

        MethodAnnotationSupport() {
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        void setParameterAnnotations(ResolvedJavaMethod element, Annotation[][] parameterAnnotations) {
            String name = element.getDeclaringClass().getName() + " " + element.getName();
            if (parameterAnnotations.length == 0) {
                this.parameterAnnotationMap.put(name, NO_PARAMETER_ANNOTATIONS);
            } else {
                this.parameterAnnotationMap.put(name, parameterAnnotations);
            }
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        void setMethodAnnotation(ResolvedJavaMethod javaMethod, Annotation[] annotations) {
            String name = javaMethod.format("%R %H.%n%P");
            if (annotations.length == 0) {
                this.methodAnnotationMap.put(name, NO_ANNOTATIONS);
            } else {
                this.methodAnnotationMap.put(name, annotations);
            }
        }

        public Annotation[] getClassAnnotations(String className) {
            return this.classAnnotationMap.getOrDefault(className, NO_ANNOTATIONS);
        }

        public Annotation[][] getParameterAnnotations(String className, String methodName) {
            String name = className + " " + methodName;
            return this.parameterAnnotationMap.get(name);
        }

        public Annotation[] getMethodAnnotations(ResolvedJavaMethod javaMethod) {
            String name = javaMethod.format("%R %H.%n%P");
            return this.methodAnnotationMap.getOrDefault(name, NO_ANNOTATIONS);
        }
    }

    static class JNIConfigSource
    implements AutoCloseable {
        private final String quotedCommand;
        private final List<String> lines;
        private final ImageClassLoader loader;
        private Path configFilePath;
        int lineNo;

        JNIConfigSource(ImageClassLoader loader) {
            int exitValue;
            Process p;
            this.loader = loader;
            Path javaHomePath = Paths.get(System.getProperty("java.home"), new String[0]);
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            Path javaExe = javaHomePath.resolve(binJava);
            if (!Files.isExecutable(javaExe)) {
                throw UserError.abort((String)("Java launcher " + javaExe + " does not exist or is not executable"));
            }
            this.configFilePath = Paths.get("libgraal_jniconfig.txt", new String[0]);
            String[] command = new String[]{javaExe.toFile().getAbsolutePath(), "-XX:+UnlockExperimentalVMOptions", "-XX:+EnableJVMCI", "-XX:JVMCILibDumpJNIConfig=" + this.configFilePath};
            this.quotedCommand = Arrays.asList(command).stream().map(e -> e.indexOf(32) == -1 ? e : '\'' + e + '\'').collect(Collectors.joining(" "));
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            try {
                p = pb.start();
            }
            catch (IOException e2) {
                throw UserError.abort((String)String.format("Could not run command: %s%n%s", this.quotedCommand, e2));
            }
            String nl = System.getProperty("line.separator");
            String out = new BufferedReader(new InputStreamReader(p.getInputStream())).lines().collect(Collectors.joining(nl));
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException e3) {
                throw UserError.abort((String)String.format("Interrupted waiting for command: %s%n%s", this.quotedCommand, out));
            }
            if (exitValue != 0) {
                throw UserError.abort((String)String.format("Command finished with exit value %d: %s%n%s", exitValue, this.quotedCommand, out));
            }
            try {
                this.lines = Files.readAllLines(this.configFilePath);
            }
            catch (IOException e4) {
                this.configFilePath = null;
                throw UserError.abort((String)String.format("Reading JNI config in %s dumped by command: %s%n%s", this.configFilePath, this.quotedCommand, out));
            }
        }

        @Override
        public void close() {
            if (this.configFilePath != null && Files.exists(this.configFilePath, new LinkOption[0])) {
                try {
                    Files.delete(this.configFilePath);
                    this.configFilePath = null;
                }
                catch (IOException e) {
                    System.out.printf("WARNING: Cound not delete %s: %s%n", this.configFilePath, e);
                }
            }
        }

        Class<?> findClass(String name) {
            Class c = this.loader.findClassByName(name, false);
            if (c == null) {
                throw this.error("Class " + name + " not found", new Object[0]);
            }
            return c;
        }

        void check(boolean condition, String format, Object ... args) {
            if (!condition) {
                this.error(format, args);
            }
        }

        UserError.UserException error(String format, Object ... args) {
            Path path = this.configFilePath;
            this.configFilePath = null;
            String errorMessage = String.format(format, args);
            String errorLine = this.lines.get(this.lineNo - 1);
            throw UserError.abort((String)String.format("Line %d of %s: %s%n%s%n%s generated by command: %s", this.lineNo, path.toAbsolutePath(), errorMessage, errorLine, path, this.quotedCommand));
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(LibGraalFeature.class);
        }
    }
}

