/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Map;
import java.util.Objects;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Mark;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotCompiledNmethod;
import jdk.vm.ci.hotspot.HotSpotForeignCallTarget;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotNmethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotRuntimeStub;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.VMField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public class HotSpotCodeCacheProvider
implements CodeCacheProvider {
    protected final HotSpotJVMCIRuntime runtime;
    private final HotSpotVMConfig config;
    protected final TargetDescription target;
    protected final RegisterConfig regConfig;

    public HotSpotCodeCacheProvider(HotSpotJVMCIRuntime runtime, TargetDescription target, RegisterConfig regConfig) {
        this.runtime = runtime;
        this.config = runtime.getConfig();
        this.target = target;
        this.regConfig = regConfig;
    }

    public String getMarkName(Mark mark) {
        int markId = (Integer)mark.id;
        HotSpotVMConfigStore store = this.runtime.getConfigStore();
        for (Map.Entry<String, Long> e : store.getConstants().entrySet()) {
            String name = e.getKey();
            if (!name.startsWith("MARKID_") || e.getValue() != (long)markId) continue;
            return name;
        }
        return super.getMarkName(mark);
    }

    public String getTargetName(Call call) {
        if (call.target instanceof HotSpotForeignCallTarget) {
            long address = ((HotSpotForeignCallTarget)call.target).address;
            HotSpotVMConfigStore store = this.runtime.getConfigStore();
            for (Map.Entry<String, VMField> e : store.getFields().entrySet()) {
                VMField field = e.getValue();
                if (!field.isStatic() || field.value == null || !(field.value instanceof Long) || (Long)field.value != address) continue;
                return e.getValue() + ":0x" + Long.toHexString(address);
            }
        }
        return super.getTargetName(call);
    }

    public RegisterConfig getRegisterConfig() {
        return this.regConfig;
    }

    public int getMinimumOutgoingSize() {
        return this.config.runtimeCallStackSize;
    }

    private InstalledCode logOrDump(InstalledCode installedCode, CompiledCode compiledCode) {
        this.runtime.notifyInstall(this, installedCode, compiledCode);
        return installedCode;
    }

    public InstalledCode installCode(ResolvedJavaMethod method, CompiledCode compiledCode, InstalledCode installedCode, SpeculationLog log, boolean isDefault) {
        long failedSpeculationsAddress;
        byte[] speculations;
        HotSpotInstalledCode resultInstalledCode;
        if (installedCode != null) {
            throw new IllegalArgumentException("InstalledCode argument must be null");
        }
        HotSpotCompiledCode hsCompiledCode = (HotSpotCompiledCode)compiledCode;
        String name = hsCompiledCode.getName();
        HotSpotCompiledNmethod hsCompiledNmethod = null;
        if (method == null) {
            resultInstalledCode = new HotSpotRuntimeStub(name);
        } else {
            hsCompiledNmethod = (HotSpotCompiledNmethod)hsCompiledCode;
            HotSpotResolvedJavaMethodImpl hsMethod = (HotSpotResolvedJavaMethodImpl)method;
            resultInstalledCode = new HotSpotNmethod(hsMethod, name, isDefault, hsCompiledNmethod.id);
        }
        HotSpotSpeculationLog speculationLog = null;
        if (log != null && log.hasSpeculations()) {
            speculationLog = (HotSpotSpeculationLog)log;
        }
        if (speculationLog != null) {
            speculations = speculationLog.getFlattenedSpeculations(true);
            failedSpeculationsAddress = speculationLog.getFailedSpeculationsAddress();
        } else {
            speculations = new byte[]{};
            failedSpeculationsAddress = 0L;
        }
        int result = this.runtime.getCompilerToVM().installCode(this.target, (HotSpotCompiledCode)compiledCode, resultInstalledCode, failedSpeculationsAddress, speculations);
        if (result != this.config.codeInstallResultOk) {
            String resultDesc = this.config.getCodeInstallResultDescription(result);
            if (hsCompiledNmethod != null) {
                String msg = hsCompiledNmethod.getInstallationFailureMessage();
                msg = msg != null ? String.format("Code installation failed: %s%n%s", resultDesc, msg) : String.format("Code installation failed: %s", resultDesc);
                if (result == this.config.codeInstallResultDependenciesInvalid) {
                    throw new AssertionError((Object)(resultDesc + " " + msg));
                }
                throw new BailoutException(result != this.config.codeInstallResultDependenciesFailed, msg, new Object[0]);
            }
            throw new BailoutException("Error installing %s: %s", new Object[]{((HotSpotCompiledCode)compiledCode).getName(), resultDesc});
        }
        return this.logOrDump(resultInstalledCode, compiledCode);
    }

    public void invalidateInstalledCode(InstalledCode installedCode) {
        if (!(installedCode instanceof HotSpotNmethod)) {
            throw new IllegalArgumentException("Cannot invalidate a " + Objects.requireNonNull(installedCode).getClass().getName());
        }
        this.runtime.getCompilerToVM().invalidateHotSpotNmethod((HotSpotNmethod)installedCode);
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    public String disassemble(InstalledCode code) {
        if (code.isValid()) {
            return this.runtime.getCompilerToVM().disassembleCodeBlob(code);
        }
        return null;
    }

    public SpeculationLog createSpeculationLog() {
        return new HotSpotSpeculationLog();
    }

    public long getMaxCallTargetOffset(long address) {
        return this.runtime.getCompilerToVM().getMaxCallTargetOffset(address);
    }

    public boolean shouldDebugNonSafepoints() {
        return this.runtime.getCompilerToVM().shouldDebugNonSafepoints();
    }

    public int interpreterFrameSize(BytecodeFrame pos) {
        return this.runtime.getCompilerToVM().interpreterFrameSize(pos);
    }

    public void resetCompilationStatistics() {
        this.runtime.getCompilerToVM().resetCompilationStatistics();
    }
}

