/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.DirectHotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotJVMCIReflection;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaFieldImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedPrimitiveType;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

final class HotSpotJDKReflection
extends HotSpotJVMCIReflection {
    private long oopSizeOffset;

    HotSpotJDKReflection() {
    }

    @Override
    Object resolveObject(HotSpotObjectConstantImpl object) {
        if (object == null) {
            return null;
        }
        return ((DirectHotSpotObjectConstantImpl)object).object;
    }

    @Override
    boolean isInstance(HotSpotResolvedObjectTypeImpl holder, HotSpotObjectConstantImpl obj) {
        Class<?> javaMirror = this.getMirror(holder);
        Object value = this.resolveObject(obj);
        return javaMirror.isInstance(value);
    }

    @Override
    boolean isAssignableFrom(HotSpotResolvedObjectTypeImpl holder, HotSpotResolvedObjectTypeImpl otherType) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.isAssignableFrom(this.getMirror(otherType));
    }

    @Override
    Annotation[] getAnnotations(HotSpotResolvedObjectTypeImpl holder) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.getAnnotations();
    }

    @Override
    Annotation[] getDeclaredAnnotations(HotSpotResolvedObjectTypeImpl holder) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.getDeclaredAnnotations();
    }

    @Override
    <T extends Annotation> T getAnnotation(HotSpotResolvedObjectTypeImpl holder, Class<T> annotationClass) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.getAnnotation(annotationClass);
    }

    @Override
    boolean isLocalClass(HotSpotResolvedObjectTypeImpl holder) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.isLocalClass();
    }

    @Override
    boolean isMemberClass(HotSpotResolvedObjectTypeImpl holder) {
        Class<?> javaMirror = this.getMirror(holder);
        return javaMirror.isMemberClass();
    }

    @Override
    HotSpotResolvedObjectType getEnclosingClass(HotSpotResolvedObjectTypeImpl holder) {
        Class<?> javaMirror = this.getMirror(holder);
        return (HotSpotResolvedObjectType)((Object)HotSpotJVMCIRuntime.runtime().fromClass(javaMirror.getEnclosingClass()));
    }

    @Override
    JavaConstant readFieldValue(HotSpotResolvedObjectTypeImpl holder, HotSpotResolvedJavaField field, boolean isVolatile) {
        Class<?> javaMirror = this.getMirror(holder);
        return this.readFieldValue(field, javaMirror, isVolatile);
    }

    @Override
    JavaConstant readFieldValue(HotSpotObjectConstantImpl object, HotSpotResolvedJavaField field, boolean isVolatile) {
        Object value = this.resolveObject(object);
        return this.readFieldValue(field, value, isVolatile);
    }

    @Override
    boolean equals(HotSpotObjectConstantImpl a, HotSpotObjectConstantImpl b) {
        return this.resolveObject(a) == this.resolveObject(b) && a.isCompressed() == b.isCompressed();
    }

    @Override
    JavaConstant getJavaMirror(HotSpotResolvedPrimitiveType holder) {
        return holder.mirror;
    }

    @Override
    ResolvedJavaMethod.Parameter[] getParameters(HotSpotResolvedJavaMethodImpl javaMethod) {
        Parameter[] javaParameters = HotSpotJDKReflection.getMethod(javaMethod).getParameters();
        ResolvedJavaMethod.Parameter[] res = new ResolvedJavaMethod.Parameter[javaParameters.length];
        for (int i = 0; i < res.length; ++i) {
            Parameter src = javaParameters[i];
            String paramName = src.isNamePresent() ? src.getName() : null;
            res[i] = new ResolvedJavaMethod.Parameter(paramName, src.getModifiers(), (ResolvedJavaMethod)javaMethod, i);
        }
        return res;
    }

    @Override
    Annotation[][] getParameterAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        return HotSpotJDKReflection.getMethod(javaMethod).getParameterAnnotations();
    }

    @Override
    Type[] getGenericParameterTypes(HotSpotResolvedJavaMethodImpl javaMethod) {
        return HotSpotJDKReflection.getMethod(javaMethod).getGenericParameterTypes();
    }

    @Override
    Annotation[] getFieldAnnotations(HotSpotResolvedJavaFieldImpl javaField) {
        return HotSpotJDKReflection.getField(javaField).getAnnotations();
    }

    @Override
    Annotation[] getMethodAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        return HotSpotJDKReflection.getMethod(javaMethod).getAnnotations();
    }

    @Override
    Annotation[] getMethodDeclaredAnnotations(HotSpotResolvedJavaMethodImpl javaMethod) {
        return HotSpotJDKReflection.getMethod(javaMethod).getDeclaredAnnotations();
    }

    @Override
    Annotation[] getFieldDeclaredAnnotations(HotSpotResolvedJavaFieldImpl javaField) {
        return HotSpotJDKReflection.getField(javaField).getDeclaredAnnotations();
    }

    @Override
    <T extends Annotation> T getMethodAnnotation(HotSpotResolvedJavaMethodImpl javaMethod, Class<T> annotationClass) {
        return HotSpotJDKReflection.getMethod(javaMethod).getAnnotation(annotationClass);
    }

    @Override
    <T extends Annotation> T getFieldAnnotation(HotSpotResolvedJavaFieldImpl javaField, Class<T> annotationClass) {
        return HotSpotJDKReflection.getField(javaField).getAnnotation(annotationClass);
    }

    @Override
    HotSpotResolvedObjectTypeImpl getType(HotSpotObjectConstantImpl object) {
        Object value = this.resolveObject(object);
        Class<?> theClass = value.getClass();
        return (HotSpotResolvedObjectTypeImpl)HotSpotJVMCIRuntime.runtime().fromClass(theClass);
    }

    @Override
    String asString(HotSpotObjectConstantImpl object) {
        Object value = this.resolveObject(object);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    ResolvedJavaType asJavaType(HotSpotObjectConstantImpl object) {
        Object value = this.resolveObject(object);
        if (value instanceof Class) {
            Class javaClass = (Class)value;
            return HotSpotJVMCIRuntime.runtime().fromClass(javaClass);
        }
        if (value instanceof ResolvedJavaType) {
            return (ResolvedJavaType)value;
        }
        return null;
    }

    @Override
    <T> T asObject(HotSpotObjectConstantImpl object, Class<T> type) {
        Object value = this.resolveObject(object);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    @Override
    Object asObject(HotSpotObjectConstantImpl object, HotSpotResolvedJavaType type) {
        Object value = this.resolveObject(object);
        if (this.getMirror(type).isInstance(value)) {
            return value;
        }
        return null;
    }

    @Override
    String formatString(HotSpotObjectConstantImpl object) {
        return JavaKind.Object.format(this.resolveObject(object));
    }

    @Override
    Integer getLength(HotSpotObjectConstantImpl arrayObject) {
        Object object = this.resolveObject(arrayObject);
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        return null;
    }

    @Override
    JavaConstant readArrayElement(HotSpotObjectConstantImpl arrayObject, int index) {
        Object a = this.resolveObject(arrayObject);
        if (!a.getClass().isArray() || index < 0 || index >= Array.getLength(a)) {
            return null;
        }
        if (a instanceof Object[]) {
            Object element = ((Object[])a)[index];
            return this.forObject(element);
        }
        if (a instanceof int[]) {
            return JavaConstant.forInt((int)((int[])a)[index]);
        }
        if (a instanceof char[]) {
            return JavaConstant.forChar((char)((char[])a)[index]);
        }
        if (a instanceof byte[]) {
            return JavaConstant.forByte((byte)((byte[])a)[index]);
        }
        if (a instanceof long[]) {
            return JavaConstant.forLong((long)((long[])a)[index]);
        }
        if (a instanceof short[]) {
            return JavaConstant.forShort((short)((short[])a)[index]);
        }
        if (a instanceof float[]) {
            return JavaConstant.forFloat((float)((float[])a)[index]);
        }
        if (a instanceof double[]) {
            return JavaConstant.forDouble((double)((double[])a)[index]);
        }
        if (a instanceof boolean[]) {
            return JavaConstant.forBoolean((boolean)((boolean[])a)[index]);
        }
        throw new JVMCIError("Should not reach here");
    }

    @Override
    JavaConstant unboxPrimitive(HotSpotObjectConstantImpl source) {
        return JavaConstant.forBoxedPrimitive((Object)this.resolveObject(source));
    }

    @Override
    JavaConstant forObject(Object value) {
        if (value == null) {
            return JavaConstant.NULL_POINTER;
        }
        return HotSpotJDKReflection.forNonNullObject(value);
    }

    private static HotSpotObjectConstantImpl forNonNullObject(Object value) {
        return DirectHotSpotObjectConstantImpl.forNonNullObject(value, false);
    }

    @Override
    JavaConstant boxPrimitive(JavaConstant source) {
        return HotSpotJDKReflection.forNonNullObject(source.asBoxedPrimitive());
    }

    @Override
    int getInt(HotSpotObjectConstantImpl object, long displacement) {
        return UnsafeAccess.UNSAFE.getInt(this.resolveObject(object), displacement);
    }

    @Override
    byte getByte(HotSpotObjectConstantImpl object, long displacement) {
        return UnsafeAccess.UNSAFE.getByte(this.resolveObject(object), displacement);
    }

    @Override
    short getShort(HotSpotObjectConstantImpl object, long displacement) {
        return UnsafeAccess.UNSAFE.getShort(this.resolveObject(object), displacement);
    }

    @Override
    long getLong(HotSpotObjectConstantImpl object, long displacement) {
        return UnsafeAccess.UNSAFE.getLong(this.resolveObject(object), displacement);
    }

    @Override
    void checkRead(HotSpotObjectConstantImpl constant, JavaKind kind, long displacement, HotSpotResolvedObjectType type) {
        this.checkRead(kind, displacement, type, this.resolveObject(constant));
    }

    private static int computeOopSizeOffset(HotSpotJVMCIRuntime runtime) {
        MetaAccessProvider metaAccess = runtime.getHostJVMCIBackend().getMetaAccess();
        ResolvedJavaType staticType = metaAccess.lookupJavaType(Class.class);
        for (ResolvedJavaField f : staticType.getInstanceFields(false)) {
            if (!f.getName().equals("oop_size")) continue;
            int offset = f.getOffset();
            assert (offset != 0) : "not expecting offset of java.lang.Class::oop_size to be 0";
            return offset;
        }
        throw new JVMCIError("Could not find injected java.lang.Class::oop_size field");
    }

    long oopSizeOffset() {
        if (this.oopSizeOffset == 0L) {
            this.oopSizeOffset = HotSpotJDKReflection.computeOopSizeOffset(HotSpotJVMCIRuntime.runtime());
        }
        return this.oopSizeOffset;
    }

    private boolean checkRead(JavaKind kind, long displacement, HotSpotResolvedObjectType type, Object object) {
        if (type.isArray()) {
            boolean aligned;
            ResolvedJavaType componentType = type.getComponentType();
            JavaKind componentKind = componentType.getJavaKind();
            int headerSize = HotSpotJVMCIRuntime.runtime().getArrayBaseOffset(componentKind);
            int sizeOfElement = HotSpotJVMCIRuntime.runtime().getArrayIndexScale(componentKind);
            int length = Array.getLength(object);
            long arrayEnd = headerSize + sizeOfElement * length;
            boolean bl = aligned = (displacement - (long)headerSize) % (long)sizeOfElement == 0L;
            if (displacement < 0L || displacement > arrayEnd - (long)sizeOfElement || kind == JavaKind.Object && !aligned) {
                int index = (int)((displacement - (long)headerSize) / (long)sizeOfElement);
                throw new IllegalArgumentException("Unsafe array access: reading element of kind " + kind + " at offset " + displacement + " (index ~ " + index + ") in " + type.toJavaName() + " object of length " + length);
            }
        } else if (kind != JavaKind.Object) {
            long size;
            if (object instanceof Class) {
                int wordSize = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getCodeCache().getTarget().wordSize;
                size = UnsafeAccess.UNSAFE.getInt(object, this.oopSizeOffset()) * wordSize;
            } else {
                size = Math.abs(type.instanceSize());
            }
            int bytesToRead = kind.getByteCount();
            if (displacement + (long)bytesToRead > size || displacement < 0L) {
                throw new IllegalArgumentException("Unsafe access: reading " + bytesToRead + " bytes at offset " + displacement + " in " + type.toJavaName() + " object of size " + size);
            }
        } else {
            HotSpotResolvedJavaType hotSpotResolvedJavaType;
            ResolvedJavaField field = null;
            if (object instanceof Class && (hotSpotResolvedJavaType = HotSpotJVMCIRuntime.runtime().fromClass((Class)object)) instanceof HotSpotResolvedObjectTypeImpl) {
                HotSpotResolvedObjectTypeImpl staticFieldsHolder = (HotSpotResolvedObjectTypeImpl)hotSpotResolvedJavaType;
                field = staticFieldsHolder.findStaticFieldWithOffset(displacement, JavaKind.Object);
            }
            if (field == null) {
                field = type.findInstanceFieldWithOffset(displacement, JavaKind.Object);
            }
            if (field == null) {
                throw new IllegalArgumentException("Unsafe object access: field not found for read of kind Object at offset " + displacement + " in " + type.toJavaName() + " object");
            }
            if (field.getJavaKind() != JavaKind.Object) {
                throw new IllegalArgumentException("Unsafe object access: field " + field.format("%H.%n:%T") + " not of expected kind Object at offset " + displacement + " in " + type.toJavaName() + " object");
            }
        }
        return true;
    }

    JavaConstant readFieldValue(HotSpotResolvedJavaField field, Object obj, boolean isVolatile) {
        assert (obj != null);
        assert (!field.isStatic() || obj instanceof Class);
        long displacement = field.getOffset();
        assert (this.checkRead(field.getJavaKind(), displacement, (HotSpotResolvedObjectType)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess().lookupJavaType(field.isStatic() ? (Class<?>)obj : obj.getClass()), obj));
        JavaKind kind = field.getJavaKind();
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((boolean)(isVolatile ? UnsafeAccess.UNSAFE.getBooleanVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getBoolean(obj, displacement)));
            }
            case Byte: {
                return JavaConstant.forByte((byte)(isVolatile ? UnsafeAccess.UNSAFE.getByteVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getByte(obj, displacement)));
            }
            case Char: {
                return JavaConstant.forChar((char)(isVolatile ? UnsafeAccess.UNSAFE.getCharVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getChar(obj, displacement)));
            }
            case Short: {
                return JavaConstant.forShort((short)(isVolatile ? UnsafeAccess.UNSAFE.getShortVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getShort(obj, displacement)));
            }
            case Int: {
                return JavaConstant.forInt((int)(isVolatile ? UnsafeAccess.UNSAFE.getIntVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getInt(obj, displacement)));
            }
            case Long: {
                return JavaConstant.forLong((long)(isVolatile ? UnsafeAccess.UNSAFE.getLongVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getLong(obj, displacement)));
            }
            case Float: {
                return JavaConstant.forFloat((float)(isVolatile ? UnsafeAccess.UNSAFE.getFloatVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getFloat(obj, displacement)));
            }
            case Double: {
                return JavaConstant.forDouble((double)(isVolatile ? UnsafeAccess.UNSAFE.getDoubleVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getDouble(obj, displacement)));
            }
            case Object: {
                return this.forObject(isVolatile ? UnsafeAccess.UNSAFE.getObjectVolatile(obj, displacement) : UnsafeAccess.UNSAFE.getObject(obj, displacement));
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Executable getMethod(HotSpotResolvedJavaMethodImpl method) {
        assert (!method.isClassInitializer()) : method;
        if (method.toJavaCache == null) {
            HotSpotResolvedJavaMethodImpl hotSpotResolvedJavaMethodImpl = method;
            synchronized (hotSpotResolvedJavaMethodImpl) {
                if (method.toJavaCache == null) {
                    method.toJavaCache = CompilerToVM.compilerToVM().asReflectionExecutable(method);
                }
            }
        }
        return method.toJavaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field getField(HotSpotResolvedJavaFieldImpl field) {
        HotSpotResolvedObjectTypeImpl declaringClass;
        HotSpotResolvedObjectTypeImpl hotSpotResolvedObjectTypeImpl = declaringClass = field.getDeclaringClass();
        synchronized (hotSpotResolvedObjectTypeImpl) {
            Field reflect;
            HashMap<HotSpotResolvedJavaFieldImpl, Field> cache = declaringClass.reflectionFieldCache;
            if (cache == null) {
                cache = new HashMap();
                declaringClass.reflectionFieldCache = cache;
            }
            if ((reflect = cache.get(field)) == null) {
                reflect = CompilerToVM.compilerToVM().asReflectionField(field.getDeclaringClass(), field.getIndex());
                cache.put(field, reflect);
            }
            return reflect;
        }
    }

    Class<?> getMirror(HotSpotResolvedObjectTypeImpl holder) {
        return (Class)this.resolveObject((HotSpotObjectConstantImpl)holder.getJavaMirror());
    }

    Class<?> getMirror(HotSpotResolvedJavaType type) {
        assert (type != null);
        if (type instanceof HotSpotResolvedPrimitiveType) {
            return (Class)this.resolveObject(((HotSpotResolvedPrimitiveType)type).mirror);
        }
        return this.getMirror((HotSpotResolvedObjectTypeImpl)type);
    }
}

