/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMethodData;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.TriState;

abstract class HotSpotMethodDataAccessor {
    final int tag;
    final int staticSize;
    final HotSpotMethodData.VMState state;
    final HotSpotVMConfig config;

    protected HotSpotMethodDataAccessor(HotSpotMethodData.VMState state, int tag, int staticSize) {
        this.state = state;
        this.config = state.config;
        this.tag = tag;
        this.staticSize = staticSize;
    }

    int getTag() {
        return this.tag;
    }

    static int readTag(HotSpotVMConfig config, HotSpotMethodData data, int position) {
        int tag = data.readUnsignedByte(position, config.dataLayoutTagOffset);
        assert (tag >= config.dataLayoutNoTag && tag <= config.dataLayoutSpeculativeTrapDataTag) : "profile data tag out of bounds: " + tag;
        return tag;
    }

    int getBCI(HotSpotMethodData data, int position) {
        return data.readUnsignedShort(position, this.config.dataLayoutBCIOffset);
    }

    final int getSize(HotSpotMethodData data, int position) {
        int size = this.staticSize + this.getDynamicSize(data, position);
        int vmSize = HotSpotJVMCIRuntime.runtime().compilerToVm.methodDataProfileDataSize(data.metaspaceMethodData, position);
        assert (size == vmSize) : size + " != " + vmSize;
        return size;
    }

    TriState getExceptionSeen(HotSpotMethodData data, int position) {
        int exceptionsMask = 1 << this.config.bitDataExceptionSeenFlag;
        return TriState.get(((this.getFlags(data, position) & exceptionsMask) != 0 ? 1 : 0) != 0);
    }

    JavaTypeProfile getTypeProfile(HotSpotMethodData data, int position) {
        return null;
    }

    JavaMethodProfile getMethodProfile(HotSpotMethodData data, int position) {
        return null;
    }

    double getBranchTakenProbability(HotSpotMethodData data, int position) {
        return -1.0;
    }

    double[] getSwitchProbabilities(HotSpotMethodData data, int position) {
        return null;
    }

    int getExecutionCount(HotSpotMethodData data, int position) {
        return -1;
    }

    TriState getNullSeen(HotSpotMethodData data, int position) {
        return TriState.UNKNOWN;
    }

    protected int getFlags(HotSpotMethodData data, int position) {
        return data.readUnsignedByte(position, this.config.dataLayoutFlagsOffset);
    }

    protected int getDynamicSize(HotSpotMethodData data, int position) {
        return 0;
    }

    abstract StringBuilder appendTo(StringBuilder var1, HotSpotMethodData var2, int var3);
}

