/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.HotSpotMethodData;
import jdk.vm.ci.hotspot.HotSpotMethodDataAccessor;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.TriState;

final class HotSpotProfilingInfo
implements ProfilingInfo {
    private final HotSpotMethodData methodData;
    private final HotSpotResolvedJavaMethod method;
    private boolean isMature;
    private int position;
    private int hintPosition;
    private int hintBCI;
    private HotSpotMethodDataAccessor dataAccessor;
    private boolean includeNormal;
    private boolean includeOSR;
    private static volatile Class<?> supportedCompilerIRType;

    HotSpotProfilingInfo(HotSpotMethodData methodData, HotSpotResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
        this.methodData = methodData;
        this.method = method;
        this.includeNormal = includeNormal;
        this.includeOSR = includeOSR;
        this.isMature = methodData.isProfileMature();
        this.hintPosition = 0;
        this.hintBCI = -1;
    }

    public int getCodeSize() {
        return this.method.getCodeSize();
    }

    public int getDecompileCount() {
        return this.methodData.getDecompileCount();
    }

    public int getOverflowRecompileCount() {
        return this.methodData.getOverflowRecompileCount();
    }

    public int getOverflowTrapCount() {
        return this.methodData.getOverflowTrapCount();
    }

    public JavaTypeProfile getTypeProfile(int bci) {
        if (!this.isMature) {
            return null;
        }
        this.findBCI(bci, false);
        return this.dataAccessor.getTypeProfile(this.methodData, this.position);
    }

    public JavaMethodProfile getMethodProfile(int bci) {
        if (!this.isMature) {
            return null;
        }
        this.findBCI(bci, false);
        return this.dataAccessor.getMethodProfile(this.methodData, this.position);
    }

    public double getBranchTakenProbability(int bci) {
        if (!this.isMature) {
            return -1.0;
        }
        this.findBCI(bci, false);
        return this.dataAccessor.getBranchTakenProbability(this.methodData, this.position);
    }

    public double[] getSwitchProbabilities(int bci) {
        if (!this.isMature) {
            return null;
        }
        this.findBCI(bci, false);
        return this.dataAccessor.getSwitchProbabilities(this.methodData, this.position);
    }

    public TriState getExceptionSeen(int bci) {
        this.findBCI(bci, true);
        return this.dataAccessor.getExceptionSeen(this.methodData, this.position);
    }

    public TriState getNullSeen(int bci) {
        this.findBCI(bci, false);
        return this.dataAccessor.getNullSeen(this.methodData, this.position);
    }

    public int getExecutionCount(int bci) {
        if (!this.isMature) {
            return -1;
        }
        this.findBCI(bci, false);
        return this.dataAccessor.getExecutionCount(this.methodData, this.position);
    }

    public int getDeoptimizationCount(DeoptimizationReason reason) {
        int count = 0;
        if (this.includeNormal) {
            count += this.methodData.getDeoptimizationCount(reason);
        }
        if (this.includeOSR) {
            count += this.methodData.getOSRDeoptimizationCount(reason);
        }
        return count;
    }

    private void findBCI(int targetBCI, boolean searchExtraData) {
        assert (targetBCI >= 0) : "invalid BCI";
        if (this.methodData.hasNormalData()) {
            HotSpotMethodDataAccessor currentAccessor;
            int currentPosition;
            int n = currentPosition = targetBCI < this.hintBCI ? 0 : this.hintPosition;
            while ((currentAccessor = this.methodData.getNormalData(currentPosition)) != null) {
                int currentBCI = currentAccessor.getBCI(this.methodData, currentPosition);
                if (currentBCI == targetBCI) {
                    this.normalDataFound(currentAccessor, currentPosition, currentBCI);
                    return;
                }
                if (currentBCI > targetBCI) break;
                currentPosition += currentAccessor.getSize(this.methodData, currentPosition);
            }
        }
        boolean exceptionPossiblyNotRecorded = false;
        if (searchExtraData && this.methodData.hasExtraData()) {
            HotSpotMethodDataAccessor currentAccessor;
            int currentPosition = this.methodData.getExtraDataBeginOffset();
            while ((currentAccessor = this.methodData.getExtraData(currentPosition)) != null) {
                int currentBCI = currentAccessor.getBCI(this.methodData, currentPosition);
                if (currentBCI == targetBCI) {
                    this.extraDataFound(currentAccessor, currentPosition);
                    return;
                }
                currentPosition += currentAccessor.getSize(this.methodData, currentPosition);
            }
            if (!this.methodData.isWithin(currentPosition)) {
                exceptionPossiblyNotRecorded = true;
            }
        }
        this.noDataFound(exceptionPossiblyNotRecorded);
    }

    private void normalDataFound(HotSpotMethodDataAccessor data, int pos, int bci) {
        this.setCurrentData(data, pos);
        this.hintPosition = this.position;
        this.hintBCI = bci;
    }

    private void extraDataFound(HotSpotMethodDataAccessor data, int pos) {
        this.setCurrentData(data, pos);
    }

    private void noDataFound(boolean exceptionPossiblyNotRecorded) {
        HotSpotMethodDataAccessor accessor = HotSpotMethodData.getNoDataAccessor(exceptionPossiblyNotRecorded);
        this.setCurrentData(accessor, -1);
    }

    private void setCurrentData(HotSpotMethodDataAccessor dataAccessor, int position) {
        this.dataAccessor = dataAccessor;
        this.position = position;
    }

    public boolean isMature() {
        return this.isMature;
    }

    public void ignoreMature() {
        this.isMature = true;
    }

    public String toString() {
        return "HotSpotProfilingInfo<" + this.toString(null, "; ") + ">";
    }

    public void setMature() {
        this.isMature = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean setCompilerIRSize(Class<?> irType, int size) {
        if (supportedCompilerIRType == null) {
            Class<HotSpotProfilingInfo> clazz = HotSpotProfilingInfo.class;
            // MONITORENTER : jdk.vm.ci.hotspot.HotSpotProfilingInfo.class
            if (supportedCompilerIRType == null) {
                supportedCompilerIRType = irType;
            }
            // MONITOREXIT : clazz
        }
        if (supportedCompilerIRType != irType) {
            return false;
        }
        this.methodData.setCompiledIRSize(size);
        return true;
    }

    public int getCompilerIRSize(Class<?> irType) {
        if (irType == supportedCompilerIRType) {
            return this.methodData.getCompiledIRSize();
        }
        return -1;
    }
}

