/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.annotation.Annotation;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotModifiers;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import sun.misc.Unsafe;

class HotSpotResolvedJavaFieldImpl
implements HotSpotResolvedJavaField {
    private final HotSpotResolvedObjectTypeImpl holder;
    private JavaType type;
    private final int offset;
    private final short index;
    private final int modifiers;

    HotSpotResolvedJavaFieldImpl(HotSpotResolvedObjectTypeImpl holder, JavaType type, long offset, int modifiers, int index) {
        this.holder = holder;
        this.type = type;
        this.index = (short)index;
        assert (this.index == index);
        assert (offset != -1L);
        assert (offset == (long)((int)offset)) : "offset larger than int";
        this.offset = (int)offset;
        this.modifiers = modifiers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HotSpotResolvedJavaFieldImpl) {
            HotSpotResolvedJavaFieldImpl that = (HotSpotResolvedJavaFieldImpl)obj;
            if (that.offset != this.offset || that.isStatic() != this.isStatic()) {
                return false;
            }
            if (this.holder.equals(that.holder)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.holder.hashCode() ^ this.offset;
    }

    public int getModifiers() {
        return this.modifiers & HotSpotModifiers.jvmFieldModifiers();
    }

    public boolean isInternal() {
        return (this.modifiers & HotSpotVMConfig.config().jvmAccFieldInternal) != 0;
    }

    @Override
    public boolean isInObject(JavaConstant object) {
        if (this.isStatic()) {
            return false;
        }
        HotSpotObjectConstant constant = (HotSpotObjectConstant)object;
        return this.getDeclaringClass().isAssignableFrom(constant.getType());
    }

    public HotSpotResolvedObjectTypeImpl getDeclaringClass() {
        return this.holder;
    }

    public String getName() {
        return this.holder.createFieldInfo(this.index).getName();
    }

    public JavaType getType() {
        JavaType currentType = this.type;
        if (currentType instanceof UnresolvedJavaType) {
            UnresolvedJavaType unresolvedType = (UnresolvedJavaType)currentType;
            JavaType resolved = HotSpotJVMCIRuntime.runtime().lookupType(unresolvedType.getName(), this.holder, false);
            if (resolved instanceof ResolvedJavaType) {
                this.type = resolved;
            }
        }
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.format("HotSpotResolvedJavaFieldImpl<%H.%n %t:") + this.offset + ">";
    }

    public boolean isSynthetic() {
        return (HotSpotVMConfig.config().jvmAccSynthetic & this.modifiers) != 0;
    }

    @Override
    public boolean isStable() {
        return (HotSpotVMConfig.config().jvmAccFieldStable & this.modifiers) != 0;
    }

    private boolean hasAnnotations() {
        if (!this.isInternal()) {
            long fieldsAnnotations;
            HotSpotVMConfig config = HotSpotVMConfig.config();
            long metaspaceAnnotations = UnsafeAccess.UNSAFE.getAddress(this.holder.getMetaspaceKlass() + (long)config.instanceKlassAnnotationsOffset);
            if (metaspaceAnnotations != 0L && (fieldsAnnotations = UnsafeAccess.UNSAFE.getAddress(metaspaceAnnotations + (long)config.annotationsFieldAnnotationsOffset)) != 0L) {
                long fieldAnnotations = UnsafeAccess.UNSAFE.getAddress(fieldsAnnotations + (long)config.fieldsAnnotationsBaseOffset + (long)(Unsafe.ADDRESS_SIZE * this.index));
                return fieldAnnotations != 0L;
            }
        }
        return false;
    }

    public Annotation[] getAnnotations() {
        if (!this.hasAnnotations()) {
            return new Annotation[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getFieldAnnotations(this);
    }

    public Annotation[] getDeclaredAnnotations() {
        if (!this.hasAnnotations()) {
            return new Annotation[0];
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getFieldDeclaredAnnotations(this);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (!this.hasAnnotations()) {
            return null;
        }
        return HotSpotJVMCIRuntime.runtime().reflection.getFieldAnnotation(this, annotationClass);
    }
}

