/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.hotspot.Cleaner;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationEncoding;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.SpeculationLog;

public class HotSpotSpeculationLog
implements SpeculationLog {
    private static final byte[] NO_FLATTENED_SPECULATIONS = new byte[0];
    private long failedSpeculationsAddress;
    private final boolean managesFailedSpeculations;
    private byte[][] failedSpeculations;
    private List<byte[]> speculations;
    private List<SpeculationLog.SpeculationReason> speculationReasons;

    public HotSpotSpeculationLog() {
        this.managesFailedSpeculations = true;
    }

    public HotSpotSpeculationLog(long failedSpeculationsAddress) {
        if (failedSpeculationsAddress == 0L) {
            throw new IllegalArgumentException("failedSpeculationsAddress cannot be 0");
        }
        this.failedSpeculationsAddress = failedSpeculationsAddress;
        this.managesFailedSpeculations = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFailedSpeculationsAddress() {
        if (this.managesFailedSpeculations) {
            HotSpotSpeculationLog hotSpotSpeculationLog = this;
            synchronized (hotSpotSpeculationLog) {
                if (this.failedSpeculationsAddress == 0L) {
                    this.failedSpeculationsAddress = UnsafeAccess.UNSAFE.allocateMemory(HotSpotJVMCIRuntime.getHostWordKind().getByteCount());
                    UnsafeAccess.UNSAFE.putAddress(this.failedSpeculationsAddress, 0L);
                    LogCleaner c = new LogCleaner(this, this.failedSpeculationsAddress);
                    assert (c.address == this.failedSpeculationsAddress);
                }
            }
        }
        return this.failedSpeculationsAddress;
    }

    public boolean addFailedSpeculation(SpeculationLog.Speculation speculation) {
        return CompilerToVM.compilerToVM().addFailedSpeculation(this.getFailedSpeculationsAddress(), ((HotSpotSpeculation)speculation).encoding);
    }

    public boolean managesFailedSpeculations() {
        return this.managesFailedSpeculations;
    }

    public void collectFailedSpeculations() {
        if (this.failedSpeculationsAddress != 0L && UnsafeAccess.UNSAFE.getLong(this.failedSpeculationsAddress) != 0L) {
            this.failedSpeculations = CompilerToVM.compilerToVM().getFailedSpeculations(this.failedSpeculationsAddress, this.failedSpeculations);
            assert (this.failedSpeculations.getClass() == byte[][].class);
        }
    }

    byte[] getFlattenedSpeculations(boolean validate) {
        if (this.speculations == null) {
            return NO_FLATTENED_SPECULATIONS;
        }
        if (validate) {
            int newFailuresStart = this.failedSpeculations == null ? 0 : this.failedSpeculations.length;
            this.collectFailedSpeculations();
            if (this.failedSpeculations != null && this.failedSpeculations.length != newFailuresStart) {
                for (SpeculationLog.SpeculationReason reason : this.speculationReasons) {
                    byte[] encoding = HotSpotSpeculationLog.encode(reason);
                    if (!HotSpotSpeculationLog.contains(this.failedSpeculations, newFailuresStart, encoding)) continue;
                    throw new BailoutException(false, "Speculation failed: " + reason, new Object[0]);
                }
            }
        }
        int size = 0;
        for (byte[] s : this.speculations) {
            size += s.length;
        }
        byte[] result = new byte[size];
        size = 0;
        for (byte[] s : this.speculations) {
            System.arraycopy(s, 0, result, size, s.length);
            size += s.length;
        }
        return result;
    }

    public boolean maySpeculate(SpeculationLog.SpeculationReason reason) {
        if (this.failedSpeculations == null) {
            this.collectFailedSpeculations();
        }
        if (this.failedSpeculations != null && this.failedSpeculations.length != 0) {
            byte[] encoding = HotSpotSpeculationLog.encode(reason);
            return !HotSpotSpeculationLog.contains(this.failedSpeculations, 0, encoding);
        }
        return true;
    }

    private static boolean contains(byte[][] haystack, int fromIndex, byte[] needle) {
        for (int i = fromIndex; i < haystack.length; ++i) {
            byte[] fs = haystack[i];
            if (!Arrays.equals(fs, needle)) continue;
            return true;
        }
        return false;
    }

    private static long encodeIndexAndLength(int index, int length) {
        return (long)index << 32 | (long)length;
    }

    private static int decodeIndex(long indexAndLength) {
        return (int)(indexAndLength >>> 32);
    }

    private static int decodeLength(long indexAndLength) {
        return (int)indexAndLength & 0xFFFFFFFF;
    }

    public SpeculationLog.Speculation speculate(SpeculationLog.SpeculationReason reason) {
        PrimitiveConstant id;
        byte[] encoding = HotSpotSpeculationLog.encode(reason);
        if (this.speculations == null) {
            this.speculations = new ArrayList<byte[]>();
            this.speculationReasons = new ArrayList<SpeculationLog.SpeculationReason>();
            id = JavaConstant.forLong((long)HotSpotSpeculationLog.encodeIndexAndLength(0, encoding.length));
            this.speculations.add(encoding);
            this.speculationReasons.add(reason);
        } else {
            id = null;
            int flattenedIndex = 0;
            for (byte[] fs : this.speculations) {
                if (Arrays.equals(fs, encoding)) {
                    id = JavaConstant.forLong((long)HotSpotSpeculationLog.encodeIndexAndLength(flattenedIndex, fs.length));
                    break;
                }
                flattenedIndex += fs.length;
            }
            if (id == null) {
                id = JavaConstant.forLong((long)HotSpotSpeculationLog.encodeIndexAndLength(flattenedIndex, encoding.length));
                this.speculations.add(encoding);
                this.speculationReasons.add(reason);
            }
        }
        return new HotSpotSpeculation(reason, (JavaConstant)id, encoding);
    }

    private static byte[] encode(SpeculationLog.SpeculationReason reason) {
        byte[] result;
        HotSpotSpeculationEncoding encoding = (HotSpotSpeculationEncoding)reason.encode(HotSpotSpeculationEncoding::new);
        byte[] byArray = result = encoding == null ? null : encoding.getByteArray();
        if (result == null) {
            throw new IllegalArgumentException(HotSpotSpeculationLog.class.getName() + " expects " + reason.getClass().getName() + ".encode() to return a non-empty encoding");
        }
        return result;
    }

    public boolean hasSpeculations() {
        return this.speculations != null;
    }

    public SpeculationLog.Speculation lookupSpeculation(JavaConstant constant) {
        if (constant.isDefaultForKind()) {
            return NO_SPECULATION;
        }
        int flattenedIndex = HotSpotSpeculationLog.decodeIndex(constant.asLong());
        int index = 0;
        for (byte[] s : this.speculations) {
            if (flattenedIndex == 0) {
                SpeculationLog.SpeculationReason reason = this.speculationReasons.get(index);
                return new HotSpotSpeculation(reason, constant, s);
            }
            ++index;
            flattenedIndex -= s.length;
        }
        throw new IllegalArgumentException("Unknown encoded speculation: " + constant);
    }

    public String toString() {
        Formatter buf = new Formatter();
        buf.format("{managed:%s, failedSpeculationsAddress:0x%x, failedSpeculations:[", this.managesFailedSpeculations, this.failedSpeculationsAddress);
        String sep = "";
        if (this.failedSpeculations != null) {
            for (int i = 0; i < this.failedSpeculations.length; ++i) {
                buf.format("%s{len:%d, hash:0x%x}", sep, this.failedSpeculations[i].length, Arrays.hashCode(this.failedSpeculations[i]));
                sep = ", ";
            }
        }
        buf.format("], speculations:[", new Object[0]);
        int size = 0;
        if (this.speculations != null) {
            sep = "";
            for (int i = 0; i < this.speculations.size(); ++i) {
                byte[] s = this.speculations.get(i);
                size += s.length;
                buf.format("%s{len:%d, hash:0x%x, reason:{%s}}", sep, s.length, Arrays.hashCode(s), this.speculationReasons.get(i));
                sep = ", ";
            }
        }
        buf.format("], len:%d, hash:0x%x}", size, Arrays.hashCode(this.getFlattenedSpeculations(false)));
        return buf.toString();
    }

    private static final class LogCleaner
    extends Cleaner {
        final long address;

        LogCleaner(HotSpotSpeculationLog referent, long address) {
            super(referent);
            this.address = address;
        }

        @Override
        void doCleanup() {
            long pointer = UnsafeAccess.UNSAFE.getAddress(this.address);
            if (pointer != 0L) {
                CompilerToVM.compilerToVM().releaseFailedSpeculations(this.address);
            }
            UnsafeAccess.UNSAFE.freeMemory(this.address);
        }
    }

    public static final class HotSpotSpeculation
    extends SpeculationLog.Speculation {
        private final JavaConstant id;
        private final byte[] encoding;

        HotSpotSpeculation(SpeculationLog.SpeculationReason reason, JavaConstant id, byte[] encoding) {
            super(reason);
            this.id = id;
            this.encoding = encoding;
        }

        public JavaConstant getEncoding() {
            return this.id;
        }

        public String toString() {
            long indexAndLength = this.id.asLong();
            int index = HotSpotSpeculationLog.decodeIndex(indexAndLength);
            int length = HotSpotSpeculationLog.decodeLength(indexAndLength);
            return String.format("{0x%016x[index: %d, len: %d, hash: 0x%x]: %s}", indexAndLength, index, length, Arrays.hashCode(this.encoding), this.getReason());
        }
    }
}

