/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.SuppressFBWarnings;
import jdk.vm.ci.hotspot.VMField;
import jdk.vm.ci.hotspot.VMFlag;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;

public final class HotSpotVMConfigStore {
    final HashMap<String, VMField> vmFields;
    final HashMap<String, Long> vmConstants;
    final HashMap<String, Long> vmAddresses;
    final HashMap<String, VMFlag> vmFlags;
    final List<VMIntrinsicMethod> vmIntrinsics;
    final CompilerToVM compilerToVm;

    public Map<String, Long> getAddresses() {
        return Collections.unmodifiableMap(this.vmAddresses);
    }

    public Map<String, Long> getConstants() {
        return Collections.unmodifiableMap(this.vmConstants);
    }

    public Map<String, VMFlag> getFlags() {
        return Collections.unmodifiableMap(this.vmFlags);
    }

    public Map<String, VMField> getFields() {
        return Collections.unmodifiableMap(this.vmFields);
    }

    public List<VMIntrinsicMethod> getIntrinsics() {
        return Collections.unmodifiableList(this.vmIntrinsics);
    }

    HotSpotVMConfigStore(CompilerToVM compilerToVm) {
        Object[] data;
        this.compilerToVm = compilerToVm;
        try (InitTimer t = InitTimer.timer((String)"CompilerToVm readConfiguration");){
            data = compilerToVm.readConfiguration();
        }
        if (data.length != 5) {
            throw new JVMCIError("Expected data.length to be 5, not %d", new Object[]{data.length});
        }
        VMField[] vmFieldsInfo = (VMField[])data[0];
        Object[] vmConstantsInfo = (Object[])data[1];
        Object[] vmAddressesInfo = (Object[])data[2];
        VMFlag[] vmFlagsInfo = (VMFlag[])data[3];
        this.vmFields = new HashMap(vmFieldsInfo.length);
        this.vmConstants = new HashMap(vmConstantsInfo.length);
        this.vmAddresses = new HashMap(vmAddressesInfo.length);
        this.vmFlags = new HashMap(vmFlagsInfo.length);
        this.vmIntrinsics = Arrays.asList((VMIntrinsicMethod[])data[4]);
        try (InitTimer t = InitTimer.timer((String)"HotSpotVMConfigStore<init> fill maps");){
            int i;
            for (VMField vmField : vmFieldsInfo) {
                this.vmFields.put(vmField.name, vmField);
            }
            for (i = 0; i < vmConstantsInfo.length / 2; ++i) {
                String name = (String)vmConstantsInfo[i * 2];
                Long value = (Long)vmConstantsInfo[i * 2 + 1];
                this.vmConstants.put(name, value);
            }
            for (i = 0; i < vmAddressesInfo.length / 2; ++i) {
                String name = (String)vmAddressesInfo[i * 2];
                Long value = (Long)vmAddressesInfo[i * 2 + 1];
                this.vmAddresses.put(name, value);
            }
            for (VMFlag vmFlag : vmFlagsInfo) {
                this.vmFlags.put(vmFlag.name, vmFlag);
            }
        }
    }

    public String toString() {
        return String.format("%s[%d fields, %d constants, %d addresses, %d flags, %d intrinsics]", this.getClass().getSimpleName(), this.vmFields.size(), this.vmConstants.size(), this.vmAddresses.size(), this.vmFlags.size(), this.vmIntrinsics.size());
    }

    void printConfig() {
        CompilerToVM vm = this.compilerToVm;
        TreeMap<String, VMField> fields = new TreeMap<String, VMField>(this.getFields());
        for (VMField vMField : fields.values()) {
            if (!vMField.isStatic()) {
                HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:instance field] %s %s {offset=%d[0x%x]}%n", vMField.type, vMField.name, vMField.offset, vMField.offset);
                continue;
            }
            String string = vMField.value == null ? "null" : (vMField.value instanceof Boolean ? vMField.value.toString() : String.format("%d[0x%x]", vMField.value, vMField.value));
            HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:static field] %s %s = %s {address=0x%x}%n", vMField.type, vMField.name, string, vMField.address);
        }
        TreeMap<String, VMFlag> flags = new TreeMap<String, VMFlag>(this.getFlags());
        for (VMFlag vMFlag : flags.values()) {
            HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:flag] %s %s = %s%n", vMFlag.type, vMFlag.name, vMFlag.value);
        }
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>(this.getAddresses());
        for (Map.Entry<String, Long> entry : treeMap.entrySet()) {
            HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:address] %s = %d[0x%x]%n", entry.getKey(), entry.getValue(), entry.getValue());
        }
        TreeMap<String, Long> treeMap2 = new TreeMap<String, Long>(this.getConstants());
        for (Map.Entry<String, Long> entry : treeMap2.entrySet()) {
            HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:constant] %s = %d[0x%x]%n", entry.getKey(), entry.getValue(), entry.getValue());
        }
        for (VMIntrinsicMethod vMIntrinsicMethod : this.getIntrinsics()) {
            HotSpotVMConfigStore.printConfigLine(vm, "[vmconfig:intrinsic] %d = %s.%s %s%n", vMIntrinsicMethod.id, vMIntrinsicMethod.declaringClass, vMIntrinsicMethod.name, vMIntrinsicMethod.descriptor);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="no localization here please!")
    private static void printConfigLine(CompilerToVM vm, String format, Object ... args) {
        String line = String.format(format, args);
        byte[] lineBytes = line.getBytes();
        vm.writeDebugOutput(lineBytes, 0, lineBytes.length, true, true);
    }
}

