/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HandleCleaner;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.HotSpotObjectConstantScope;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.JavaConstant;

final class IndirectHotSpotObjectConstantImpl
extends HotSpotObjectConstantImpl {
    private long objectHandle;
    private int hashCode;
    final IndirectHotSpotObjectConstantImpl base;
    private Object rawAudit;

    @VMEntryPoint
    private IndirectHotSpotObjectConstantImpl(final long objectHandle, boolean compressed, boolean skipRegister) {
        super(compressed);
        assert (objectHandle != 0L && UnsafeAccess.UNSAFE.getLong(objectHandle) != 0L);
        this.objectHandle = objectHandle;
        this.base = null;
        if (!skipRegister) {
            HotSpotObjectConstantScope scope = HotSpotObjectConstantScope.CURRENT.get();
            if (scope != null && !scope.isGlobal()) {
                scope.add(this);
                if (HotSpotJVMCIRuntime.Option.AuditHandles.getBoolean()) {
                    this.rawAudit = new Audit(scope.localScopeDescription, objectHandle, new Throwable(){

                        @Override
                        public String toString() {
                            return "Created " + objectHandle;
                        }
                    });
                }
            } else {
                HandleCleaner.create(this, objectHandle);
            }
        }
    }

    private IndirectHotSpotObjectConstantImpl(IndirectHotSpotObjectConstantImpl base, boolean compressed) {
        super(compressed);
        this.objectHandle = base.getHandle();
        assert (base.base == null || base.base.base == null);
        this.base = base.base != null ? base.base : base;
    }

    long getHandle() {
        this.checkHandle();
        return this.objectHandle;
    }

    private void checkHandle() {
        if (this.objectHandle == 0L) {
            String message;
            if (this.rawAudit instanceof Audit) {
                Audit audit = (Audit)this.rawAudit;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                ps.println("Foreign object reference " + audit.handle + " created in scope '" + audit.scope + "' is no longer valid. Origin: {");
                audit.origin.printStackTrace(ps);
                ps.print('}');
                ps.flush();
                message = baos.toString();
            } else {
                message = "Foreign object reference created in scope '" + this.rawAudit + "' is no longer valid. Set property " + HotSpotJVMCIRuntime.Option.AuditHandles.getPropertyName() + "=true to show origin of invalid foreign references.";
            }
            throw new NullPointerException(message);
        }
    }

    boolean isValid() {
        return this.objectHandle != 0L;
    }

    @Override
    public HotSpotResolvedObjectType getType() {
        this.checkHandle();
        return super.getType();
    }

    void clear(Object scopeDescription) {
        this.checkHandle();
        CompilerToVM.compilerToVM().deleteGlobalHandle(this.objectHandle);
        if (this.rawAudit == null) {
            this.rawAudit = scopeDescription;
        }
        this.objectHandle = 0L;
    }

    @Override
    public JavaConstant compress() {
        assert (!this.compressed);
        return new IndirectHotSpotObjectConstantImpl(this, true);
    }

    @Override
    public JavaConstant uncompress() {
        assert (this.compressed);
        return new IndirectHotSpotObjectConstantImpl(this, false);
    }

    @Override
    public int getIdentityHashCode() {
        this.checkHandle();
        int hash = this.hashCode;
        if (hash == 0) {
            hash = HotSpotJVMCIRuntime.runtime().compilerToVm.getIdentityHashCode(this);
            if (hash == 0) {
                hash = 31;
            }
            this.hashCode = hash;
        }
        return hash;
    }

    private static class Audit {
        final Object scope;
        final long handle;
        final Throwable origin;

        Audit(Object scope, long handle, Throwable origin) {
            this.scope = scope;
            this.handle = handle;
            this.origin = origin;
        }
    }
}

