/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.sparc;

import java.util.EnumSet;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotStackIntrospection;
import jdk.vm.ci.hotspot.sparc.SPARCHotSpotRegisterConfig;
import jdk.vm.ci.hotspot.sparc.SPARCHotSpotVMConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.sparc.SPARC;

public class SPARCHotSpotJVMCIBackendFactory
implements HotSpotJVMCIBackendFactory {
    private static TargetDescription createTarget(SPARCHotSpotVMConfig config) {
        int stackFrameAlignment = 16;
        int implicitNullCheckLimit = 4096;
        boolean inlineObjects = false;
        SPARC arch = new SPARC(SPARCHotSpotJVMCIBackendFactory.computeFeatures(config));
        return new TargetDescription((Architecture)arch, true, 16, 4096, false);
    }

    protected HotSpotCodeCacheProvider createCodeCache(HotSpotJVMCIRuntime runtime, TargetDescription target, RegisterConfig regConfig) {
        return new HotSpotCodeCacheProvider(runtime, target, regConfig);
    }

    private static EnumSet<SPARC.CPUFeature> computeFeatures(SPARCHotSpotVMConfig config) {
        EnumSet<SPARC.CPUFeature> features = EnumSet.noneOf(SPARC.CPUFeature.class);
        if ((config.vmVersionFeatures & config.sparcVis1Instructions) != 0) {
            features.add(SPARC.CPUFeature.VIS1);
        }
        if ((config.vmVersionFeatures & config.sparcVis2Instructions) != 0) {
            features.add(SPARC.CPUFeature.VIS2);
        }
        if ((config.vmVersionFeatures & config.sparcVis3Instructions) != 0) {
            features.add(SPARC.CPUFeature.VIS3);
        }
        if ((config.vmVersionFeatures & config.sparcCbcondInstructions) != 0) {
            features.add(SPARC.CPUFeature.CBCOND);
        }
        if ((config.vmVersionFeatures & config.sparcV8Instructions) != 0) {
            features.add(SPARC.CPUFeature.V8);
        }
        if ((config.vmVersionFeatures & config.sparcHardwareMul32) != 0) {
            features.add(SPARC.CPUFeature.HARDWARE_MUL32);
        }
        if ((config.vmVersionFeatures & config.sparcHardwareDiv32) != 0) {
            features.add(SPARC.CPUFeature.HARDWARE_DIV32);
        }
        if ((config.vmVersionFeatures & config.sparcHardwareFsmuld) != 0) {
            features.add(SPARC.CPUFeature.HARDWARE_FSMULD);
        }
        if ((config.vmVersionFeatures & config.sparcHardwarePopc) != 0) {
            features.add(SPARC.CPUFeature.HARDWARE_POPC);
        }
        if ((config.vmVersionFeatures & config.sparcV9Instructions) != 0) {
            features.add(SPARC.CPUFeature.V9);
        }
        if ((config.vmVersionFeatures & config.sparcSun4v) != 0) {
            features.add(SPARC.CPUFeature.SUN4V);
        }
        if ((config.vmVersionFeatures & config.sparcBlkInitInstructions) != 0) {
            features.add(SPARC.CPUFeature.BLK_INIT_INSTRUCTIONS);
        }
        if ((config.vmVersionFeatures & config.sparcFmafInstructions) != 0) {
            features.add(SPARC.CPUFeature.FMAF);
        }
        if ((config.vmVersionFeatures & config.sparcFmauInstructions) != 0) {
            features.add(SPARC.CPUFeature.FMAU);
        }
        if ((config.vmVersionFeatures & config.sparcSparc64Family) != 0) {
            features.add(SPARC.CPUFeature.SPARC64_FAMILY);
        }
        if ((config.vmVersionFeatures & config.sparcMFamily) != 0) {
            features.add(SPARC.CPUFeature.M_FAMILY);
        }
        if ((config.vmVersionFeatures & config.sparcTFamily) != 0) {
            features.add(SPARC.CPUFeature.T_FAMILY);
        }
        if ((config.vmVersionFeatures & config.sparcT1Model) != 0) {
            features.add(SPARC.CPUFeature.T1_MODEL);
        }
        if ((config.vmVersionFeatures & config.sparcSparc5Instructions) != 0) {
            features.add(SPARC.CPUFeature.SPARC5);
        }
        if ((config.vmVersionFeatures & config.sparcAesInstructions) != 0) {
            features.add(SPARC.CPUFeature.SPARC64_FAMILY);
        }
        if ((config.vmVersionFeatures & config.sparcSha1Instruction) != 0) {
            features.add(SPARC.CPUFeature.SHA1);
        }
        if ((config.vmVersionFeatures & config.sparcSha256Instruction) != 0) {
            features.add(SPARC.CPUFeature.SHA256);
        }
        if ((config.vmVersionFeatures & config.sparcSha512Instruction) != 0) {
            features.add(SPARC.CPUFeature.SHA512);
        }
        return features;
    }

    @Override
    public String getArchitecture() {
        return "SPARC";
    }

    public String toString() {
        return "JVMCIBackend:" + this.getArchitecture();
    }

    @Override
    public JVMCIBackend createJVMCIBackend(HotSpotJVMCIRuntime runtime, JVMCIBackend host) {
        assert (host == null);
        SPARCHotSpotVMConfig config = new SPARCHotSpotVMConfig(runtime.getConfigStore());
        TargetDescription target = SPARCHotSpotJVMCIBackendFactory.createTarget(config);
        HotSpotMetaAccessProvider metaAccess = new HotSpotMetaAccessProvider(runtime);
        SPARCHotSpotRegisterConfig regConfig = new SPARCHotSpotRegisterConfig(target, config.useCompressedOops);
        HotSpotCodeCacheProvider codeCache = this.createCodeCache(runtime, target, regConfig);
        HotSpotConstantReflectionProvider constantReflection = new HotSpotConstantReflectionProvider(runtime);
        HotSpotStackIntrospection stackIntrospection = new HotSpotStackIntrospection(runtime);
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            JVMCIBackend jVMCIBackend = this.createBackend(metaAccess, codeCache, constantReflection, stackIntrospection);
            return jVMCIBackend;
        }
    }

    protected JVMCIBackend createBackend(HotSpotMetaAccessProvider metaAccess, HotSpotCodeCacheProvider codeCache, HotSpotConstantReflectionProvider constantReflection, StackIntrospection stackIntrospection) {
        return new JVMCIBackend((MetaAccessProvider)metaAccess, (CodeCacheProvider)codeCache, (ConstantReflectionProvider)constantReflection, stackIntrospection);
    }
}

