/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr;

import java.io.File;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.core.ui.DataSourceViewsManager;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.JFRSnapshotsContainer;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotCategory;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotDescriptorProvider;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotProvider;
import org.graalvm.visualvm.jfr.views.browser.JFRSnapshotBrowserViewProvider;
import org.graalvm.visualvm.jfr.views.environment.JFRSnapshotEnvironmentViewProvider;
import org.graalvm.visualvm.jfr.views.exceptions.JFRSnapshotExceptionsViewProvider;
import org.graalvm.visualvm.jfr.views.fileio.JFRSnapshotFileIOViewProvider;
import org.graalvm.visualvm.jfr.views.gc.JFRSnapshotGcViewProvider;
import org.graalvm.visualvm.jfr.views.locks.JFRSnapshotLocksViewProvider;
import org.graalvm.visualvm.jfr.views.monitor.JFRSnapshotMonitorViewProvider;
import org.graalvm.visualvm.jfr.views.overview.JFRSnapshotOverviewViewProvider;
import org.graalvm.visualvm.jfr.views.recording.JFRSnapshotRecordingViewProvider;
import org.graalvm.visualvm.jfr.views.sampler.JFRSnapshotSamplerViewProvider;
import org.graalvm.visualvm.jfr.views.socketio.JFRSnapshotSocketIOViewProvider;
import org.graalvm.visualvm.jfr.views.threads.JFRSnapshotThreadsViewProvider;

public final class JFRSnapshotSupport {
    private static final String JFRSNAPSHOTS_STORAGE_DIRNAME = "jfrsnapshots";
    private static final Object jfrSnapshotsStorageDirectoryLock = new Object();
    private static File jfrSnapshotsStorageDirectory;
    private static final Object jfrSnapshotsStorageDirectoryStringLock;
    private static String jfrSnapshotsStorageDirectoryString;
    private static JFRSnapshotOverviewViewProvider viewProvider;
    private static JFRSnapshotCategory category;

    public static PluggableDataSourceViewProvider<JFRSnapshot> getOverviewView() {
        return viewProvider;
    }

    public static SnapshotCategory getCategory() {
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStorageDirectoryString() {
        Object object = jfrSnapshotsStorageDirectoryStringLock;
        synchronized (object) {
            if (jfrSnapshotsStorageDirectoryString == null) {
                jfrSnapshotsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + JFRSNAPSHOTS_STORAGE_DIRNAME;
            }
            return jfrSnapshotsStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = jfrSnapshotsStorageDirectoryLock;
        synchronized (object) {
            if (jfrSnapshotsStorageDirectory == null) {
                String snapshotsStorageString = JFRSnapshotSupport.getStorageDirectoryString();
                jfrSnapshotsStorageDirectory = new File(snapshotsStorageString);
                if (jfrSnapshotsStorageDirectory.exists() && jfrSnapshotsStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create JFR snapshots storage directory " + snapshotsStorageString + ", file in the way");
                }
                if (!(!jfrSnapshotsStorageDirectory.exists() || jfrSnapshotsStorageDirectory.canRead() && jfrSnapshotsStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access JFR snapshots storage directory " + snapshotsStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)jfrSnapshotsStorageDirectory)) {
                    throw new IllegalStateException("Cannot create JFR snapshots storage directory " + snapshotsStorageString);
                }
            }
            return jfrSnapshotsStorageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(JFRSnapshotSupport.getStorageDirectoryString()).isDirectory();
    }

    static void register() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new JFRSnapshotDescriptorProvider());
        JFRSnapshotsContainer.sharedInstance();
        JFRSnapshotProvider.register();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)category);
        DataSourceViewsManager views = DataSourceViewsManager.sharedInstance();
        views.addViewProvider((DataSourceViewProvider)viewProvider, JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotMonitorViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotThreadsViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotSamplerViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotLocksViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotFileIOViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotSocketIOViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotExceptionsViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotGcViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotBrowserViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotEnvironmentViewProvider(), JFRSnapshot.class);
        views.addViewProvider((DataSourceViewProvider)new JFRSnapshotRecordingViewProvider(), JFRSnapshot.class);
    }

    static {
        jfrSnapshotsStorageDirectoryStringLock = new Object();
        viewProvider = new JFRSnapshotOverviewViewProvider();
        category = new JFRSnapshotCategory();
    }
}

