/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import java.awt.Font;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsNode;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

final class ExceptionsRenderers {
    ExceptionsRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    static class CountRenderer
    extends NumberRenderer {
        CountRenderer() {
        }

        static String getDisplayName() {
            return "Count";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, ExceptionsRenderers.getMinimumWidth(CountRenderer.getDisplayName()));
        }
    }

    static class NameRenderer
    extends LabelRenderer {
        private static Font regular;
        private static Font bold;

        NameRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof ExceptionsNode) {
                ExceptionsNode node = (ExceptionsNode)((Object)value);
                ExceptionsNode parent = node.getParent();
                this.setFont(parent == null || parent.getParent() == null ? NameRenderer.bold() : NameRenderer.regular());
                this.setText(node.name);
                this.setIcon(node.icon);
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

