/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.gc;

import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.gc.GcNode;
import org.graalvm.visualvm.jfr.views.gc.GcViewSupport;
import org.graalvm.visualvm.jfr.views.gc.JFRSnapshotGcViewProvider;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.RequestProcessor;

final class JFRSnapshotGcView
extends DataSourceView {
    private JFRModel model;
    private GcViewSupport.MasterViewSupport masterView;
    private GcViewSupport.DataViewSupport dataView;

    JFRSnapshotGcView(JFRSnapshot jfrSnapshot) {
        super((DataSource)jfrSnapshot, "GC", Icons.getImage((String)"ProfilerIcons.RunGC"), 36, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        boolean hasEvents;
        boolean bl = hasEvents = this.model != null && this.model.containsEvent(JFRSnapshotGcViewProvider.EventChecker.class);
        if (!hasEvents) {
            this.masterView = new GcViewSupport.MasterViewSupport(this.model){

                @Override
                void firstShown() {
                }

                @Override
                void changeAggregation(GcViewSupport.Aggregation primary, GcViewSupport.Aggregation secondary) {
                }
            };
            return new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final GcViewSupport.GcConfigurationSupport gcConfigurationView = new GcViewSupport.GcConfigurationSupport();
        final GcViewSupport.GcHeapConfigurationSupport gcHeapConfigurationView = new GcViewSupport.GcHeapConfigurationSupport();
        final GcViewSupport.GcYoungGenConfigurationSupport gcYoungGenConfigurationView = new GcViewSupport.GcYoungGenConfigurationSupport();
        final GcViewSupport.GcSurvivorConfigurationSupport gcSurvivorConfigurationView = new GcViewSupport.GcSurvivorConfigurationSupport();
        final GcViewSupport.GcTlabConfigurationSupport gcTlabConfigurationView = new GcViewSupport.GcTlabConfigurationSupport();
        this.masterView = new GcViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                this.changeAggregation(GcViewSupport.Aggregation.NONE, GcViewSupport.Aggregation.NONE);
                JFRSnapshotGcView.this.initialize(new JFREventVisitor[]{gcConfigurationView, gcHeapConfigurationView, gcYoungGenConfigurationView, gcSurvivorConfigurationView, gcTlabConfigurationView});
            }

            @Override
            void changeAggregation(GcViewSupport.Aggregation primary, GcViewSupport.Aggregation secondary) {
                JFRSnapshotGcView.this.setAggregation(primary, secondary);
            }
        };
        DataViewComponent dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
        this.dataView = new GcViewSupport.DataViewSupport();
        dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Configuration", true), 3);
        dvc.addDetailsView(gcConfigurationView.getDetailsView(), 3);
        dvc.addDetailsView(gcHeapConfigurationView.getDetailsView(), 3);
        dvc.addDetailsView(gcYoungGenConfigurationView.getDetailsView(), 3);
        dvc.addDetailsView(gcSurvivorConfigurationView.getDetailsView(), 3);
        dvc.addDetailsView(gcTlabConfigurationView.getDetailsView(), 3);
        return dvc;
    }

    private void setAggregation(final GcViewSupport.Aggregation primary, final GcViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new GcNode.Root(), false, false);
        new RequestProcessor("JFR GC Initializer").post(new Runnable(){

            @Override
            public void run() {
                final GcNode.Root root = new GcNode.Root(primary, secondary);
                JFRSnapshotGcView.this.model.visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFRSnapshotGcView.this.dataView.setData(root, !GcViewSupport.Aggregation.NONE.equals((Object)primary), GcViewSupport.Aggregation.PHASE.equals((Object)secondary));
                        JFRSnapshotGcView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }

    private void initialize(final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR GC Initializer").post(new Runnable(){

            @Override
            public void run() {
                JFRSnapshotGcView.this.model.visitEvents(visitors);
            }
        });
    }
}

