/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.jfr.model.JFRMethod;
import org.graalvm.visualvm.jfr.model.JFRStackFrame;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;

final class JFRThreadInfoSupport {
    JFRThreadInfoSupport() {
    }

    static Map<String, Object> getThreadInfo(JFRThread thread, JFRStackTrace stack, String state) {
        return JFRThreadInfoSupport.getThreadInfo(thread, stack, JFRThreadInfoSupport.state(state));
    }

    static Map<String, Object> getThreadInfo(JFRThread thread, JFRStackTrace stack, Thread.State state) {
        String name = thread.getName();
        Long id = thread.getId();
        StackTraceElement[] stackTrace = JFRThreadInfoSupport.stackTrace(stack);
        HashMap<String, Object> threadInfo = new HashMap<String, Object>();
        threadInfo.put("name", name);
        threadInfo.put("tid", id);
        threadInfo.put("stack", stackTrace);
        threadInfo.put("state", (Object)state);
        return threadInfo;
    }

    private static StackTraceElement[] stackTrace(JFRStackTrace stack) {
        List<JFRStackFrame> frames = stack.getFrames();
        StackTraceElement[] elements = new StackTraceElement[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            elements[i] = JFRThreadInfoSupport.stackTraceElement(frames.get(i));
        }
        return elements;
    }

    private static StackTraceElement stackTraceElement(JFRStackFrame frame) {
        String methodName;
        String className;
        JFRMethod method = frame.getMethod();
        String string = className = method == null ? "<unknown class>" : method.getType().getName();
        if (className == null) {
            className = "<unknown class>";
        }
        String string2 = methodName = method == null ? "<unknown method>" : method.getName();
        if (methodName == null) {
            methodName = "<unknown method>";
        }
        int lineNumber = "Native".equals(frame.getType()) ? -2 : frame.getLine();
        return new StackTraceElement(className, methodName, null, lineNumber);
    }

    private static Thread.State state(String state) {
        if ("STATE_RUNNABLE".equals(state)) {
            return Thread.State.RUNNABLE;
        }
        return Thread.State.RUNNABLE;
    }
}

