/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.threads.JFRThreadsDataManager;
import org.graalvm.visualvm.lib.jfluid.results.threads.ThreadData;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.threads.ThreadsPanel;
import org.openide.util.NbBundle;

class ThreadsViewSupport {
    ThreadsViewSupport() {
    }

    static class TimelineViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private JFRThreadsDataManager threadsManager;
        private ProfilerToolbar toolbar;
        private ThreadsPanel threadsPanel;
        private JLabel shLabel;
        private ActionPopupButton shFilter;
        private JLabel tlLabel;
        private JComponent tlZoomInButton;
        private JComponent tlZoomOutButton;
        private JComponent tlFitWidthButton;
        private long firstTimestamp = Long.MAX_VALUE;
        private long lastTimestamp = Long.MIN_VALUE;
        private Map<Long, List<State>> states;
        private Map<Long, Definition> definitions;
        private boolean[] activeTypes = new boolean[6];

        TimelineViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ThreadsViewSupport.class, (String)"LBL_Timeline"), null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.states = new HashMap<Long, List<State>>();
            this.definitions = new TreeMap<Long, Definition>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.ThreadStart".equals(typeName)) {
                this.processEvent(event, "thread", (byte)1, (byte)-128);
                this.activeTypes[0] = true;
            } else if ("jdk.ThreadEnd".equals(typeName)) {
                this.processEvent(event, "thread", (byte)0, (byte)-128);
                this.activeTypes[1] = true;
            } else if ("jdk.JavaMonitorWait".equals(typeName)) {
                this.processEvent(event, "eventThread", (byte)4, (byte)1);
                this.activeTypes[2] = true;
            } else if ("jdk.JavaMonitorEnter".equals(typeName)) {
                this.processEvent(event, "eventThread", (byte)3, (byte)1);
                this.activeTypes[3] = true;
            } else if ("jdk.ThreadPark".equals(typeName)) {
                this.processEvent(event, "eventThread", (byte)5, (byte)1);
                this.activeTypes[4] = true;
            } else if ("jdk.ThreadSleep".equals(typeName)) {
                this.processEvent(event, "eventThread", (byte)2, (byte)1);
                this.activeTypes[5] = true;
            } else if ("jdk.Compilation".equals(typeName)) {
                this.processEvent(event, "eventThread", (byte)1, (byte)5);
            } else if ("jdk.ThreadAllocationStatistics".equals(typeName)) {
                try {
                    JFRThread thread = event.getThread("eventThread");
                    if (thread != null) {
                        long allocated = event.getLong("allocated");
                        byte tstate = allocated > 0L ? (byte)1 : 4;
                        this.processDefinition(thread.getId(), thread.getName(), ValuesConverter.instantToRelativeNanos(event.getInstant("eventTime"), this.jfrModel), tstate);
                    }
                }
                catch (JFRPropertyNotAvailableException e) {
                    System.err.println(">>> --- " + e);
                }
            } else {
                try {
                    JFRThread thread = event.getThread("eventThread");
                    if (thread != null) {
                        this.processDefinition(thread.getId(), thread.getName(), ValuesConverter.instantToRelativeNanos(event.getInstant("eventTime"), this.jfrModel), (byte)1);
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            final ArrayList<ThreadData> tdataC = new ArrayList<ThreadData>();
            for (Map.Entry<Long, Definition> definitionE : this.definitions.entrySet()) {
                long tid = definitionE.getKey();
                Definition definition = definitionE.getValue();
                List<State> statesL = this.states.get(tid);
                if (statesL == null) {
                    statesL = new ArrayList<State>();
                }
                Collections.sort(statesL, State.COMPARATOR);
                if (statesL.isEmpty() && definition.firstState != -128) {
                    statesL.add(new State(definition.firstTime, definition.firstState));
                } else {
                    long firstStateTime = statesL.get((int)0).time;
                    if (firstStateTime > definition.firstTime && definition.firstState != -128) {
                        statesL.add(0, new State(definition.firstTime, definition.firstState));
                    }
                }
                this.firstTimestamp = Math.min(this.firstTimestamp, statesL.get((int)0).time);
                this.lastTimestamp = Math.max(this.lastTimestamp, statesL.get((int)(statesL.size() - 1)).time);
                ThreadData tdata = new ThreadData(definition.tname, "java.lang.Thread");
                byte lastState = -128;
                for (State state : statesL) {
                    long ttime = state.time;
                    byte tstate = state.tstate;
                    if (lastState == tstate) continue;
                    tdata.add(this.jfrModel.nsToAbsoluteMillis(ttime), tstate);
                    lastState = tstate;
                }
                tdataC.add(tdata);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    threadsManager.setData(jfrModel.nsToAbsoluteMillis(firstTimestamp), jfrModel.nsToAbsoluteMillis(lastTimestamp), tdataC);
                }
            });
            this.states.clear();
            this.states = null;
            this.definitions.clear();
            this.definitions = null;
        }

        Collection<String> getActiveTypes() {
            ArrayList<String> names = new ArrayList<String>();
            if (this.activeTypes[0]) {
                names.add("jdk.ThreadStart");
            }
            if (this.activeTypes[1]) {
                names.add("jdk.ThreadEnd");
            }
            if (this.activeTypes[2]) {
                names.add("jdk.JavaMonitorWait");
            }
            if (this.activeTypes[3]) {
                names.add("jdk.JavaMonitorEnter");
            }
            if (this.activeTypes[4]) {
                names.add("jdk.ThreadPark");
            }
            if (this.activeTypes[5]) {
                names.add("jdk.ThreadSleep");
            }
            this.activeTypes = null;
            return names;
        }

        int getThreadsCount() {
            return this.threadsManager.getThreadsCount();
        }

        private void processEvent(JFREvent event, String tkey, byte tstate1, byte tstate2) {
            try {
                JFRThread thread = event.getThread(tkey);
                long tid = thread.getId();
                List<State> tdata = this.states.get(tid);
                if (tdata == null) {
                    tdata = new ArrayList<State>();
                    this.states.put(tid, tdata);
                }
                long ttime = ValuesConverter.instantToRelativeNanos(event.getInstant("eventTime"), this.jfrModel);
                tdata.add(new State(ttime, tstate1));
                this.processDefinition(tid, thread.getName(), ttime, tstate1);
                if (tstate2 != -128) {
                    tdata.add(new State(ttime += ValuesConverter.durationToNanos(event.getDuration("eventDuration")), tstate2));
                }
            }
            catch (JFRPropertyNotAvailableException e) {
                System.err.println(">>> " + e + " --- " + event);
            }
        }

        private void processDefinition(long tid, String tname, long ttime, byte tstate) {
            Definition definition = this.definitions.get(tid);
            if (definition == null) {
                this.definitions.put(tid, new Definition(tname, ttime, tstate));
            } else if (definition.firstTime > ttime) {
                definition.firstTime = ttime;
                definition.firstState = tstate;
            }
        }

        private void initModels() {
            this.threadsManager = new JFRThreadsDataManager();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.threadsPanel = new ThreadsPanel(this.threadsManager, null){

                protected void filterSelected(ThreadsPanel.Filter filter) {
                    super.filterSelected(filter);
                    shFilter.selectAction(filter.ordinal());
                }
            };
            this.threadsPanel.threadsMonitoringEnabled();
            this.shLabel = new GrayLabel("Show:");
            AbstractAction aAll = new AbstractAction(){
                {
                    this.putValue("Name", "All Threads");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.ALL);
                }
            };
            AbstractAction aLive = new AbstractAction(){
                {
                    this.putValue("Name", "Live Threads");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.LIVE);
                }
            };
            AbstractAction aFinished = new AbstractAction(){
                {
                    this.putValue("Name", "Finished Threads");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.FINISHED);
                }
            };
            AbstractAction aSelected = new AbstractAction(){
                {
                    this.putValue("Name", "Selected Threads");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setSelectedFilter();
                }
            };
            this.shFilter = new ActionPopupButton(new Action[]{aAll, aLive, aFinished, aSelected});
            this.shFilter.setToolTipText("Threads filter");
            this.tlLabel = new GrayLabel("Timeline:");
            this.tlZoomInButton = (JComponent)this.threadsPanel.getZoomIn();
            this.tlZoomInButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlZoomInButton.putClientProperty("JButton.segmentPosition", "first");
            this.tlZoomOutButton = (JComponent)this.threadsPanel.getZoomOut();
            this.tlZoomOutButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlZoomOutButton.putClientProperty("JButton.segmentPosition", "middle");
            this.tlFitWidthButton = (JComponent)this.threadsPanel.getFitWidth();
            this.tlFitWidthButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlFitWidthButton.putClientProperty("JButton.segmentPosition", "last");
            if (this.tlFitWidthButton instanceof AbstractButton) {
                ((AbstractButton)this.tlFitWidthButton).doClick();
            }
            this.toolbar = ProfilerToolbar.create((boolean)true);
            this.toolbar.addSpace(5);
            this.toolbar.add((Component)this.shLabel);
            this.toolbar.addSpace(2);
            this.toolbar.add((Component)this.shFilter);
            this.toolbar.addSpace(2);
            this.toolbar.addSeparator();
            this.toolbar.addSpace(5);
            this.toolbar.add((Component)this.tlLabel);
            this.toolbar.addSpace(2);
            this.toolbar.add((Component)this.tlZoomInButton);
            this.toolbar.add((Component)this.tlZoomOutButton);
            this.toolbar.add((Component)this.tlFitWidthButton);
            this.add((Component)this.toolbar.getComponent(), "North");
            this.setFilter(ThreadsPanel.Filter.ALL);
            this.add((Component)this.threadsPanel, "Center");
        }

        private void setSelectedFilter() {
            if (this.threadsPanel.hasSelectedThreads()) {
                this.setFilter(ThreadsPanel.Filter.SELECTED);
            } else {
                this.threadsPanel.showSelectedColumn();
                this.shFilter.selectAction(this.threadsPanel.getFilter().ordinal());
            }
        }

        private void setFilter(ThreadsPanel.Filter filter) {
            this.threadsPanel.setFilter(filter);
        }

        private static final class State {
            final long time;
            final byte tstate;
            static final Comparator<State> COMPARATOR = new Comparator<State>(){

                @Override
                public int compare(State r1, State r2) {
                    return Long.compare(r1.time, r2.time);
                }
            };

            State(long time, byte tstate) {
                this.time = time;
                this.tstate = tstate;
            }

            public int hashCode() {
                return Long.hashCode(this.time);
            }

            public boolean equals(Object o) {
                return o instanceof State ? ((State)o).time == this.time : false;
            }
        }

        private static final class Definition {
            final String tname;
            long firstTime;
            byte firstState;

            Definition(String tname, long firstTime, byte firstState) {
                this.tname = tname;
                this.firstTime = firstTime;
                this.firstState = firstState;
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private HTMLTextArea area;
        private HTMLTextArea alertArea;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ThreadsViewSupport.class, (String)"LBL_Threads"), null, (JComponent)this);
        }

        void initialized(Collection<String> activeTypes, int threadsCount) {
            if (activeTypes.isEmpty()) {
                this.area.setText(threadsCount == 0 ? "No threads information recorded" : "No thread states recorded.");
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String s : activeTypes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(s);
                }
                this.area.setText("Thread states based on:&nbsp;&nbsp;<code>" + sb.toString() + "</code>");
            }
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else {
                this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
                this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                this.add((Component)this.area, "West");
                this.alertArea = new HTMLTextArea();
                this.alertArea.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                this.alertArea.setForeground(Color.RED);
                this.add((Component)this.alertArea, "Center");
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

