/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.profiler.Bundle;
import org.graalvm.visualvm.profiler.CalibrationSupport;
import org.graalvm.visualvm.profiler.ProfilerSupport;
import org.graalvm.visualvm.profiling.presets.ProfilingOptionsSectionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;

public final class ManageCalibration
extends ProfilingOptionsSectionProvider {
    private String[] javaPlatforms;

    public String getSectionName() {
        return Bundle.CAP_SectionName();
    }

    public Component getSection() {
        JPanel container = new JPanel(new BorderLayout());
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)Bundle.LBL_ManageCalibration());
        container.add((Component)label, "Center");
        JButton button = new JButton(){

            protected void fireActionPerformed(ActionEvent e) {
                ManageCalibration.this.manageCalibration();
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.BTN_ManageCalibration());
        container.add((Component)button, "East");
        return container;
    }

    private void manageCalibration() {
        Object[] columnNames = new String[]{Bundle.LBL_JavaPlatform(), Bundle.LBL_LastCalibrated()};
        final DefaultTableModel model = new DefaultTableModel(this.createData(), columnNames){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ManageCalibration.this.displayUI(model);
            }
        });
    }

    private void displayUI(TableModel model) {
        final JTable table = new JTable(model);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(true);
        table.setGridColor(Color.LIGHT_GRAY);
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        TableColumnModel columns = table.getColumnModel();
        TableColumn status = columns.getColumn(1);
        status.setCellRenderer(new CalibrationDateCellRenderer());
        table.setPreferredScrollableViewportSize(new Dimension(350, table.getRowHeight() * 4));
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        container.add(new JScrollPane(table));
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)Bundle.LBL_JavaPlatformsForProfiling());
        label.setLabelFor(table);
        label.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
        final JButton calibrate = new JButton(){

            protected void fireActionPerformed(ActionEvent e) {
                ManageCalibration.this.calibrate(table);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)calibrate, (String)Bundle.LBL_Calibrate());
        table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        table.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ManageCalibration.this.calibrate(table);
            }
        });
        table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ManageCalibration.this.calibrate(table);
                }
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                calibrate.setEnabled(table.getSelectedRow() != -1);
            }
        });
        calibrate.setEnabled(false);
        table.clearSelection();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)container, "Center");
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ManageCalibration.this.refreshTimes(table);
            }
        });
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.HINT_RunCalibrationAction(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
        dd.setAdditionalOptions(new Object[]{calibrate});
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    }

    private void calibrate(final JTable table) {
        final int row = table.getSelectedRow();
        if (row == -1) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Runnable refresher = new Runnable(){

                    public void run() {
                        ManageCalibration.this.refreshTimes(table);
                    }
                };
                CalibrationSupport.calibrate(ManageCalibration.this.javaPlatforms[row], -1, null, refresher);
            }
        });
    }

    private void refreshTimes(JTable table) {
        final TableModel model = table.getModel();
        int row = 0;
        while (row < model.getRowCount()) {
            File f;
            String javaPlatform = this.javaPlatforms[row];
            Long modified = null;
            String s = CalibrationSupport.getCalibrationDataFileName(javaPlatform);
            if (s != null && (f = new File(s)).isFile()) {
                modified = f.lastModified();
            }
            final int index = row++;
            final Long _modified = modified;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    model.setValueAt(_modified, index, 1);
                }
            });
        }
    }

    private Object[][] createData() {
        String[][] platforms = ProfilerSupport.getInstance().getSupportedJavaPlatforms();
        this.javaPlatforms = platforms[1];
        String[] names = platforms[0];
        Object[][] data = new String[names.length][2];
        for (int i = 0; i < names.length; ++i) {
            data[i] = new String[]{names[i], null};
        }
        return data;
    }

    private static class CalibrationDateCellRenderer
    extends DefaultTableCellRenderer {
        private static Calendar CALENDAR;
        private static int REF_DAY_OF_YEAR;
        private static int DAY_OF_YEAR;
        private static int YEAR;
        private static int ERA;
        private static Date DATE;
        private static DateFormat FORMAT_TIME;
        private static DateFormat FORMAT_DATE;

        CalibrationDateCellRenderer() {
            this.setHorizontalAlignment(11);
        }

        protected void setValue(Object value) {
            if (value == null) {
                this.setText(Bundle.LBL_NotCalibrated());
            } else {
                long time = (Long)value;
                this.setValue(time, CalibrationDateCellRenderer.isToday(time));
            }
        }

        private void setValue(long time, boolean today) {
            DateFormat format;
            if (today) {
                if (FORMAT_TIME == null) {
                    FORMAT_TIME = DateFormat.getTimeInstance();
                }
                format = FORMAT_TIME;
            } else {
                if (FORMAT_DATE == null) {
                    FORMAT_DATE = DateFormat.getDateInstance();
                }
                format = FORMAT_DATE;
            }
            if (DATE == null) {
                DATE = new Date();
            }
            DATE.setTime(time);
            this.setText(format.format(DATE));
        }

        private static boolean isToday(long time) {
            if (REF_DAY_OF_YEAR != -1 && CALENDAR.get(6) != REF_DAY_OF_YEAR) {
                CALENDAR = null;
            }
            if (CALENDAR == null) {
                CalibrationDateCellRenderer.initializeCalendar();
            }
            CALENDAR.setTimeInMillis(time);
            return DAY_OF_YEAR == CALENDAR.get(6) && YEAR == CALENDAR.get(1) && ERA == CALENDAR.get(0);
        }

        private static void initializeCalendar() {
            CALENDAR = Calendar.getInstance();
            DAY_OF_YEAR = CALENDAR.get(6);
            YEAR = CALENDAR.get(1);
            ERA = CALENDAR.get(0);
            if (REF_DAY_OF_YEAR == -1) {
                REF_DAY_OF_YEAR = DAY_OF_YEAR;
            }
        }

        static {
            REF_DAY_OF_YEAR = -1;
            DAY_OF_YEAR = -1;
            YEAR = -1;
            ERA = -1;
        }
    }
}

