/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class Log {
    private final ProcessingEnvironment processingEnv;
    private final boolean emitWarnings;

    public static boolean isDebug() {
        return false;
    }

    public Log(ProcessingEnvironment env, boolean emitWarnings) {
        this.processingEnv = env;
        this.emitWarnings = emitWarnings;
    }

    public void debug(String message, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, null, null, null, message, args);
    }

    public void message(Diagnostic.Kind kind, Element element, AnnotationMirror mirror, AnnotationValue value, String format, Object ... args) {
        AnnotationMirror usedMirror = mirror;
        Element usedElement = element;
        AnnotationValue usedValue = value;
        String message = String.format(format, args);
        if (element instanceof GeneratedElement) {
            usedMirror = ((GeneratedElement)((Object)element)).getGeneratorAnnotationMirror();
            usedElement = ((GeneratedElement)((Object)element)).getGeneratorElement();
            usedValue = null;
            if (usedElement != null) {
                message = String.format("Element %s: %s", element, message);
            }
        }
        if (kind != Diagnostic.Kind.WARNING || this.emitWarnings) {
            this.processingEnv.getMessager().printMessage(kind, message, usedElement, usedMirror, usedValue);
        }
    }
}

