/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.generator.DSLExpressionGenerator;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeParameterElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.model.GeneratedTypeMirror;
import com.oracle.truffle.dsl.processor.model.AssumptionExpression;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.CreateCastData;
import com.oracle.truffle.dsl.processor.model.ExecutableTypeData;
import com.oracle.truffle.dsl.processor.model.GuardExpression;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import com.oracle.truffle.dsl.processor.model.NodeFieldData;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import com.oracle.truffle.dsl.processor.model.SpecializationThrowsData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.SpecializationGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class FlatNodeGenFactory {
    private static final String FRAME_VALUE = "frameValue";
    private static final String STATE_VALUE = "state";
    private static final String NAME_SUFFIX = "_";
    private static final String VARARGS_NAME = "args";
    private final ProcessorContext context;
    private final TruffleTypes types = ProcessorContext.getInstance().getTypes();
    private final NodeData node;
    private final TypeSystemData typeSystem;
    private final TypeMirror genericType;
    private final Set<TypeMirror> expectedTypes = new HashSet<TypeMirror>();
    private List<SpecializationData> reachableSpecializations;
    private SpecializationData[] reachableSpecializationsArray;
    private final Collection<NodeData> sharingNodes;
    private final boolean boxingEliminationEnabled;
    private int boxingSplitIndex = 0;
    private final BitSet state;
    private final BitSet exclude;
    private final ExecutableTypeData executeAndSpecializeType;
    private boolean fallbackNeedsState = false;
    private boolean fallbackNeedsFrame = false;
    private final Map<SpecializationData, CodeTypeElement> specializationClasses = new LinkedHashMap<SpecializationData, CodeTypeElement>();
    private final Set<SpecializationData> usedInsertAccessorsArray = new LinkedHashSet<SpecializationData>();
    private final Set<SpecializationData> usedInsertAccessorsSimple = new LinkedHashSet<SpecializationData>();
    private final boolean primaryNode;
    private final Map<CacheExpression, String> sharedCaches;
    private final Map<ExecutableElement, Function<DSLExpression.Call, DSLExpression>> substitutions = new LinkedHashMap<ExecutableElement, Function<DSLExpression.Call, DSLExpression>>();
    private final Map<String, CodeVariableElement> libraryConstants;
    private final boolean needsLocking;
    private static final String INSERT_ACCESSOR_NAME = "insertAccessor";
    private static final String OLD_PREFIX = "old";
    private static final String NEW_PREFIX = "new";
    private static final String COUNT_SUFIX = "Count";
    private static final String OLD_STATE = "oldState";
    private static final String OLD_EXCLUDE = "oldExclude";
    private static final String OLD_CACHE_COUNT = "oldCacheCount";
    private static final String NEW_STATE = "newState";
    private static final String NEW_EXCLUDE = "newExclude";
    private static final String REPORT_POLYMORPHIC_SPECIALIZE = "reportPolymorphicSpecialize";
    private static final String CHECK_FOR_POLYMORPHIC_SPECIALIZE = "checkForPolymorphicSpecialize";
    private static final String COUNT_CACHES = "countCaches";
    private int boundaryIndex = 0;
    private final Set<String> usedBoundaryNames = new HashSet<String>();
    private Map<SpecializationData, CodeExecutableElement> removeThisMethods = new HashMap<SpecializationData, CodeExecutableElement>();

    public FlatNodeGenFactory(ProcessorContext context, NodeData node, Map<String, CodeVariableElement> libraryConstants) {
        this(context, node, Arrays.asList(node), node.getSharedCaches(), libraryConstants);
    }

    public FlatNodeGenFactory(ProcessorContext context, NodeData node, Collection<NodeData> stateSharingNodes, Map<CacheExpression, String> sharedCaches, Map<String, CodeVariableElement> libraryConstants) {
        Objects.requireNonNull(node);
        this.context = context;
        this.sharingNodes = stateSharingNodes;
        this.node = node;
        this.typeSystem = node.getTypeSystem();
        this.genericType = context.getType(Object.class);
        this.boxingEliminationEnabled = true;
        this.reachableSpecializations = FlatNodeGenFactory.calculateReachableSpecializations(node);
        this.reachableSpecializationsArray = this.reachableSpecializations.toArray(new SpecializationData[0]);
        this.primaryNode = stateSharingNodes.iterator().next() == node;
        this.sharedCaches = sharedCaches;
        ArrayList<MessageContainer> stateObjects = new ArrayList<MessageContainer>();
        ArrayList<SpecializationData> excludeObjects = new ArrayList<SpecializationData>();
        for (NodeData stateNode : stateSharingNodes) {
            boolean needsRewrites = stateNode.needsRewrites(context);
            if (!needsRewrites) continue;
            List<SpecializationData> specializations = FlatNodeGenFactory.calculateReachableSpecializations(stateNode);
            LinkedHashSet<SpecializationGroup.TypeGuard> implicitCasts = new LinkedHashSet<SpecializationGroup.TypeGuard>();
            for (SpecializationData specialization : specializations) {
                stateObjects.add(specialization);
                int index = 0;
                for (Parameter p : specialization.getSignatureParameters()) {
                    TypeMirror targetType = p.getType();
                    List<TypeMirror> sourceTypes = stateNode.getTypeSystem().lookupSourceTypes(targetType);
                    if (sourceTypes.size() > 1) {
                        implicitCasts.add(new SpecializationGroup.TypeGuard(targetType, index));
                    }
                    ++index;
                }
                for (GuardExpression guard : specialization.getGuards()) {
                    if (!FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) continue;
                    stateObjects.add(guard);
                }
            }
            stateObjects.addAll(implicitCasts);
            excludeObjects.addAll(specializations);
        }
        this.state = new StateBitSet(stateObjects.toArray(new Object[0]));
        this.exclude = new ExcludeBitSet(excludeObjects.toArray(new SpecializationData[0]));
        this.executeAndSpecializeType = this.createExecuteAndSpecializeType();
        this.needsLocking = this.exclude.computeStateLength() != 0 || this.reachableSpecializations.stream().anyMatch(s -> !s.getCaches().isEmpty());
        this.libraryConstants = libraryConstants;
        this.substitutions.put(ElementUtils.findExecutableElement(this.types.LibraryFactory, "resolve"), binary -> this.substituteLibraryCall((DSLExpression.Call)binary));
    }

    private boolean needsRewrites() {
        return this.node.needsRewrites(this.context);
    }

    private boolean hasMultipleNodes() {
        return this.sharingNodes.size() > 1;
    }

    private String createSpecializationTypeName(SpecializationData s) {
        if (this.hasMultipleNodes()) {
            return ElementUtils.firstLetterUpperCase(FlatNodeGenFactory.getNodePrefix(s)) + ElementUtils.firstLetterUpperCase(s.getId()) + "Data";
        }
        return ElementUtils.firstLetterUpperCase(s.getId()) + "Data";
    }

    private String createSpecializationFieldName(SpecializationData s) {
        if (this.hasMultipleNodes()) {
            return ElementUtils.firstLetterLowerCase(FlatNodeGenFactory.getNodePrefix(s)) + NAME_SUFFIX + ElementUtils.firstLetterLowerCase(s.getId()) + "_cache";
        }
        return ElementUtils.firstLetterLowerCase(s.getId()) + "_cache";
    }

    private String createFieldName(SpecializationData specialization, Parameter cacheParameter) {
        if (this.useSpecializationClass(specialization)) {
            return cacheParameter.getLocalName() + NAME_SUFFIX;
        }
        String prefix = "";
        if (this.hasMultipleNodes()) {
            prefix = ElementUtils.firstLetterLowerCase(FlatNodeGenFactory.getNodePrefix(specialization)) + NAME_SUFFIX;
        }
        if (this.reachableSpecializations.size() > 1) {
            prefix = prefix + ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX;
        }
        return prefix + cacheParameter.getLocalName() + NAME_SUFFIX;
    }

    private static String getNodePrefix(SpecializationData specialization) {
        String name = specialization.getNode().getNodeId();
        if (name.endsWith("Node")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private String createAssumptionFieldName(SpecializationData specialization, AssumptionExpression assumption) {
        if (this.useSpecializationClass(specialization)) {
            return assumption.getId() + NAME_SUFFIX;
        }
        return ElementUtils.firstLetterLowerCase(specialization.getId()) + NAME_SUFFIX + assumption.getId() + NAME_SUFFIX;
    }

    private static String createSpecializationLocalName(SpecializationData s) {
        if (s == null) {
            return null;
        }
        return "s" + s.getIndex() + NAME_SUFFIX;
    }

    private static String nodeFieldName(NodeExecutionData execution) {
        if (execution.getChild() == null || execution.getChild().needsGeneratedField()) {
            return execution.getName() + NAME_SUFFIX;
        }
        return execution.getName();
    }

    private static String accessNodeField(NodeExecutionData execution) {
        if (execution.getChild() == null || execution.getChild().needsGeneratedField()) {
            return "this." + FlatNodeGenFactory.nodeFieldName(execution);
        }
        String access = "super." + execution.getChild().getName();
        if (execution.hasChildArrayIndex()) {
            access = access + "[" + execution.getChildArrayIndex() + "]";
        }
        return access;
    }

    private boolean useSpecializationClass(SpecializationData specialization) {
        for (CacheExpression expression : specialization.getCaches()) {
            if (expression.getDefaultExpression() == null) continue;
            if (this.sharedCaches.containsKey(expression)) {
                return false;
            }
            if (!this.isNodeInterfaceArray(expression.getDefaultExpression().getResolvedType())) continue;
            return true;
        }
        int size = 0;
        for (CacheExpression expression : specialization.getCaches()) {
            if (expression.isAlwaysInitialized()) continue;
            TypeMirror type = expression.getParameter().getType();
            if (ElementUtils.isPrimitive(type)) {
                switch (type.getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        ++size;
                        break;
                    }
                    case CHAR: 
                    case SHORT: {
                        size += 2;
                        break;
                    }
                    case INT: 
                    case FLOAT: {
                        size += 4;
                        break;
                    }
                    case LONG: 
                    case DOUBLE: {
                        size += 8;
                    }
                }
                continue;
            }
            size += 4;
        }
        if (size > 8 && !this.hasMultipleNodes()) {
            return true;
        }
        return specialization.getMaximumNumberOfInstances() > 1;
    }

    private static boolean needsFrameToExecute(List<SpecializationData> specializations) {
        for (SpecializationData specialization : specializations) {
            if (specialization.getFrame() == null) continue;
            return true;
        }
        return false;
    }

    private static String createImplicitTypeStateLocalName(Parameter execution) {
        String name = ElementUtils.firstLetterLowerCase(ElementUtils.getTypeId(execution.getType()));
        return name + "Cast" + execution.getSpecification().getExecution().getIndex();
    }

    private static boolean mayBeExcluded(SpecializationData specialization) {
        return !specialization.getExceptions().isEmpty() || !specialization.getExcludedBy().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public CodeTypeElement create(CodeTypeElement clazz) {
        void var8_18;
        String string;
        SpecializationData fallback;
        if (this.primaryNode) {
            for (NodeChildData child : this.node.getChildren()) {
                clazz.addOptional(this.createAccessChildMethod(child, false));
            }
            for (NodeFieldData field : this.node.getFields()) {
                if (!field.isGenerated()) continue;
                clazz.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), field.getType(), field.getName()));
                if (field.getGetter() == null || !field.getGetter().getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                CodeExecutableElement method = CodeExecutableElement.clone(field.getGetter());
                method.getModifiers().remove((Object)Modifier.ABSTRACT);
                method.createBuilder().startReturn().string("this.").string(field.getName()).end();
                clazz.add(method);
            }
            for (ExecutableElement superConstructor : GeneratorUtils.findUserConstructors(this.node.getTemplateType().asType())) {
                clazz.add(this.createNodeConstructor(clazz, superConstructor));
            }
            for (NodeExecutionData execution : this.node.getChildExecutions()) {
                if (execution.getChild() == null || !execution.getChild().needsGeneratedField()) continue;
                clazz.add(FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, execution.getNodeType(), FlatNodeGenFactory.nodeFieldName(execution), this.types.Node_Child, new Modifier[0]));
            }
        }
        this.createFields(clazz);
        TypeMirror genericReturnType = this.node.getPolymorphicSpecialization().getReturnType().getType();
        List<ExecutableTypeData> executableTypes = this.filterExecutableTypes(this.node.getExecutableTypes(), this.reachableSpecializations);
        ArrayList<ExecutableTypeData> genericExecutableTypes = new ArrayList<ExecutableTypeData>();
        ArrayList<ExecutableTypeData> specializedExecutableTypes = new ArrayList<ExecutableTypeData>();
        ArrayList<ExecutableTypeData> voidExecutableTypes = new ArrayList<ExecutableTypeData>();
        for (ExecutableTypeData executableTypeData : executableTypes) {
            if (ElementUtils.isVoid(executableTypeData.getReturnType())) {
                voidExecutableTypes.add(executableTypeData);
                continue;
            }
            if (executableTypeData.hasUnexpectedValue() && !ElementUtils.typeEquals(genericReturnType, executableTypeData.getReturnType())) {
                specializedExecutableTypes.add(executableTypeData);
                continue;
            }
            genericExecutableTypes.add(executableTypeData);
        }
        if (genericExecutableTypes.size() > 1) {
            boolean hasGenericTypeMatch = false;
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                if (!ElementUtils.typeEquals(executableTypeData.getReturnType(), genericReturnType)) continue;
                hasGenericTypeMatch = true;
                break;
            }
            if (hasGenericTypeMatch) {
                ListIterator listIterator = genericExecutableTypes.listIterator();
                while (listIterator.hasNext()) {
                    ExecutableTypeData executableTypeData = (ExecutableTypeData)listIterator.next();
                    if (ElementUtils.isAssignable(genericReturnType, executableTypeData.getReturnType())) continue;
                    listIterator.remove();
                    specializedExecutableTypes.add(executableTypeData);
                }
            }
        }
        if ((fallback = this.node.getGenericSpecialization()).getMethod() != null && fallback.isReachable()) {
            clazz.add(this.createFallbackGuard());
        }
        for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
            this.createExecute(clazz, executableTypeData, Collections.emptyList());
        }
        for (ExecutableTypeData executableTypeData : specializedExecutableTypes) {
            this.createExecute(clazz, executableTypeData, genericExecutableTypes);
        }
        for (ExecutableTypeData executableTypeData : voidExecutableTypes) {
            Iterator<SpecializationData> genericAndSpecialized = new ArrayList<ExecutableTypeData>();
            genericAndSpecialized.addAll(genericExecutableTypes);
            genericAndSpecialized.addAll(specializedExecutableTypes);
            this.createExecute(clazz, executableTypeData, (List<ExecutableTypeData>)((Object)genericAndSpecialized));
        }
        clazz.addOptional(this.createExecuteAndSpecialize());
        if (FlatNodeGenFactory.shouldReportPolymorphism(this.node, this.reachableSpecializations)) {
            clazz.addOptional(this.createCheckForPolymorphicSpecialize());
            if (this.requiresCacheCheck()) {
                clazz.addOptional(this.createCountCaches());
            }
        }
        Object var8_16 = null;
        try {
            AnnotationMirror annotationMirror = ElementUtils.findAnnotationMirror((Element)this.node.getTemplateType(), (TypeMirror)this.types.NodeInfo);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String string2 = string = var8_18 != null ? ElementUtils.getAnnotationValue(VariableElement.class, (AnnotationMirror)var8_18, "cost").getSimpleName().toString() : null;
        if ((string == null || string.equals("MONOMORPHIC")) && this.primaryNode) {
            clazz.add(this.createGetCostMethod(false));
        }
        for (TypeMirror typeMirror : ElementUtils.uniqueSortedTypes(this.expectedTypes, false)) {
            if (this.typeSystem.hasType(typeMirror)) continue;
            clazz.addOptional(TypeSystemCodeGenerator.createExpectMethod(Modifier.PRIVATE, this.typeSystem, this.context.getType(Object.class), typeMirror));
        }
        clazz.getEnclosedElements().addAll(this.removeThisMethods.values());
        for (SpecializationData specializationData : this.specializationClasses.keySet()) {
            CodeTypeElement codeTypeElement = this.specializationClasses.get(specializationData);
            if (this.getInsertAccessorSet(true).contains(specializationData)) {
                codeTypeElement.add(this.createInsertAccessor(true));
            }
            if (!this.getInsertAccessorSet(false).contains(specializationData)) continue;
            codeTypeElement.add(this.createInsertAccessor(false));
        }
        if (this.node.isReflectable()) {
            this.generateReflectionInfo(clazz);
        }
        if (this.node.isUncachable() && this.node.isGenerateUncached()) {
            CodeTypeElement uncached = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Uncached", this.node.getTemplateType().asType());
            uncached.getEnclosedElements().addAll(this.createUncachedFields());
            for (NodeChildData nodeChildData : this.node.getChildren()) {
                uncached.addOptional(this.createAccessChildMethod(nodeChildData, true));
            }
            for (ExecutableTypeData executableTypeData : genericExecutableTypes) {
                uncached.add(this.createUncachedExecute(executableTypeData));
            }
            for (ExecutableTypeData executableTypeData : specializedExecutableTypes) {
                uncached.add(this.createUncachedExecute(executableTypeData));
            }
            for (ExecutableTypeData executableTypeData : voidExecutableTypes) {
                uncached.add(this.createUncachedExecute(executableTypeData));
            }
            if (string == null || string.equals("MONOMORPHIC")) {
                uncached.add(this.createGetCostMethod(true));
            }
            CodeExecutableElement codeExecutableElement = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable"));
            codeExecutableElement.createBuilder().returnFalse();
            uncached.add(codeExecutableElement);
            clazz.add(uncached);
            GeneratedTypeMirror generatedTypeMirror = new GeneratedTypeMirror("", uncached.getSimpleName().toString());
            CodeVariableElement uncachedField = clazz.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), generatedTypeMirror, "UNCACHED"));
            uncachedField.createInitBuilder().startNew(generatedTypeMirror).end();
        }
        return clazz;
    }

    public List<CodeVariableElement> createUncachedFields() {
        ArrayList<CodeVariableElement> fields = new ArrayList<CodeVariableElement>();
        List<CacheExpression> cacheExpressions = this.computeUniqueReferenceCaches(true);
        for (CacheExpression cache : cacheExpressions) {
            CodeVariableElement supplierField = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), cache.getReferenceType(), FlatNodeGenFactory.createElementReferenceName(cache));
            CodeTreeBuilder builder = supplierField.createInitBuilder();
            if (cache.isCachedContext()) {
                builder.startCall("lookupContextReference").typeLiteral(cache.getLanguageType()).end();
            } else {
                builder.startCall("lookupLanguageReference").typeLiteral(cache.getLanguageType()).end();
            }
            fields.add(supplierField);
        }
        return fields;
    }

    private static boolean shouldReportPolymorphism(NodeData node, List<SpecializationData> reachableSpecializations) {
        if (reachableSpecializations.size() == 1 && reachableSpecializations.get(0).getMaximumNumberOfInstances() == 1) {
            return false;
        }
        return node.isReportPolymorphism();
    }

    private void generateReflectionInfo(CodeTypeElement clazz) {
        clazz.getImplements().add(this.types.Introspection_Provider);
        CodeExecutableElement reflection = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), this.types.Introspection, "getIntrospectionData", new CodeVariableElement[0]);
        CodeTreeBuilder builder = reflection.createBuilder();
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        for (SpecializationData s : this.node.getSpecializations()) {
            if (s.getMethod() == null) continue;
            filteredSpecializations.add(s);
        }
        CodeTypeMirror.ArrayCodeTypeMirror objectArray = new CodeTypeMirror.ArrayCodeTypeMirror(this.context.getType(Object.class));
        builder.declaration((TypeMirror)objectArray, "data", builder.create().startNewArray(objectArray, CodeTreeBuilder.singleString(String.valueOf(filteredSpecializations.size() + 1))).end().build());
        builder.declaration((TypeMirror)objectArray, "s", (CodeTree)null);
        builder.statement("data[0] = 0");
        boolean needsRewrites = this.needsRewrites();
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, reflection);
        if (needsRewrites) {
            builder.tree(this.state.createLoad(frameState));
            if (this.requiresExclude()) {
                builder.tree(this.exclude.createLoad(frameState));
            }
        }
        int index = 1;
        for (SpecializationData specialization : filteredSpecializations) {
            builder.startStatement().string("s = ").startNewArray(objectArray, CodeTreeBuilder.singleString("3")).end().end();
            builder.startStatement().string("s[0] = ").doubleQuote(specialization.getMethodName()).end();
            if (needsRewrites) {
                builder.startIf().tree(this.state.createContains(frameState, new Object[]{specialization})).end().startBlock();
            }
            builder.startStatement().string("s[1] = (byte)0b01 /* active */").end();
            CodeTypeMirror.DeclaredCodeTypeMirror listType = new CodeTypeMirror.DeclaredCodeTypeMirror((TypeElement)this.context.getDeclaredType(ArrayList.class).asElement(), Arrays.asList(this.context.getType(Object.class)));
            if (!specialization.getCaches().isEmpty()) {
                builder.declaration((TypeMirror)listType, "cached", "new ArrayList<>()");
                boolean useSpecializationClass = this.useSpecializationClass(specialization);
                String name = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                if (useSpecializationClass) {
                    builder.tree(this.loadSpecializationClass(frameState, specialization));
                    if (specialization.hasMultipleInstances()) {
                        builder.startWhile();
                    } else {
                        builder.startIf();
                    }
                    builder.string(name, " != null");
                    builder.end();
                    builder.startBlock();
                }
                builder.startStatement().startCall("cached", "add");
                builder.startStaticCall(this.context.getType(Arrays.class), "asList");
                for (CacheExpression cache : specialization.getCaches()) {
                    builder.startGroup();
                    if (cache.isAlwaysInitialized() && cache.isCachedLibrary()) {
                        builder.staticReference(FlatNodeGenFactory.createLibraryConstant(this.libraryConstants, cache.getParameter().getType()));
                        builder.startCall(".getUncached").end();
                    } else {
                        builder.tree(this.createCacheReference(frameState, specialization, cache));
                    }
                    builder.end();
                }
                builder.end();
                builder.end().end();
                if (useSpecializationClass) {
                    if (specialization.getMaximumNumberOfInstances() > 1) {
                        builder.startStatement().string(name, " = ", name, ".next_").end();
                    }
                    builder.end();
                }
                builder.statement("s[2] = cached");
            }
            if (needsRewrites) {
                builder.end();
                if (FlatNodeGenFactory.mayBeExcluded(specialization)) {
                    builder.startElseIf().tree(this.exclude.createContains(frameState, new Object[]{specialization})).end().startBlock();
                    builder.startStatement().string("s[1] = (byte)0b10 /* excluded */").end();
                    builder.end();
                }
                builder.startElseBlock();
                builder.startStatement().string("s[1] = (byte)0b00 /* inactive */").end();
                builder.end();
            }
            builder.startStatement().string("data[", String.valueOf(index), "] = s").end();
            ++index;
        }
        builder.startReturn().startStaticCall(this.types.Introspection_Provider, "create").string("data").end().end();
        clazz.add(reflection);
    }

    private void createFields(CodeTypeElement clazz) {
        if (this.primaryNode) {
            if (this.state.computeStateLength() > 0) {
                this.state.declareFields(clazz);
            }
            if (this.exclude.computeStateLength() > 0) {
                this.exclude.declareFields(clazz);
            }
        }
        if (this.primaryNode && !this.sharedCaches.isEmpty()) {
            HashSet<Iterator<AssumptionExpression>> expressions = new HashSet<Iterator<AssumptionExpression>>();
            for (Map.Entry entry : this.sharedCaches.entrySet()) {
                CodeVariableElement cachedField;
                CacheExpression cache = (CacheExpression)entry.getKey();
                String fieldName = (String)entry.getValue();
                if (expressions.contains(fieldName) || cache.isAlwaysInitialized()) continue;
                expressions.add((Iterator<AssumptionExpression>)((Object)fieldName));
                Parameter parameter = cache.getParameter();
                TypeMirror type = parameter.getType();
                Modifier visibility = Modifier.PRIVATE;
                if (ElementUtils.isAssignable(type, this.types.NodeInterface)) {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, this.types.Node_Child, new Modifier[0]);
                } else if (this.isNodeInterfaceArray(type)) {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, this.types.Node_Children, new Modifier[0]);
                } else {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, null, new Modifier[0]);
                    AnnotationMirror mirror = ElementUtils.findAnnotationMirror(parameter.getVariableElement().getAnnotationMirrors(), (TypeMirror)this.types.Cached);
                    int dimensions = ElementUtils.getAnnotationValue(Integer.class, mirror, "dimensions");
                    FlatNodeGenFactory.setFieldCompilationFinal(cachedField, dimensions);
                }
                clazz.getEnclosedElements().add(cachedField);
            }
        }
        if (this.primaryNode) {
            List<CacheExpression> cacheExpressions = this.computeUniqueReferenceCaches(false);
            for (CacheExpression cacheExpression : cacheExpressions) {
                CodeVariableElement supplierField = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), cacheExpression.getReferenceType(), FlatNodeGenFactory.createElementReferenceName(cacheExpression));
                supplierField.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_CompilationFinal));
                clazz.getEnclosedElements().add(supplierField);
            }
        }
        for (SpecializationData specialization : this.reachableSpecializations) {
            ArrayList<CodeVariableElement> arrayList = new ArrayList<CodeVariableElement>();
            boolean useSpecializationClass = this.useSpecializationClass(specialization);
            for (CacheExpression cache : specialization.getCaches()) {
                CodeVariableElement cachedField;
                Modifier visibility;
                String sharedName;
                if (cache.isAlwaysInitialized() || (sharedName = this.sharedCaches.get(cache)) != null) continue;
                Parameter parameter = cache.getParameter();
                String fieldName = this.createFieldName(specialization, parameter);
                TypeMirror type = parameter.getType();
                Modifier modifier = visibility = useSpecializationClass ? null : Modifier.PRIVATE;
                if (ElementUtils.isAssignable(type, this.types.NodeInterface)) {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, this.types.Node_Child, new Modifier[0]);
                } else if (this.isNodeInterfaceArray(type)) {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, this.types.Node_Children, new Modifier[0]);
                } else {
                    cachedField = FlatNodeGenFactory.createNodeField(visibility, type, fieldName, null, new Modifier[0]);
                    if (cache.isCached()) {
                        AnnotationMirror mirror = cache.getMessageAnnotation();
                        int dimensions = ElementUtils.getAnnotationValue(Integer.class, mirror, "dimensions");
                        FlatNodeGenFactory.setFieldCompilationFinal(cachedField, dimensions);
                    }
                }
                arrayList.add(cachedField);
            }
            for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
                int compilationFinalDimensions;
                ReferenceType type;
                String fieldName = this.createAssumptionFieldName(specialization, assumption);
                if (assumption.getExpression().getResolvedType().getKind() == TypeKind.ARRAY) {
                    type = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Assumption);
                    compilationFinalDimensions = 1;
                } else {
                    type = this.types.Assumption;
                    compilationFinalDimensions = -1;
                }
                CodeVariableElement assumptionField = useSpecializationClass ? FlatNodeGenFactory.createNodeField(null, type, fieldName, null, new Modifier[0]) : FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, type, fieldName, null, new Modifier[0]);
                FlatNodeGenFactory.setFieldCompilationFinal(assumptionField, compilationFinalDimensions);
                arrayList.add(assumptionField);
            }
            if (useSpecializationClass) {
                DeclaredType annotationType;
                boolean useNode = this.specializationClassIsNode(specialization);
                TypeMirror baseType = useNode ? this.types.Node : this.context.getType(Object.class);
                String typeName = this.createSpecializationTypeName(specialization);
                CodeTypeElement cacheType = GeneratorUtils.createClass(this.node, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC), this.createSpecializationTypeName(specialization), baseType);
                GeneratedTypeMirror referenceType = new GeneratedTypeMirror("", typeName);
                if (useNode) {
                    annotationType = this.types.Node_Child;
                    if (specialization.getMaximumNumberOfInstances() > 1) {
                        cacheType.add(FlatNodeGenFactory.createNodeField(null, referenceType, "next_", this.types.Node_Child, new Modifier[0]));
                    }
                    CodeExecutableElement getNodeCost = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), this.types.NodeCost, "getCost", new CodeVariableElement[0]);
                    getNodeCost.createBuilder().startReturn().staticReference(this.types.NodeCost, "NONE").end();
                    cacheType.add(getNodeCost);
                } else {
                    annotationType = this.types.CompilerDirectives_CompilationFinal;
                    if (specialization.getMaximumNumberOfInstances() > 1) {
                        cacheType.add(FlatNodeGenFactory.createNodeField(null, referenceType, "next_", annotationType, new Modifier[0]));
                    }
                }
                cacheType.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cacheType));
                cacheType.getEnclosedElements().addAll(arrayList);
                clazz.add(FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, referenceType, this.createSpecializationFieldName(specialization), annotationType, new Modifier[0]));
                clazz.add(cacheType);
                this.specializationClasses.put(specialization, cacheType);
                continue;
            }
            clazz.getEnclosedElements().addAll(arrayList);
        }
    }

    private List<CacheExpression> computeUniqueReferenceCaches(boolean uncached) {
        ArrayList<CacheExpression> cacheExpressions = new ArrayList<CacheExpression>();
        HashSet<String> computedContextReferences = new HashSet<String>();
        HashSet<String> computedLanguageReferences = new HashSet<String>();
        for (NodeData sharedNode : this.sharingNodes) {
            Collection<SpecializationData> specializations = uncached ? sharedNode.computeUncachedSpecializations(FlatNodeGenFactory.calculateReachableSpecializations(sharedNode)) : FlatNodeGenFactory.calculateReachableSpecializations(sharedNode);
            for (SpecializationData specialization : specializations) {
                for (CacheExpression cache : specialization.getCaches()) {
                    if (!cache.isCachedContext() && !cache.isCachedLanguage()) continue;
                    TypeMirror languageType = cache.getLanguageType();
                    String qualifiedLanguageTypeName = ElementUtils.getQualifiedName(languageType);
                    if (cache.isCachedLanguage()) {
                        if (computedLanguageReferences.contains(qualifiedLanguageTypeName)) continue;
                        computedLanguageReferences.add(qualifiedLanguageTypeName);
                    }
                    if (cache.isCachedContext()) {
                        if (computedContextReferences.contains(qualifiedLanguageTypeName)) continue;
                        computedContextReferences.add(qualifiedLanguageTypeName);
                    }
                    cacheExpressions.add(cache);
                }
            }
        }
        return cacheExpressions;
    }

    private CodeExecutableElement createInsertAccessor(boolean array) {
        CodeTypeParameterElement tVar = new CodeTypeParameterElement(CodeNames.of("T"), this.types.Node);
        TypeMirror type = tVar.createMirror(null, null);
        if (array) {
            type = new CodeTypeMirror.ArrayCodeTypeMirror(type);
        }
        CodeExecutableElement insertAccessor = new CodeExecutableElement(ElementUtils.modifiers(Modifier.FINAL), type, INSERT_ACCESSOR_NAME, new CodeVariableElement[0]);
        insertAccessor.getParameters().add(new CodeVariableElement(type, "node"));
        insertAccessor.getTypeParameters().add(tVar);
        insertAccessor.createBuilder().startReturn().string("super.insert(node)").end();
        return insertAccessor;
    }

    private String useInsertAccessor(SpecializationData specialization, boolean array) {
        this.getInsertAccessorSet(array).add(specialization);
        return INSERT_ACCESSOR_NAME;
    }

    private Set<SpecializationData> getInsertAccessorSet(boolean array) {
        if (array) {
            return this.usedInsertAccessorsArray;
        }
        return this.usedInsertAccessorsSimple;
    }

    private boolean isNodeInterfaceArray(TypeMirror type) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.ARRAY && ElementUtils.isAssignable(((ArrayType)type).getComponentType(), this.types.NodeInterface);
    }

    private static void setFieldCompilationFinal(CodeVariableElement field, int dimensions) {
        if (field.getModifiers().contains((Object)Modifier.FINAL) && dimensions <= 0) {
            return;
        }
        CodeAnnotationMirror annotation = new CodeAnnotationMirror(ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal);
        if (dimensions > 0 || field.getType().getKind() == TypeKind.ARRAY) {
            annotation.setElementValue(annotation.findExecutableElement("dimensions"), new CodeAnnotationValue(dimensions < 0 ? 0 : dimensions));
        }
        field.getAnnotationMirrors().add(annotation);
    }

    private boolean specializationClassIsNode(SpecializationData specialization) {
        boolean useSpecializationClass = this.useSpecializationClass(specialization);
        if (useSpecializationClass) {
            for (CacheExpression cache : specialization.getCaches()) {
                TypeMirror type = cache.getParameter().getType();
                if (ElementUtils.isAssignable(type, this.types.NodeInterface)) {
                    return true;
                }
                if (!this.isNodeInterfaceArray(type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean requiresExclude() {
        for (SpecializationData specialization : this.reachableSpecializations) {
            if (!FlatNodeGenFactory.mayBeExcluded(specialization)) continue;
            return true;
        }
        return false;
    }

    private Element createFallbackGuard() {
        boolean frameUsed = false;
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>(this.reachableSpecializations);
        ListIterator iterator = specializations.listIterator();
        while (iterator.hasNext()) {
            SpecializationData specialization = (SpecializationData)iterator.next();
            if (specialization.isFallback()) {
                iterator.remove();
                continue;
            }
            if (!specialization.isReachesFallback()) {
                iterator.remove();
                continue;
            }
            if (!specialization.isFrameUsedByGuard()) continue;
            frameUsed = true;
        }
        SpecializationGroup group = SpecializationGroup.create(specializations);
        ExecutableTypeData executableType = this.node.findAnyGenericExecutableType(this.context, -1);
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.getType(Boolean.TYPE), this.createFallbackName(), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.FALLBACK_GUARD, method);
        if (!frameUsed) {
            frameState.removeValue(FRAME_VALUE);
        }
        this.fallbackNeedsState = false;
        this.fallbackNeedsFrame = frameUsed;
        this.state.createLoad(frameState);
        frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE, STATE_VALUE);
        LinkedHashSet<? extends TypeMirror> thrownTypes = new LinkedHashSet<TypeMirror>();
        for (SpecializationData specialization : specializations) {
            for (GuardExpression expression : specialization.getGuards()) {
                for (ExecutableElement boundMethod : expression.getExpression().findBoundExecutableElements()) {
                    thrownTypes.addAll(boundMethod.getThrownTypes());
                }
            }
        }
        method.getThrownTypes().addAll(thrownTypes);
        CodeTree result = this.visitSpecializationGroup(CodeTreeBuilder.createBuilder(), null, group, executableType, frameState, null);
        if (!this.fallbackNeedsState) {
            VariableElement toRemove = null;
            for (VariableElement v : method.getParameters()) {
                if (!v.getSimpleName().toString().equals(STATE_VALUE)) continue;
                toRemove = v;
                break;
            }
            if (toRemove != null) {
                method.getParameters().remove(toRemove);
            }
        }
        CodeTreeBuilder builder = method.createBuilder();
        for (SpecializationData implemented : specializations) {
            if (implemented.getMaximumNumberOfInstances() <= 1) continue;
            method.getAnnotationMirrors().add(this.createExplodeLoop());
            break;
        }
        builder.tree(result);
        builder.returnTrue();
        if (!FlatNodeGenFactory.accessesCachedState(specializations)) {
            method.getModifiers().add(Modifier.STATIC);
        }
        return method;
    }

    private DSLExpression substituteLibraryCall(DSLExpression.Call call) {
        DSLExpression.ClassLiteral literal = (DSLExpression.ClassLiteral)call.getParameters().get(0);
        CodeVariableElement var = FlatNodeGenFactory.createLibraryConstant(this.libraryConstants, literal.getLiteral());
        String constantName = var.getSimpleName().toString();
        DSLExpression.Variable singleton = new DSLExpression.Variable(null, constantName);
        singleton.setResolvedTargetType(var.asType());
        singleton.setResolvedVariable(var);
        return singleton;
    }

    public static CodeVariableElement createLibraryConstant(Map<String, CodeVariableElement> constants, TypeMirror libraryTypeMirror) {
        CodeVariableElement var;
        TypeElement libraryType = ElementUtils.castTypeElement(libraryTypeMirror);
        String name = libraryType.getSimpleName().toString();
        String constantName = ElementUtils.createConstantName(name);
        do {
            String useConstantName = constantName = constantName + NAME_SUFFIX;
            TypeElement resolvedLibrary = (TypeElement)ProcessorContext.getInstance().getTypes().LibraryFactory.asElement();
            CodeTypeMirror.DeclaredCodeTypeMirror constantType = new CodeTypeMirror.DeclaredCodeTypeMirror(resolvedLibrary, Arrays.asList(libraryType.asType()));
            var = constants.computeIfAbsent(constantName, c -> {
                CodeVariableElement newVar = new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), constantType, useConstantName);
                newVar.createInitBuilder().startStaticCall(resolvedLibrary.asType(), "resolve").typeLiteral(libraryType.asType()).end();
                return newVar;
            });
        } while (!ElementUtils.typeEquals(libraryType.asType(), ((DeclaredType)var.getType()).getTypeArguments().get(0)));
        return var;
    }

    private DSLExpression optimizeExpression(DSLExpression expression) {
        return expression.reduce(new DSLExpression.DSLExpressionReducer(){

            @Override
            public DSLExpression visitVariable(DSLExpression.Variable binary) {
                return binary;
            }

            @Override
            public DSLExpression visitNegate(DSLExpression.Negate negate) {
                return negate;
            }

            @Override
            public DSLExpression visitCall(DSLExpression.Call binary) {
                for (ExecutableElement substitution : FlatNodeGenFactory.this.substitutions.keySet()) {
                    if (!ElementUtils.executableEquals(binary.getResolvedMethod(), substitution)) continue;
                    return (DSLExpression)((Function)FlatNodeGenFactory.this.substitutions.get(substitution)).apply(binary);
                }
                return binary;
            }

            @Override
            public DSLExpression visitBinary(DSLExpression.Binary binary) {
                return binary;
            }
        });
    }

    private static boolean accessesCachedState(List<SpecializationData> specializations) {
        final AtomicBoolean needsState = new AtomicBoolean(false);
        for (final SpecializationData specialization : specializations) {
            if (!specialization.getAssumptionExpressions().isEmpty()) {
                needsState.set(true);
                break;
            }
            for (GuardExpression expression : specialization.getGuards()) {
                expression.getExpression().accept(new DSLExpression.DSLExpressionVisitor(){

                    @Override
                    public void visitVariable(DSLExpression.Variable binary) {
                        if (!needsState.get() && this.isVariableAccessMember(binary)) {
                            needsState.set(true);
                        }
                    }

                    @Override
                    public void visitClassLiteral(DSLExpression.ClassLiteral classLiteral) {
                    }

                    private boolean isVariableAccessMember(DSLExpression.Variable variable) {
                        if (variable.getName().equals("null") && variable.getReceiver() == null) {
                            return false;
                        }
                        Parameter p = specialization.findByVariable(variable.getResolvedVariable());
                        if (p == null && !variable.getResolvedVariable().getModifiers().contains((Object)Modifier.STATIC)) {
                            DSLExpression receiver = variable.getReceiver();
                            if (receiver instanceof DSLExpression.Variable) {
                                return this.isVariableAccessMember((DSLExpression.Variable)receiver);
                            }
                            if (receiver instanceof DSLExpression.Call) {
                                return this.isMethodAccessMember((DSLExpression.Call)receiver);
                            }
                            return true;
                        }
                        if (p != null && p.getSpecification().isCached()) {
                            CacheExpression cache = specialization.findCache(p);
                            return cache == null || !cache.isAlwaysInitialized();
                        }
                        return false;
                    }

                    @Override
                    public void visitBooleanLiteral(DSLExpression.BooleanLiteral binary) {
                    }

                    @Override
                    public void visitNegate(DSLExpression.Negate negate) {
                    }

                    @Override
                    public void visitIntLiteral(DSLExpression.IntLiteral binary) {
                    }

                    private boolean isMethodAccessMember(DSLExpression.Call call) {
                        if (!call.getResolvedMethod().getModifiers().contains((Object)Modifier.STATIC)) {
                            DSLExpression receiver = call.getReceiver();
                            if (receiver instanceof DSLExpression.Variable) {
                                return this.isVariableAccessMember((DSLExpression.Variable)receiver);
                            }
                            if (receiver instanceof DSLExpression.Call) {
                                return this.isMethodAccessMember((DSLExpression.Call)receiver);
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void visitCall(DSLExpression.Call call) {
                        if (!needsState.get() && this.isMethodAccessMember(call)) {
                            needsState.set(true);
                        }
                    }

                    @Override
                    public void visitBinary(DSLExpression.Binary binary) {
                    }
                });
            }
        }
        boolean needsStat = needsState.get();
        return needsStat;
    }

    private CodeAnnotationMirror createExplodeLoop() {
        VariableElement kindValue;
        DeclaredType explodeLoopType = this.types.ExplodeLoop;
        CodeAnnotationMirror explodeLoop = new CodeAnnotationMirror(explodeLoopType);
        DeclaredType loopExplosionKind = this.types.ExplodeLoop_LoopExplosionKind;
        if (loopExplosionKind != null && (kindValue = ElementUtils.findVariableElement(loopExplosionKind, "FULL_EXPLODE_UNTIL_RETURN")) != null) {
            explodeLoop.setElementValue(ElementUtils.findExecutableElement(explodeLoopType, "kind"), new CodeAnnotationValue(kindValue));
        }
        return explodeLoop;
    }

    private List<SpecializationData> filterCompatibleSpecializations(Collection<SpecializationData> specializations, ExecutableTypeData forType) {
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        block0: for (SpecializationData specialization : specializations) {
            if (specialization.isFallback() && specialization.getMethod() == null) continue;
            List<TypeMirror> signatureParameters = forType.getSignatureParameters();
            for (int i = 0; i < signatureParameters.size(); ++i) {
                TypeMirror specializedType;
                TypeMirror evaluatedType = signatureParameters.get(i);
                if (this.typeSystem.lookupCast(evaluatedType, specializedType = specialization.findParameterOrDie(this.node.getChildExecutions().get(i)).getType()) == null && !ElementUtils.isSubtypeBoxed(this.context, specializedType, evaluatedType) && !ElementUtils.isSubtypeBoxed(this.context, evaluatedType, specializedType)) continue block0;
            }
            TypeMirror returnType = forType.getReturnType();
            if (!ElementUtils.isVoid(returnType) && !ElementUtils.isSubtypeBoxed(this.context, specialization.getReturnType().getType(), returnType) && !ElementUtils.isSubtypeBoxed(this.context, returnType, specialization.getReturnType().getType())) continue;
            filteredSpecializations.add(specialization);
        }
        return filteredSpecializations;
    }

    private List<SpecializationData> filterImplementedSpecializations(List<SpecializationData> specializations, TypeMirror expectedReturnType) {
        ArrayList<SpecializationData> filteredSpecializations = new ArrayList<SpecializationData>();
        TypeMirror returnType = ElementUtils.boxType(this.context, expectedReturnType);
        for (SpecializationData specialization : specializations) {
            TypeMirror specializationReturnType = ElementUtils.boxType(this.context, specialization.getReturnType().getType());
            if (!ElementUtils.typeEquals(specializationReturnType, returnType)) continue;
            filteredSpecializations.add(specialization);
        }
        return filteredSpecializations;
    }

    private List<ExecutableTypeData> filterCompatibleExecutableTypes(ExecutableTypeData type, List<ExecutableTypeData> genericExecutes) {
        ArrayList<ExecutableTypeData> compatible = new ArrayList<ExecutableTypeData>();
        block0: for (ExecutableTypeData genericExecute : genericExecutes) {
            if (genericExecute.getEvaluatedCount() != type.getEvaluatedCount()) continue;
            for (int i = 0; i < genericExecute.getEvaluatedCount(); ++i) {
                TypeMirror targetType;
                TypeMirror sourceType = type.getSignatureParameters().get(i);
                if (!ElementUtils.isAssignable(sourceType, targetType = genericExecute.getSignatureParameters().get(i))) continue block0;
            }
            if (!ElementUtils.isVoid(type.getReturnType()) && !ElementUtils.isSubtypeBoxed(this.context, type.getReturnType(), genericExecute.getReturnType()) && !ElementUtils.isSubtypeBoxed(this.context, genericExecute.getReturnType(), type.getReturnType())) continue;
            compatible.add(genericExecute);
        }
        return compatible;
    }

    private CodeExecutableElement createExecute(CodeTypeElement clazz, ExecutableTypeData type, List<ExecutableTypeData> delegateableTypes) {
        List<SpecializationData> allSpecializations = this.reachableSpecializations;
        List<SpecializationData> compatibleSpecializations = this.filterCompatibleSpecializations(allSpecializations, type);
        List<SpecializationData> implementedSpecializations = delegateableTypes.isEmpty() ? compatibleSpecializations : this.filterImplementedSpecializations(compatibleSpecializations, type.getReturnType());
        CodeExecutableElement method = this.createExecuteMethod(type);
        FrameState frameState = FrameState.load(this, type, Integer.MAX_VALUE, NodeExecutionMode.FAST_PATH, method);
        if (type.getMethod() == null) {
            frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        } else {
            this.renameOriginalParameters(type, method, frameState);
        }
        clazz.add(method);
        CodeTreeBuilder builder = method.createBuilder();
        if (compatibleSpecializations.size() != implementedSpecializations.size()) {
            ExecuteDelegationResult delegation = this.createExecuteDelegation(builder, frameState, type, delegateableTypes, compatibleSpecializations, implementedSpecializations);
            builder.tree(delegation.tree);
            if (!delegation.hasFallthrough) {
                return method;
            }
        }
        if (implementedSpecializations.isEmpty()) {
            implementedSpecializations = compatibleSpecializations;
        }
        if (implementedSpecializations.isEmpty()) {
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.startThrow().startNew(this.getType(AssertionError.class)).doubleQuote("Delegation failed.").end().end();
        } else {
            SpecializationGroup group = SpecializationGroup.create(implementedSpecializations);
            builder.tree(this.createFastPath(builder, implementedSpecializations, group, type, frameState));
        }
        return method;
    }

    public CodeExecutableElement createUncached() {
        SpecializationData fallback = this.node.getGenericSpecialization();
        TypeMirror returnType = fallback.getReturnType().getType();
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>();
        for (Parameter parameter : fallback.getSignatureParameters()) {
            parameterTypes.add(parameter.getType());
        }
        ExecutableTypeData forType = new ExecutableTypeData(this.node, returnType, "uncached", null, parameterTypes);
        return this.createUncachedExecute(forType);
    }

    private CodeExecutableElement createUncachedExecute(ExecutableTypeData forType) {
        boolean isExecutableInUncached;
        Collection<SpecializationData> allSpecializations = this.node.computeUncachedSpecializations(this.reachableSpecializations);
        List<SpecializationData> compatibleSpecializations = this.filterCompatibleSpecializations(allSpecializations, forType);
        CodeExecutableElement method = this.createExecuteMethod(forType);
        FrameState frameState = FrameState.load(this, forType, Integer.MAX_VALUE, NodeExecutionMode.UNCACHED, method);
        if (forType.getMethod() == null) {
            frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE);
        } else {
            this.renameOriginalParameters(forType, method, frameState);
        }
        boolean bl = isExecutableInUncached = forType.getEvaluatedCount() != this.node.getExecutionCount();
        if (!isExecutableInUncached) {
            method.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
        }
        if (forType.getMethod() != null) {
            method.getModifiers().addAll(forType.getMethod().getModifiers());
            method.getModifiers().remove((Object)Modifier.ABSTRACT);
        }
        CodeTreeBuilder builder = method.createBuilder();
        if (isExecutableInUncached) {
            builder.startThrow().startNew(this.context.getType(AssertionError.class));
            builder.doubleQuote("This execute method cannot be used for uncached node versions as it requires child nodes to be present. Use an execute method that takes all arguments as parameters.");
            builder.end().end();
        } else {
            SpecializationGroup group = SpecializationGroup.create(compatibleSpecializations);
            FrameState originalFrameState = frameState.copy();
            builder.tree(this.visitSpecializationGroup(builder, null, group, forType, frameState, allSpecializations));
            if (group.hasFallthrough()) {
                builder.tree(this.createThrowUnsupported(builder, originalFrameState));
            }
        }
        return method;
    }

    private ExecuteDelegationResult createExecuteDelegation(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData type, List<ExecutableTypeData> delegateableTypes, List<SpecializationData> compatibleSpecializations, List<SpecializationData> implementedSpecializations) {
        CodeTreeBuilder builder = parent.create();
        ArrayList<SpecializationData> notImplemented = new ArrayList<SpecializationData>(compatibleSpecializations);
        for (SpecializationData specialization : implementedSpecializations) {
            notImplemented.remove(specialization);
        }
        if (notImplemented.isEmpty()) {
            throw new AssertionError();
        }
        List<ExecutableTypeData> compatibleDelegateTypes = this.filterCompatibleExecutableTypes(type, delegateableTypes);
        ArrayList<ExecutableTypeData> delegatedDelegateTypes = new ArrayList<ExecutableTypeData>();
        CodeTreeBuilder delegateBuilder = builder.create();
        boolean elseIf = false;
        boolean coversAllSpecializations = false;
        if (this.boxingEliminationEnabled) {
            HashSet<TypeMirror> optimizeTypes = new HashSet<TypeMirror>();
            for (SpecializationData specialization : this.reachableSpecializations) {
                TypeMirror returnType = specialization.getReturnType().getType();
                if (!ElementUtils.isPrimitive(returnType)) continue;
                optimizeTypes.add(returnType);
            }
            for (TypeMirror optimizedType : ElementUtils.uniqueSortedTypes(optimizeTypes, true)) {
                ExecutableTypeData delegateType = null;
                for (ExecutableTypeData compatibleType : compatibleDelegateTypes) {
                    if (!ElementUtils.typeEquals(compatibleType.getReturnType(), optimizedType)) continue;
                    delegateType = compatibleType;
                    break;
                }
                if (delegateType == null) continue;
                List<SpecializationData> delegateSpecializations = this.filterImplementedSpecializations(this.filterCompatibleSpecializations(this.reachableSpecializations, delegateType), delegateType.getReturnType());
                boolean bl = coversAllSpecializations = delegateSpecializations.size() == this.reachableSpecializations.size();
                if (!coversAllSpecializations) {
                    builder.tree(this.state.createLoad(frameState));
                    elseIf = delegateBuilder.startIf(elseIf);
                    delegateBuilder.startGroup();
                    delegateBuilder.tree(this.state.createContainsOnly(frameState, 0, -1, delegateSpecializations.toArray(), this.reachableSpecializationsArray)).end();
                    delegateBuilder.string(" && ");
                    delegateBuilder.tree(this.state.createIsNotAny(frameState, this.reachableSpecializationsArray));
                    delegateBuilder.end();
                    delegateBuilder.end();
                    delegateBuilder.startBlock();
                }
                delegatedDelegateTypes.add(delegateType);
                delegateBuilder.tree(this.createCallExecute(type, delegateType, frameState));
                if (!coversAllSpecializations) {
                    delegateBuilder.end();
                }
                if (!coversAllSpecializations) continue;
                break;
            }
        }
        if (!compatibleDelegateTypes.isEmpty() && !coversAllSpecializations) {
            ExecutableTypeData delegateType = compatibleDelegateTypes.get(0);
            boolean bl = coversAllSpecializations = notImplemented.size() == this.reachableSpecializations.size();
            if (!coversAllSpecializations) {
                builder.tree(this.state.createLoad(frameState));
                elseIf = delegateBuilder.startIf(elseIf);
                delegateBuilder.tree(this.state.createContains(frameState, notImplemented.toArray())).end();
                delegateBuilder.startBlock();
            }
            delegatedDelegateTypes.add(delegateType);
            delegateBuilder.tree(this.createCallExecute(type, delegateType, frameState));
            if (!coversAllSpecializations) {
                delegateBuilder.end();
            }
        }
        boolean hasUnexpected = false;
        for (ExecutableTypeData delegateType : delegatedDelegateTypes) {
            if (!this.needsUnexpectedResultException(delegateType)) continue;
            hasUnexpected = true;
            break;
        }
        if (hasUnexpected) {
            builder.startTryBlock();
            builder.tree(delegateBuilder.build());
            builder.end().startCatchBlock(this.types.UnexpectedResultException, "ex");
            if (ElementUtils.isVoid(type.getReturnType())) {
                builder.returnStatement();
            } else {
                builder.startReturn();
                builder.tree(this.expectOrCast(this.getType(Object.class), type, CodeTreeBuilder.singleString("ex")));
                builder.end();
            }
            builder.end();
        } else {
            builder.tree(delegateBuilder.build());
        }
        return new ExecuteDelegationResult(builder.build(), !coversAllSpecializations);
    }

    private String createFallbackName() {
        if (this.hasMultipleNodes()) {
            String messageName = this.node.getNodeId();
            if (messageName.endsWith("Node")) {
                messageName = messageName.substring(0, messageName.length() - 4);
            }
            return ElementUtils.firstLetterLowerCase(messageName) + "FallbackGuard_";
        }
        return "fallbackGuard_";
    }

    private String createExecuteAndSpecializeName() {
        if (this.hasMultipleNodes()) {
            String messageName = this.node.getNodeId();
            if (messageName.endsWith("Node")) {
                messageName = messageName.substring(0, messageName.length() - 4);
            }
            return ElementUtils.firstLetterLowerCase(messageName) + "AndSpecialize";
        }
        return "executeAndSpecialize";
    }

    private CodeExecutableElement createExecuteAndSpecialize() {
        if (!this.needsRewrites()) {
            return null;
        }
        String frame = null;
        if (FlatNodeGenFactory.needsFrameToExecute(this.reachableSpecializations)) {
            frame = FRAME_VALUE;
        }
        TypeMirror returnType = this.executeAndSpecializeType.getReturnType();
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, this.createExecuteAndSpecializeName(), new CodeVariableElement[0]);
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, method);
        frameState.addParametersTo(method, Integer.MAX_VALUE, frame);
        CodeTreeBuilder builder = method.createBuilder();
        boolean reportPolymorphism = FlatNodeGenFactory.shouldReportPolymorphism(this.node, this.reachableSpecializations);
        if (this.needsLocking) {
            builder.declaration(this.context.getType(Lock.class), "lock", "getLock()");
            builder.declaration(this.context.getType(Boolean.TYPE), "hasLock", "true");
            builder.statement("lock.lock()");
        }
        builder.tree(this.state.createLoad(frameState));
        if (this.requiresExclude()) {
            builder.tree(this.exclude.createLoad(frameState));
        }
        if (reportPolymorphism) {
            this.generateSaveOldPolymorphismState(builder, frameState);
        }
        if (this.needsLocking || reportPolymorphism) {
            builder.startTryBlock();
        }
        FrameState originalFrameState = frameState.copy();
        SpecializationGroup group = this.createSpecializationGroups();
        CodeTree execution = this.visitSpecializationGroup(builder, null, group, this.executeAndSpecializeType, frameState, null);
        builder.tree(execution);
        if (group.hasFallthrough()) {
            builder.tree(this.createThrowUnsupported(builder, originalFrameState));
        }
        if (this.needsLocking || reportPolymorphism) {
            builder.end().startFinallyBlock();
            if (reportPolymorphism) {
                this.generateCheckNewPolymorphismState(builder);
            }
            if (this.needsLocking) {
                builder.startIf().string("hasLock").end().startBlock();
                builder.statement("lock.unlock()");
                builder.end();
            }
            builder.end();
        }
        return method;
    }

    private boolean requiresCacheCheck() {
        for (SpecializationData specialization : this.reachableSpecializations) {
            if (!this.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
            return true;
        }
        return false;
    }

    private Element createCheckForPolymorphicSpecialize() {
        boolean requiresExclude = this.requiresExclude();
        boolean requiresCacheCheck = this.requiresCacheCheck();
        TypeMirror returnType = this.getType(Void.TYPE);
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, CHECK_FOR_POLYMORPHIC_SPECIALIZE, new CodeVariableElement[0]);
        executable.addParameter(new CodeVariableElement(this.state.bitSetType, OLD_STATE));
        if (requiresExclude) {
            executable.addParameter(new CodeVariableElement(this.exclude.bitSetType, OLD_EXCLUDE));
        }
        if (requiresCacheCheck) {
            executable.addParameter(new CodeVariableElement(this.getType(Integer.TYPE), OLD_CACHE_COUNT));
        }
        CodeTreeBuilder builder = executable.createBuilder();
        FrameState frameState = FrameState.load(this, NodeExecutionMode.SLOW_PATH, executable);
        builder.declaration(this.state.bitSetType, NEW_STATE, this.state.createMaskedReference(frameState, this.reachableSpecializations.toArray()));
        if (requiresExclude) {
            builder.declaration(this.exclude.bitSetType, NEW_EXCLUDE, this.exclude.createReference(frameState));
        }
        builder.startIf().string("(oldState ^ newState) != 0");
        if (requiresExclude) {
            builder.string(" || ");
            builder.string("(oldExclude ^ newExclude) != 0");
        }
        if (requiresCacheCheck) {
            builder.string(" || oldCacheCount < countCaches()");
        }
        builder.end();
        builder.startBlock().startStatement().startCall("this", REPORT_POLYMORPHIC_SPECIALIZE).end(2);
        builder.end();
        return executable;
    }

    private Element createCountCaches() {
        TypeMirror returnType = this.getType(Integer.TYPE);
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), returnType, COUNT_CACHES, new CodeVariableElement[0]);
        CodeTreeBuilder builder = executable.createBuilder();
        String cacheCount = "cacheCount";
        builder.declaration(this.context.getType(Integer.TYPE), "cacheCount", "0");
        for (SpecializationData specialization : this.reachableSpecializations) {
            if (!this.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
            String typeName = this.createSpecializationTypeName(specialization);
            String fieldName = this.createSpecializationFieldName(specialization);
            String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
            builder.declaration(typeName, localName, "this." + fieldName);
            builder.startWhile().string(localName, " != null");
            builder.end();
            builder.startBlock().statement("cacheCount++").statement(localName + "= " + localName + ".next_");
            builder.end();
        }
        builder.startReturn().statement("cacheCount");
        return executable;
    }

    private void generateCheckNewPolymorphismState(CodeTreeBuilder builder) {
        builder.startIf().string("oldState != 0");
        if (this.requiresExclude()) {
            builder.string(" || oldExclude != 0");
        }
        builder.end();
        builder.startBlock();
        builder.string("checkForPolymorphicSpecialize(oldState");
        if (this.requiresExclude()) {
            builder.string(", oldExclude");
        }
        if (this.requiresCacheCheck()) {
            builder.string(", oldCacheCount");
        }
        builder.string(");").newLine();
        builder.end();
    }

    private void generateSaveOldPolymorphismState(CodeTreeBuilder builder, FrameState frameState) {
        builder.declaration(this.state.bitSetType, OLD_STATE, this.state.createMaskedReference(frameState, this.reachableSpecializations.toArray()));
        if (this.requiresExclude()) {
            builder.declaration(this.exclude.bitSetType, OLD_EXCLUDE, "exclude");
        }
        if (this.requiresCacheCheck()) {
            builder.declaration(this.context.getType(Integer.TYPE), OLD_CACHE_COUNT, "state == 0 ? 0 : countCaches()");
        }
    }

    private CodeTree createThrowUnsupported(CodeTreeBuilder parent, FrameState frameState) {
        CodeTreeBuilder builder = parent.create();
        builder.startThrow().startNew(this.types.UnsupportedSpecializationException);
        ExecutableElement method = parent.findMethod();
        if (method != null && method.getModifiers().contains((Object)Modifier.STATIC)) {
            builder.string("null");
        } else {
            builder.string("this");
        }
        builder.startNewArray(new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node), null);
        ArrayList<CodeTree> values = new ArrayList<CodeTree>();
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            NodeChildData child = execution.getChild();
            LocalVariable var = frameState.getValue(execution);
            if (child != null && !frameState.getMode().isUncached()) {
                builder.string(FlatNodeGenFactory.accessNodeField(execution));
            } else {
                builder.string("null");
            }
            if (var == null) continue;
            values.add(var.createReference());
        }
        builder.end();
        builder.trees(values.toArray(new CodeTree[0]));
        builder.end().end();
        return builder.build();
    }

    private CodeTree createFastPath(CodeTreeBuilder parent, List<SpecializationData> allSpecializations, SpecializationGroup originalGroup, ExecutableTypeData currentType, FrameState frameState) {
        List<BoxingSplit> boxingSplits;
        CodeTreeBuilder builder = parent.create();
        boolean needsRewrites = this.needsRewrites();
        if (needsRewrites) {
            builder.tree(this.state.createLoad(frameState));
        }
        int sharedExecutes = 0;
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            boolean canExecuteChild = execution.getIndex() < currentType.getEvaluatedCount();
            for (SpecializationGroup.TypeGuard checkedGuard : originalGroup.getTypeGuards()) {
                if (checkedGuard.getSignatureIndex() != execution.getIndex()) continue;
                canExecuteChild = true;
                break;
            }
            if (!canExecuteChild) break;
            for (SpecializationGroup.TypeGuard checkedGuard : originalGroup.getTypeGuards()) {
                if (this.resolveOptimizedImplicitSourceTypes(execution, checkedGuard.getType()).size() <= 1) continue;
                canExecuteChild = false;
                break;
            }
            if (!canExecuteChild) break;
            builder.tree(this.createFastPathExecuteChild(builder, frameState.copy(), frameState, currentType, originalGroup, execution));
            ++sharedExecutes;
        }
        if ((boxingSplits = this.parameterBoxingElimination(originalGroup, sharedExecutes)).isEmpty()) {
            builder.tree(this.executeFastPathGroup(builder, frameState, currentType, originalGroup, sharedExecutes, null));
            this.addExplodeLoop(builder, originalGroup);
        } else {
            FrameState originalFrameState = frameState.copy();
            boolean elseIf = false;
            for (BoxingSplit split : boxingSplits) {
                elseIf = builder.startIf(elseIf);
                List<SpecializationData> specializations = split.group.collectSpecializations();
                builder.startGroup();
                builder.tree(this.state.createContainsOnly(frameState, 0, -1, specializations.toArray(), allSpecializations.toArray())).end();
                builder.string(" && ");
                builder.tree(this.state.createIsNotAny(frameState, allSpecializations.toArray()));
                builder.end();
                builder.end().startBlock();
                builder.tree(this.wrapInAMethod(builder, split.group, originalFrameState, split.getName(), this.executeFastPathGroup(builder, frameState.copy(), currentType, split.group, sharedExecutes, specializations)));
                builder.end();
            }
            builder.startElseBlock();
            builder.tree(this.wrapInAMethod(builder, originalGroup, originalFrameState, "generic", this.executeFastPathGroup(builder, frameState, currentType, originalGroup, sharedExecutes, null)));
            builder.end();
        }
        return builder.build();
    }

    private void addExplodeLoop(CodeTreeBuilder builder, SpecializationGroup originalGroup) {
        for (SpecializationData implemented : originalGroup.collectSpecializations()) {
            if (implemented.getMaximumNumberOfInstances() <= 1) continue;
            ((CodeExecutableElement)builder.findMethod()).getAnnotationMirrors().add(this.createExplodeLoop());
            break;
        }
    }

    private CodeTree wrapInAMethod(CodeTreeBuilder parent, SpecializationGroup group, FrameState frameState, String suffix, CodeTree codeTree) {
        CodeExecutableElement parentMethod = (CodeExecutableElement)parent.findMethod();
        CodeTypeElement parentClass = (CodeTypeElement)parentMethod.getEnclosingElement();
        String name = parentMethod.getSimpleName().toString() + NAME_SUFFIX + suffix + this.boxingSplitIndex++;
        CodeExecutableElement method = parentClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), parentMethod.getReturnType(), name, new CodeVariableElement[0]));
        frameState.addParametersTo(method, Integer.MAX_VALUE, FRAME_VALUE, STATE_VALUE);
        CodeTreeBuilder builder = method.createBuilder();
        builder.tree(codeTree);
        method.getThrownTypes().addAll(parentMethod.getThrownTypes());
        this.addExplodeLoop(builder, group);
        CodeTreeBuilder parentBuilder = parent.create();
        parentBuilder.startReturn();
        parentBuilder.startCall(method.getSimpleName().toString());
        frameState.addReferencesTo(parentBuilder, FRAME_VALUE, STATE_VALUE);
        parentBuilder.end();
        parentBuilder.end();
        return parentBuilder.build();
    }

    private CodeTree executeFastPathGroup(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData currentType, SpecializationGroup group, int sharedExecutes, List<SpecializationData> allowedSpecializations) {
        CodeTreeBuilder builder = parent.create();
        if (currentType.getMethod() != null && currentType.getMethod().isVarArgs()) {
            int readVarargsCount = this.node.getSignatureSize() - (currentType.getEvaluatedCount() - 1);
            int offset = this.node.getSignatureSize() - 1;
            for (int i = 0; i < readVarargsCount; ++i) {
                NodeExecutionData execution = this.node.getChildExecutions().get(offset + i);
                LocalVariable var = frameState.getValue(execution);
                if (var == null) continue;
                builder.tree(var.createDeclaration(var.createReference()));
                frameState.setValue(execution, var.accessWith(null));
            }
        }
        FrameState originalFrameState = frameState.copy();
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            if (execution.getIndex() < sharedExecutes) continue;
            builder.tree(this.createFastPathExecuteChild(builder, originalFrameState, frameState, currentType, group, execution));
        }
        builder.tree(this.visitSpecializationGroup(builder, null, group, currentType, frameState, allowedSpecializations));
        if (group.hasFallthrough()) {
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
            builder.tree(this.createCallExecuteAndSpecialize(currentType, originalFrameState));
        }
        return builder.build();
    }

    private List<BoxingSplit> parameterBoxingElimination(SpecializationGroup group, int evaluatedcount) {
        if (!this.boxingEliminationEnabled) {
            return Collections.emptyList();
        }
        List<SpecializationData> allSpecializations = group.collectSpecializations();
        ArrayList signatures = new ArrayList();
        ArrayList signatureSpecializations = new ArrayList();
        for (SpecializationData specialization : allSpecializations) {
            int index = -1;
            ArrayList<SpecializationGroup.TypeGuard> guards = new ArrayList<SpecializationGroup.TypeGuard>();
            for (Parameter p : specialization.getSignatureParameters()) {
                NodeChildData child;
                if (!ElementUtils.isPrimitive(p.getType()) || ++index < evaluatedcount || (child = p.getSpecification().getExecution().getChild()) != null && child.findExecutableType(p.getType()) == null) continue;
                guards.add(new SpecializationGroup.TypeGuard(p.getType(), index));
            }
            if (guards.isEmpty()) continue;
            boolean directFound = false;
            for (int i = 0; i < signatures.size(); ++i) {
                if (!guards.containsAll((Collection)signatures.get(i))) continue;
                if (((Set)signatures.get(i)).containsAll(guards)) {
                    directFound = true;
                }
                ((List)signatureSpecializations.get(i)).add(specialization);
            }
            if (directFound) continue;
            signatures.add(new LinkedHashSet(guards));
            ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
            specializations.add(specialization);
            signatureSpecializations.add(specializations);
        }
        ArrayList<BoxingSplit> groups = new ArrayList<BoxingSplit>();
        for (int i = 0; i < signatureSpecializations.size(); ++i) {
            List groupedSpecialization = (List)signatureSpecializations.get(i);
            if (allSpecializations.size() == groupedSpecialization.size()) continue;
            Set signature = (Set)signatures.get(i);
            TypeMirror[] signatureMirrors = new TypeMirror[signature.size()];
            int index = 0;
            for (SpecializationGroup.TypeGuard typeGuard : signature) {
                signatureMirrors[index] = typeGuard.getType();
                ++index;
            }
            groups.add(new BoxingSplit(SpecializationGroup.create(groupedSpecialization), signatureMirrors));
        }
        Collections.sort(groups, new Comparator<BoxingSplit>(){

            @Override
            public int compare(BoxingSplit o1, BoxingSplit o2) {
                return Integer.compare(o2.primitiveSignature.length, o1.primitiveSignature.length);
            }
        });
        return groups;
    }

    private CodeTree createFastPathExecuteChild(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, ExecutableTypeData currentType, SpecializationGroup group, NodeExecutionData execution) {
        CodeTreeBuilder builder = parent.create();
        LocalVariable var = frameState.getValue(execution);
        if (var == null) {
            LocalVariable fallbackVar;
            TypeMirror targetType;
            SpecializationGroup.TypeGuard eliminatedGuard = null;
            if (this.boxingEliminationEnabled) {
                for (SpecializationGroup.TypeGuard checkedGuard : group.getTypeGuards()) {
                    if (!ElementUtils.isPrimitive(checkedGuard.getType()) || this.node.getChildExecutions().get(checkedGuard.getSignatureIndex()).getChild().findExecutableType(checkedGuard.getType()) == null || checkedGuard.getSignatureIndex() != execution.getIndex()) continue;
                    eliminatedGuard = checkedGuard;
                    break;
                }
            }
            if (eliminatedGuard != null) {
                group.getTypeGuards().remove(eliminatedGuard);
                targetType = eliminatedGuard.getType();
            } else {
                targetType = execution.getChild().findAnyGenericExecutableType(this.context).getReturnType();
            }
            var = frameState.createValue(execution, targetType).nextName();
            List<TypeMirror> originalSourceTypes = this.typeSystem.lookupSourceTypes(targetType);
            List<TypeMirror> sourceTypes = this.resolveOptimizedImplicitSourceTypes(execution, targetType);
            if (sourceTypes.size() > 1) {
                SpecializationGroup.TypeGuard typeGuard = new SpecializationGroup.TypeGuard(targetType, execution.getIndex());
                TypeMirror generic = this.node.getPolymorphicSpecialization().findParameterOrDie(execution).getType();
                fallbackVar = originalFrameState.createValue(execution, generic);
                Collections.reverse(sourceTypes);
                CodeTree access = var.createReference();
                boolean first = true;
                for (TypeMirror sType : sourceTypes) {
                    if (ElementUtils.typeEquals(sType, targetType)) continue;
                    String localName = FlatNodeGenFactory.createSourceTypeLocalName(var, sType);
                    builder.declaration(sType, localName, CodeTreeBuilder.createBuilder().defaultValue(sType).build());
                    CodeTreeBuilder accessBuilder = builder.create();
                    accessBuilder.startParantheses();
                    accessBuilder.tree(this.state.createContainsOnly(frameState, originalSourceTypes.indexOf(sType), 1, new Object[]{typeGuard}, new Object[]{typeGuard}));
                    accessBuilder.string(" && ");
                    accessBuilder.tree(this.state.createIsNotAny(frameState, this.reachableSpecializationsArray));
                    accessBuilder.string(" ? ");
                    if (ElementUtils.isPrimitive(sType)) {
                        accessBuilder.string("(").type(generic).string(") ");
                    }
                    accessBuilder.string(localName);
                    accessBuilder.string(" : ");
                    if (first && ElementUtils.isPrimitive(targetType)) {
                        accessBuilder.string("(").type(generic).string(") ");
                    }
                    accessBuilder.tree(access);
                    accessBuilder.end();
                    access = accessBuilder.build();
                    first = false;
                }
                fallbackVar = fallbackVar.accessWith(access);
            } else {
                fallbackVar = var;
            }
            builder.tree(this.createAssignExecuteChild(originalFrameState, frameState, builder, execution, currentType, var));
            frameState.setValue(execution, var);
            originalFrameState.setValue(execution, fallbackVar);
        }
        return builder.build();
    }

    private CodeTree createAssignExecuteChild(FrameState originalFrameState, FrameState frameState, CodeTreeBuilder parent, NodeExecutionData execution, ExecutableTypeData forType, LocalVariable targetValue) {
        CodeTreeBuilder builder = parent.create();
        ChildExecutionResult executeChild = this.createExecuteChild(builder, originalFrameState, frameState, execution, targetValue);
        builder.tree(FlatNodeGenFactory.createTryExecuteChild(targetValue, executeChild.code, true, executeChild.throwsUnexpectedResult));
        builder.end();
        if (executeChild.throwsUnexpectedResult) {
            builder.startCatchBlock(this.types.UnexpectedResultException, "ex");
            FrameState slowPathFrameState = originalFrameState.copy();
            slowPathFrameState.setValue(execution, targetValue.makeGeneric(this.context).accessWith(CodeTreeBuilder.singleString("ex.getResult()")));
            ExecutableTypeData delegateType = this.node.getGenericExecutableType(forType);
            boolean found = false;
            for (NodeExecutionData otherExecution : this.node.getChildExecutions()) {
                if (found) {
                    LocalVariable childEvaluatedValue = slowPathFrameState.createValue(otherExecution, this.genericType);
                    builder.tree(this.createAssignExecuteChild(slowPathFrameState.copy(), slowPathFrameState, builder, otherExecution, delegateType, childEvaluatedValue));
                    slowPathFrameState.setValue(otherExecution, childEvaluatedValue);
                    continue;
                }
                found = execution == otherExecution;
            }
            builder.tree(this.createCallExecuteAndSpecialize(forType, slowPathFrameState));
            builder.end();
        }
        return builder.build();
    }

    private static String createSourceTypeLocalName(LocalVariable targetValue, TypeMirror sType) {
        return targetValue.getName() + ElementUtils.getSimpleName(sType);
    }

    private ChildExecutionResult createCallSingleChildExecute(NodeExecutionData execution, LocalVariable target, FrameState frameState, ExecutableTypeData executableType) {
        CodeTree execute = this.callChildExecuteMethod(execution, executableType, frameState);
        TypeMirror sourceType = executableType.getReturnType();
        TypeMirror targetType = target.getTypeMirror();
        CodeTree result = this.expect(sourceType, targetType, execute);
        return new ChildExecutionResult(result, executableType.hasUnexpectedValue() || ElementUtils.needsCastTo(sourceType, targetType));
    }

    private ChildExecutionResult createExecuteChild(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, NodeExecutionData execution, LocalVariable target) {
        ChildExecutionResult result;
        if (!this.typeSystem.hasImplicitSourceTypes(target.getTypeMirror())) {
            ExecutableTypeData targetExecutable = this.resolveTargetExecutable(execution, target.typeMirror);
            CodeTreeBuilder builder = parent.create();
            result = this.createCallSingleChildExecute(execution, target, frameState, targetExecutable);
            builder.string(target.getName()).string(" = ");
            builder.tree(result.code);
            result.code = builder.build();
        } else {
            result = this.createExecuteChildImplicitCast(parent.create(), originalFrameState, frameState, execution, target);
        }
        return result;
    }

    private CodeExecutableElement createNodeConstructor(CodeTypeElement clazz, ExecutableElement superConstructor) {
        CodeExecutableElement constructor = GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), clazz, superConstructor);
        ElementUtils.setVisibility(constructor.getModifiers(), ElementUtils.getVisibility(superConstructor.getModifiers()));
        constructor.setVarArgs(superConstructor.isVarArgs());
        ArrayList<CodeVariableElement> childParameters = new ArrayList<CodeVariableElement>();
        for (NodeChildData child : this.node.getChildren()) {
            if (!child.needsGeneratedField()) continue;
            childParameters.add(new CodeVariableElement(child.getOriginalType(), child.getName()));
        }
        constructor.getParameters().addAll(superConstructor.getParameters().size(), childParameters);
        CodeTreeBuilder builder = constructor.appendBuilder();
        ArrayList<String> childValues = new ArrayList<String>(this.node.getChildren().size());
        if (!this.node.getChildExecutions().isEmpty()) {
            for (NodeChildData child : this.node.getChildren()) {
                CreateCastData createCast;
                if (!child.needsGeneratedField()) continue;
                String name = child.getName();
                if (child.getCardinality().isMany() && (createCast = this.node.findCast(child.getName())) != null) {
                    CodeTree nameTree = CodeTreeBuilder.singleString(name);
                    CodeTreeBuilder callBuilder = builder.create();
                    callBuilder.string(name).string(" != null ? ");
                    callBuilder.tree(FlatNodeGenFactory.callMethod(null, null, createCast.getMethod(), nameTree));
                    callBuilder.string(" : null");
                    name = name + NAME_SUFFIX;
                    builder.declaration(child.getNodeType(), name, callBuilder.build());
                }
                childValues.add(name);
            }
        }
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            if (execution.getChild() == null || !execution.getChild().needsGeneratedField()) continue;
            CreateCastData createCast = this.node.findCast(execution.getChild().getName());
            builder.startStatement();
            builder.string("this.").string(FlatNodeGenFactory.nodeFieldName(execution)).string(" = ");
            String name = (String)childValues.get(this.node.getChildren().indexOf(execution.getChild()));
            CodeTreeBuilder accessorBuilder = builder.create();
            accessorBuilder.string(name);
            if (execution.hasChildArrayIndex()) {
                accessorBuilder.string("[").string(String.valueOf(execution.getChildArrayIndex())).string("]");
            }
            CodeTree accessor = accessorBuilder.build();
            if (createCast != null && execution.getChild().getCardinality().isOne()) {
                accessor = FlatNodeGenFactory.callMethod(null, null, createCast.getMethod(), accessor);
            }
            if (execution.hasChildArrayIndex()) {
                CodeTreeBuilder nullCheck = builder.create();
                nullCheck.string(name).string(" != null && ").string(String.valueOf(execution.getChildArrayIndex())).string(" < ").string(name).string(".length").string(" ? ");
                nullCheck.tree(accessor);
                nullCheck.string(" : null");
                accessor = nullCheck.build();
            }
            builder.tree(accessor);
            builder.end();
        }
        return constructor;
    }

    private List<ExecutableTypeData> filterExecutableTypes(List<ExecutableTypeData> executableTypes, List<SpecializationData> specializations) {
        HashSet<TypeMirror> specializedReturnTypes = new HashSet<TypeMirror>();
        for (SpecializationData specialization : specializations) {
            specializedReturnTypes.add(specialization.getReturnType().getType());
        }
        ArrayList<ExecutableTypeData> filteredTypes = new ArrayList<ExecutableTypeData>();
        block1: for (ExecutableTypeData executable : executableTypes) {
            if (executable.getMethod() == null) continue;
            if (executable.isAbstract()) {
                filteredTypes.add(executable);
                continue;
            }
            if (executable.isFinal()) continue;
            if (!executable.hasUnexpectedValue()) {
                filteredTypes.add(executable);
                continue;
            }
            TypeMirror returnType = executable.getReturnType();
            if (!this.boxingEliminationEnabled || !ElementUtils.isVoid(returnType) && !ElementUtils.isPrimitive(returnType)) continue;
            for (TypeMirror specializedReturnType : specializedReturnTypes) {
                if (!ElementUtils.isSubtypeBoxed(this.context, specializedReturnType, returnType)) continue;
                filteredTypes.add(executable);
                continue block1;
            }
        }
        Collections.sort(filteredTypes);
        return filteredTypes;
    }

    private Element createGetCostMethod(boolean uncached) {
        DeclaredType returnType = this.types.NodeCost;
        CodeExecutableElement executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, "getCost", new CodeVariableElement[0]);
        executable.getAnnotationMirrors().add(new CodeAnnotationMirror(this.context.getDeclaredType(Override.class)));
        CodeTreeBuilder builder = executable.createBuilder();
        if (uncached) {
            builder.startReturn().staticReference(this.types.NodeCost, "MEGAMORPHIC").end();
        } else if (this.needsRewrites()) {
            FrameState frameState = FrameState.load(this, NodeExecutionMode.UNCACHED, executable);
            builder.tree(this.state.createLoad(frameState));
            builder.startIf().tree(this.state.createIs(frameState, new Object[0], this.reachableSpecializationsArray)).end();
            builder.startBlock();
            builder.startReturn().staticReference(this.types.NodeCost, "UNINITIALIZED").end();
            builder.end();
            if (this.reachableSpecializations.size() == 1 && !this.reachableSpecializations.iterator().next().hasMultipleInstances()) {
                builder.startElseBlock();
                builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
                builder.end();
            } else {
                builder.startElseIf();
                builder.tree(this.state.createIsOneBitOf(frameState, this.reachableSpecializationsArray));
                builder.end();
                builder.startBlock();
                ArrayList<CodeTree> additionalChecks = new ArrayList<CodeTree>();
                for (SpecializationData specialization : this.reachableSpecializations) {
                    if (!this.useSpecializationClass(specialization) || specialization.getMaximumNumberOfInstances() <= 1) continue;
                    String typeName = this.createSpecializationTypeName(specialization);
                    String fieldName = this.createSpecializationFieldName(specialization);
                    String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                    builder.declaration(typeName, localName, "this." + fieldName);
                    CodeTree check = builder.create().startParantheses().string(localName, " == null || ", localName, ".next_ == null").end().build();
                    additionalChecks.add(check);
                }
                if (!additionalChecks.isEmpty()) {
                    builder.startIf().tree(FlatNodeGenFactory.combineTrees(" && ", additionalChecks.toArray(new CodeTree[0]))).end().startBlock();
                }
                builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
                if (!additionalChecks.isEmpty()) {
                    builder.end();
                }
                builder.end();
                builder.startReturn().staticReference(this.types.NodeCost, "POLYMORPHIC").end();
            }
        } else {
            builder.startReturn().staticReference(this.types.NodeCost, "MONOMORPHIC").end();
        }
        return executable;
    }

    private ExecutableElement createAccessChildMethod(NodeChildData child, boolean uncached) {
        if (child.getAccessElement() != null && child.getAccessElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            ExecutableElement getter = (ExecutableElement)child.getAccessElement();
            CodeExecutableElement method = CodeExecutableElement.clone(getter);
            method.getModifiers().remove((Object)Modifier.ABSTRACT);
            ArrayList<NodeExecutionData> executions = new ArrayList<NodeExecutionData>();
            for (NodeExecutionData execution : this.node.getChildExecutions()) {
                if (execution.getChild() != child) continue;
                executions.add(execution);
            }
            CodeTreeBuilder builder = method.createBuilder();
            if (uncached) {
                method.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
                builder.startThrow().startNew(this.context.getType(AssertionError.class));
                builder.doubleQuote("This getter method cannot be used for uncached node versions as it requires child nodes to be present.");
                builder.end().end();
            } else if (child.getCardinality().isMany()) {
                builder.startReturn().startNewArray((ArrayType)child.getOriginalType(), null);
                for (NodeExecutionData execution : executions) {
                    builder.string(FlatNodeGenFactory.accessNodeField(execution));
                }
                builder.end().end();
            } else {
                Iterator iterator = executions.iterator();
                if (iterator.hasNext()) {
                    NodeExecutionData execution = (NodeExecutionData)iterator.next();
                    builder.startReturn().string(FlatNodeGenFactory.accessNodeField(execution)).end();
                }
            }
            return method;
        }
        return null;
    }

    private static List<SpecializationData> calculateReachableSpecializations(NodeData node) {
        ArrayList<SpecializationData> specializations = new ArrayList<SpecializationData>();
        for (SpecializationData specialization : node.getSpecializations()) {
            if (!specialization.isReachable() || !specialization.isSpecialized() && (!specialization.isFallback() || specialization.getMethod() == null)) continue;
            specializations.add(specialization);
        }
        return specializations;
    }

    private TypeMirror getType(Class<?> clazz) {
        return this.context.getType(clazz);
    }

    private static CodeVariableElement createNodeField(Modifier visibility, TypeMirror type, String name, DeclaredType annotationClass, Modifier ... modifiers) {
        CodeVariableElement childField = new CodeVariableElement(ElementUtils.modifiers(modifiers), type, name);
        if (annotationClass != null) {
            if (annotationClass == ProcessorContext.getInstance().getTypes().CompilerDirectives_CompilationFinal) {
                FlatNodeGenFactory.setFieldCompilationFinal(childField, 0);
            } else {
                childField.getAnnotationMirrors().add(new CodeAnnotationMirror(annotationClass));
            }
        }
        ElementUtils.setVisibility(childField.getModifiers(), visibility);
        return childField;
    }

    private static CodeTree callMethod(FrameState frameState, CodeTree receiver, ExecutableElement method, CodeTree ... boundValues) {
        VariableElement receiverVar;
        if (frameState != null) {
            frameState.addThrownExceptions(method);
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        List<? extends VariableElement> parameters = method.getParameters();
        CodeTree useReceiver = receiver;
        boolean staticMethod = method.getModifiers().contains((Object)Modifier.STATIC);
        int boundValueIndex = -1;
        if (!method.getParameters().isEmpty() && staticMethod && (receiverVar = method.getParameters().get(0)).getSimpleName().toString().equals("this")) {
            useReceiver = boundValues[0];
            parameters = parameters.subList(1, parameters.size());
            boundValueIndex = 0;
            staticMethod = false;
        }
        if (staticMethod) {
            builder.startStaticCall(method);
        } else {
            builder.startCall(useReceiver, method.getSimpleName().toString());
        }
        for (VariableElement variableElement : parameters) {
            CodeTree tree;
            if (++boundValueIndex < boundValues.length && (tree = boundValues[boundValueIndex]) != null) {
                builder.tree(tree);
                continue;
            }
            builder.defaultValue(variableElement.asType());
        }
        builder.end();
        return builder.build();
    }

    private CodeTree[] bindExecuteMethodParameters(NodeExecutionData execution, ExecutableTypeData method, FrameState frameState) {
        List<NodeExecutionData> executeWith = execution != null ? execution.getChild().getExecuteWith() : null;
        ArrayList<CodeTree> values = new ArrayList<CodeTree>();
        if (method.getFrameParameter() != null) {
            LocalVariable frameLocal = frameState.get(FRAME_VALUE);
            if (frameLocal == null) {
                throw new AssertionError((Object)(method.getName() + " requires a frame parameter."));
            }
            values.add(this.createParameterReference(frameLocal, method.getMethod(), 0));
        }
        int evaluatedIndex = 0;
        for (int executionIndex = 0; executionIndex < this.node.getExecutionCount(); ++executionIndex) {
            NodeExecutionData parameterExecution = executeWith != null && executionIndex < executeWith.size() ? executeWith.get(executionIndex) : this.node.getChildExecutions().get(executionIndex);
            if (evaluatedIndex >= method.getEvaluatedCount()) continue;
            TypeMirror targetType = method.getEvaluatedParameters().get(evaluatedIndex);
            LocalVariable value = frameState.getValue(parameterExecution);
            if (value != null) {
                int parameterIndex = method.getParameterIndex(evaluatedIndex);
                values.add(this.createParameterReference(value, method.getMethod(), parameterIndex));
            } else {
                values.add(CodeTreeBuilder.createBuilder().defaultValue(targetType).build());
            }
            ++evaluatedIndex;
        }
        return values.toArray(new CodeTree[values.size()]);
    }

    private CodeTree callChildExecuteMethod(NodeExecutionData execution, ExecutableTypeData method, FrameState frameState) {
        return FlatNodeGenFactory.callMethod(frameState, CodeTreeBuilder.singleString(FlatNodeGenFactory.accessNodeField(execution)), method.getMethod(), this.bindExecuteMethodParameters(execution, method, frameState));
    }

    private CodeTree createParameterReference(LocalVariable sourceVariable, ExecutableElement targetMethod, int targetIndex) {
        CodeTree valueReference = sourceVariable.createReference();
        TypeMirror sourceType = sourceVariable.getTypeMirror();
        VariableElement targetParameter = targetMethod.getParameters().get(targetIndex);
        TypeMirror targetType = targetParameter.asType();
        if (targetType == null || sourceType == null) {
            return valueReference;
        }
        boolean hasCast = false;
        if (ElementUtils.needsCastTo(sourceType, targetType)) {
            CodeTree castValue = TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference);
            hasCast = valueReference != castValue;
            valueReference = castValue;
        }
        if (!ElementUtils.typeEquals(sourceType, targetType) && !hasCast) {
            Element element = targetMethod.getEnclosingElement();
            boolean needsOverloadCast = false;
            if (element != null) {
                for (ExecutableElement executable : ElementFilter.methodsIn(element.getEnclosedElements())) {
                    TypeMirror overloadedTarget;
                    if (ElementUtils.executableEquals(executable, targetMethod) || !executable.getSimpleName().toString().equals(targetMethod.getSimpleName().toString()) || executable.getParameters().size() != targetMethod.getParameters().size() || ElementUtils.needsCastTo(sourceType, overloadedTarget = executable.getParameters().get(targetIndex).asType())) continue;
                    needsOverloadCast = true;
                    break;
                }
            }
            if (needsOverloadCast) {
                valueReference = TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference);
            }
        }
        return valueReference;
    }

    private SpecializationGroup createSpecializationGroups() {
        return SpecializationGroup.create(this.reachableSpecializations);
    }

    private CodeTree expectOrCast(TypeMirror sourceType, ExecutableTypeData targetType, CodeTree content) {
        if (this.needsUnexpectedResultException(targetType)) {
            return this.expect(sourceType, targetType.getReturnType(), content);
        }
        return this.cast(sourceType, targetType.getReturnType(), content);
    }

    private CodeTree cast(TypeMirror sourceType, TypeMirror targetType, CodeTree content) {
        if (ElementUtils.needsCastTo(sourceType, targetType) && !ElementUtils.isVoid(sourceType)) {
            return TypeSystemCodeGenerator.cast(this.typeSystem, targetType, content);
        }
        return content;
    }

    private CodeTree expect(TypeMirror sourceType, TypeMirror forType, CodeTree tree) {
        if (sourceType == null || ElementUtils.needsCastTo(sourceType, forType)) {
            this.expectedTypes.add(forType);
            return TypeSystemCodeGenerator.expect(this.typeSystem, forType, tree);
        }
        return tree;
    }

    private CodeExecutableElement createExecuteMethod(ExecutableTypeData executedType) {
        CodeExecutableElement executable;
        TypeMirror returnType = executedType.getReturnType();
        String methodName = executedType.getMethod() != null ? executedType.getMethod().getSimpleName().toString() : executedType.getUniqueName();
        if (executedType.getMethod() != null) {
            executable = CodeExecutableElement.clone(executedType.getMethod());
            executable.getAnnotationMirrors().clear();
            executable.getModifiers().remove((Object)Modifier.ABSTRACT);
            for (VariableElement var : executable.getParameters()) {
                ((CodeVariableElement)var).getAnnotationMirrors().clear();
            }
            executable.renameArguments(FRAME_VALUE);
            if (executable.isVarArgs()) {
                ((CodeVariableElement)executable.getParameters().get(executable.getParameters().size() - 1)).setName(VARARGS_NAME);
            }
        } else {
            executable = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC), returnType, methodName, new CodeVariableElement[0]);
        }
        DeclaredType unexpectedResult = this.types.UnexpectedResultException;
        Iterator<TypeMirror> thrownTypes = executable.getThrownTypes().iterator();
        while (thrownTypes.hasNext()) {
            if (!ElementUtils.typeEquals(unexpectedResult, thrownTypes.next())) continue;
            thrownTypes.remove();
        }
        if (this.needsUnexpectedResultException(executedType)) {
            executable.getThrownTypes().add(unexpectedResult);
        }
        return executable;
    }

    private void renameOriginalParameters(ExecutableTypeData executedType, CodeExecutableElement executable, FrameState frameState) {
        int evaluatedIndex = 0;
        for (int executionIndex = 0; executionIndex < this.node.getExecutionCount(); ++executionIndex) {
            NodeExecutionData execution = this.node.getChildExecutions().get(executionIndex);
            if (evaluatedIndex >= executedType.getEvaluatedCount()) continue;
            TypeMirror evaluatedType = executedType.getEvaluatedParameters().get(evaluatedIndex);
            LocalVariable value = frameState.getValue(execution);
            if (value != null) {
                frameState.setValue(execution, FlatNodeGenFactory.renameExecutableTypeParameter(executable, executedType, evaluatedIndex, evaluatedType, value));
            }
            ++evaluatedIndex;
        }
    }

    private static LocalVariable renameExecutableTypeParameter(CodeExecutableElement method, ExecutableTypeData executedType, int evaluatedIndex, TypeMirror targetType, LocalVariable var) {
        int parameterIndex = executedType.getParameterIndex(evaluatedIndex);
        int varArgsIndex = executedType.getVarArgsIndex(parameterIndex);
        LocalVariable returnVar = var;
        if (varArgsIndex >= 0) {
            returnVar = returnVar.accessWith(CodeTreeBuilder.singleString("args[" + varArgsIndex + "]"));
        } else {
            ((CodeVariableElement)method.getParameters().get(parameterIndex)).setName(returnVar.getName());
        }
        if (!ElementUtils.isObject(targetType)) {
            returnVar = returnVar.newType(targetType);
        }
        return returnVar;
    }

    private boolean needsUnexpectedResultException(ExecutableTypeData executedType) {
        if (!executedType.hasUnexpectedValue()) {
            return false;
        }
        return !ElementUtils.isSubtypeBoxed(this.context, this.executeAndSpecializeType.getReturnType(), executedType.getReturnType());
    }

    private CodeTree createFastPathExecute(CodeTreeBuilder parent, ExecutableTypeData forType, SpecializationData specialization, FrameState frameState) {
        CodeTreeBuilder builder = parent.create();
        int ifCount = 0;
        if (specialization.isFallback()) {
            builder.startIf().startCall(this.createFallbackName());
            if (this.fallbackNeedsFrame) {
                if (frameState.get(FRAME_VALUE) != null) {
                    builder.string(FRAME_VALUE);
                } else {
                    builder.nullLiteral();
                }
            }
            if (this.fallbackNeedsState) {
                builder.string(STATE_VALUE);
            }
            frameState.addReferencesTo(builder, new String[0]);
            builder.end();
            builder.end();
            builder.startBlock();
            ++ifCount;
        }
        builder.tree(this.createCallSpecialization(builder, frameState, forType, specialization));
        builder.end(ifCount);
        return builder.build();
    }

    private CodeTree createCallSpecialization(CodeTreeBuilder parent, FrameState parentState, ExecutableTypeData forType, SpecializationData specialization) {
        CodeTreeBuilder builder = parent.create();
        FrameState frameState = parentState.copy();
        for (SpecializationThrowsData throwsData : specialization.getExceptions()) {
            frameState.addCaughtException(throwsData.getJavaClass());
        }
        if (this.needsLocking && frameState.getMode().isSlowPath()) {
            builder.statement("lock.unlock()");
            builder.statement("hasLock = false");
        }
        if (specialization.getMethod() == null) {
            builder.tree(this.createThrowUnsupported(builder, frameState));
        } else {
            CodeTree[] bindings = new CodeTree[specialization.getParameters().size()];
            for (int i = 0; i < bindings.length; ++i) {
                Parameter parameter = specialization.getParameters().get(i);
                if (parameter.getSpecification().isCached()) {
                    LocalVariable var = frameState.get(this.createFieldName(specialization, parameter));
                    if (var != null) {
                        bindings[i] = var.createReference();
                        continue;
                    }
                    bindings[i] = this.createCacheReference(frameState, specialization, specialization.findCache(parameter));
                    continue;
                }
                LocalVariable variable = this.bindExpressionVariable(frameState, specialization, parameter);
                if (variable == null) continue;
                bindings[i] = this.createParameterReference(variable, specialization.getMethod(), i);
            }
            CodeTree specializationCall = FlatNodeGenFactory.callMethod(frameState, null, specialization.getMethod(), bindings);
            if (ElementUtils.isVoid(specialization.getMethod().getReturnType())) {
                builder.statement(specializationCall);
                if (ElementUtils.isVoid(forType.getReturnType())) {
                    builder.returnStatement();
                } else {
                    builder.startReturn().defaultValue(forType.getReturnType()).end();
                }
            } else {
                builder.startReturn();
                builder.tree(this.expectOrCast(specialization.getReturnType().getType(), forType, specializationCall));
                builder.end();
            }
        }
        return this.createCatchRewriteException(builder, specialization, forType, frameState, builder.build());
    }

    private static boolean guardNeedsStateBit(SpecializationData specialization, GuardExpression guard) {
        return specialization.isReachesFallback() && specialization.isGuardBoundWithCache(guard);
    }

    private static GuardExpression getGuardThatNeedsStateBit(SpecializationData specialization, GuardExpression guard) {
        if (FlatNodeGenFactory.guardNeedsStateBit(specialization, guard)) {
            return guard;
        }
        List<GuardExpression> guards = specialization.getGuards();
        int index = guards.indexOf(guard);
        if (index < 0) {
            throw new AssertionError((Object)"guard must be contained");
        }
        for (int i = index - 1; i >= 0; --i) {
            GuardExpression otherGuard = guards.get(i);
            if (!FlatNodeGenFactory.guardNeedsStateBit(specialization, otherGuard)) continue;
            return otherGuard;
        }
        return null;
    }

    private CodeTree visitSpecializationGroup(CodeTreeBuilder parent, SpecializationGroup originalPrev, SpecializationGroup group, ExecutableTypeData forType, FrameState frameState, Collection<SpecializationData> allowedSpecializations) {
        BlockState ifCount;
        CodeTreeBuilder builder = parent.create();
        SpecializationGroup prev = originalPrev;
        NodeExecutionMode mode = frameState.getMode();
        boolean hasFallthrough = false;
        boolean hasImplicitCast = false;
        List<IfTriple> cachedTriples = new ArrayList<IfTriple>();
        for (SpecializationGroup.TypeGuard guard : group.getTypeGuards()) {
            IfTriple triple = this.createTypeCheckOrCast(frameState, group, guard, mode, false, true);
            if (triple != null) {
                cachedTriples.add(triple);
            }
            boolean bl = hasImplicitCast = hasImplicitCast || this.node.getTypeSystem().hasImplicitSourceTypes(guard.getType());
            if (mode.isGuardFallback() || (triple = this.createTypeCheckOrCast(frameState, group, guard, mode, true, true)) == null) continue;
            cachedTriples.add(triple);
        }
        SpecializationData specialization = group.getSpecialization();
        Object[] specializations = group.collectSpecializations().toArray(new SpecializationData[0]);
        ArrayList<GuardExpression> guardExpressions = new ArrayList<GuardExpression>(group.getGuards());
        if (specialization != null && specialization.hasMultipleInstances()) {
            GuardExpression guard;
            ArrayList<GuardExpression> unboundGuards = new ArrayList<GuardExpression>();
            Iterator iterator = guardExpressions.iterator();
            while (iterator.hasNext() && !specialization.isGuardBoundWithCache(guard = (GuardExpression)iterator.next())) {
                unboundGuards.add(guard);
            }
            cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, unboundGuards, mode));
            guardExpressions.removeAll(unboundGuards);
        }
        boolean useSpecializationClass = specialization != null && this.useSpecializationClass(specialization);
        boolean needsRewrites = this.needsRewrites();
        if (mode.isFastPath()) {
            CodeTreeBuilder innerBuilder;
            Set<CacheExpression> caches;
            boolean stateGuaranteed;
            ifCount = BlockState.NONE;
            boolean bl = stateGuaranteed = group.isLast() && allowedSpecializations != null && allowedSpecializations.size() == 1 && group.getAllSpecializations().size() == allowedSpecializations.size();
            if (needsRewrites && (!group.isEmpty() || specialization != null)) {
                CodeTree stateCheck = this.state.createContains(frameState, specializations);
                CodeTree stateGuard = null;
                CodeTree assertCheck = null;
                if (stateGuaranteed) {
                    assertCheck = CodeTreeBuilder.createBuilder().startAssert().tree(stateCheck).end().build();
                } else {
                    stateGuard = stateCheck;
                }
                cachedTriples.add(0, new IfTriple(null, stateGuard, assertCheck));
            }
            ifCount = ifCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
            cachedTriples = new ArrayList();
            String specializationLocalName = null;
            if (useSpecializationClass) {
                specializationLocalName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                builder.tree(this.loadSpecializationClass(frameState, specialization));
                if (specialization.getMaximumNumberOfInstances() > 1) {
                    builder.startWhile();
                } else {
                    builder.startIf();
                }
                builder.string(specializationLocalName, " != null");
                builder.end();
                builder.startBlock();
                ifCount = ifCount.incrementIf();
            }
            if (specialization != null && !specialization.getAssumptionExpressions().isEmpty()) {
                builder.tree(this.createFastPathAssumptionCheck(builder, specialization, forType, frameState));
            }
            boolean extractInBoundary = false;
            boolean pushEnclosingNode = false;
            ArrayList<IfTriple> nonBoundaryGuards = new ArrayList<IfTriple>();
            Iterator iterator = guardExpressions.iterator();
            while (iterator.hasNext()) {
                GuardExpression guard = (GuardExpression)iterator.next();
                caches = group.getSpecialization().getBoundCaches(guard.getExpression());
                if (FlatNodeGenFactory.cachesRequireFastPathBoundary(caches)) break;
                nonBoundaryGuards.addAll(this.initializeCaches(frameState, mode, group, caches, true, false));
                nonBoundaryGuards.add(this.createMethodGuardCheck(frameState, group.getSpecialization(), guard, mode));
                iterator.remove();
            }
            for (GuardExpression guard : guardExpressions) {
                caches = group.getSpecialization().getBoundCaches(guard.getExpression());
                if (FlatNodeGenFactory.cachesRequireFastPathBoundary(caches)) {
                    pushEnclosingNode = true;
                }
                cachedTriples.addAll(this.initializeCaches(frameState, mode, group, caches, true, false));
                cachedTriples.add(this.createMethodGuardCheck(frameState, group.getSpecialization(), guard, mode));
            }
            if (specialization != null) {
                List<CacheExpression> caches2 = specialization.getCaches();
                if (!pushEnclosingNode) {
                    extractInBoundary |= FlatNodeGenFactory.cachesRequireFastPathBoundary(caches2);
                    if (specialization.getFrame() != null && ElementUtils.typeEquals(specialization.getFrame().getType(), this.types.VirtualFrame)) {
                        extractInBoundary = false;
                    }
                }
                cachedTriples.addAll(this.initializeCaches(frameState, frameState.getMode(), group, specialization.getCaches(), true, false));
            }
            if (pushEnclosingNode && extractInBoundary) {
                throw new AssertionError((Object)"cannot push enclosing node and extract boundary");
            }
            BlockState nonBoundaryIfCount = BlockState.NONE;
            if (extractInBoundary) {
                nonBoundaryIfCount = nonBoundaryIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(nonBoundaryGuards), false));
                innerBuilder = this.extractInBoundaryMethod(builder, frameState, specialization);
            } else if (pushEnclosingNode) {
                innerBuilder = builder;
                nonBoundaryIfCount = IfTriple.materialize(innerBuilder, IfTriple.optimize(nonBoundaryGuards), false);
            } else {
                innerBuilder = builder;
                cachedTriples.addAll(0, nonBoundaryGuards);
            }
            if (pushEnclosingNode || extractInBoundary) {
                innerBuilder.startStatement().type(this.types.Node).string(" prev_ = ").startStaticCall(this.types.NodeUtil, "pushEncapsulatingNode").string("this").end().end();
                innerBuilder.startTryBlock();
            }
            BlockState innerIfCount = BlockState.NONE;
            innerIfCount = innerIfCount.add(IfTriple.materialize(innerBuilder, IfTriple.optimize(cachedTriples), false));
            prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            if (specialization != null && (prev == null || prev.hasFallthrough())) {
                innerBuilder.tree(this.createFastPathExecute(builder, forType, specialization, frameState));
            }
            innerBuilder.end(innerIfCount.blockCount);
            hasFallthrough |= innerIfCount.ifCount > 0;
            if (pushEnclosingNode || extractInBoundary) {
                innerBuilder.end().startFinallyBlock();
                innerBuilder.startStatement().startStaticCall(this.types.NodeUtil, "popEncapsulatingNode").string("prev_").end().end();
                innerBuilder.end();
            }
            builder.end(nonBoundaryIfCount.blockCount);
            if (useSpecializationClass && specialization.getMaximumNumberOfInstances() > 1) {
                String name = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                builder.startStatement().string(name, " = ", name, ".next_").end();
            }
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0;
        } else if (mode.isSlowPath()) {
            if (specialization != null && FlatNodeGenFactory.mayBeExcluded(specialization)) {
                CodeTree excludeCheck = this.exclude.createNotContains(frameState, specializations);
                cachedTriples.add(0, new IfTriple(null, excludeCheck, null));
            }
            BlockState outerIfCount = BlockState.NONE;
            if (specialization == null) {
                cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, guardExpressions, mode));
                outerIfCount = outerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
                prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            } else {
                outerIfCount = outerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
                String countName = specialization != null ? "count" + specialization.getIndex() + NAME_SUFFIX : null;
                boolean needsDuplicationCheck = specialization.isGuardBindsCache() || specialization.hasMultipleInstances();
                boolean useDuplicateFlag = specialization.isGuardBindsCache() && !specialization.hasMultipleInstances();
                String duplicateFoundName = specialization.getId() + "_duplicateFound_";
                boolean pushBoundary = FlatNodeGenFactory.cachesRequireFastPathBoundary(specialization.getCaches());
                if (pushBoundary) {
                    builder.startBlock();
                    builder.startStatement();
                    builder.type(this.types.Node);
                    builder.string(" prev_ = ").startStaticCall(this.types.NodeUtil, "pushEncapsulatingNode").string("this").end().end();
                    builder.startTryBlock();
                }
                BlockState innerIfCount = BlockState.NONE;
                String specializationLocalName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
                if (needsDuplicationCheck) {
                    builder.tree(this.createDuplicationCheck(builder, frameState, group, guardExpressions, useDuplicateFlag, countName, duplicateFoundName, specializationLocalName));
                    builder.startIf();
                    if (useDuplicateFlag) {
                        builder.string("!", duplicateFoundName);
                    } else {
                        builder.string(FlatNodeGenFactory.createSpecializationLocalName(specialization), " == null");
                    }
                    builder.end().startBlock();
                    innerIfCount = innerIfCount.incrementIf();
                }
                FrameState innerFrameState = frameState.copy();
                ArrayList<IfTriple> innerTripples = new ArrayList<IfTriple>();
                innerTripples.addAll(this.createMethodGuardChecks(innerFrameState, group, guardExpressions, mode));
                List<AssumptionExpression> assumptions = specialization.getAssumptionExpressions();
                if (!assumptions.isEmpty()) {
                    for (AssumptionExpression assumption : assumptions) {
                        innerTripples.addAll(this.createAssumptionSlowPathTriples(innerFrameState, group, assumption));
                    }
                }
                if (specialization.hasMultipleInstances()) {
                    DSLExpression limit = this.optimizeExpression(specialization.getLimitExpression());
                    Set<CacheExpression> caches = specialization.getBoundCaches(limit);
                    innerTripples.addAll(this.initializeCaches(innerFrameState, innerFrameState.getMode(), group, caches, true, false));
                    CodeTree limitExpression = this.writeExpression(innerFrameState, specialization, limit);
                    CodeTree limitCondition = CodeTreeBuilder.createBuilder().string(countName).string(" < ").tree(limitExpression).build();
                    innerTripples.add(new IfTriple(null, limitCondition, null));
                    FlatNodeGenFactory.assertSpecializationClassNotInitialized(innerFrameState, specialization);
                } else if (needsDuplicationCheck) {
                    innerTripples.add(new IfTriple(null, this.state.createNotContains(innerFrameState, new Object[]{specialization}), null));
                }
                innerIfCount = innerIfCount.add(IfTriple.materialize(builder, IfTriple.optimize(innerTripples), false));
                builder.tree(this.createSpecialize(builder, innerFrameState, group, specialization));
                if (needsDuplicationCheck) {
                    hasFallthrough = true;
                    if (useDuplicateFlag) {
                        builder.startStatement().string(duplicateFoundName, " = true").end();
                    }
                    builder.end(innerIfCount.blockCount);
                    CodeTree updateImplicitCast = this.createUpdateImplicitCastState(builder, frameState, specialization);
                    if (updateImplicitCast != null) {
                        builder.startElseBlock();
                        builder.tree(this.createUpdateImplicitCastState(builder, frameState, specialization));
                        builder.tree(this.state.createSet(frameState, new Object[]{specialization}, true, true));
                        builder.end();
                    }
                    builder.startIf();
                    if (useDuplicateFlag) {
                        builder.string(duplicateFoundName);
                    } else {
                        builder.string(FlatNodeGenFactory.createSpecializationLocalName(specialization), " != null");
                    }
                    builder.end().startBlock();
                    builder.tree(this.createCallSpecialization(builder, frameState, this.executeAndSpecializeType, specialization));
                    builder.end();
                } else {
                    builder.tree(this.createCallSpecialization(builder, innerFrameState, this.executeAndSpecializeType, specialization));
                    builder.end(innerIfCount.blockCount);
                    hasFallthrough |= innerIfCount.ifCount > 0;
                }
                if (pushBoundary) {
                    builder.end().startFinallyBlock();
                    builder.startStatement().startStaticCall(this.types.NodeUtil, "popEncapsulatingNode").string("prev_").end().end();
                    builder.end();
                    builder.end();
                }
            }
            builder.end(outerIfCount.blockCount);
            hasFallthrough |= outerIfCount.ifCount > 0;
        } else if (mode.isGuardFallback()) {
            ifCount = BlockState.NONE;
            if (specialization != null && specialization.getMaximumNumberOfInstances() > 1) {
                throw new AssertionError((Object)"unsupported path. should be caught by parser..");
            }
            BlockState innerIfCount = BlockState.NONE;
            cachedTriples.addAll(this.createMethodGuardChecks(frameState, group, guardExpressions, mode));
            cachedTriples.addAll(this.createAssumptionCheckTriples(frameState, specialization, NodeExecutionMode.FALLBACK_GUARD));
            cachedTriples = IfTriple.optimize(cachedTriples);
            if (specialization != null && !hasImplicitCast) {
                IfTriple singleCondition = null;
                if (cachedTriples.size() == 1) {
                    singleCondition = cachedTriples.get(0);
                }
                if (singleCondition != null) {
                    int index = cachedTriples.indexOf(singleCondition);
                    CodeTree stateCheck = this.state.createNotContains(frameState, specializations);
                    cachedTriples.set(index, new IfTriple(singleCondition.prepare, FlatNodeGenFactory.combineTrees(" && ", stateCheck, singleCondition.condition), singleCondition.statements));
                    this.fallbackNeedsState = true;
                }
            }
            innerIfCount = innerIfCount.add(IfTriple.materialize(builder, cachedTriples, false));
            prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            if (specialization != null && (prev == null || prev.hasFallthrough())) {
                builder.returnFalse();
            }
            builder.end(innerIfCount.blockCount);
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0 || innerIfCount.ifCount > 0;
        } else if (mode.isUncached()) {
            ifCount = BlockState.NONE;
            if (specialization != null) {
                cachedTriples.addAll(this.createAssumptionCheckTriples(frameState, specialization, NodeExecutionMode.UNCACHED));
            }
            ifCount = ifCount.add(IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false));
            cachedTriples = this.createMethodGuardChecks(frameState, group, guardExpressions, mode);
            BlockState innerIfCount = IfTriple.materialize(builder, IfTriple.optimize(cachedTriples), false);
            prev = this.visitSpecializationGroupChildren(builder, frameState, prev, group, forType, allowedSpecializations);
            if (specialization != null && (prev == null || prev.hasFallthrough())) {
                builder.tree(this.createCallSpecialization(builder, frameState, forType, specialization));
            }
            builder.end(innerIfCount.blockCount);
            builder.end(ifCount.blockCount);
            hasFallthrough |= ifCount.ifCount > 0 || innerIfCount.ifCount > 0;
        } else {
            throw new AssertionError((Object)"unexpected path");
        }
        group.setFallthrough(hasFallthrough);
        return builder.build();
    }

    private SpecializationGroup visitSpecializationGroupChildren(CodeTreeBuilder builder, FrameState frameState, SpecializationGroup prev, SpecializationGroup group, ExecutableTypeData forType, Collection<SpecializationData> allowedSpecializations) {
        SpecializationGroup currentPrev = prev;
        for (SpecializationGroup child : group.getChildren()) {
            if (currentPrev != null && !currentPrev.hasFallthrough()) break;
            builder.tree(this.visitSpecializationGroup(builder, prev, child, forType, frameState.copy(), allowedSpecializations));
            currentPrev = child;
        }
        return currentPrev;
    }

    private CodeTreeBuilder extractInBoundaryMethod(CodeTreeBuilder builder, FrameState frameState, SpecializationData specialization) {
        CodeExecutableElement parentMethod = (CodeExecutableElement)builder.findMethod();
        String boundaryMethodName = specialization != null ? specialization.getId() + "Boundary" : "specializationBoundary";
        if (this.usedBoundaryNames.contains(boundaryMethodName = ElementUtils.firstLetterLowerCase(boundaryMethodName))) {
            boundaryMethodName = boundaryMethodName + this.boundaryIndex++;
        }
        this.usedBoundaryNames.add(boundaryMethodName);
        String includeFrameParameter = null;
        if (specialization != null && specialization.getFrame() != null) {
            includeFrameParameter = FRAME_VALUE;
        }
        CodeExecutableElement boundaryMethod = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), parentMethod.getReturnType(), boundaryMethodName, new CodeVariableElement[0]);
        frameState.addParametersTo(boundaryMethod, Integer.MAX_VALUE, STATE_VALUE, includeFrameParameter, FlatNodeGenFactory.createSpecializationLocalName(specialization));
        boundaryMethod.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
        boundaryMethod.getThrownTypes().addAll(parentMethod.getThrownTypes());
        CodeTreeBuilder innerBuilder = boundaryMethod.createBuilder();
        ((CodeTypeElement)parentMethod.getEnclosingElement()).add(boundaryMethod);
        builder.startReturn().startCall("this", boundaryMethod);
        frameState.addReferencesTo(builder, STATE_VALUE, includeFrameParameter, FlatNodeGenFactory.createSpecializationLocalName(specialization));
        builder.end().end();
        return innerBuilder;
    }

    private static boolean cachesRequireFastPathBoundary(Collection<CacheExpression> caches) {
        for (CacheExpression cache : caches) {
            if (!cache.isAlwaysInitialized() || !cache.isRequiresBoundary()) continue;
            return true;
        }
        return false;
    }

    private List<IfTriple> createAssumptionCheckTriples(FrameState frameState, SpecializationData specialization, NodeExecutionMode mode) {
        if (specialization == null || specialization.getAssumptionExpressions().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        List<AssumptionExpression> assumptions = specialization.getAssumptionExpressions();
        for (AssumptionExpression assumption : assumptions) {
            CodeTree assumptionReference;
            CodeTreeBuilder builder;
            CodeTree prepare = null;
            if (mode.isUncached()) {
                String localName = assumption.getId();
                builder = new CodeTreeBuilder(null);
                CodeTree assumptionInit = this.writeExpression(frameState, specialization, assumption.getExpression());
                builder.declaration(assumption.getExpression().getResolvedType(), localName, assumptionInit);
                prepare = builder.build();
                assumptionReference = CodeTreeBuilder.singleString(localName);
            } else {
                assumptionReference = this.createAssumptionReference(frameState, specialization, assumption);
            }
            CodeTree assumptionGuard = this.createAssumptionGuard(assumptionReference);
            builder = new CodeTreeBuilder(null);
            builder.string("(");
            builder.tree(assumptionReference).string(" == null || ");
            builder.tree(assumptionGuard);
            builder.string(")");
            triples.add(new IfTriple(prepare, builder.build(), null));
        }
        return triples;
    }

    private CodeTree writeExpression(final FrameState frameState, SpecializationData specialization, DSLExpression expression) throws AssertionError {
        expression.accept(new DSLExpression.AbstractDSLExpressionVisitor(){

            @Override
            public void visitCall(DSLExpression.Call binary) {
                frameState.addThrownExceptions(binary.getResolvedMethod());
            }
        });
        return DSLExpressionGenerator.write(this.optimizeExpression(expression), null, FlatNodeGenFactory.castBoundTypes(this.bindExpressionValues(frameState, expression, specialization)));
    }

    private List<IfTriple> createAssumptionSlowPathTriples(FrameState frameState, SpecializationGroup group, AssumptionExpression assumption) throws AssertionError {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        LocalVariable var = frameState.get(assumption.getId());
        CodeTree declaration = null;
        if (var == null) {
            triples.addAll(this.initializeCaches(frameState, frameState.getMode(), group, group.getSpecialization().getBoundCaches(assumption.getExpression()), true, false));
            CodeTree assumptionExpressions = this.writeExpression(frameState, group.getSpecialization(), assumption.getExpression());
            String name = this.createAssumptionFieldName(group.getSpecialization(), assumption);
            var = new LocalVariable(assumption.getExpression().getResolvedType(), name.substring(0, name.length() - 1), null);
            frameState.set(assumption.getId(), var);
            declaration = var.createDeclaration(assumptionExpressions);
        }
        triples.add(new IfTriple(declaration, this.createAssumptionGuard(var.createReference()), null));
        return triples;
    }

    private CodeTree createDuplicationCheck(CodeTreeBuilder parent, FrameState frameState, SpecializationGroup group, List<GuardExpression> guardExpressions, boolean useDuplicate, String countName, String duplicateFoundName, String specializationLocalName) {
        SpecializationData specialization = group.getSpecialization();
        CodeTreeBuilder builder = parent.create();
        if (!useDuplicate) {
            builder.declaration("int", countName, CodeTreeBuilder.singleString("0"));
        }
        if (this.useSpecializationClass(specialization)) {
            builder.tree(this.loadSpecializationClass(frameState, specialization));
        }
        if (!specialization.hasMultipleInstances()) {
            builder.declaration("boolean", duplicateFoundName, CodeTreeBuilder.singleString("false"));
        }
        builder.startIf().tree(this.state.createContains(frameState, new Object[]{specialization})).end().startBlock();
        if (specialization.hasMultipleInstances()) {
            builder.startWhile().string(specializationLocalName, " != null").end().startBlock();
        }
        ArrayList<IfTriple> duplicationtriples = new ArrayList<IfTriple>();
        duplicationtriples.addAll(this.createMethodGuardChecks(frameState, group, guardExpressions, NodeExecutionMode.FAST_PATH));
        duplicationtriples.addAll(this.createAssumptionCheckTriples(frameState, specialization, NodeExecutionMode.SLOW_PATH));
        BlockState duplicationIfCount = IfTriple.materialize(builder, IfTriple.optimize(duplicationtriples), false);
        if (useDuplicate) {
            builder.startStatement().string(duplicateFoundName, " = true").end();
        }
        if (specialization.hasMultipleInstances()) {
            builder.statement("break");
        }
        builder.end(duplicationIfCount.blockCount);
        if (!useDuplicate) {
            if (specialization.getMaximumNumberOfInstances() > 1) {
                builder.startStatement().string(specializationLocalName, " = ", specializationLocalName, ".next_").end();
            } else {
                builder.statement(specializationLocalName + " = null");
            }
            builder.statement(countName + "++");
            builder.end();
        }
        builder.end();
        return builder.build();
    }

    private CodeTree createSpecialize(CodeTreeBuilder parent, FrameState frameState, SpecializationGroup group, SpecializationData specialization) {
        CodeTree updateImplicitCast;
        CodeTreeBuilder builder = parent.create();
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.addAll(this.initializeSpecializationClass(frameState, specialization));
        triples.addAll(this.initializeCaches(frameState, frameState.getMode(), group, specialization.getCaches(), false, true));
        triples.addAll(this.persistAssumptions(frameState, specialization));
        triples.addAll(this.persistSpecializationClass(frameState, specialization));
        builder.end(IfTriple.materialize((CodeTreeBuilder)builder, triples, (boolean)true).blockCount);
        ArrayList<SpecializationData> excludesSpecializations = new ArrayList<SpecializationData>();
        for (SpecializationData otherSpeciailzation : this.reachableSpecializations) {
            if (otherSpeciailzation == specialization || !otherSpeciailzation.getExcludedBy().contains(specialization)) continue;
            excludesSpecializations.add(otherSpeciailzation);
        }
        if (!excludesSpecializations.isEmpty()) {
            Object[] excludesArray = excludesSpecializations.toArray(new SpecializationData[0]);
            builder.tree(this.exclude.createSet(frameState, excludesArray, true, true));
            for (Object excludes : excludesArray) {
                if (!this.useSpecializationClass((SpecializationData)excludes)) continue;
                builder.statement("this." + this.createSpecializationFieldName((SpecializationData)excludes) + " = null");
            }
            builder.tree(this.state.createSet(frameState, excludesArray, false, false));
        }
        if ((updateImplicitCast = this.createUpdateImplicitCastState(builder, frameState, specialization)) != null) {
            builder.tree(this.createUpdateImplicitCastState(builder, frameState, specialization));
        }
        builder.tree(this.state.createSet(frameState, new SpecializationData[]{specialization}, true, true));
        return builder.build();
    }

    private List<IfTriple> persistAssumptions(FrameState frameState, SpecializationData specialization) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
            LocalVariable var = frameState.get(assumption.getId());
            String name = this.createAssumptionFieldName(specialization, assumption);
            CodeTreeBuilder builder = new CodeTreeBuilder(null);
            builder.startStatement();
            builder.tree(this.createSpecializationFieldReference(frameState, specialization, name)).string(" = ").tree(var.createReference());
            builder.end();
            triples.add(new IfTriple(builder.build(), null, null));
        }
        return triples;
    }

    private CodeTree loadSpecializationClass(FrameState frameState, SpecializationData specialization) {
        if (!this.useSpecializationClass(specialization)) {
            return null;
        }
        String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        String typeName = this.createSpecializationTypeName(specialization);
        LocalVariable var = frameState.get(localName);
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.startStatement();
        if (var == null) {
            builder.string(typeName);
            builder.string(" ");
        }
        builder.string(localName);
        builder.string(" = ");
        builder.tree(this.createSpecializationFieldReference(frameState, specialization, null));
        builder.end();
        if (var == null) {
            frameState.set(localName, new LocalVariable(new GeneratedTypeMirror("", typeName), localName, null));
        }
        return builder.build();
    }

    private Collection<IfTriple> persistSpecializationClass(FrameState frameState, SpecializationData specialization) {
        if (!this.useSpecializationClass(specialization)) {
            return Collections.emptyList();
        }
        String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        LocalVariable var = frameState.get(localName);
        if (var == null) {
            return Collections.emptyList();
        }
        String persistFrameState = FlatNodeGenFactory.createSpecializationClassPersisted(specialization);
        if (frameState.getBoolean(persistFrameState, false)) {
            return Collections.emptyList();
        }
        frameState.setBoolean(persistFrameState, true);
        CodeTree ref = var.createReference();
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        builder.startStatement();
        builder.string("this.", this.createSpecializationFieldName(specialization));
        builder.string(" = ");
        builder.tree(ref);
        builder.end();
        return Arrays.asList(new IfTriple(builder.build(), null, null));
    }

    private static String createSpecializationClassPersisted(SpecializationData specialization) {
        return FlatNodeGenFactory.createSpecializationLocalName(specialization) + "$persisted";
    }

    private static void assertSpecializationClassNotInitialized(FrameState frameState, SpecializationData specialization) {
        String framestateVarName = FlatNodeGenFactory.createSpecializationClassInitialized(specialization);
        if (frameState.get(framestateVarName) != null) {
            throw new AssertionError((Object)("Specialization class already initialized. " + specialization));
        }
    }

    private Collection<? extends IfTriple> initializeSpecializationClass(FrameState frameState, SpecializationData specialization) {
        boolean useSpecializationClass = this.useSpecializationClass(specialization);
        if (useSpecializationClass) {
            String localName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
            String typeName = this.createSpecializationTypeName(specialization);
            String classInitialized = FlatNodeGenFactory.createSpecializationClassInitialized(specialization);
            if (!frameState.getBoolean(classInitialized, false)) {
                GeneratedTypeMirror type = new GeneratedTypeMirror("", typeName);
                CodeTreeBuilder initBuilder = new CodeTreeBuilder(null);
                boolean isNode = this.specializationClassIsNode(specialization);
                if (isNode) {
                    initBuilder.startCall("super", "insert");
                }
                initBuilder.startNew(typeName);
                if (specialization.getMaximumNumberOfInstances() > 1) {
                    initBuilder.string(this.createSpecializationFieldName(specialization));
                }
                initBuilder.end();
                if (isNode) {
                    initBuilder.end();
                }
                CodeTree init = initBuilder.build();
                CodeTreeBuilder builder = new CodeTreeBuilder(null);
                builder.startStatement();
                if (frameState.get(localName) == null) {
                    builder.string(typeName);
                    builder.string(" ");
                }
                builder.string(localName);
                builder.string(" = ");
                builder.tree(init);
                builder.end();
                frameState.setBoolean(classInitialized, true);
                frameState.set(localName, new LocalVariable(type, localName, CodeTreeBuilder.singleString(localName)));
                return Arrays.asList(new IfTriple(builder.build(), null, null));
            }
        }
        return Collections.emptyList();
    }

    private static String createSpecializationClassInitialized(SpecializationData specialization) {
        return FlatNodeGenFactory.createSpecializationLocalName(specialization) + "$initialized";
    }

    private CodeTree createUpdateImplicitCastState(CodeTreeBuilder parent, FrameState frameState, SpecializationData specialization) {
        CodeTreeBuilder builder = null;
        int signatureIndex = 0;
        for (Parameter p : specialization.getSignatureParameters()) {
            TypeMirror targetType = p.getType();
            TypeMirror polymorphicType = this.node.getPolymorphicSpecialization().findParameterOrDie(p.getSpecification().getExecution()).getType();
            if (this.typeSystem.hasImplicitSourceTypes(targetType) && ElementUtils.needsCastTo(polymorphicType, targetType)) {
                String implicitFieldName = FlatNodeGenFactory.createImplicitTypeStateLocalName(p);
                if (builder == null) {
                    builder = parent.create();
                }
                builder.tree(this.state.createSetInteger(frameState, new SpecializationGroup.TypeGuard(p.getType(), signatureIndex), CodeTreeBuilder.singleString(implicitFieldName)));
            }
            ++signatureIndex;
        }
        return builder == null ? null : builder.build();
    }

    private CodeTree createAssumptionGuard(CodeTree assumptionValue) {
        return CodeTreeBuilder.createBuilder().startStaticCall(this.types.Assumption, "isValidAssumption").tree(assumptionValue).end().build();
    }

    private static CodeTree combineTrees(String sep, CodeTree ... trees) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        String s = "";
        for (CodeTree tree : trees) {
            if (tree == null || tree.isEmpty()) continue;
            if (sep != null) {
                builder.string(s);
            }
            builder.tree(tree);
            s = sep;
        }
        return builder.build();
    }

    private CodeTree createFastPathAssumptionCheck(CodeTreeBuilder parent, SpecializationData specialization, ExecutableTypeData forType, FrameState frameState) throws AssertionError {
        CodeTreeBuilder builder = parent.create();
        builder.startIf();
        String sep = "";
        for (AssumptionExpression assumption : specialization.getAssumptionExpressions()) {
            builder.string(sep);
            builder.string("!");
            builder.tree(this.createAssumptionGuard(this.createAssumptionReference(frameState, specialization, assumption)));
            sep = " || ";
        }
        builder.end().startBlock();
        builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        builder.tree(this.createRemoveThis(builder, frameState, forType, specialization));
        builder.end();
        return builder.build();
    }

    private static CodeTree createTryExecuteChild(LocalVariable value, CodeTree executeChild, boolean needDeclaration, boolean hasTry) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        boolean hasDeclaration = false;
        if ((hasTry || !executeChild.isSingleLine()) && needDeclaration) {
            builder.tree(value.createDeclaration(null));
            hasDeclaration = true;
        }
        if (hasTry) {
            builder.startTryBlock();
        } else {
            builder.startGroup();
        }
        if (executeChild.isSingleLine()) {
            builder.startStatement();
            if (hasDeclaration || !needDeclaration) {
                builder.tree(executeChild);
            } else {
                builder.type(value.getTypeMirror()).string(" ").tree(executeChild);
            }
            builder.end();
        } else {
            builder.tree(executeChild);
        }
        builder.end();
        return builder.build();
    }

    private ExecutableTypeData resolveTargetExecutable(NodeExecutionData execution, TypeMirror target) {
        NodeChildData child = execution.getChild();
        if (child == null) {
            return null;
        }
        ExecutableTypeData targetExecutable = child.findExecutableType(target);
        if (targetExecutable == null) {
            targetExecutable = child.findAnyGenericExecutableType(this.context);
        }
        return targetExecutable;
    }

    private CodeTree createCatchRewriteException(CodeTreeBuilder parent, SpecializationData specialization, ExecutableTypeData forType, FrameState frameState, CodeTree execution) {
        if (specialization.getExceptions().isEmpty()) {
            return execution;
        }
        CodeTreeBuilder builder = parent.create();
        builder.startTryBlock();
        builder.tree(execution);
        boolean nonSlowPath = false;
        TypeMirror[] exceptionTypes = new TypeMirror[specialization.getExceptions().size()];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            TypeMirror type = specialization.getExceptions().get(i).getJavaClass();
            if (!ElementUtils.isAssignable(type, this.types.SlowPathException) && !ElementUtils.isAssignable(type, this.context.getType(ArithmeticException.class))) {
                nonSlowPath = true;
            }
            exceptionTypes[i] = type;
        }
        builder.end().startCatchBlock(exceptionTypes, "ex");
        if (nonSlowPath) {
            builder.tree(GeneratorUtils.createTransferToInterpreterAndInvalidate());
        } else {
            builder.lineComment("implicit transferToInterpreterAndInvalidate()");
        }
        builder.tree(this.createExcludeThis(builder, frameState, forType, specialization));
        builder.end();
        return builder.build();
    }

    private CodeTree createExcludeThis(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData forType, SpecializationData specialization) {
        boolean hasUnexpectedResultRewrite;
        boolean hasReexecutingRewrite;
        CodeTreeBuilder builder = parent.create();
        if (!frameState.getMode().isSlowPath()) {
            builder.declaration(this.context.getType(Lock.class), "lock", "getLock()");
        }
        if (this.needsLocking) {
            builder.statement("lock.lock()");
            builder.startTryBlock();
        }
        Object[] specializations = specialization.getExcludeCompanion() != null ? new SpecializationData[]{specialization, specialization.getExcludeCompanion()} : new SpecializationData[]{specialization};
        builder.tree(this.exclude.createSet(null, specializations, true, true));
        builder.tree(this.state.createSet(null, specializations, false, true));
        for (Object removeSpecialization : specializations) {
            if (!this.useSpecializationClass((SpecializationData)removeSpecialization)) continue;
            String fieldName = this.createSpecializationFieldName((SpecializationData)removeSpecialization);
            builder.statement("this." + fieldName + " = null");
        }
        if (this.needsLocking) {
            builder.end().startFinallyBlock();
            builder.statement("lock.unlock()");
            builder.end();
        }
        boolean bl = hasReexecutingRewrite = !(hasUnexpectedResultRewrite = specialization.hasUnexpectedResultRewrite()) || specialization.getExceptions().size() > 1;
        if (hasReexecutingRewrite) {
            if (hasUnexpectedResultRewrite) {
                builder.startIf().string("ex").instanceOf(this.types.UnexpectedResultException).end().startBlock();
                builder.tree(this.createReturnUnexpectedResult(forType, true));
                builder.end().startElseBlock();
                builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
                builder.end();
            } else {
                builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
            }
        } else {
            assert (hasUnexpectedResultRewrite);
            builder.tree(this.createReturnUnexpectedResult(forType, false));
        }
        builder.end();
        return builder.build();
    }

    private CodeTree createRemoveThis(CodeTreeBuilder parent, FrameState frameState, ExecutableTypeData forType, SpecializationData specialization) {
        CodeTreeBuilder builder;
        CodeExecutableElement method = this.removeThisMethods.get(specialization);
        String specializationLocalName = FlatNodeGenFactory.createSpecializationLocalName(specialization);
        boolean useSpecializationClass = this.useSpecializationClass(specialization);
        if (method == null) {
            method = new CodeExecutableElement(this.context.getType(Void.TYPE), "remove" + specialization.getId() + NAME_SUFFIX);
            if (useSpecializationClass) {
                method.addParameter(new CodeVariableElement(this.context.getType(Object.class), specializationLocalName));
            }
            builder = method.createBuilder();
            if (this.needsLocking) {
                builder.declaration(this.context.getType(Lock.class), "lock", "getLock()");
                builder.statement("lock.lock()");
                builder.startTryBlock();
            }
            String fieldName = this.createSpecializationFieldName(specialization);
            if (!useSpecializationClass || specialization.getMaximumNumberOfInstances() == 1) {
                builder.tree(this.state.createSet(null, new Object[]{specialization}, false, true));
                if (useSpecializationClass) {
                    builder.statement("this." + fieldName + " = null");
                }
            } else {
                String typeName = this.createSpecializationTypeName(specialization);
                boolean specializedIsNode = this.specializationClassIsNode(specialization);
                builder.declaration(typeName, "prev", "null");
                builder.declaration(typeName, "cur", "this." + fieldName);
                builder.startWhile();
                builder.string("cur != null");
                builder.end().startBlock();
                builder.startIf().string("cur == ").string(specializationLocalName).end().startBlock();
                builder.startIf().string("prev == null").end().startBlock();
                builder.statement("this." + fieldName + " = cur.next_");
                if (specializedIsNode) {
                    builder.statement("this.adoptChildren()");
                }
                builder.end().startElseBlock();
                builder.statement("prev.next_ = cur.next_");
                if (specializedIsNode) {
                    builder.statement("prev.adoptChildren()");
                }
                builder.end();
                builder.statement("break");
                builder.end();
                builder.statement("prev = cur");
                builder.statement("cur = cur.next_");
                builder.end();
                builder.startIf().string("this." + fieldName).string(" == null").end().startBlock();
                builder.tree(this.state.createSet(null, Arrays.asList(specialization).toArray(new SpecializationData[0]), false, true));
                builder.end();
            }
            if (this.needsLocking) {
                builder.end().startFinallyBlock();
                builder.statement("lock.unlock()");
                builder.end();
            }
            this.removeThisMethods.put(specialization, method);
        }
        builder = parent.create();
        builder.startStatement().startCall(method.getSimpleName().toString());
        if (useSpecializationClass) {
            builder.string(specializationLocalName);
        }
        builder.end().end();
        builder.tree(this.createCallExecuteAndSpecialize(forType, frameState));
        return builder.build();
    }

    private CodeTree createCallExecute(ExecutableTypeData forType, ExecutableTypeData targetType, FrameState frameState) {
        TypeMirror returnType = targetType.getReturnType();
        ArrayList<CodeTree> bindings = new ArrayList<CodeTree>();
        List<TypeMirror> sourceTypes = forType.getSignatureParameters();
        List<TypeMirror> targetTypes = targetType.getSignatureParameters();
        if (sourceTypes.size() != targetTypes.size()) {
            throw new IllegalArgumentException();
        }
        if (targetType.getFrameParameter() != null) {
            LocalVariable parameterLocal = frameState.get(FRAME_VALUE);
            TypeMirror parameterTargetType = targetType.getFrameParameter();
            if (parameterLocal == null) {
                bindings.add(CodeTreeBuilder.createBuilder().defaultValue(parameterTargetType).build());
            } else {
                bindings.add(parameterLocal.createReference());
            }
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            LocalVariable parameterLocal = frameState.getValue(i);
            TypeMirror parameterTargetType = targetTypes.get(i);
            if (parameterLocal == null) {
                bindings.add(CodeTreeBuilder.createBuilder().defaultValue(parameterTargetType).build());
                continue;
            }
            bindings.add(parameterLocal.createReference());
        }
        CodeTree call = FlatNodeGenFactory.callMethod(frameState, null, targetType.getMethod(), bindings.toArray(new CodeTree[0]));
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private CodeTree createCallExecuteAndSpecialize(ExecutableTypeData forType, FrameState frameState) {
        TypeMirror returnType = this.node.getPolymorphicSpecialization().getReturnType().getType();
        String frame = null;
        if (FlatNodeGenFactory.needsFrameToExecute(this.reachableSpecializations)) {
            frame = FRAME_VALUE;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startCall(this.createExecuteAndSpecializeName());
        frameState.addReferencesTo(builder, frame);
        builder.end();
        CodeTree call = builder.build();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private CodeTree createReturnUnexpectedResult(ExecutableTypeData forType, boolean needsCast) {
        TypeMirror returnType = this.context.getType(Object.class);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startCall(needsCast ? "((UnexpectedResultException) ex)" : "ex", "getResult").end();
        CodeTree call = builder.build();
        builder = builder.create();
        if (ElementUtils.isVoid(forType.getReturnType())) {
            builder.statement(call);
            builder.returnStatement();
        } else {
            builder.startReturn();
            builder.tree(this.expectOrCast(returnType, forType, call));
            builder.end();
        }
        return builder.build();
    }

    private List<IfTriple> createMethodGuardChecks(FrameState frameState, SpecializationGroup group, List<GuardExpression> guardExpressions, NodeExecutionMode mode) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (GuardExpression guard : guardExpressions) {
            if (mode.isSlowPath() && !guard.isConstantTrueInSlowPath(this.context)) {
                CodeTreeBuilder builder = new CodeTreeBuilder(null);
                ArrayList<IfTriple> innerTriples = new ArrayList<IfTriple>();
                boolean guardStateBit = FlatNodeGenFactory.guardNeedsStateBit(group.getSpecialization(), guard);
                FrameState innerFrameState = frameState;
                if (guardStateBit) {
                    if (group.getSpecialization() == null) {
                        throw new AssertionError();
                    }
                    innerFrameState = frameState.copy();
                    builder.startIf().tree(this.state.createNotContains(innerFrameState, new Object[]{guard})).end().startBlock();
                    innerTriples.addAll(this.initializeSpecializationClass(innerFrameState, group.getSpecialization()));
                    innerTriples.addAll(this.persistSpecializationClass(innerFrameState, group.getSpecialization()));
                }
                innerTriples.addAll(this.initializeCaches(innerFrameState, mode, group, group.getSpecialization().getBoundCaches(guard.getExpression()), !guardStateBit, guardStateBit));
                innerTriples.addAll(this.initializeCasts(innerFrameState, group, guard.getExpression(), mode));
                IfTriple.materialize(builder, innerTriples, true);
                if (guardStateBit) {
                    builder.tree(this.state.createSet(innerFrameState, new Object[]{guard}, true, true));
                    builder.end();
                }
                triples.add(new IfTriple(builder.build(), null, null));
            } else if (mode.isGuardFallback()) {
                triples.addAll(this.initializeCasts(frameState, group, guard.getExpression(), mode));
            } else if (mode.isFastPath()) {
                triples.addAll(this.initializeCaches(frameState, mode, group, group.getSpecialization().getBoundCaches(guard.getExpression()), true, false));
            }
            triples.add(this.createMethodGuardCheck(frameState, group.getSpecialization(), guard, mode));
        }
        return triples;
    }

    private List<IfTriple> initializeCaches(FrameState frameState, NodeExecutionMode mode, SpecializationGroup group, Collection<CacheExpression> caches, boolean store, boolean forcePersist) {
        if (group.getSpecialization() == null || caches.isEmpty() || mode.isFastPath()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (CacheExpression cache : caches) {
            triples.addAll(this.initializeCasts(frameState, group, cache.getDefaultExpression(), mode));
            triples.addAll(this.persistAndInitializeCache(frameState, group.getSpecialization(), cache, store, forcePersist));
        }
        return triples;
    }

    private Collection<IfTriple> persistAndInitializeCache(FrameState frameState, SpecializationData specialization, CacheExpression cache, boolean store, boolean persist) {
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.addAll(FlatNodeGenFactory.initializeReferences(frameState, cache));
        CodeTree init = this.initializeCache(frameState, specialization, cache);
        if (store) {
            triples.addAll(this.storeCache(frameState, specialization, cache, init));
        }
        if (persist) {
            triples.addAll(this.persistCache(frameState, specialization, cache, init));
        }
        return triples;
    }

    private Collection<IfTriple> persistCache(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree cacheValue) {
        boolean isNodeInterfaceArray;
        CodeTree value;
        if (cache.isAlwaysInitialized()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        String name = this.createFieldName(specialization, cache.getParameter());
        LocalVariable local = frameState.get(name);
        if (local != null) {
            value = local.createReference();
        } else {
            if (cacheValue == null) {
                return Collections.emptyList();
            }
            value = cacheValue;
        }
        TypeMirror type = cache.getParameter().getType();
        String frameStateInitialized = name + "$initialized";
        if (frameState.getBoolean(frameStateInitialized, false)) {
            return Collections.emptyList();
        }
        frameState.setBoolean(frameStateInitialized, true);
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        Parameter parameter = cache.getParameter();
        boolean useSpecializationClass = this.useSpecializationClass(specialization);
        String insertTarget = useSpecializationClass ? FlatNodeGenFactory.createSpecializationLocalName(specialization) : "super";
        DeclaredType nodeType = this.types.Node;
        CodeTypeMirror.ArrayCodeTypeMirror nodeArrayType = new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node);
        boolean isNode = ElementUtils.isAssignable(parameter.getType(), nodeType);
        boolean isNodeInterface = isNode || ElementUtils.isAssignable(type, this.types.NodeInterface);
        boolean isNodeArray = ElementUtils.isAssignable(type, nodeArrayType);
        boolean bl = isNodeInterfaceArray = isNodeArray || this.isNodeInterfaceArray(type);
        if (isNodeInterface || isNodeInterfaceArray) {
            ReferenceType castType;
            String insertName;
            builder = new CodeTreeBuilder(null);
            String fieldName = this.createFieldName(specialization, cache.getParameter()) + "__";
            String string = insertName = useSpecializationClass ? this.useInsertAccessor(specialization, isNodeInterfaceArray) : "insert";
            if (isNodeInterface) {
                castType = isNode ? null : nodeType;
            } else {
                assert (isNodeInterfaceArray);
                castType = isNodeArray ? null : nodeArrayType;
            }
            if (castType == null) {
                CodeTreeBuilder noCast = new CodeTreeBuilder(null);
                noCast.startCall(insertTarget, insertName);
                noCast.tree(value);
                noCast.end();
                value = noCast.build();
            } else {
                builder.declaration(cache.getDefaultExpression().getResolvedType(), fieldName, value);
                builder.startIf().string(fieldName).instanceOf(castType).end().startBlock();
                builder.startStatement().startCall(insertTarget, insertName);
                builder.startGroup().cast(castType).string(fieldName).end();
                builder.end().end();
                builder.end();
                value = CodeTreeBuilder.singleString(fieldName);
            }
        }
        CodeTree cacheReference = this.createCacheReference(frameState, specialization, cache);
        if (this.sharedCaches.containsKey(cache) && !ElementUtils.isPrimitive(cache.getParameter().getType())) {
            builder.startIf().tree(cacheReference).string(" == null").end().startBlock();
            builder.startStatement().tree(cacheReference).string(" = ").tree(value).end();
            builder.end();
        } else {
            builder.startStatement().tree(cacheReference).string(" = ").tree(value).end();
        }
        triples.add(new IfTriple(builder.build(), null, null));
        return triples;
    }

    private static List<IfTriple> initializeReferences(FrameState frameState, CacheExpression cache) {
        if (cache.isCachedContext() || cache.isCachedLanguage()) {
            String supplierName = FlatNodeGenFactory.createElementReferenceName(cache);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            String supplierLocalName = supplierName + NAME_SUFFIX;
            builder.declaration(cache.getReferenceType(), supplierLocalName, "this." + supplierName);
            builder.startIf().string(supplierLocalName).string(" == null").end().startBlock();
            String method = cache.isCachedContext() ? "super.lookupContextReference" : "super.lookupLanguageReference";
            builder.startStatement().string("this.", supplierName).string(" = ").string(supplierLocalName).string(" = ").startCall(method).typeLiteral(cache.getLanguageType()).end().end();
            builder.end();
            String supplierInitialized = supplierName + "$initialized";
            if (frameState.getBoolean(supplierInitialized, false)) {
                return Collections.emptyList();
            }
            frameState.setBoolean(supplierInitialized, true);
            frameState.set(supplierName, new LocalVariable(cache.getReferenceType(), supplierLocalName, null));
            return Arrays.asList(new IfTriple(builder.build(), null, null));
        }
        return Collections.emptyList();
    }

    private Collection<IfTriple> storeCache(FrameState frameState, SpecializationData specialization, CacheExpression cache, CodeTree value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String name = this.createFieldName(specialization, cache.getParameter());
        LocalVariable var = frameState.get(name);
        if (var != null) {
            return Collections.emptyList();
        }
        TypeMirror type = cache.getParameter().getType();
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        String refName = name + NAME_SUFFIX;
        CodeTree useValue = (ElementUtils.isAssignable(type, this.types.Node) || ElementUtils.isAssignable(type, new CodeTypeMirror.ArrayCodeTypeMirror(this.types.Node))) && !cache.isAlwaysInitialized() ? builder.create().startCall("super.insert").tree(value).end().build() : value;
        builder.declaration(type, refName, useValue);
        frameState.set(name, new LocalVariable(type, name, CodeTreeBuilder.singleString(refName)));
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        triples.add(new IfTriple(builder.build(), null, null));
        return triples;
    }

    private CodeTree initializeCache(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        CodeTree tree;
        String name = this.createFieldName(specialization, cache.getParameter());
        if (frameState.get(name) != null) {
            return null;
        }
        if (cache.isMergedLibrary()) {
            if (frameState.getMode().isUncached()) {
                CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
                builder.staticReference(FlatNodeGenFactory.createLibraryConstant(this.libraryConstants, cache.getParameter().getType()));
                builder.startCall(".getUncached");
                builder.tree(this.writeExpression(frameState, specialization, cache.getDefaultExpression()));
                builder.end();
                tree = builder.build();
            } else {
                tree = CodeTreeBuilder.singleString("this." + cache.getMergedLibraryIdentifier());
            }
        } else if (cache.isCachedContext() || cache.isCachedLanguage()) {
            String fieldName = FlatNodeGenFactory.createElementReferenceName(cache);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            LocalVariable var = frameState.get(fieldName);
            if (var != null) {
                builder.tree(var.createReference());
            } else {
                builder.string("this.").string(fieldName);
            }
            if (!cache.isReference()) {
                builder.string(".get()");
            }
            tree = builder.build();
        } else {
            DSLExpression expression = frameState.getMode().isUncached() ? cache.getUncachedExpression() : cache.getDefaultExpression();
            tree = this.writeExpression(frameState, specialization, expression);
        }
        return tree;
    }

    private static String createElementReferenceName(CacheExpression cache) {
        if (cache.isCachedContext()) {
            return ElementUtils.firstLetterLowerCase(ElementUtils.getSimpleName(cache.getLanguageType())) + "ContextReference_";
        }
        if (cache.isCachedLanguage()) {
            return ElementUtils.firstLetterLowerCase(ElementUtils.getSimpleName(cache.getLanguageType())) + "Reference_";
        }
        throw new AssertionError();
    }

    private IfTriple createMethodGuardCheck(FrameState frameState, SpecializationData specialization, GuardExpression guard, NodeExecutionMode mode) {
        GuardExpression guardWithBit;
        DSLExpression expression = this.optimizeExpression(guard.getExpression());
        CodeTree init = null;
        CodeTree expressionCode = this.writeExpression(frameState, specialization, expression);
        if (mode.isGuardFallback() && (guardWithBit = FlatNodeGenFactory.getGuardThatNeedsStateBit(specialization, guard)) != null) {
            CodeTreeBuilder builder = new CodeTreeBuilder(null);
            builder.string("(");
            builder.tree(this.state.createNotContains(frameState, new Object[]{guardWithBit}));
            builder.string(" || ");
            builder.tree(expressionCode);
            builder.string(")");
            expressionCode = builder.build();
            this.fallbackNeedsState = true;
        }
        CodeTree assertion = null;
        if (mode.isFastPath() || mode.isGuardFallback()) {
            if (!specialization.isDynamicParameterBound(expression, true)) {
                assertion = CodeTreeBuilder.createBuilder().startAssert().tree(expressionCode).end().build();
                expressionCode = null;
            }
        } else if (guard.isConstantTrueInSlowPath(this.context)) {
            assertion = CodeTreeBuilder.createBuilder().startStatement().string("// assert ").tree(expressionCode).end().build();
            expressionCode = null;
        }
        return new IfTriple(init, expressionCode, assertion);
    }

    private static Map<DSLExpression.Variable, CodeTree> castBoundTypes(Map<DSLExpression.Variable, LocalVariable> bindings) {
        HashMap<DSLExpression.Variable, CodeTree> resolvedBindings = new HashMap<DSLExpression.Variable, CodeTree>();
        for (DSLExpression.Variable variable : bindings.keySet()) {
            LocalVariable localVariable = bindings.get(variable);
            CodeTree resolved = localVariable.createReference();
            TypeMirror sourceType = localVariable.getTypeMirror();
            TypeMirror targetType = variable.getResolvedTargetType();
            if (targetType == null) {
                targetType = variable.getResolvedType();
            }
            if (!ElementUtils.isAssignable(sourceType, targetType)) {
                resolved = CodeTreeBuilder.createBuilder().startParantheses().cast(targetType, resolved).end().build();
            }
            resolvedBindings.put(variable, resolved);
        }
        return resolvedBindings;
    }

    private Map<DSLExpression.Variable, LocalVariable> bindExpressionValues(FrameState frameState, DSLExpression expression, SpecializationData specialization) throws AssertionError {
        HashMap<DSLExpression.Variable, LocalVariable> bindings = new HashMap<DSLExpression.Variable, LocalVariable>();
        Set<DSLExpression.Variable> boundVariables = expression.findBoundVariables();
        if (specialization == null && !boundVariables.isEmpty()) {
            throw new AssertionError((Object)"Cannot bind guard variable in non-specialization group. yet.");
        }
        for (DSLExpression.Variable variable : boundVariables) {
            LocalVariable localVariable;
            Parameter resolvedParameter = specialization.findByVariable(variable.getResolvedVariable());
            if (resolvedParameter == null || (localVariable = this.bindExpressionVariable(frameState, specialization, resolvedParameter)) == null) continue;
            bindings.put(variable, localVariable);
        }
        return bindings;
    }

    private LocalVariable bindExpressionVariable(FrameState frameState, SpecializationData specialization, Parameter resolvedParameter) {
        LocalVariable localVariable;
        if (resolvedParameter.getSpecification().isCached()) {
            CodeTree ref;
            String cachedMemberName = this.createFieldName(specialization, resolvedParameter);
            localVariable = frameState.get(cachedMemberName);
            if (localVariable == null) {
                CacheExpression cache = specialization.findCache(resolvedParameter);
                ref = this.createCacheReference(frameState, specialization, cache);
            } else {
                ref = localVariable.createReference();
            }
            localVariable = new LocalVariable(resolvedParameter.getType(), cachedMemberName, ref);
        } else if (resolvedParameter.getSpecification().isSignature()) {
            NodeExecutionData execution = resolvedParameter.getSpecification().getExecution();
            localVariable = frameState.getValue(execution);
        } else {
            localVariable = frameState.get(resolvedParameter.getLocalName());
        }
        return localVariable;
    }

    private CodeTree createSpecializationFieldReference(FrameState frameState, SpecializationData s, String fieldName) {
        CodeTreeBuilder builder = new CodeTreeBuilder(null);
        if (this.useSpecializationClass(s)) {
            String localName = FlatNodeGenFactory.createSpecializationLocalName(s);
            LocalVariable var = frameState.get(localName);
            if (var != null) {
                builder.string(localName);
            } else {
                builder.string("this.", this.createSpecializationFieldName(s));
            }
        } else {
            builder.string("this");
        }
        if (fieldName != null) {
            builder.string(".");
            builder.string(fieldName);
        }
        return builder.build();
    }

    private CodeTree createCacheReference(FrameState frameState, SpecializationData specialization, CacheExpression cache) {
        if (cache == null) {
            return CodeTreeBuilder.singleString("null /* cache not resolved */");
        }
        if (frameState.getMode().isUncached()) {
            return this.initializeCache(frameState, specialization, cache);
        }
        if (cache.isAlwaysInitialized()) {
            return this.initializeCache(frameState, specialization, cache);
        }
        String sharedName = this.sharedCaches.get(cache);
        if (sharedName != null) {
            return CodeTreeBuilder.createBuilder().string("this.").string(sharedName).build();
        }
        String cacheFieldName = this.createFieldName(specialization, cache.getParameter());
        return this.createSpecializationFieldReference(frameState, specialization, cacheFieldName);
    }

    private CodeTree createAssumptionReference(FrameState frameState, SpecializationData s, AssumptionExpression a) {
        String assumptionFieldName = this.createAssumptionFieldName(s, a);
        return this.createSpecializationFieldReference(frameState, s, assumptionFieldName);
    }

    private IfTriple createTypeCheckOrCast(FrameState frameState, SpecializationGroup group, SpecializationGroup.TypeGuard typeGuard, NodeExecutionMode specializationExecution, boolean castOnly, boolean forceImplicitCast) {
        CodeTreeBuilder prepareBuilder = CodeTreeBuilder.createBuilder();
        CodeTreeBuilder checkBuilder = CodeTreeBuilder.createBuilder();
        int signatureIndex = typeGuard.getSignatureIndex();
        LocalVariable value = frameState.getValue(signatureIndex);
        TypeMirror targetType = typeGuard.getType();
        if (!ElementUtils.needsCastTo(value.getTypeMirror(), targetType)) {
            TypeMirror genericTargetType = this.node.getGenericSpecialization().findParameterOrDie(this.node.getChildExecutions().get(signatureIndex)).getType();
            if (ElementUtils.typeEquals(value.getTypeMirror(), genericTargetType)) {
                return null;
            }
            boolean foundImplicitSubType = false;
            if (forceImplicitCast) {
                List<ImplicitCastData> casts = this.typeSystem.lookupByTargetType(targetType);
                for (ImplicitCastData cast : casts) {
                    if (!ElementUtils.isSubtype(cast.getSourceType(), targetType)) continue;
                    foundImplicitSubType = true;
                    break;
                }
            }
            if (!foundImplicitSubType) {
                return null;
            }
        }
        NodeExecutionData execution = this.node.getChildExecutions().get(signatureIndex);
        CodeTreeBuilder castBuilder = prepareBuilder.create();
        List<ImplicitCastData> sourceTypes = this.typeSystem.lookupByTargetType(targetType);
        CodeTree valueReference = value.createReference();
        if (sourceTypes.isEmpty()) {
            checkBuilder.tree(TypeSystemCodeGenerator.check(this.typeSystem, targetType, valueReference));
            castBuilder.tree(TypeSystemCodeGenerator.cast(this.typeSystem, targetType, valueReference));
        } else {
            List<SpecializationData> specializations = group.collectSpecializations();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (SpecializationData otherSpecialization : specializations) {
                parameters.add(otherSpecialization.findParameterOrDie(execution));
            }
            if (specializationExecution.isFastPath() || specializationExecution.isGuardFallback() || specializationExecution.isUncached()) {
                CodeTree implicitState = specializationExecution.isGuardFallback() || specializationExecution.isUncached() ? null : this.state.createExtractInteger(frameState, typeGuard);
                checkBuilder.tree(TypeSystemCodeGenerator.implicitCheckFlat(this.typeSystem, targetType, valueReference, implicitState));
                castBuilder.tree(TypeSystemCodeGenerator.implicitCastFlat(this.typeSystem, targetType, valueReference, implicitState));
            } else {
                Parameter parameter = (Parameter)parameters.get(0);
                String implicitStateName = FlatNodeGenFactory.createImplicitTypeStateLocalName(parameter);
                CodeTree defaultValue = null;
                prepareBuilder.declaration(this.context.getType(Integer.TYPE), implicitStateName, defaultValue);
                CodeTree specializeCall = TypeSystemCodeGenerator.implicitSpecializeFlat(this.typeSystem, targetType, valueReference);
                checkBuilder.startParantheses();
                checkBuilder.string(implicitStateName, " = ").tree(specializeCall);
                checkBuilder.end();
                checkBuilder.string(" != 0");
                castBuilder.tree(TypeSystemCodeGenerator.implicitCastFlat(this.typeSystem, targetType, valueReference, CodeTreeBuilder.singleString(implicitStateName)));
            }
        }
        if (castOnly) {
            LocalVariable currentValue = frameState.getValue(execution);
            CodeTreeBuilder localsBuilder = CodeTreeBuilder.createBuilder();
            LocalVariable castVariable = currentValue.nextName().newType(typeGuard.getType()).accessWith(null);
            frameState.setValue(execution, castVariable);
            localsBuilder.tree(castVariable.createDeclaration(castBuilder.build()));
            return new IfTriple(localsBuilder.build(), null, null);
        }
        return new IfTriple(prepareBuilder.build(), checkBuilder.build(), null);
    }

    private List<IfTriple> initializeCasts(FrameState frameState, SpecializationGroup group, DSLExpression expression, NodeExecutionMode specializationExecution) {
        Set<VariableElement> boundElements = expression.findBoundVariableElements();
        if (boundElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IfTriple> triples = new ArrayList<IfTriple>();
        for (VariableElement variable : boundElements) {
            NodeExecutionData execution;
            Parameter p = group.getSpecialization().findByVariable(variable);
            if (p == null || (execution = p.getSpecification().getExecution()) == null) continue;
            LocalVariable var = frameState.getValue(execution);
            if (var == null) {
                throw new AssertionError();
            }
            IfTriple triple = this.createTypeCheckOrCast(frameState, group, new SpecializationGroup.TypeGuard(p.getType(), execution.getIndex()), specializationExecution, true, false);
            if (triple == null) continue;
            triples.add(triple);
        }
        return triples;
    }

    private ExecutableTypeData createExecuteAndSpecializeType() {
        SpecializationData polymorphicSpecialization = this.node.getPolymorphicSpecialization();
        TypeMirror polymorphicType = polymorphicSpecialization.getReturnType().getType();
        ArrayList<TypeMirror> parameters = new ArrayList<TypeMirror>();
        for (Parameter param : polymorphicSpecialization.getSignatureParameters()) {
            parameters.add(param.getType());
        }
        return new ExecutableTypeData(this.node, polymorphicType, this.createExecuteAndSpecializeName(), this.node.getFrameType(), parameters);
    }

    private List<TypeMirror> resolveOptimizedImplicitSourceTypes(NodeExecutionData execution, TypeMirror targetType) {
        List<TypeMirror> allSourceTypes = this.typeSystem.lookupSourceTypes(targetType);
        ArrayList<TypeMirror> filteredSourceTypes = new ArrayList<TypeMirror>();
        for (TypeMirror sourceType : allSourceTypes) {
            ExecutableTypeData executableType = this.resolveTargetExecutable(execution, sourceType);
            if (executableType == null || !ElementUtils.isPrimitive(sourceType) || !this.boxingEliminationEnabled || !ElementUtils.typeEquals(executableType.getReturnType(), sourceType)) continue;
            filteredSourceTypes.add(sourceType);
        }
        return filteredSourceTypes;
    }

    private ChildExecutionResult createExecuteChildImplicitCast(CodeTreeBuilder parent, FrameState originalFrameState, FrameState frameState, NodeExecutionData execution, LocalVariable target) {
        CodeTreeBuilder builder = parent.create();
        List<TypeMirror> originalSourceTypes = this.typeSystem.lookupSourceTypes(target.getTypeMirror());
        List<TypeMirror> sourceTypes = this.resolveOptimizedImplicitSourceTypes(execution, target.getTypeMirror());
        SpecializationGroup.TypeGuard typeGuard = new SpecializationGroup.TypeGuard(target.getTypeMirror(), execution.getIndex());
        boolean throwsUnexpected = false;
        boolean elseIf = false;
        for (TypeMirror sourceType : sourceTypes) {
            ExecutableTypeData executableType = this.resolveTargetExecutable(execution, sourceType);
            elseIf = builder.startIf(elseIf);
            throwsUnexpected |= executableType.hasUnexpectedValue();
            builder.startGroup();
            builder.tree(this.state.createContainsOnly(frameState, originalSourceTypes.indexOf(sourceType), 1, new Object[]{typeGuard}, new Object[]{typeGuard}));
            builder.string(" && ");
            builder.tree(this.state.createIsNotAny(frameState, this.reachableSpecializationsArray));
            builder.end();
            builder.end();
            builder.startBlock();
            CodeTree value = this.callChildExecuteMethod(execution, executableType, frameState);
            value = this.expect(executableType.getReturnType(), sourceType, value);
            throwsUnexpected |= ElementUtils.needsCastTo(executableType.getReturnType(), sourceType);
            ImplicitCastData cast = this.typeSystem.lookupCast(sourceType, target.getTypeMirror());
            if (cast != null) {
                String localName = FlatNodeGenFactory.createSourceTypeLocalName(target, sourceType);
                builder.startStatement().string(localName).string(" = ").tree(value).end();
                value = FlatNodeGenFactory.callMethod(frameState, null, cast.getMethod(), CodeTreeBuilder.singleString(localName));
            }
            builder.startStatement().string(target.getName()).string(" = ").tree(value).end();
            builder.end();
        }
        if (elseIf) {
            builder.startElseBlock();
        }
        LocalVariable genericValue = target.makeGeneric(this.context).nextName();
        builder.tree(this.createAssignExecuteChild(originalFrameState, frameState, builder, execution, this.node.getGenericExecutableType(null), genericValue));
        builder.startStatement().string(target.getName()).string(" = ");
        CodeTree implicitState = this.state.createExtractInteger(frameState, typeGuard);
        builder.tree(TypeSystemCodeGenerator.implicitExpectFlat(this.typeSystem, target.getTypeMirror(), genericValue.createReference(), implicitState));
        builder.end();
        if (!sourceTypes.isEmpty()) {
            builder.end();
        }
        return new ChildExecutionResult(builder.build(), throwsUnexpected);
    }

    private static enum NodeExecutionMode {
        FAST_PATH,
        SLOW_PATH,
        UNCACHED,
        FALLBACK_GUARD;


        public boolean isGuardFallback() {
            return this == FALLBACK_GUARD;
        }

        public boolean isUncached() {
            return this == UNCACHED;
        }

        public boolean isSlowPath() {
            return this == SLOW_PATH;
        }

        public final boolean isFastPath() {
            return this == FAST_PATH;
        }
    }

    private static class BoxingSplit {
        private final SpecializationGroup group;
        private final TypeMirror[] primitiveSignature;

        BoxingSplit(SpecializationGroup group, TypeMirror[] primitiveSignature) {
            this.group = group;
            this.primitiveSignature = primitiveSignature;
        }

        public String getName() {
            StringBuilder b = new StringBuilder();
            String sep = "";
            for (TypeMirror typeMirror : this.primitiveSignature) {
                b.append(sep).append(ElementUtils.firstLetterLowerCase(ElementUtils.getSimpleName(typeMirror)));
                sep = FlatNodeGenFactory.NAME_SUFFIX;
            }
            return b.toString();
        }
    }

    private static final class LocalVariable {
        private final TypeMirror typeMirror;
        private final CodeTree accessorTree;
        private final String name;

        private LocalVariable(TypeMirror typeMirror, String name, CodeTree accessorTree) {
            Objects.requireNonNull(typeMirror);
            this.typeMirror = typeMirror;
            this.accessorTree = accessorTree;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static String createNextName(String name) {
            return name + FlatNodeGenFactory.NAME_SUFFIX;
        }

        public TypeMirror getTypeMirror() {
            return this.typeMirror;
        }

        public CodeVariableElement createParameter() {
            return new CodeVariableElement(this.getTypeMirror(), this.getName());
        }

        public CodeTree createDeclaration(CodeTree init) {
            return CodeTreeBuilder.createBuilder().declaration(this.getTypeMirror(), this.getName(), init).build();
        }

        public CodeTree createReference() {
            if (this.accessorTree != null) {
                return this.accessorTree;
            }
            return CodeTreeBuilder.singleString(this.getName());
        }

        public LocalVariable newType(TypeMirror newType) {
            return new LocalVariable(newType, this.name, this.accessorTree);
        }

        public LocalVariable accessWith(CodeTree tree) {
            return new LocalVariable(this.typeMirror, this.name, tree);
        }

        public LocalVariable nextName() {
            return new LocalVariable(this.typeMirror, LocalVariable.createNextName(this.name), this.accessorTree);
        }

        public LocalVariable makeOriginal() {
            return new LocalVariable(this.typeMirror, this.name, this.accessorTree);
        }

        public LocalVariable makeGeneric(ProcessorContext context) {
            return this.newType(context.getType(Object.class));
        }

        public String toString() {
            return "Local[type = " + this.getTypeMirror() + ", name = " + this.name + ", accessWith = " + this.accessorTree + "]";
        }
    }

    private static final class FrameState {
        private final FlatNodeGenFactory factory;
        private final Map<String, LocalVariable> values = new HashMap<String, LocalVariable>();
        private final Map<String, Boolean> directValues = new HashMap<String, Boolean>();
        private final NodeExecutionMode mode;
        private final CodeExecutableElement method;
        private final List<TypeMirror> caughtTypes = new ArrayList<TypeMirror>();

        private FrameState(FlatNodeGenFactory factory, NodeExecutionMode mode, CodeExecutableElement method) {
            this.factory = factory;
            this.mode = mode;
            this.method = method;
        }

        public void addCaughtException(TypeMirror exceptionType) {
            this.caughtTypes.add(exceptionType);
        }

        public void addThrownExceptions(ExecutableElement calledMethod) {
            if (!calledMethod.getThrownTypes().isEmpty()) {
                CodeExecutableElement target = this.getMethod();
                if (!calledMethod.getThrownTypes().isEmpty()) {
                    block0: for (TypeMirror typeMirror : calledMethod.getThrownTypes()) {
                        if (ElementUtils.isAssignable(typeMirror, ProcessorContext.getInstance().getType(RuntimeException.class)) || ElementUtils.isAssignable(typeMirror, ProcessorContext.getInstance().getTypes().UnexpectedResultException)) continue;
                        for (TypeMirror caughtType : this.caughtTypes) {
                            if (!ElementUtils.typeEquals(caughtType, typeMirror)) continue;
                            continue block0;
                        }
                        boolean found = false;
                        for (TypeMirror foundType : target.getThrownTypes()) {
                            if (!ElementUtils.typeEquals(typeMirror, foundType)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        target.getThrownTypes().add(typeMirror);
                    }
                }
            }
        }

        public NodeExecutionMode getMode() {
            return this.mode;
        }

        public void setBoolean(String name, boolean value) {
            this.directValues.put(name, value);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Boolean bool = this.directValues.get(name);
            if (bool == null) {
                return defaultValue;
            }
            return bool;
        }

        public CodeExecutableElement getMethod() {
            return this.method;
        }

        public static FrameState load(FlatNodeGenFactory factory, ExecutableTypeData type, int varargsThreshold, NodeExecutionMode mode, CodeExecutableElement method) {
            FrameState context = new FrameState(factory, mode, method);
            context.loadEvaluatedValues(type, varargsThreshold);
            return context;
        }

        private void loadEvaluatedValues(ExecutableTypeData executedType, int varargsThreshold) {
            TypeMirror frame = executedType.getFrameParameter();
            if (frame == null) {
                this.removeValue(FlatNodeGenFactory.FRAME_VALUE);
            } else {
                this.set(FlatNodeGenFactory.FRAME_VALUE, new LocalVariable(frame, FlatNodeGenFactory.FRAME_VALUE, null));
            }
            for (NodeFieldData field : this.factory.node.getFields()) {
                String fieldName = FrameState.fieldValueName(field);
                this.values.put(fieldName, new LocalVariable(field.getType(), fieldName, CodeTreeBuilder.singleString(field.getName())));
            }
            boolean varargs = this.needsVarargs(false, varargsThreshold);
            List<TypeMirror> evaluatedParameter = executedType.getEvaluatedParameters();
            int evaluatedIndex = 0;
            for (int executionIndex = 0; executionIndex < this.factory.node.getExecutionCount(); ++executionIndex) {
                NodeExecutionData execution = this.factory.node.getChildExecutions().get(executionIndex);
                if (evaluatedIndex >= executedType.getEvaluatedCount()) continue;
                TypeMirror evaluatedType = evaluatedParameter.get(evaluatedIndex);
                LocalVariable value = this.createValue(execution, evaluatedType);
                if (varargs) {
                    value = value.accessWith(FrameState.createReadVarargs(evaluatedIndex));
                }
                this.values.put(value.getName(), value.makeOriginal());
                ++evaluatedIndex;
            }
        }

        public static FrameState load(FlatNodeGenFactory factory, NodeExecutionMode mode, CodeExecutableElement method) {
            return FrameState.load(factory, factory.createExecuteAndSpecializeType(), Integer.MAX_VALUE, mode, method);
        }

        public FrameState copy() {
            FrameState copy = new FrameState(this.factory, this.mode, this.method);
            copy.values.putAll(this.values);
            copy.caughtTypes.addAll(this.caughtTypes);
            copy.directValues.putAll(this.directValues);
            return copy;
        }

        private static String fieldValueName(NodeFieldData field) {
            return field.getName() + "Value";
        }

        public LocalVariable createValue(NodeExecutionData execution, TypeMirror type) {
            return new LocalVariable(type, FrameState.valueName(execution), null);
        }

        private static String valueName(NodeExecutionData execution) {
            return execution.getName() + "Value";
        }

        public void set(String id, LocalVariable var) {
            this.values.put(id, var);
        }

        public LocalVariable get(String id) {
            return this.values.get(id);
        }

        public LocalVariable getValue(NodeExecutionData execution) {
            return this.get(FrameState.valueName(execution));
        }

        public LocalVariable getValue(int signatureIndex) {
            List<NodeExecutionData> childExecutions = this.factory.node.getChildExecutions();
            if (signatureIndex < childExecutions.size()) {
                return this.getValue(childExecutions.get(signatureIndex));
            }
            return null;
        }

        public void removeValue(String id) {
            this.values.remove(id);
        }

        public void setValue(NodeExecutionData execution, LocalVariable var) {
            this.values.put(FrameState.valueName(execution), var);
        }

        private boolean needsVarargs(boolean requireLoaded, int varArgsThreshold) {
            int size = 0;
            for (NodeExecutionData execution : this.factory.node.getChildExecutions()) {
                if (requireLoaded && this.getValue(execution) == null) continue;
                ++size;
            }
            return size >= varArgsThreshold;
        }

        private static CodeTree createReadVarargs(int i) {
            return CodeTreeBuilder.createBuilder().string("args_[").string(String.valueOf(i)).string("]").build();
        }

        public void addReferencesTo(CodeTreeBuilder builder, String ... optionalNames) {
            for (String string : optionalNames) {
                LocalVariable local = this.values.get(string);
                if (local == null) continue;
                builder.tree(local.createReference());
            }
            List<NodeExecutionData> executions = this.factory.node.getChildExecutions();
            for (NodeExecutionData execution : executions) {
                LocalVariable localVariable = this.getValue(execution);
                if (localVariable == null) continue;
                builder.startGroup().tree(localVariable.createReference()).end();
            }
        }

        public void addParametersTo(CodeExecutableElement targetMethod, int varArgsThreshold, String ... optionalNames) {
            for (String var : optionalNames) {
                LocalVariable local = this.values.get(var);
                if (local == null) continue;
                targetMethod.addParameter(local.createParameter());
            }
            if (this.needsVarargs(true, varArgsThreshold)) {
                targetMethod.addParameter(new CodeVariableElement(this.factory.getType(Object[].class), "args_"));
                targetMethod.setVarArgs(true);
            } else {
                for (NodeExecutionData execution : this.factory.node.getChildExecutions()) {
                    LocalVariable var = this.getValue(execution);
                    if (var == null) continue;
                    targetMethod.addParameter(var.createParameter());
                }
            }
        }

        public String toString() {
            return "LocalContext [values=" + this.values + "]";
        }
    }

    private static class ExcludeBitSet
    extends BitSet {
        ExcludeBitSet(SpecializationData[] specializations) {
            super("exclude", specializations);
        }

        @Override
        protected int calculateRequiredBits(Object object) {
            if (object instanceof SpecializationData) {
                SpecializationData specialization = (SpecializationData)object;
                if (specialization.isPolymorphic()) {
                    return 0;
                }
                if (specialization.isUninitialized()) {
                    return 0;
                }
                if (!specialization.getExceptions().isEmpty() || !specialization.getExcludedBy().isEmpty()) {
                    return 1;
                }
                return 0;
            }
            throw new IllegalArgumentException();
        }
    }

    private class StateBitSet
    extends BitSet {
        StateBitSet(Object[] objects) {
            super(FlatNodeGenFactory.STATE_VALUE, objects);
        }

        @Override
        protected int calculateRequiredBits(Object object) {
            if (object instanceof SpecializationData) {
                SpecializationData specialization = (SpecializationData)object;
                if (specialization.isPolymorphic()) {
                    return 0;
                }
                return 1;
            }
            if (object instanceof SpecializationGroup.TypeGuard) {
                SpecializationGroup.TypeGuard guard = (SpecializationGroup.TypeGuard)object;
                TypeMirror type = guard.getType();
                List<TypeMirror> sourceTypes = FlatNodeGenFactory.this.typeSystem.lookupSourceTypes(type);
                if (sourceTypes.size() > 1) {
                    return sourceTypes.size();
                }
                throw new AssertionError();
            }
            if (object instanceof GuardExpression) {
                return 1;
            }
            throw new AssertionError();
        }
    }

    private static abstract class BitSet {
        private final int capacity;
        private final String name;
        private final Map<Object, Integer> offsets = new HashMap<Object, Integer>();
        private final Object[] objects;
        private final ProcessorContext context = ProcessorContext.getInstance();
        private final long allMask;
        private final TypeMirror bitSetType;

        BitSet(String name, Object[] objects) {
            this.name = name;
            this.objects = objects;
            this.capacity = this.computeStateLength();
            if (this.capacity <= 32) {
                this.bitSetType = this.context.getType(Integer.TYPE);
            } else if (this.capacity <= 64) {
                this.bitSetType = this.context.getType(Long.TYPE);
            } else {
                throw new UnsupportedOperationException("State space too big " + this.capacity + ". Only <= 64 supported.");
            }
            this.allMask = this.createMask(objects);
        }

        private int computeStateLength() {
            if (this.objects.length == 0) {
                return 0;
            }
            int bitIndex = 0;
            for (Object specialization : this.objects) {
                int specializationSize = this.calculateRequiredBits(specialization);
                this.offsets.put(specialization, bitIndex);
                bitIndex += specializationSize;
            }
            return bitIndex;
        }

        public CodeVariableElement declareFields(CodeTypeElement clazz) {
            return clazz.add(FlatNodeGenFactory.createNodeField(Modifier.PRIVATE, this.bitSetType, this.name + FlatNodeGenFactory.NAME_SUFFIX, this.context.getTypes().CompilerDirectives_CompilationFinal, new Modifier[0]));
        }

        public CodeTree createLoad(FrameState frameState) {
            if (frameState.get(this.name) != null) {
                return CodeTreeBuilder.singleString("");
            }
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            String fieldName = this.name + FlatNodeGenFactory.NAME_SUFFIX;
            LocalVariable var = new LocalVariable(this.bitSetType, this.name, null);
            CodeTreeBuilder init = builder.create();
            init.tree(CodeTreeBuilder.singleString(fieldName));
            builder.tree(var.createDeclaration(init.build()));
            frameState.set(this.name, var);
            return builder.build();
        }

        public CodeTree createContainsOnly(FrameState frameState, int offset, int length, Object[] selectedElements, Object[] allElements) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            long mask = (this.createMask(offset, length, selectedElements) ^ 0xFFFFFFFFFFFFFFFFL) & this.createMask(allElements);
            builder.tree(this.createMaskedReference(frameState, mask));
            builder.string(" == 0");
            builder.string(" /* only-active ", this.toString(selectedElements, " && "), " */");
            return builder.build();
        }

        public CodeTree createIs(FrameState frameState, Object[] selectedElements, Object[] maskedElements) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.tree(this.createMaskedReference(frameState, maskedElements));
            builder.string(" == ").string(this.formatMask(this.createMask(selectedElements)));
            return builder.build();
        }

        private CodeTree createMaskedReference(FrameState frameState, long maskedElements) {
            if (maskedElements == this.allMask) {
                return this.createReference(frameState);
            }
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.string("(").tree(this.createReference(frameState)).string(" & ").string(this.formatMask(maskedElements)).string(")");
            return builder.build();
        }

        private CodeTree createMaskedReference(FrameState frameState, Object[] maskedElements) {
            return this.createMaskedReference(frameState, this.createMask(maskedElements));
        }

        public CodeTree createIsNotAny(FrameState frameState, Object[] elements) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.tree(this.createMaskedReference(frameState, elements));
            builder.string(" != 0 ");
            builder.string(" /* is-not ", this.toString(elements, " && "), " */");
            return builder.build();
        }

        private String formatMask(long mask) {
            int bitsUsed = 64 - Long.numberOfLeadingZeros(mask);
            if (bitsUsed <= 16) {
                return "0b" + Integer.toBinaryString((int)mask);
            }
            if (this.capacity <= 32) {
                return "0x" + Integer.toHexString((int)mask);
            }
            return "0x" + Long.toHexString(mask) + "L";
        }

        public CodeTree createIsOneBitOf(FrameState frameState, Object[] elements) {
            CodeTree masked = this.createMaskedReference(frameState, elements);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.startParantheses().tree(masked).string(" & ").startParantheses().tree(masked).string(" - 1").end().end().string(" == 0");
            builder.string(" /* ", this.label("is-single"), " */");
            return builder.build();
        }

        public CodeTree createContains(FrameState frameState, Object[] elements) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.tree(this.createMaskedReference(frameState, elements));
            builder.string(" != 0");
            builder.string(" /* ", this.label("is"), this.toString(elements, " || "), " */");
            return builder.build();
        }

        private String toString(Object[] elements, String elementSep) {
            StringBuilder b = new StringBuilder();
            String sep = "";
            for (int i = 0; i < elements.length; ++i) {
                b.append(sep).append(this.toString(elements[i]));
                sep = elementSep;
            }
            return b.toString();
        }

        protected String toString(Object element) {
            if (element instanceof SpecializationData) {
                SpecializationData specialization = (SpecializationData)element;
                if (specialization.isUninitialized()) {
                    return "uninitialized";
                }
                return ElementUtils.createReferenceName(specialization.getMethod());
            }
            if (element instanceof SpecializationGroup.TypeGuard) {
                int index = ((SpecializationGroup.TypeGuard)element).getSignatureIndex();
                String simpleName = ElementUtils.getSimpleName(((SpecializationGroup.TypeGuard)element).getType());
                return index + ":" + simpleName;
            }
            return element.toString();
        }

        private CodeTree createLocalReference(FrameState frameState) {
            LocalVariable var;
            LocalVariable localVariable = var = frameState != null ? frameState.get(this.name) : null;
            if (var != null) {
                return var.createReference();
            }
            return null;
        }

        private CodeTree createReference(FrameState frameState) {
            CodeTree ref = this.createLocalReference(frameState);
            if (ref == null) {
                ref = CodeTreeBuilder.createBuilder().string("this.", this.name, FlatNodeGenFactory.NAME_SUFFIX).build();
            }
            return ref;
        }

        public CodeTree createNotContains(FrameState frameState, Object[] elements) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.startParantheses();
            builder.tree(this.createMaskedReference(frameState, elements));
            builder.end();
            builder.string(" == 0");
            builder.string(" /* ", this.label("is-not"), this.toString(elements, " && "), " */");
            return builder.build();
        }

        private String label(String message) {
            return message + "-" + this.getName() + " ";
        }

        protected String getName() {
            if (this instanceof ExcludeBitSet) {
                return "excluded";
            }
            return "active";
        }

        public CodeTree createExtractInteger(FrameState frameState, Object element) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            if (this.capacity > 32) {
                builder.string("(int)(");
            }
            builder.tree(this.createMaskedReference(frameState, this.createMask(element)));
            builder.string(" >>> ", Integer.toString(this.getStateOffset(element)));
            if (this.capacity > 32) {
                builder.string(")");
            }
            builder.string(" /* ", this.label("extract-implicit"), this.toString(element), " */");
            return builder.build();
        }

        public CodeTree createSet(FrameState frameState, Object[] elements, boolean value, boolean persist) {
            CodeTreeBuilder valueBuilder = CodeTreeBuilder.createBuilder();
            valueBuilder.tree(this.createReference(frameState));
            if (value) {
                valueBuilder.string(" | ");
                valueBuilder.string(this.formatMask(this.createMask(elements)));
                valueBuilder.string(" /* ", this.label("add"), this.toString(elements, ", "), " */");
            } else {
                valueBuilder.string(" & ");
                valueBuilder.string(this.formatMask(this.createMask(elements) ^ 0xFFFFFFFFFFFFFFFFL));
                valueBuilder.string(" /* ", this.label("remove"), this.toString(elements, ", "), " */");
            }
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.startStatement();
            if (persist) {
                builder.string("this.", this.name, "_ = ");
                CodeTree localReference = this.createLocalReference(frameState);
                if (localReference != null) {
                    builder.tree(localReference).string(" = ");
                }
            } else {
                builder.tree(this.createReference(frameState)).string(" = ");
            }
            builder.tree(valueBuilder.build());
            builder.end();
            return builder.build();
        }

        public CodeTree createSetInteger(FrameState frameState, Object element, CodeTree value) {
            int offset = this.getStateOffset(element);
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.startStatement();
            builder.tree(this.createReference(frameState)).string(" = ");
            builder.startParantheses();
            builder.tree(this.createReference(frameState));
            builder.string(" | (");
            if (this.capacity > 32) {
                builder.string("(long) ");
            }
            builder.tree(value).string(" << ", Integer.toString(offset), ")");
            builder.string(" /* ", this.label("set-implicit"), this.toString(element), " */");
            builder.end();
            builder.end();
            return builder.build();
        }

        private long createMask(Object e) {
            return this.createMask(new Object[]{e});
        }

        private long createMask(Object[] e) {
            return this.createMask(0, -1, e);
        }

        private long createMask(int offset, int length, Object[] e) {
            long mask = 0L;
            for (Object element : e) {
                if (!this.offsets.containsKey(element)) continue;
                int stateOffset = this.getStateOffset(element);
                int stateLength = this.calculateRequiredBits(element);
                int realLength = length < 0 ? stateLength : Math.min(stateLength, offset + length);
                for (int i = offset; i < realLength; ++i) {
                    mask |= 1L << stateOffset + i;
                }
            }
            return mask;
        }

        private int getStateOffset(Object stateSpecialization) {
            Integer value = this.offsets.get(stateSpecialization);
            if (value == null) {
                return 0;
            }
            return value;
        }

        protected abstract int calculateRequiredBits(Object var1);
    }

    private static class ExecuteDelegationResult {
        public final CodeTree tree;
        public final boolean hasFallthrough;

        ExecuteDelegationResult(CodeTree tree, boolean hasFallthrough) {
            this.tree = tree;
            this.hasFallthrough = hasFallthrough;
        }
    }

    private static class ChildExecutionResult {
        CodeTree code;
        final boolean throwsUnexpectedResult;

        ChildExecutionResult(CodeTree code, boolean throwsUnexpectedResult) {
            this.code = code;
            this.throwsUnexpectedResult = throwsUnexpectedResult;
        }
    }

    private static class IfTriple {
        private CodeTree prepare;
        private CodeTree condition;
        private CodeTree statements;

        IfTriple(CodeTree prepare, CodeTree condition, CodeTree statements) {
            this.prepare = prepare;
            this.condition = condition;
            this.statements = statements;
        }

        private boolean canBeMerged(IfTriple triple) {
            boolean prepareSet = !IfTriple.isEmpty(triple.prepare) || !IfTriple.isEmpty(this.prepare);
            boolean conditionSet = !IfTriple.isEmpty(triple.condition) || !IfTriple.isEmpty(this.condition);
            boolean statementsSet = !IfTriple.isEmpty(triple.statements) || !IfTriple.isEmpty(this.statements);
            return conditionSet ^ (prepareSet || statementsSet);
        }

        private static boolean isEmpty(CodeTree e) {
            return e == null || e.isEmpty();
        }

        public String toString() {
            CodeTreeBuilder b = CodeTreeBuilder.createBuilder();
            b.startGroup();
            if (!IfTriple.isEmpty(this.prepare)) {
                b.tree(this.prepare);
            }
            if (!IfTriple.isEmpty(this.condition)) {
                b.startIf().tree(this.condition).end().startBlock();
            }
            if (!IfTriple.isEmpty(this.statements)) {
                b.tree(this.statements);
            }
            if (!IfTriple.isEmpty(this.condition)) {
                b.end();
            }
            b.end();
            return b.build().toString();
        }

        private static IfTriple merge(String conditionSep, Set<IfTriple> triples) {
            if (triples.isEmpty()) {
                throw new AssertionError();
            }
            if (triples.size() == 1) {
                return triples.iterator().next();
            }
            CodeTree[] prepareTrees = new CodeTree[triples.size()];
            CodeTree[] conditionTrees = new CodeTree[triples.size()];
            CodeTree[] statementTrees = new CodeTree[triples.size()];
            int index = 0;
            for (IfTriple triple : triples) {
                prepareTrees[index] = triple.prepare;
                conditionTrees[index] = triple.condition;
                statementTrees[index] = triple.statements;
                ++index;
            }
            return new IfTriple(FlatNodeGenFactory.combineTrees(null, prepareTrees), FlatNodeGenFactory.combineTrees(conditionSep, conditionTrees), FlatNodeGenFactory.combineTrees(null, statementTrees));
        }

        public static List<IfTriple> optimize(List<IfTriple> triples) {
            ArrayList<IfTriple> newTriples = new ArrayList<IfTriple>();
            LinkedHashSet<IfTriple> mergable = new LinkedHashSet<IfTriple>();
            IfTriple prev = null;
            for (IfTriple triple : triples) {
                if (prev != null) {
                    if (prev.canBeMerged(triple)) {
                        mergable.add(triple);
                    } else {
                        newTriples.add(IfTriple.merge(" && ", mergable));
                        mergable.clear();
                    }
                }
                prev = triple;
                mergable.add(prev);
            }
            if (prev != null) {
                newTriples.add(IfTriple.merge(" && ", mergable));
            }
            return newTriples;
        }

        public static BlockState materialize(CodeTreeBuilder builder, Collection<IfTriple> triples, boolean forceNoBlocks) {
            int blockCount = 0;
            int ifCount = 0;
            boolean otherPrepare = false;
            for (IfTriple triple : triples) {
                if (triple.prepare != null && !triple.prepare.isEmpty()) {
                    if (!otherPrepare) {
                        if (blockCount == 0 && !forceNoBlocks) {
                            builder.startBlock();
                            ++blockCount;
                        }
                        otherPrepare = true;
                    }
                    builder.tree(triple.prepare);
                }
                if (triple.condition != null && !triple.condition.isEmpty()) {
                    if (forceNoBlocks) {
                        throw new AssertionError((Object)"no blocks forced but block required");
                    }
                    builder.startIf().tree(triple.condition).end().startBlock();
                    ++blockCount;
                    ++ifCount;
                }
                if (triple.statements == null || triple.statements.isEmpty()) continue;
                builder.tree(triple.statements);
            }
            return BlockState.create(ifCount, blockCount);
        }
    }

    static final class BlockState {
        static final BlockState NONE = new BlockState(0, 0);
        final int ifCount;
        final int blockCount;

        private BlockState(int ifCount, int blockCount) {
            this.ifCount = ifCount;
            this.blockCount = blockCount;
        }

        BlockState add(BlockState state) {
            return new BlockState(this.ifCount + state.ifCount, this.blockCount + state.blockCount);
        }

        BlockState incrementIf() {
            return new BlockState(this.ifCount + 1, this.blockCount + 1);
        }

        static BlockState create(int ifCount, int blockCount) {
            if (ifCount == 0 && blockCount == 0) {
                return NONE;
            }
            return new BlockState(ifCount, blockCount);
        }
    }
}

