/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.model.CacheExpression;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.Template;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class ExportsLibrary
extends Template {
    private final Map<String, ExportMessageData> exportedMessages = new LinkedHashMap<String, ExportMessageData>();
    private final ExportsData exports;
    private final LibraryData library;
    private final TypeMirror receiverType;
    private final boolean explicitReceiver;
    private Map<CacheExpression, String> sharedExpressions;

    public ExportsLibrary(ProcessorContext context, TypeElement templateType, AnnotationMirror annotation, ExportsData exports, LibraryData library, TypeMirror receiverType, boolean explicitReceiver) {
        super(context, templateType, annotation);
        this.exports = exports;
        this.receiverType = receiverType;
        this.library = library;
        this.explicitReceiver = explicitReceiver;
    }

    public void setSharedExpressions(Map<CacheExpression, String> sharedExpressions) {
        this.sharedExpressions = sharedExpressions;
    }

    public Map<CacheExpression, String> getSharedExpressions() {
        return this.sharedExpressions;
    }

    public boolean isFinalReceiver() {
        TypeElement type = ElementUtils.castTypeElement(this.receiverType);
        if (type == null) {
            return true;
        }
        return type.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isDynamicDispatchTarget() {
        return this.isExplicitReceiver() && !this.isDefaultExport() && this.isReceiverDynamicDispatched();
    }

    public boolean needsDynamicDispatch() {
        TypeElement type = ElementUtils.castTypeElement(this.receiverType);
        if (type == null) {
            return false;
        }
        if (this.getLibrary().isDynamicDispatch()) {
            return false;
        }
        if (type.getKind().isInterface() || ElementUtils.isObject(this.receiverType)) {
            return true;
        }
        for (ExportsLibrary otherLibrary : this.exports.getExportedLibraries().values()) {
            if (otherLibrary == this || !otherLibrary.getLibrary().isDynamicDispatch()) continue;
            return true;
        }
        return this.isExplicitReceiver() && this.isReceiverDynamicDispatched();
    }

    public boolean isDefaultExport() {
        for (LibraryDefaultExportData defaultExport : this.getLibrary().getDefaultExports()) {
            if (!ElementUtils.typeEquals(defaultExport.getImplType(), this.getTemplateType().asType())) continue;
            return true;
        }
        return false;
    }

    private boolean isReceiverDynamicDispatched() {
        TypeElement receiverTypeElement = ElementUtils.castTypeElement(this.receiverType);
        while (receiverTypeElement != null) {
            List<AnnotationMirror> exportLibrary = ElementUtils.getRepeatedAnnotation(receiverTypeElement.getAnnotationMirrors(), this.types.ExportLibrary);
            for (AnnotationMirror export : exportLibrary) {
                TypeMirror exportedLibrary = ElementUtils.getAnnotationValue(TypeMirror.class, export, "value");
                if (!ElementUtils.typeEquals(exportedLibrary, this.types.DynamicDispatchLibrary)) continue;
                return true;
            }
            receiverTypeElement = ElementUtils.getSuperType(receiverTypeElement);
        }
        return false;
    }

    public boolean needsRewrites() {
        for (ExportMessageData message : this.exportedMessages.values()) {
            if (message.getSpecializedNode() == null || !message.getSpecializedNode().needsRewrites(ProcessorContext.getInstance())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<MessageContainer> findChildContainers() {
        return new ArrayList<MessageContainer>(this.exportedMessages.values());
    }

    public LibraryData getLibrary() {
        return this.library;
    }

    public Map<String, ExportMessageData> getExportedMessages() {
        return this.exportedMessages;
    }

    @Override
    public AnnotationMirror getMessageAnnotation() {
        return this.getTemplateTypeAnnotation();
    }

    public TypeMirror getExplicitReceiver() {
        return this.isExplicitReceiver() ? this.getReceiverType() : null;
    }

    public TypeMirror getReceiverType() {
        return this.receiverType;
    }

    public boolean isExplicitReceiver() {
        return this.explicitReceiver;
    }
}

