/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class LibraryMessage
extends MessageContainer {
    private final LibraryData library;
    private final String name;
    private final ExecutableElement executable;
    private String cacheName;
    private boolean isAbstract;
    private final Set<LibraryMessage> abstractIfExported = new LinkedHashSet<LibraryMessage>();

    public LibraryMessage(LibraryData library, String name, ExecutableElement executable) {
        this.library = library;
        this.name = name;
        this.executable = executable;
    }

    public LibraryData getLibrary() {
        return this.library;
    }

    public boolean hasUnexpectedValue() {
        DeclaredType unexpectedType = this.types.UnexpectedResultException;
        for (TypeMirror typeMirror : this.executable.getThrownTypes()) {
            if (!ElementUtils.typeEquals(typeMirror, unexpectedType)) continue;
            return true;
        }
        return false;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public String getSimpleName() {
        return this.library.getMessageElement().getSimpleName().toString() + "." + this.name;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public Element getMessageElement() {
        return this.executable;
    }

    public Set<LibraryMessage> getAbstractIfExported() {
        return this.abstractIfExported;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract || this.getExecutable().getModifiers().contains((Object)Modifier.ABSTRACT);
    }
}

