/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class LibraryParser
extends AbstractParser<LibraryData> {
    public final List<DeclaredType> annotations;

    public LibraryParser() {
        this.annotations = Arrays.asList(this.types.GenerateLibrary, this.types.GenerateLibrary_DefaultExport, this.types.GenerateLibrary_Abstract);
    }

    @Override
    public boolean isDelegateToRootDeclaredType() {
        return true;
    }

    @Override
    protected LibraryData parse(Element element, List<AnnotationMirror> mirrors) {
        TypeMirror customReceiverType;
        TypeElement type = (TypeElement)element;
        if (mirrors.isEmpty()) {
            return null;
        }
        AnnotationMirror mirror = mirrors.iterator().next();
        LibraryData model = new LibraryData((TypeElement)element, mirror);
        if (!ElementUtils.typeEquals(type.getSuperclass(), this.types.Library)) {
            model.addError("Declared library classes must exactly extend the type %s.", ElementUtils.getQualifiedName(this.types.Library));
            return model;
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            model.addError("Declared library classes must be abstract.", new Object[0]);
            return model;
        }
        if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            model.addError("Declared inner library classes must be static.", new Object[0]);
            return model;
        }
        boolean defaultExportReachable = true;
        List<AnnotationMirror> defaultExports = ElementUtils.getRepeatedAnnotation(element.getAnnotationMirrors(), this.types.GenerateLibrary_DefaultExport);
        for (AnnotationMirror defaultExport : defaultExports) {
            LibraryDefaultExportData export = this.loadDefaultExportImpl(model, defaultExport, "value");
            if (export == null) continue;
            for (LibraryDefaultExportData prev : model.getDefaultExports()) {
                if (!ElementUtils.isAssignable(export.getReceiverType(), prev.getReceiverType())) continue;
                model.addError(defaultExport, null, "The receiver type '%s' of the export '%s' is not reachable. It is shadowed by receiver type '%s' of export '%s'.", ElementUtils.getSimpleName(export.getReceiverType()), ElementUtils.getSimpleName(export.getImplType()), ElementUtils.getSimpleName(prev.getReceiverType()), ElementUtils.getSimpleName(prev.getImplType()));
                break;
            }
            model.getDefaultExports().add(export);
            if (!ElementUtils.isAssignable(this.context.getType(Object.class), export.getReceiverType())) continue;
            defaultExportReachable = false;
        }
        LibraryParser.parseAssertions(element, mirror, type, model);
        List<ExecutableElement> allMethods = ElementFilter.methodsIn(CompilerFactory.getCompiler(type).getEnclosedElementsInDeclarationOrder(type));
        allMethods.add(ElementUtils.findExecutableElement(this.types.Library, "accepts"));
        TypeMirror inferredReceiverType = null;
        HashMap<String, LibraryMessage> messages = new HashMap<String, LibraryMessage>();
        for (ExecutableElement executable : allMethods) {
            Modifier visibility = ElementUtils.getVisibility(executable.getModifiers());
            if (visibility == Modifier.PRIVATE || executable.getModifiers().contains((Object)Modifier.FINAL) || executable.getModifiers().contains((Object)Modifier.STATIC) || model.isDynamicDispatch() && executable.getSimpleName().toString().equals("cast")) continue;
            String messageName = executable.getSimpleName().toString();
            LibraryMessage libraryMessage = (LibraryMessage)messages.get(messageName);
            if (libraryMessage != null) {
                libraryMessage.addError("Library message must have a unique name. Two methods with the same name found.If this method is not intended to be a library message then add the private or final modifier to ignore it.", new Object[0]);
                continue;
            }
            LibraryMessage libraryMessage2 = new LibraryMessage(model, messageName, executable);
            if (visibility == Modifier.PROTECTED || visibility == null) {
                libraryMessage2.addError("Library messages must be public.", new Object[0]);
            }
            if (executable.getParameters().isEmpty()) {
                libraryMessage2.addError("Not enough arguments specified for a library message. The first argument of a library method must be of type Object. Add a receiver argument with type Object resolve this.If this method is not intended to be a library message then add the private or final modifier to ignore it.", new Object[0]);
            } else {
                TypeMirror methodReceiverType = executable.getParameters().get(0).asType();
                if (inferredReceiverType == null) {
                    inferredReceiverType = methodReceiverType;
                } else if (!ElementUtils.isAssignable(methodReceiverType, inferredReceiverType) && !libraryMessage2.getName().equals("accepts")) {
                    libraryMessage2.addError(String.format("Invalid first argument type %s specified. The first argument of a library method must be of the same type for all methods. If this method is not intended to be a library message then add the private or final modifier to ignore it.", ElementUtils.getSimpleName(methodReceiverType)), new Object[0]);
                }
            }
            LibraryMessage declaredIn = (LibraryMessage)messages.get(messageName);
            if (declaredIn != null) {
                libraryMessage2.addError("Messages with the same name are not supported.", new Object[0]);
                continue;
            }
            messages.put(messageName, libraryMessage2);
            model.getMethods().add(libraryMessage2);
        }
        if (!model.hasErrors() && model.getMethods().size() <= 1) {
            model.addError("The library does not export any messages. Use public instance methods to declare library messages.", new Object[0]);
        }
        for (LibraryMessage message : model.getMethods()) {
            AnnotationMirror abstractMirror = ElementUtils.findAnnotationMirror((Element)message.getExecutable(), (TypeMirror)this.types.GenerateLibrary_Abstract);
            if (abstractMirror == null) continue;
            message.setAbstract(true);
            AnnotationValue value = ElementUtils.getAnnotationValue(abstractMirror, "ifExported");
            for (String ifExported : ElementUtils.getAnnotationValueList(String.class, abstractMirror, "ifExported")) {
                LibraryMessage ifExportedMessage = (LibraryMessage)messages.get(ifExported);
                if (ifExportedMessage == message) {
                    message.addError(abstractMirror, value, "The ifExported condition links to itself. Remove that condition to resolve this problem.", new Object[0]);
                    continue;
                }
                if (ifExportedMessage == null) {
                    message.addError(abstractMirror, value, "The ifExported condition links to an unknown message '%s'. Only valid library messages may be linked.", ifExported);
                    continue;
                }
                message.getAbstractIfExported().add(ifExportedMessage);
            }
        }
        if (inferredReceiverType == null) {
            inferredReceiverType = this.context.getType(Object.class);
        }
        if (!model.hasErrors() && inferredReceiverType.getKind().isPrimitive()) {
            model.addError("Primitive receiver type found. Only reference types are supported.", new Object[0]);
            inferredReceiverType = this.context.getType(Object.class);
        }
        if ((customReceiverType = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "receiverType", false)) != null) {
            AnnotationValue customReceiverTypeValue = ElementUtils.getAnnotationValue(mirror, "receiverType");
            if (ElementUtils.typeEquals(customReceiverType, inferredReceiverType)) {
                model.addError(mirror, customReceiverTypeValue, "Redundant receiver type. This receiver type could be inferred from the method signatures. Remove the explicit receiver type to resolve this redundancy.", new Object[0]);
            }
            if (customReceiverType.getKind() != TypeKind.DECLARED) {
                model.addError(mirror, customReceiverTypeValue, "Invalid type. Valid declared type expected.", new Object[0]);
            }
            model.setExportsReceiverType(customReceiverType);
        } else {
            model.setExportsReceiverType(inferredReceiverType);
        }
        model.setSignatureReceiverType(inferredReceiverType);
        if (defaultExportReachable) {
            model.getDefaultExports().add(new LibraryDefaultExportData(null, this.context.getType(Object.class)));
            ExportsData exports = new ExportsData(this.context, type, mirror);
            ExportsLibrary objectExports = new ExportsLibrary(this.context, type, mirror, exports, model, model.getSignatureReceiverType(), true);
            for (LibraryMessage libraryMessage : objectExports.getLibrary().getMethods()) {
                if (libraryMessage.getName().equals("accepts")) continue;
                ExportMessageData exportMessage = new ExportMessageData(objectExports, libraryMessage, null, null);
                objectExports.getExportedMessages().put(libraryMessage.getName(), exportMessage);
            }
            model.setObjectExports(objectExports);
        }
        return model;
    }

    private static void parseAssertions(Element element, AnnotationMirror mirror, TypeElement type, LibraryData model) {
        TypeMirror assertions = ElementUtils.getAnnotationValue(TypeMirror.class, mirror, "assertions", false);
        if (assertions != null) {
            AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "assertions");
            TypeElement assertionsType = ElementUtils.castTypeElement(assertions);
            if (assertionsType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                model.addError(value, "Assertions type must not be abstract.", new Object[0]);
                return;
            }
            if (!ElementUtils.isVisible(element, assertionsType)) {
                model.addError(value, "Assertions type must be visible.", new Object[0]);
                return;
            }
            if (!ElementUtils.isAssignable(assertions, type.asType())) {
                model.addError(value, "Assertions type must be a subclass of the library type '%s'.", ElementUtils.getSimpleName(model.getTemplateType()));
                return;
            }
            ExecutableElement foundConstructor = null;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(assertionsType.getEnclosedElements())) {
                if (constructor.getParameters().size() != 1 || !ElementUtils.typeEquals(constructor.getParameters().get(0).asType(), model.getTemplateType().asType())) continue;
                foundConstructor = constructor;
                break;
            }
            if (foundConstructor == null) {
                model.addError(value, "No constructor with single delegate parameter of type %s found.", ElementUtils.getSimpleName(model.getTemplateType()));
                return;
            }
            if (!ElementUtils.isVisible(model.getTemplateType(), foundConstructor)) {
                model.addError(value, "Assertions constructor is not visible.", new Object[0]);
                return;
            }
            model.setAssertions(assertions);
        }
    }

    private LibraryDefaultExportData loadDefaultExportImpl(LibraryData model, AnnotationMirror exportAnnotation, String annotationName) {
        TypeMirror type = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotation, annotationName);
        AnnotationValue typeValue = ElementUtils.getAnnotationValue(exportAnnotation, annotationName, false);
        if (typeValue == null) {
            return null;
        }
        if (type.getKind() != TypeKind.DECLARED) {
            model.addError(exportAnnotation, typeValue, "The %s type '%s' is invalid.", annotationName, ElementUtils.getSimpleName(type));
            return null;
        }
        List<AnnotationMirror> exportedLibraries = ElementUtils.getRepeatedAnnotation(ElementUtils.castTypeElement(type).getAnnotationMirrors(), this.types.ExportLibrary);
        TypeMirror receiverClass = null;
        for (AnnotationMirror exportedLibrary : exportedLibraries) {
            TypeMirror exportedLib = ElementUtils.getAnnotationValue(TypeMirror.class, exportedLibrary, "value");
            if (!ElementUtils.typeEquals(model.getTemplateType().asType(), exportedLib)) continue;
            receiverClass = ElementUtils.getAnnotationValue(TypeMirror.class, exportedLibrary, "receiverType", false);
            if (receiverClass != null) break;
            model.addError(exportAnnotation, typeValue, "Default export '%s' must specify a receiverType.", ElementUtils.getSimpleName(exportedLib));
            return null;
        }
        if (receiverClass == null) {
            model.addError(exportAnnotation, typeValue, "Default export '%s' does not export a library '%s'.", ElementUtils.getSimpleName(type), ElementUtils.getSimpleName(model.getMessageElement().asType()));
            return null;
        }
        return new LibraryDefaultExportData(type, receiverClass);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.GenerateLibrary;
    }
}

