/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.NodeExecutionData;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;

public class ExecutableTypeData
extends MessageContainer
implements Comparable<ExecutableTypeData> {
    private final NodeData node;
    private final ExecutableElement method;
    private final TypeMirror returnType;
    private final TypeMirror frameParameter;
    private final List<TypeMirror> evaluatedParameters;
    private ExecutableTypeData delegatedTo;
    private final List<ExecutableTypeData> delegatedFrom = new ArrayList<ExecutableTypeData>();
    private String uniqueName;

    public ExecutableTypeData(NodeData node, TypeMirror returnType, String uniqueName, TypeMirror frameParameter, List<TypeMirror> evaluatedParameters) {
        this.node = node;
        this.returnType = returnType;
        this.frameParameter = frameParameter;
        this.evaluatedParameters = evaluatedParameters;
        this.uniqueName = uniqueName;
        this.method = null;
    }

    public ExecutableTypeData(NodeData node, ExecutableElement method, int signatureSize, List<TypeMirror> frameTypes) {
        this.node = node;
        this.method = method;
        this.returnType = method.getReturnType();
        TypeMirror foundFrameParameter = null;
        List<? extends VariableElement> parameters = method.getParameters();
        int parameterIndex = 0;
        this.evaluatedParameters = new ArrayList<TypeMirror>();
        if (!parameters.isEmpty()) {
            TypeMirror firstParameter = parameters.get(0).asType();
            for (TypeMirror frameType : frameTypes) {
                if (!ElementUtils.typeEquals(firstParameter, frameType)) continue;
                foundFrameParameter = firstParameter;
                ++parameterIndex;
                break;
            }
        }
        int numberParameters = Math.max(parameters.size() - parameterIndex, signatureSize);
        for (int i = 0; i < numberParameters; ++i) {
            TypeMirror parameter;
            if (method.isVarArgs() && parameterIndex >= parameters.size() - 1) {
                ArrayType varArgsArray = (ArrayType)parameters.get(parameters.size() - 1).asType();
                parameter = varArgsArray.getComponentType();
            } else {
                if (parameterIndex >= parameters.size()) break;
                parameter = parameters.get(parameterIndex).asType();
            }
            ++parameterIndex;
            this.evaluatedParameters.add(parameter);
        }
        this.frameParameter = foundFrameParameter;
        this.uniqueName = ExecutableTypeData.createName(this);
    }

    public static String createName(ExecutableTypeData type) {
        return "execute" + (ElementUtils.isObject(type.getReturnType()) ? "" : ElementUtils.getTypeId(type.getReturnType()));
    }

    public void addDelegatedFrom(ExecutableTypeData child) {
        this.delegatedFrom.add(child);
        child.delegatedTo = this;
    }

    public List<ExecutableTypeData> getDelegatedFrom() {
        return this.delegatedFrom;
    }

    public ExecutableTypeData getDelegatedTo() {
        return this.delegatedTo;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String name) {
        this.uniqueName = name;
    }

    @Override
    public Element getMessageElement() {
        return this.method;
    }

    public List<TypeMirror> getEvaluatedParameters() {
        return this.evaluatedParameters;
    }

    public List<TypeMirror> getSignatureParameters() {
        ArrayList<TypeMirror> signaturetypes = new ArrayList<TypeMirror>();
        int index = 0;
        for (NodeExecutionData execution : this.node.getChildExecutions()) {
            if (index < this.getEvaluatedCount()) {
                signaturetypes.add(this.getEvaluatedParameters().get(index));
            }
            ++index;
        }
        return signaturetypes;
    }

    public int getVarArgsIndex(int parameterIndex) {
        if (this.method.isVarArgs()) {
            int index = parameterIndex - (this.method.getParameters().size() - 1);
            return index;
        }
        return -1;
    }

    public int getParameterIndex(int signatureIndex) {
        return this.frameParameter != null ? signatureIndex + 1 : signatureIndex;
    }

    public TypeMirror getFrameParameter() {
        return this.frameParameter;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public boolean hasUnexpectedValue() {
        return this.method == null ? false : ElementUtils.canThrowTypeExact(this.method.getThrownTypes(), this.types.UnexpectedResultException);
    }

    public boolean isFinal() {
        return this.method == null ? false : this.method.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isAbstract() {
        return this.method == null ? false : this.method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public int getEvaluatedCount() {
        return this.evaluatedParameters.size();
    }

    public boolean canDelegateTo(ExecutableTypeData to) {
        ExecutableTypeData from = this;
        if (to.getEvaluatedCount() < from.getEvaluatedCount()) {
            return false;
        }
        ProcessorContext context = this.node.getContext();
        if (!from.hasUnexpectedValue() && to.hasUnexpectedValue()) {
            return false;
        }
        if (!(ElementUtils.isVoid(from.getReturnType()) || ElementUtils.isSubtypeBoxed(context, from.getReturnType(), to.getReturnType()) || ElementUtils.isSubtypeBoxed(context, to.getReturnType(), from.getReturnType()))) {
            return false;
        }
        if (from.getFrameParameter() != to.getFrameParameter() && from.getFrameParameter() != null && to.getFrameParameter() != null && !ElementUtils.isSubtypeBoxed(context, from.getFrameParameter(), to.getFrameParameter())) {
            return false;
        }
        for (int i = 0; i < from.getEvaluatedCount(); ++i) {
            if (ElementUtils.isSubtypeBoxed(context, from.getEvaluatedParameters().get(i), to.getEvaluatedParameters().get(i))) continue;
            return false;
        }
        List<TypeMirror> fromSignatureParameters = from.getSignatureParameters();
        List<TypeMirror> toSignatureParameters = to.getSignatureParameters();
        for (int i = fromSignatureParameters.size(); i < toSignatureParameters.size(); ++i) {
            TypeMirror genericType;
            TypeMirror delegateToParameter = toSignatureParameters.get(i);
            if (i >= this.node.getChildExecutions().size() || ElementUtils.isSubtypeBoxed(context, genericType = this.node.getGenericType(this.node.getChildExecutions().get(i)), delegateToParameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ExecutableTypeData o2) {
        int result;
        ExecutableTypeData o1 = this;
        ProcessorContext context = ProcessorContext.getInstance();
        if (this.canDelegateTo(o2)) {
            if (!o2.canDelegateTo(this)) {
                return 1;
            }
        } else if (o2.canDelegateTo(this)) {
            return -1;
        }
        if ((result = Integer.compare(o2.getEvaluatedCount(), o1.getEvaluatedCount())) != 0) {
            return result;
        }
        result = Boolean.compare(o1.hasUnexpectedValue(), o2.hasUnexpectedValue());
        if (result != 0) {
            return result;
        }
        result = ExecutableTypeData.compareType(context, o1.getReturnType(), o2.getReturnType());
        if (result != 0) {
            return result;
        }
        result = ExecutableTypeData.compareType(context, o1.getFrameParameter(), o2.getFrameParameter());
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < o1.getEvaluatedCount(); ++i) {
            result = ExecutableTypeData.compareType(context, o1.getEvaluatedParameters().get(i), o2.getEvaluatedParameters().get(i));
            if (result == 0) continue;
            return result;
        }
        result = o1.getUniqueName().compareTo(o2.getUniqueName());
        if (result != 0) {
            return result;
        }
        if (o1.getMethod() != null && o2.getMethod() != null && (result = ElementUtils.compareMethod(o1.getMethod(), o2.getMethod())) != 0) {
            return result;
        }
        return 0;
    }

    public static int compareType(ProcessorContext context, TypeMirror signature1, TypeMirror signature2) {
        TypeMirror boxedType2;
        if (signature1 == null) {
            if (signature2 == null) {
                return 0;
            }
            return -1;
        }
        if (signature2 == null) {
            return 1;
        }
        if (ElementUtils.typeEquals(signature1, signature2)) {
            return 0;
        }
        if (ElementUtils.isVoid(signature1)) {
            if (ElementUtils.isVoid(signature2)) {
                return 0;
            }
            return 1;
        }
        if (ElementUtils.isVoid(signature2)) {
            return -1;
        }
        TypeMirror boxedType1 = ElementUtils.boxType(context, signature1);
        if (ElementUtils.isSubtype(boxedType1, boxedType2 = ElementUtils.boxType(context, signature2))) {
            if (ElementUtils.isSubtype(boxedType2, boxedType1)) {
                return 0;
            }
            return 1;
        }
        if (ElementUtils.isSubtype(boxedType2, boxedType1)) {
            return -1;
        }
        return ElementUtils.getSimpleName(signature1).compareTo(ElementUtils.getSimpleName(signature2));
    }

    public String getName() {
        if (this.method != null) {
            return this.method.getSimpleName().toString();
        }
        return this.getUniqueName();
    }

    private static String formatType(TypeMirror type) {
        return type == null ? "null" : ElementUtils.getSimpleName(type);
    }

    public String toString() {
        return String.format("%s %s(%s,%s)", ExecutableTypeData.formatType(this.getReturnType()), this.getName(), ExecutableTypeData.formatType(this.getFrameParameter()), this.getEvaluatedParameters());
    }

    public boolean sameParameters(ExecutableTypeData other) {
        if (!ElementUtils.typeEquals(other.getFrameParameter(), this.getFrameParameter())) {
            return false;
        }
        if (this.getEvaluatedCount() != other.getEvaluatedCount()) {
            return false;
        }
        for (int i = 0; i < this.getEvaluatedCount(); ++i) {
            if (ElementUtils.typeEquals(this.getEvaluatedParameters().get(i), other.getEvaluatedParameters().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean sameSignature(ExecutableTypeData other) {
        if (!ElementUtils.typeEquals(other.getReturnType(), this.getReturnType())) {
            return false;
        }
        if (other.getFrameParameter() != null && !ElementUtils.typeEquals(this.getFrameParameter(), other.getFrameParameter())) {
            return false;
        }
        if (this.getEvaluatedCount() != other.getEvaluatedCount()) {
            return false;
        }
        for (int i = 0; i < this.getEvaluatedCount(); ++i) {
            if (ElementUtils.typeEquals(this.getEvaluatedParameters().get(i), other.getEvaluatedParameters().get(i))) continue;
            return false;
        }
        return true;
    }
}

