/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor.model;

import com.oracle.truffle.object.dsl.processor.LayoutParser;
import javax.lang.model.type.TypeMirror;

public class PropertyModel {
    private String name;
    private final TypeMirror type;
    private final boolean hasObjectTypeGetter;
    private final boolean hasShapeGetter;
    private final boolean hasShapeSetter;
    private final boolean hasGetter;
    private final boolean hasSetter;
    private final boolean hasUnsafeSetter;
    private final boolean nullable;
    private final boolean volatileSemantics;
    private final boolean hasCompareAndSet;
    private final boolean hasGetAndSet;
    private final boolean hasIdentifier;
    private final boolean isShapeProperty;

    public PropertyModel(String name, TypeMirror type, boolean hasObjectTypeGetter, boolean hasShapeGetter, boolean hasShapeSetter, boolean hasGetter, boolean hasSetter, boolean hasUnsafeSetter, boolean nullable, boolean volatileSemantics, boolean hasCompareAndSet, boolean hasGetAndSet, boolean hasIdentifier, boolean isShapeProperty) {
        this.name = name;
        this.hasObjectTypeGetter = hasObjectTypeGetter;
        this.hasShapeGetter = hasShapeGetter;
        this.hasShapeSetter = hasShapeSetter;
        this.hasGetter = hasGetter;
        this.hasSetter = hasSetter;
        this.hasUnsafeSetter = hasUnsafeSetter;
        this.type = type;
        this.nullable = nullable;
        this.volatileSemantics = volatileSemantics;
        this.hasCompareAndSet = hasCompareAndSet;
        this.hasGetAndSet = hasGetAndSet;
        this.hasIdentifier = hasIdentifier;
        this.isShapeProperty = isShapeProperty;
    }

    public String getName() {
        return this.name;
    }

    public void fixName(String realName) {
        this.name = realName;
    }

    public boolean hasGeneratedName() {
        return LayoutParser.isGeneratedName(this.name);
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean hasObjectTypeGetter() {
        return this.hasObjectTypeGetter;
    }

    public boolean hasShapeSetter() {
        return this.hasShapeSetter;
    }

    public boolean hasShapeGetter() {
        return this.hasShapeGetter;
    }

    public boolean hasGetter() {
        return this.hasGetter;
    }

    public boolean hasSetter() {
        return this.hasSetter;
    }

    public boolean isFinal() {
        return !this.hasSetter && !this.hasGetAndSet && !this.hasCompareAndSet;
    }

    public boolean hasUnsafeSetter() {
        return this.hasUnsafeSetter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isVolatile() {
        return this.volatileSemantics;
    }

    public boolean hasCompareAndSet() {
        return this.hasCompareAndSet;
    }

    public boolean hasGetAndSet() {
        return this.hasGetAndSet;
    }

    public boolean hasIdentifier() {
        return this.hasIdentifier;
    }

    public boolean isInstanceProperty() {
        return !this.isShapeProperty;
    }

    public boolean isShapeProperty() {
        return this.isShapeProperty;
    }

    public String toString() {
        return this.name + " type=" + this.type + " shape=" + this.isShapeProperty;
    }
}

