/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;

public class ApplicationDescriptor
extends DataSourceDescriptor<Application> {
    private static final String DISPLAY_NAME_PROPERTY = "-Dvisualvm.display.name=";
    private static final String pid_PARAM = "%pid";
    private static final String PID_PARAM = "%PID";
    private String name = super.getName();

    protected ApplicationDescriptor(Application application) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), 0x7FFFFFFE);
    }

    protected ApplicationDescriptor(Application application, int preferredPosition) {
        this(application, ApplicationTypeFactory.getApplicationTypeFor(application), preferredPosition);
    }

    private ApplicationDescriptor(final Application application, final ApplicationType type, int preferredPosition) {
        super((DataSource)application, ApplicationDescriptor.resolveApplicationName(application, type), type.getDescription(), type.getIcon(), preferredPosition, 2);
        type.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("name".equals(propertyName)) {
                    if (ApplicationDescriptor.resolveName((DataSource)application, (String)null) != null) {
                        return;
                    }
                    if (ApplicationDescriptor.this.supportsRename()) {
                        ApplicationDescriptor.this.setName((String)evt.getNewValue());
                        ApplicationDescriptor.this.name = ApplicationDescriptor.super.getName();
                    } else {
                        String oldName = ApplicationDescriptor.this.name;
                        ApplicationDescriptor.this.name = ApplicationDescriptor.this.formatName(ApplicationDescriptor.createGenericName(application, type.getName()));
                        PropertyChangeSupport pcs = ApplicationDescriptor.this.getChangeSupport();
                        pcs.firePropertyChange("prop_name", oldName, ApplicationDescriptor.this.name);
                    }
                } else if ("icon".equals(propertyName)) {
                    ApplicationDescriptor.this.setIcon((Image)evt.getNewValue());
                } else if ("description".equals(propertyName)) {
                    ApplicationDescriptor.this.setDescription((String)evt.getNewValue());
                } else if ("version".equals(propertyName)) {
                    // empty if block
                }
            }
        });
    }

    public String getName() {
        if (this.supportsRename()) {
            return super.getName();
        }
        return this.name;
    }

    public boolean providesProperties() {
        return true;
    }

    protected static String resolveApplicationName(Application application, ApplicationType type) {
        String persistedName = ApplicationDescriptor.resolveName((DataSource)application, null);
        if (persistedName != null) {
            return persistedName;
        }
        String customName = ApplicationDescriptor.resolveCustomName(application);
        if (customName != null) {
            return customName;
        }
        return ApplicationDescriptor.createGenericName(application, type.getName());
    }

    private static String resolveCustomName(Application application) {
        String args;
        int propIndex;
        Jvm jvm = JvmFactory.getJVMFor(application);
        if (jvm.isBasicInfoSupported() && (propIndex = (args = jvm.getJvmArgs()).indexOf(DISPLAY_NAME_PROPERTY)) != -1) {
            int endIndex = args.indexOf(" ", propIndex += DISPLAY_NAME_PROPERTY.length());
            if (endIndex == -1) {
                return args.substring(propIndex);
            }
            return args.substring(propIndex, endIndex);
        }
        return null;
    }

    protected String formatName(String namePattern) {
        Integer pid;
        if (namePattern == null) {
            return null;
        }
        String formatted = namePattern;
        Integer n = pid = namePattern.contains(pid_PARAM) || namePattern.contains(PID_PARAM) ? Integer.valueOf(((Application)this.getDataSource()).getPid()) : null;
        if (pid != null) {
            boolean unknownPid = -1 == pid;
            formatted = formatted.replace(pid_PARAM, unknownPid ? "unknown" : pid.toString());
            formatted = formatted.replace(PID_PARAM, unknownPid ? " (unknown pid) " : " (pid " + pid.toString() + ") ").trim();
        }
        return formatted;
    }

    private static String createGenericName(Application application, String nameBase) {
        int pid = application.getPid();
        String id = Application.CURRENT_APPLICATION.getPid() == pid || pid == -1 ? "" : " (pid " + pid + ")";
        return nameBase + id;
    }
}

