/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class PolyglotSourceCache {
    private final ConcurrentHashMap<Object, CallTarget> sourceCache;
    private final ReferenceQueue<Source> deadSources = new ReferenceQueue();

    PolyglotSourceCache() {
        this.sourceCache = new ConcurrentHashMap();
    }

    CallTarget parseCached(PolyglotLanguageContext context, Source source, String[] argumentNames) {
        CallTarget target;
        this.cleanupStaleEntries();
        if (source.isCached()) {
            CallTarget prev;
            Object sourceId = EngineAccessor.SOURCE.getSourceIdentifier(source);
            WeakSourceKey ref = new WeakSourceKey(sourceId, source, argumentNames, this.deadSources);
            target = this.sourceCache.get(ref);
            if (target == null && (prev = this.sourceCache.putIfAbsent(ref, target = PolyglotSourceCache.parseImpl(context, argumentNames, EngineAccessor.SOURCE.copySource(source)))) != null) {
                target = prev;
            }
        } else {
            target = PolyglotSourceCache.parseImpl(context, argumentNames, source);
        }
        return target;
    }

    private static CallTarget parseImpl(PolyglotLanguageContext context, String[] argumentNames, Source source) {
        CallTarget parsedTarget;
        if (!EngineAccessor.SOURCE.isLegacySource(source)) {
            PolyglotSourceCache.validateSource(context, source);
        }
        if ((parsedTarget = EngineAccessor.LANGUAGE.parse(context.requireEnv(), source, null, argumentNames)) == null) {
            throw new IllegalStateException(String.format("Parsing resulted in a null CallTarget for %s.", source));
        }
        return parsedTarget;
    }

    private static void validateSource(PolyglotLanguageContext context, Source source) {
        boolean expectCharacters;
        if (!source.hasBytes() && !source.hasCharacters()) {
            throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The source does not specify characters nor bytes.", new Object[0]));
        }
        String mimeType = source.getMimeType();
        Set<String> mimeTypes = context.language.cache.getMimeTypes();
        if (mimeType != null && !mimeTypes.contains(mimeType)) {
            throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The language %s does not support MIME type %s. Supported MIME types are %s.", source.getLanguage(), mimeType, mimeTypes));
        }
        String activeMimeType = mimeType;
        if (activeMimeType == null) {
            activeMimeType = context.language.cache.getDefaultMimeType();
        }
        boolean bl = expectCharacters = activeMimeType != null ? context.language.cache.isCharacterMimeType(activeMimeType) : true;
        if (mimeType != null && source.hasCharacters() != expectCharacters) {
            if (source.hasBytes()) {
                throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. MIME type '%s' is character based for language '%s' but the source contents are byte based.", mimeType, source.getLanguage()));
            }
            throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. MIME type '%s' is byte based for language '%s' but the source contents are character based.", mimeType, source.getLanguage()));
        }
        if (source.hasCharacters() != expectCharacters) {
            HashSet<String> binaryMimeTypes = new HashSet<String>();
            HashSet<String> characterMimeTypes = new HashSet<String>();
            for (String supportedMimeType : mimeTypes) {
                if (context.language.cache.isCharacterMimeType(supportedMimeType)) {
                    characterMimeTypes.add(supportedMimeType);
                    continue;
                }
                binaryMimeTypes.add(supportedMimeType);
            }
            if (expectCharacters) {
                if (binaryMimeTypes.isEmpty()) {
                    throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The language %s only supports character based sources but a binary based source was provided.", source.getLanguage()));
                }
                throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a binary based source instead or specify a MIME type for the source. Available MIME types for binary based sources are %s.", source.getLanguage(), binaryMimeTypes));
            }
            if (characterMimeTypes.isEmpty()) {
                throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The language %s only supports binary based sources but a character based source was provided.", source.getLanguage()));
            }
            throw new PolyglotIllegalArgumentException(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a character based source instead or specify a MIME type for the source. Available MIME types for character based sources are %s.", source.getLanguage(), characterMimeTypes));
        }
    }

    private void cleanupStaleEntries() {
        WeakSourceKey sourceRef = null;
        while ((sourceRef = (WeakSourceKey)this.deadSources.poll()) != null) {
            this.sourceCache.remove(sourceRef);
        }
    }

    private static final class WeakSourceKey
    extends WeakReference<Source> {
        final Object key;
        private final String[] arguments;

        WeakSourceKey(Object key, Source value, String[] arguments, ReferenceQueue<? super Source> q) {
            super(value, q);
            this.key = key;
            this.arguments = arguments != null && arguments.length == 0 ? null : arguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakSourceKey) {
                WeakSourceKey other = (WeakSourceKey)obj;
                return this.key.equals(other.key) && Arrays.equals(this.arguments, other.arguments);
            }
            return false;
        }
    }
}

