/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.RawPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.core.llvm.LLVMIRBuilder;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.phases.util.Providers;

public abstract class LLVMGenerator
implements LIRGeneratorTool {
    private final ArithmeticLLVMGenerator arithmetic;
    protected final LLVMIRBuilder builder;
    private final LIRKindTool lirKindTool;
    private final Providers providers;
    private final LLVMGenerationResult generationResult;
    private final boolean returnsEnum;
    private final int debugLevel;
    private LLVM.LLVMValueRef indentCounter;
    private LLVM.LLVMValueRef spacesVector;
    private Block currentBlock;
    private Map<AbstractBeginNode, LLVM.LLVMBasicBlockRef> basicBlockMap = new HashMap<AbstractBeginNode, LLVM.LLVMBasicBlockRef>();
    Map<Block, LLVM.LLVMBasicBlockRef> splitBlockEndMap = new HashMap<Block, LLVM.LLVMBasicBlockRef>();
    private long nextConstantId = 0L;

    public LLVMGenerator(Providers providers, LLVMGenerationResult generationResult, ResolvedJavaMethod method, LLVMIRBuilder builder, LIRKindTool lirKindTool, int debugLevel) {
        this.providers = providers;
        this.generationResult = generationResult;
        this.returnsEnum = method.getSignature().getReturnType(null).resolve(null).isEnum();
        this.builder = builder;
        this.arithmetic = new ArithmeticLLVMGenerator(builder);
        this.lirKindTool = lirKindTool;
        this.debugLevel = debugLevel;
        if (debugLevel >= 1) {
            this.indentCounter = builder.getUniqueGlobal("__svm_indent_counter", builder.intType(), true);
            this.spacesVector = builder.getUniqueGlobal("__svm_spaces_vector", builder.vectorType(builder.rawPointerType(), 100), false);
            StringBuilder strBuilder = new StringBuilder();
            LLVM.LLVMValueRef[] strings = new LLVM.LLVMValueRef[100];
            for (int i = 0; i < 100; ++i) {
                strings[i] = builder.getUniqueGlobal("__svm_" + i + "_spaces", builder.arrayType(builder.byteType(), strBuilder.length() + 1), false);
                builder.setInitializer(strings[i], builder.constantString(strBuilder.toString()));
                strings[i] = builder.buildBitcast(strings[i], builder.rawPointerType());
                strBuilder.append(' ');
            }
            builder.setInitializer(this.spacesVector, builder.constantVector(strings));
        }
    }

    public LLVMIRBuilder getBuilder() {
        return this.builder;
    }

    void appendBasicBlock(Block block) {
        LLVM.LLVMBasicBlockRef basicBlock = this.builder.appendBasicBlock(block.toString());
        this.basicBlockMap.put(block.getBeginNode(), basicBlock);
    }

    LLVM.LLVMBasicBlockRef getBlock(Block block) {
        return this.getBlock(block.getBeginNode());
    }

    LLVM.LLVMBasicBlockRef getBlock(AbstractBeginNode begin) {
        return this.basicBlockMap.get(begin);
    }

    public LLVM.LLVMBasicBlockRef getBlockEnd(Block block) {
        return this.splitBlockEndMap.containsKey(block) ? this.splitBlockEndMap.get(block) : this.getBlock(block);
    }

    void beginBlock(Block block) {
        this.currentBlock = block;
        this.builder.positionAtEnd(this.getBlock(block));
    }

    LLVM.LLVMTypeRef getLLVMType(Stamp stamp) {
        if (stamp instanceof RawPointerStamp) {
            return this.builder.rawPointerType();
        }
        return this.builder.getLLVMType(this.getTypeKind(stamp.javaType(this.getMetaAccess()), false));
    }

    protected JavaKind getTypeKind(ResolvedJavaType type, boolean forMainFunction) {
        throw GraalError.unimplemented();
    }

    public LLVM.LLVMValueRef getFunction(ResolvedJavaMethod method) {
        LLVM.LLVMTypeRef functionType = this.getLLVMFunctionType(method, false);
        return this.builder.getFunction(this.getFunctionName(method), functionType);
    }

    public abstract void allocateRegisterSlots();

    public String getFunctionName(ResolvedJavaMethod method) {
        return method.getName();
    }

    LLVM.LLVMTypeRef getLLVMFunctionReturnType(ResolvedJavaMethod method, boolean forMainFunction) {
        ResolvedJavaType returnType = method.getSignature().getReturnType(null).resolve(null);
        return this.builder.getLLVMStackType(this.getTypeKind(returnType, forMainFunction));
    }

    protected LLVM.LLVMTypeRef[] getLLVMFunctionArgTypes(ResolvedJavaMethod method, boolean forMainFunction) {
        ResolvedJavaType receiver = method.hasReceiver() ? method.getDeclaringClass() : null;
        JavaType[] parameterTypes = method.getSignature().toParameterTypes((JavaType)receiver);
        return (LLVM.LLVMTypeRef[])Arrays.stream(parameterTypes).map(type -> this.builder.getLLVMStackType(this.getTypeKind(type.resolve(null), forMainFunction))).toArray(LLVM.LLVMTypeRef[]::new);
    }

    public LLVM.LLVMTypeRef getLLVMFunctionType(ResolvedJavaMethod method, boolean forMainFunction) {
        return this.builder.functionType(this.getLLVMFunctionReturnType(method, forMainFunction), this.getLLVMFunctionArgTypes(method, forMainFunction));
    }

    private LLVM.LLVMValueRef getLLVMPlaceholderForConstant(Constant constant) {
        String symbolName = this.generationResult.getSymbolNameForConstant(constant);
        if (symbolName == null) {
            symbolName = "constant_" + this.builder.getFunctionName() + "#" + this.nextConstantId++;
            this.generationResult.recordConstant(constant, symbolName);
        }
        return this.builder.getExternalObject(symbolName);
    }

    protected void emitPrintf(String base) {
        this.emitPrintf(base, new JavaKind[0], new LLVM.LLVMValueRef[0]);
    }

    protected void emitPrintf(String base, JavaKind[] types, LLVM.LLVMValueRef[] values) {
        LLVM.LLVMValueRef printf = this.builder.getFunction("printf", this.builder.functionType(this.builder.intType(), true, this.builder.rawPointerType()));
        if (this.debugLevel >= 1) {
            LLVM.LLVMValueRef count = this.builder.buildLoad(this.indentCounter);
            LLVM.LLVMValueRef vector = this.builder.buildLoad(this.spacesVector);
            LLVM.LLVMValueRef spaces = this.builder.buildExtractElement(vector, count);
            this.builder.buildCall(printf, spaces);
        }
        StringBuilder introString = new StringBuilder(base);
        ArrayList<LLVM.LLVMValueRef> printfArgs = new ArrayList<LLVM.LLVMValueRef>();
        assert (types.length == values.length);
        for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case Boolean: 
                case Byte: {
                    introString.append(" %hhd ");
                    break;
                }
                case Short: {
                    introString.append(" %hd ");
                    break;
                }
                case Char: {
                    introString.append(" %c ");
                    break;
                }
                case Int: {
                    introString.append(" %ld ");
                    break;
                }
                case Float: 
                case Double: {
                    introString.append(" %f ");
                    break;
                }
                case Long: {
                    introString.append(" %lld ");
                    break;
                }
                case Object: {
                    introString.append(" %p ");
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
            printfArgs.add(values[i]);
        }
        introString.append("\n");
        printfArgs.add(0, this.builder.buildGlobalStringPtr(introString.toString()));
        this.builder.buildCall(printf, printfArgs.toArray(new LLVM.LLVMValueRef[0]));
    }

    public ArithmeticLIRGeneratorTool getArithmetic() {
        return this.arithmetic;
    }

    public CodeGenProviders getProviders() {
        return this.providers;
    }

    public TargetDescription target() {
        return this.getCodeCache().getTarget();
    }

    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    public CodeCacheProvider getCodeCache() {
        return this.providers.getCodeCache();
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public AbstractBlockBase<?> getCurrentBlock() {
        return this.currentBlock;
    }

    public LIRGenerationResult getResult() {
        throw GraalError.unimplemented();
    }

    public RegisterConfig getRegisterConfig() {
        return this.getCodeCache().getRegisterConfig();
    }

    public boolean hasBlockEnd(AbstractBlockBase<?> block) {
        throw GraalError.unimplemented();
    }

    public LIRGeneratorTool.MoveFactory getMoveFactory() {
        throw GraalError.unimplemented();
    }

    public LIRGeneratorTool.MoveFactory getSpillMoveFactory() {
        return null;
    }

    public LIRGeneratorTool.BlockScope getBlockScope(AbstractBlockBase<?> block) {
        throw GraalError.unimplemented();
    }

    public boolean canInlineConstant(Constant constant) {
        return false;
    }

    public boolean mayEmbedConstantLoad(Constant constant) {
        return false;
    }

    public Value emitConstant(LIRKind kind, Constant constant) {
        LLVM.LLVMValueRef value = this.emitLLVMConstant(((LLVMUtils.LLVMKind)kind.getPlatformKind()).get(), (JavaConstant)constant);
        return new LLVMUtils.LLVMConstant(value, constant);
    }

    public Value emitJavaConstant(JavaConstant constant) {
        LLVM.LLVMValueRef value = this.emitLLVMConstant(this.builder.getLLVMType(constant.getJavaKind()), constant);
        return new LLVMUtils.LLVMConstant(value, (Constant)constant);
    }

    LLVM.LLVMValueRef emitLLVMConstant(LLVM.LLVMTypeRef type, JavaConstant constant) {
        LLVM.LLVMValueRef value;
        block14: {
            block13: {
                if (!LLVMIRBuilder.isIntegerType(type)) break block13;
                switch (LLVMIRBuilder.integerTypeWidth(type)) {
                    case 1: {
                        value = this.builder.constantBoolean(constant.asBoolean());
                        break block14;
                    }
                    case 8: {
                        value = this.builder.constantByte((byte)constant.asInt());
                        break block14;
                    }
                    case 16: {
                        value = this.builder.constantShort((short)constant.asInt());
                        break block14;
                    }
                    case 32: {
                        value = this.builder.constantInt(constant.asInt());
                        break block14;
                    }
                    case 64: {
                        value = this.builder.constantLong(constant.asLong());
                        break block14;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere((String)("invalid integer width " + LLVMIRBuilder.integerTypeWidth(type)));
                    }
                }
            }
            if (LLVMIRBuilder.isFloatType(type)) {
                value = this.builder.constantFloat(constant.asFloat());
            } else if (LLVMIRBuilder.isDoubleType(type)) {
                value = this.builder.constantDouble(constant.asDouble());
            } else if (LLVMIRBuilder.isObject(type)) {
                value = constant.isNull() ? this.builder.constantNull(this.builder.objectType()) : this.builder.buildLoad(this.getLLVMPlaceholderForConstant((Constant)constant), this.builder.objectType());
            } else {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("unsupported constant type", type));
            }
        }
        return value;
    }

    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        throw GraalError.unimplemented();
    }

    public AllocatableValue emitLoadConstant(ValueKind<?> kind, Constant constant) {
        LLVM.LLVMValueRef value = this.builder.buildLoad(this.getLLVMPlaceholderForConstant(constant), ((LLVMUtils.LLVMKind)kind.getPlatformKind()).get());
        return new LLVMUtils.LLVMVariable(value);
    }

    public void emitNullCheck(Value address, LIRFrameState state) {
        throw GraalError.unimplemented();
    }

    public Value emitAtomicReadAndWrite(Value address, ValueKind<?> valueKind, Value newValue) {
        LLVM.LLVMValueRef atomicRMW = this.builder.buildAtomicXchg(LLVMUtils.getVal(address), LLVMUtils.getVal(newValue));
        return new LLVMUtils.LLVMVariable(atomicRMW);
    }

    public Value emitAtomicReadAndAdd(Value address, ValueKind<?> valueKind, Value delta) {
        LLVM.LLVMValueRef atomicRMW = this.builder.buildAtomicAdd(LLVMUtils.getVal(address), LLVMUtils.getVal(delta));
        return new LLVMUtils.LLVMVariable(atomicRMW);
    }

    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue) {
        LLVM.LLVMValueRef success = this.builder.buildLogicCmpxchg(LLVMUtils.getVal(address), LLVMUtils.getVal(expectedValue), LLVMUtils.getVal(newValue));
        LLVM.LLVMValueRef result = this.builder.buildSelect(success, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(result);
    }

    public Value emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue) {
        LLVM.LLVMValueRef result = this.builder.buildValueCmpxchg(LLVMUtils.getVal(address), LLVMUtils.getVal(expectedValue), LLVMUtils.getVal(newValue));
        return new LLVMUtils.LLVMVariable(result);
    }

    public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
        throw GraalError.unimplemented();
    }

    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... arguments) {
        ResolvedJavaMethod targetMethod = this.findForeignCallTarget(linkage.getDescriptor());
        state.initDebugInfo(null, false);
        long patchpointId = LLVMIRBuilder.nextPatchpointId.getAndIncrement();
        this.generationResult.recordDirectCall(targetMethod, patchpointId, state.debugInfo());
        LLVM.LLVMValueRef callee = this.getFunction(targetMethod);
        LLVM.LLVMValueRef[] args = (LLVM.LLVMValueRef[])Arrays.stream(arguments).map(LLVMUtils::getVal).toArray(LLVM.LLVMValueRef[]::new);
        LLVM.LLVMValueRef[] callArguments = this.getCallArguments(args, this.getCallingConventionType(linkage.getOutgoingCallingConvention()), targetMethod);
        LLVM.LLVMValueRef call = this.builder.buildCall(callee, patchpointId, callArguments);
        return LLVMIRBuilder.isVoidType(this.getLLVMFunctionReturnType(targetMethod, false)) ? null : new LLVMUtils.LLVMVariable(call);
    }

    protected abstract CallingConvention.Type getCallingConventionType(CallingConvention var1);

    public abstract LLVM.LLVMValueRef[] getCallArguments(LLVM.LLVMValueRef[] var1, CallingConvention.Type var2, ResolvedJavaMethod var3);

    public abstract LLVM.LLVMTypeRef[] getUnknownCallArgumentTypes(LLVM.LLVMTypeRef[] var1, CallingConvention.Type var2);

    protected abstract ResolvedJavaMethod findForeignCallTarget(ForeignCallDescriptor var1);

    public RegisterAttributes attributes(Register register) {
        throw GraalError.unimplemented();
    }

    public Variable newVariable(ValueKind<?> kind) {
        return new LLVMUtils.LLVMVariable(kind);
    }

    public Variable emitMove(Value input) {
        if (input instanceof LLVMUtils.LLVMVariable) {
            return (LLVMUtils.LLVMVariable)input;
        }
        if (input instanceof LLVMUtils.LLVMValueWrapper) {
            return new LLVMUtils.LLVMVariable(LLVMUtils.getVal(input));
        }
        throw GraalError.shouldNotReachHere((String)"Unknown move input");
    }

    public void emitMove(AllocatableValue dst, Value src) {
        LLVM.LLVMValueRef source = LLVMUtils.getVal(src);
        LLVM.LLVMTypeRef sourceType = LLVMIRBuilder.typeOf(source);
        LLVM.LLVMTypeRef destType = ((LLVMUtils.LLVMKind)dst.getPlatformKind()).get();
        if (LLVMIRBuilder.isObject(destType) && LLVMIRBuilder.isIntegerType(sourceType) && LLVMIRBuilder.integerTypeWidth(sourceType) == JavaKind.Long.getBitCount()) {
            source = this.builder.buildIntToPtr(source, this.builder.rawPointerType());
            source = this.builder.buildRegisterObject(source);
        } else if (LLVMIRBuilder.isIntegerType(destType) && LLVMIRBuilder.integerTypeWidth(destType) == JavaKind.Long.getBitCount() && LLVMIRBuilder.isObject(sourceType)) {
            source = this.builder.buildPtrToInt(source, this.builder.longType());
        }
        ((LLVMUtils.LLVMVariable)dst).set(source);
    }

    public void emitMoveConstant(AllocatableValue dst, Constant src) {
        throw GraalError.unimplemented();
    }

    public Variable emitAddress(AllocatableValue stackslot) {
        if (stackslot instanceof LLVMUtils.LLVMStackSlot) {
            return ((LLVMUtils.LLVMStackSlot)stackslot).address();
        }
        throw GraalError.shouldNotReachHere((String)"Unknown address type");
    }

    public void emitMembar(int barriers) {
        this.builder.buildFence();
    }

    public void emitUnwind(Value operand) {
        throw GraalError.unimplemented();
    }

    public void beforeRegisterAllocation() {
        throw GraalError.unimplemented();
    }

    public void emitIncomingValues(Value[] params) {
        throw GraalError.unimplemented();
    }

    public void emitReturn(JavaKind javaKind, Value input) {
        block10: {
            LLVM.LLVMValueRef retVal;
            block12: {
                block11: {
                    block9: {
                        if (javaKind != JavaKind.Void) break block9;
                        if (this.debugLevel >= 1) {
                            this.emitPrintf("Return");
                            this.deindent();
                        }
                        this.builder.buildRetVoid();
                        break block10;
                    }
                    if (this.debugLevel >= 1) {
                        this.emitPrintf("Return", new JavaKind[]{javaKind}, new LLVM.LLVMValueRef[]{LLVMUtils.getVal(input)});
                        this.deindent();
                    }
                    retVal = LLVMUtils.getVal(input);
                    if (javaKind != JavaKind.Int) break block11;
                    assert (LLVMIRBuilder.isIntegerType(LLVMIRBuilder.typeOf(retVal)));
                    switch (LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(retVal))) {
                        case 1: {
                            retVal = this.builder.buildZExt(retVal, JavaKind.Int.getBitCount());
                            break block12;
                        }
                        case 8: 
                        case 16: {
                            retVal = this.builder.buildSExt(retVal, JavaKind.Int.getBitCount());
                            break block12;
                        }
                        case 32: {
                            break block12;
                        }
                        default: {
                            throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpValues("invalid return type for stack int", retVal));
                        }
                    }
                }
                if (this.returnsEnum && javaKind == JavaKind.Long) {
                    retVal = this.convertEnumReturnValue(retVal);
                }
            }
            this.builder.buildRet(retVal);
        }
    }

    protected LLVM.LLVMValueRef convertEnumReturnValue(LLVM.LLVMValueRef longValue) {
        LLVM.LLVMValueRef retVal = this.builder.buildIntToPtr(longValue, this.builder.rawPointerType());
        retVal = this.builder.buildRegisterObject(retVal);
        return retVal;
    }

    void indent() {
        LLVM.LLVMValueRef counter = this.builder.buildLoad(this.indentCounter);
        LLVM.LLVMValueRef newCounter = this.builder.buildAdd(counter, this.builder.constantInt(1));
        this.builder.buildStore(newCounter, this.indentCounter);
    }

    private void deindent() {
        LLVM.LLVMValueRef counter = this.builder.buildLoad(this.indentCounter);
        LLVM.LLVMValueRef newCounter = this.builder.buildSub(counter, this.builder.constantInt(1));
        this.builder.buildStore(newCounter, this.indentCounter);
    }

    public AllocatableValue asAllocatable(Value value) {
        return (AllocatableValue)value;
    }

    public Variable load(Value value) {
        LLVM.LLVMValueRef load = this.builder.buildPtrToInt(LLVMUtils.getVal(value), this.builder.longType());
        return new LLVMUtils.LLVMVariable(load);
    }

    public Value loadNonConst(Value value) {
        throw GraalError.unimplemented();
    }

    public boolean needOnlyOopMaps() {
        return false;
    }

    public AllocatableValue resultOperandFor(JavaKind javaKind, ValueKind<?> valueKind) {
        return new LLVMUtils.LLVMVariable(this.builder.getLLVMType(javaKind));
    }

    public <I extends LIRInstruction> I append(I op) {
        throw GraalError.unimplemented();
    }

    public void setSourcePosition(NodeSourcePosition position) {
        throw GraalError.unimplemented();
    }

    public void emitJump(LabelRef label) {
        this.builder.buildBranch(this.getBlock((Block)label.getTargetBlock()));
    }

    public void emitCompareBranch(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        throw GraalError.unimplemented();
    }

    public void emitOverflowCheckBranch(LabelRef overflow, LabelRef noOverflow, LIRKind cmpKind, double overflowProbability) {
        throw GraalError.unimplemented();
    }

    public void emitIntegerTestBranch(Value left, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueSuccessorProbability) {
        throw GraalError.unimplemented();
    }

    public Variable emitConditionalMove(PlatformKind cmpKind, Value leftVal, Value rightVal, Condition cond, boolean unorderedIsTrue, Value trueVal, Value falseVal) {
        LLVM.LLVMValueRef condition = this.builder.buildCompare(cond, LLVMUtils.getVal(leftVal), LLVMUtils.getVal(rightVal), unorderedIsTrue);
        LLVM.LLVMValueRef trueValue = LLVMUtils.getVal(trueVal);
        LLVM.LLVMValueRef falseValue = LLVMUtils.getVal(falseVal);
        LLVM.LLVMValueRef select = LLVMIRBuilder.isObject(LLVMIRBuilder.typeOf(trueValue)) ? this.buildSelect(condition, trueValue, falseValue) : this.builder.buildSelect(condition, trueValue, falseValue);
        return new LLVMUtils.LLVMVariable(select);
    }

    Variable emitIsNullMove(Value value, Value trueValue, Value falseValue) {
        LLVM.LLVMValueRef isNull = this.builder.buildIsNull(LLVMUtils.getVal(value));
        LLVM.LLVMValueRef select = this.builder.buildSelect(isNull, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(select);
    }

    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        LLVM.LLVMValueRef and = this.builder.buildAnd(LLVMUtils.getVal(left), LLVMUtils.getVal(right));
        LLVM.LLVMValueRef isNull = this.builder.buildIsNull(and);
        LLVM.LLVMValueRef select = this.builder.buildSelect(isNull, LLVMUtils.getVal(trueValue), LLVMUtils.getVal(falseValue));
        return new LLVMUtils.LLVMVariable(select);
    }

    private LLVM.LLVMValueRef buildSelect(LLVM.LLVMValueRef condition, LLVM.LLVMValueRef trueVal, LLVM.LLVMValueRef falseVal) {
        LLVM.LLVMBasicBlockRef trueBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_true");
        LLVM.LLVMBasicBlockRef falseBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_false");
        LLVM.LLVMBasicBlockRef mergeBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "_select_end");
        this.splitBlockEndMap.put(this.currentBlock, mergeBlock);
        assert (LLVMIRBuilder.compatibleTypes(LLVMIRBuilder.typeOf(trueVal), LLVMIRBuilder.typeOf(falseVal)));
        this.builder.buildIf(condition, trueBlock, falseBlock);
        this.builder.positionAtEnd(trueBlock);
        this.builder.buildBranch(mergeBlock);
        this.builder.positionAtEnd(falseBlock);
        this.builder.buildBranch(mergeBlock);
        this.builder.positionAtEnd(mergeBlock);
        LLVM.LLVMValueRef[] incomingValues = new LLVM.LLVMValueRef[]{trueVal, falseVal};
        LLVM.LLVMBasicBlockRef[] incomingBlocks = new LLVM.LLVMBasicBlockRef[]{trueBlock, falseBlock};
        return this.builder.buildPhi(LLVMIRBuilder.typeOf(trueVal), incomingValues, incomingBlocks);
    }

    public void emitStrategySwitch(JavaConstant[] keyConstants, double[] keyProbabilities, LabelRef[] keyTargets, LabelRef defaultTarget, Variable value) {
        throw GraalError.unimplemented();
    }

    public void emitStrategySwitch(SwitchStrategy strategy, Variable key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        throw GraalError.unimplemented();
    }

    public Variable emitByteSwap(Value operand) {
        LLVM.LLVMValueRef byteSwap = this.builder.buildBswap(LLVMUtils.getVal(operand));
        return new LLVMUtils.LLVMVariable(byteSwap);
    }

    public Variable emitArrayEquals(JavaKind kind, Value array1, Value array2, Value length, boolean directPointers) {
        int constantLength;
        LLVM.LLVMValueRef inArray2;
        LLVM.LLVMValueRef inArray1;
        LLVM.LLVMTypeRef elemType = this.builder.getLLVMType(kind);
        if (directPointers) {
            inArray1 = this.builder.buildIntToPtr(LLVMUtils.getVal(array1), this.builder.pointerType(elemType, false));
            inArray2 = this.builder.buildIntToPtr(LLVMUtils.getVal(array2), this.builder.pointerType(elemType, false));
        } else {
            int arrayBaseOffset = this.getProviders().getMetaAccess().getArrayBaseOffset(kind);
            inArray1 = this.builder.buildAddrSpaceCast(LLVMUtils.getVal(array1), this.builder.rawPointerType());
            inArray1 = this.builder.buildGEP(inArray1, this.builder.constantInt(arrayBaseOffset));
            inArray1 = this.builder.buildBitcast(inArray1, this.builder.pointerType(elemType, false));
            inArray2 = this.builder.buildAddrSpaceCast(LLVMUtils.getVal(array2), this.builder.rawPointerType());
            inArray2 = this.builder.buildGEP(inArray2, this.builder.constantInt(arrayBaseOffset));
            inArray2 = this.builder.buildBitcast(inArray2, this.builder.pointerType(elemType, false));
        }
        int n = constantLength = LIRValueUtil.isJavaConstant((Value)length) ? LIRValueUtil.asJavaConstant((Value)length).asInt() : -1;
        if (constantLength == 0) {
            return new LLVMUtils.LLVMVariable(this.builder.constantBoolean(true));
        }
        LLVM.LLVMValueRef count = constantLength > 0 ? this.builder.constantInt(constantLength) : LLVMUtils.getVal(length);
        LLVM.LLVMBasicBlockRef startBlock = this.getBlockEnd(this.currentBlock);
        LLVM.LLVMBasicBlockRef loopBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "array_equals_loop");
        LLVM.LLVMBasicBlockRef endBlock = this.builder.appendBasicBlock(this.currentBlock.toString() + "array_equals_end");
        this.splitBlockEndMap.put(this.currentBlock, endBlock);
        LLVM.LLVMValueRef zeroLength = this.builder.buildIsNull(count);
        this.builder.buildIf(zeroLength, endBlock, loopBlock);
        this.builder.positionAtEnd(loopBlock);
        LLVM.LLVMBasicBlockRef[] incomingBlocks = new LLVM.LLVMBasicBlockRef[]{startBlock};
        LLVM.LLVMValueRef[] incomingEqualsValues = new LLVM.LLVMValueRef[]{this.builder.constantBoolean(true)};
        LLVM.LLVMValueRef equals = this.builder.buildPhi(this.builder.booleanType(), incomingEqualsValues, incomingBlocks);
        LLVM.LLVMValueRef[] incomingIValues = new LLVM.LLVMValueRef[]{this.builder.constantInt(0)};
        LLVM.LLVMValueRef i = this.builder.buildPhi(this.builder.intType(), incomingIValues, incomingBlocks);
        LLVM.LLVMValueRef elem1 = this.builder.buildLoad(this.builder.buildGEP(inArray1, i));
        LLVM.LLVMValueRef elem2 = this.builder.buildLoad(this.builder.buildGEP(inArray2, i));
        LLVM.LLVMValueRef compare = this.builder.buildCompare(Condition.EQ, elem1, elem2, false);
        LLVM.LLVMValueRef newEquals = this.builder.buildAnd(compare, equals);
        LLVM.LLVMValueRef newI = this.builder.buildAdd(i, this.builder.constantInt(1));
        LLVM.LLVMBasicBlockRef[] newIncomingBlocks = new LLVM.LLVMBasicBlockRef[]{loopBlock};
        LLVM.LLVMValueRef[] newIncomingEqualsValues = new LLVM.LLVMValueRef[]{newEquals};
        this.builder.addIncoming(equals, newIncomingEqualsValues, newIncomingBlocks);
        LLVM.LLVMValueRef[] newIncomingIValues = new LLVM.LLVMValueRef[]{newI};
        this.builder.addIncoming(i, newIncomingIValues, newIncomingBlocks);
        LLVM.LLVMValueRef atEnd = this.builder.buildCompare(Condition.EQ, newI, count, false);
        LLVM.LLVMValueRef exitLoop = this.builder.buildOr(atEnd, this.builder.buildNot(newEquals));
        this.builder.buildIf(exitLoop, endBlock, loopBlock);
        this.builder.positionAtEnd(endBlock);
        LLVM.LLVMBasicBlockRef[] incomingArrayEqualsBlocks = new LLVM.LLVMBasicBlockRef[]{startBlock, loopBlock};
        LLVM.LLVMValueRef[] incomingArrayEqualsValues = new LLVM.LLVMValueRef[]{this.builder.constantBoolean(true), newEquals};
        LLVM.LLVMValueRef arrayEquals = this.builder.buildPhi(this.builder.booleanType(), incomingArrayEqualsValues, incomingArrayEqualsBlocks);
        return new LLVMUtils.LLVMVariable(this.builder.buildSelect(arrayEquals, this.builder.constantInt(1), this.builder.constantInt(0)));
    }

    public void emitBlackhole(Value operand) {
        this.builder.buildStackmap(this.builder.constantLong(2882400000L), LLVMUtils.getVal(operand));
    }

    public LIRKind getLIRKind(Stamp stamp) {
        return stamp.getLIRKind(this.lirKindTool);
    }

    public void emitPause() {
    }

    public void emitPrefetchAllocate(Value address) {
        this.builder.buildPrefetch(LLVMUtils.getVal(address));
    }

    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        throw GraalError.unimplemented();
    }

    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        throw GraalError.unimplemented();
    }

    public void emitSpeculationFence() {
        throw GraalError.unimplemented();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return this.getLIRKind(StampFactory.forKind((JavaKind)javaKind));
    }

    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        throw GraalError.unimplemented();
    }

    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        throw GraalError.unimplemented();
    }

    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        throw GraalError.unimplemented();
    }

    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters) {
        throw GraalError.unimplemented();
    }

    public StandardOp.ZapRegistersOp createZapRegisters() {
        throw GraalError.unimplemented();
    }

    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        throw GraalError.unimplemented();
    }

    public LIRInstruction zapArgumentSpace() {
        throw GraalError.unimplemented();
    }

    public VirtualStackSlot allocateStackSlots(int slots) {
        this.builder.positionAtStart();
        LLVM.LLVMValueRef alloca = this.builder.buildPtrToInt(this.builder.buildArrayAlloca(slots), this.builder.longType());
        this.builder.positionAtEnd(this.getBlockEnd(this.currentBlock));
        return new LLVMUtils.LLVMStackSlot(alloca);
    }

    public Value emitReadCallerStackPointer(Stamp wordStamp) {
        LLVM.LLVMValueRef basePointer = this.builder.buildFrameAddress(this.builder.constantInt(0));
        LLVM.LLVMValueRef callerSP = this.builder.buildAdd(this.builder.buildPtrToInt(basePointer, this.builder.longType()), this.builder.constantLong(16L));
        return new LLVMUtils.LLVMVariable(callerSP);
    }

    public Value emitReadReturnAddress(Stamp wordStamp, int returnAddressSize) {
        LLVM.LLVMValueRef returnAddress = this.builder.buildReturnAddress(this.builder.constantInt(0));
        return new LLVMUtils.LLVMVariable(this.builder.buildPtrToInt(returnAddress, this.builder.longType()));
    }

    public abstract LLVM.LLVMValueRef getRetrieveExceptionFunction();

    public LLVMGenerationResult getLLVMResult() {
        return this.generationResult;
    }

    int getDebugLevel() {
        return this.debugLevel;
    }

    public static class ArithmeticLLVMGenerator
    implements ArithmeticLIRGeneratorTool {
        private final LLVMIRBuilder builder;

        ArithmeticLLVMGenerator(LLVMIRBuilder builder) {
            this.builder = builder;
        }

        public Value emitNegate(Value input) {
            LLVM.LLVMValueRef neg = this.builder.buildNeg(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(neg);
        }

        public Value emitAdd(Value a, Value b, boolean setFlags) {
            LLVM.LLVMValueRef add = this.builder.buildAdd(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(add);
        }

        public Value emitSub(Value a, Value b, boolean setFlags) {
            LLVM.LLVMValueRef sub = this.builder.buildSub(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(sub);
        }

        public Value emitMul(Value a, Value b, boolean setFlags) {
            LLVM.LLVMValueRef mul = this.builder.buildMul(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(mul);
        }

        public Value emitMulHigh(Value a, Value b) {
            return this.emitMulHigh(a, b, true);
        }

        public Value emitUMulHigh(Value a, Value b) {
            return this.emitMulHigh(a, b, false);
        }

        private LLVMUtils.LLVMVariable emitMulHigh(Value a, Value b, boolean signed) {
            LLVM.LLVMValueRef valA = LLVMUtils.getVal(a);
            LLVM.LLVMValueRef valB = LLVMUtils.getVal(b);
            assert (LLVMIRBuilder.compatibleTypes(LLVMIRBuilder.typeOf(valA), LLVMIRBuilder.typeOf(valB))) : LLVMUtils.dumpValues("invalid mulhigh arguments", valA, valB);
            int baseBits = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(valA));
            int extendedBits = baseBits * 2;
            BiFunction<LLVM.LLVMValueRef, Integer, LLVM.LLVMValueRef> extend = signed ? this.builder::buildSExt : this.builder::buildZExt;
            valA = extend.apply(valA, extendedBits);
            valB = extend.apply(valB, extendedBits);
            LLVM.LLVMValueRef mul = this.builder.buildMul(valA, valB);
            BiFunction<LLVM.LLVMValueRef, LLVM.LLVMValueRef, LLVM.LLVMValueRef> shift = signed ? this.builder::buildShr : this.builder::buildUShr;
            LLVM.LLVMValueRef shiftedMul = shift.apply(mul, this.builder.constantInteger(baseBits, baseBits));
            LLVM.LLVMValueRef truncatedMul = this.builder.buildTrunc(shiftedMul, baseBits);
            return new LLVMUtils.LLVMVariable(truncatedMul);
        }

        public Value emitDiv(Value a, Value b, LIRFrameState state) {
            LLVM.LLVMValueRef div = this.builder.buildDiv(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(div);
        }

        public Value emitRem(Value a, Value b, LIRFrameState state) {
            LLVM.LLVMValueRef rem = this.builder.buildRem(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(rem);
        }

        public Value emitUDiv(Value a, Value b, LIRFrameState state) {
            LLVM.LLVMValueRef uDiv = this.builder.buildUDiv(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(uDiv);
        }

        public Value emitURem(Value a, Value b, LIRFrameState state) {
            LLVM.LLVMValueRef uRem = this.builder.buildURem(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(uRem);
        }

        public Value emitNot(Value input) {
            LLVM.LLVMValueRef not = this.builder.buildNot(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(not);
        }

        public Value emitAnd(Value a, Value b) {
            LLVM.LLVMValueRef and = this.builder.buildAnd(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(and);
        }

        public Value emitOr(Value a, Value b) {
            LLVM.LLVMValueRef or = this.builder.buildOr(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(or);
        }

        public Value emitXor(Value a, Value b) {
            LLVM.LLVMValueRef xor = this.builder.buildXor(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(xor);
        }

        public Value emitShl(Value a, Value b) {
            LLVM.LLVMValueRef shl = this.builder.buildShl(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(shl);
        }

        public Value emitShr(Value a, Value b) {
            LLVM.LLVMValueRef shr = this.builder.buildShr(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(shr);
        }

        public Value emitUShr(Value a, Value b) {
            LLVM.LLVMValueRef ushr = this.builder.buildUShr(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(ushr);
        }

        public Value emitFloatConvert(FloatConvert op, Value inputVal) {
            LLVM.LLVMValueRef convert;
            LLVM.LLVMTypeRef destType;
            switch (op) {
                case F2I: 
                case D2I: {
                    destType = this.builder.intType();
                    break;
                }
                case F2L: 
                case D2L: {
                    destType = this.builder.longType();
                    break;
                }
                case I2F: 
                case L2F: 
                case D2F: {
                    destType = this.builder.floatType();
                    break;
                }
                case I2D: 
                case L2D: 
                case F2D: {
                    destType = this.builder.doubleType();
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere((String)"invalid FloatConvert type");
                }
            }
            switch (op.getCategory()) {
                case FloatingPointToInteger: {
                    convert = this.builder.buildFPToSI(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                case IntegerToFloatingPoint: {
                    convert = this.builder.buildSIToFP(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                case FloatingPointToFloatingPoint: {
                    convert = this.builder.buildFPCast(LLVMUtils.getVal(inputVal), destType);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere((String)"invalid FloatConvert type");
                }
            }
            return new LLVMUtils.LLVMVariable(convert);
        }

        public Value emitReinterpret(LIRKind to, Value inputVal) {
            LLVM.LLVMTypeRef type = LLVMUtils.getType(to);
            LLVM.LLVMValueRef cast = this.builder.buildBitcast(LLVMUtils.getVal(inputVal), type);
            return new LLVMUtils.LLVMVariable(cast);
        }

        public Value emitNarrow(Value inputVal, int bits) {
            LLVM.LLVMValueRef narrow = this.builder.buildTrunc(LLVMUtils.getVal(inputVal), bits);
            return new LLVMUtils.LLVMVariable(narrow);
        }

        public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
            LLVM.LLVMValueRef signExtend = this.builder.buildSExt(LLVMUtils.getVal(inputVal), toBits);
            return new LLVMUtils.LLVMVariable(signExtend);
        }

        public Value emitZeroExtend(Value inputVal, int fromBits, int toBits) {
            LLVM.LLVMValueRef zeroExtend = this.builder.buildZExt(LLVMUtils.getVal(inputVal), toBits);
            return new LLVMUtils.LLVMVariable(zeroExtend);
        }

        public Value emitMathAbs(Value input) {
            LLVM.LLVMValueRef abs = this.builder.buildAbs(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(abs);
        }

        public Value emitMathSqrt(Value input) {
            LLVM.LLVMValueRef sqrt = this.builder.buildSqrt(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(sqrt);
        }

        public Value emitMathLog(Value input, boolean base10) {
            LLVM.LLVMValueRef value = LLVMUtils.getVal(input);
            LLVM.LLVMValueRef log = base10 ? this.builder.buildLog10(value) : this.builder.buildLog(value);
            return new LLVMUtils.LLVMVariable(log);
        }

        public Value emitMathCos(Value input) {
            LLVM.LLVMValueRef cos = this.builder.buildCos(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(cos);
        }

        public Value emitMathSin(Value input) {
            LLVM.LLVMValueRef sin = this.builder.buildSin(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(sin);
        }

        public Value emitMathTan(Value input) {
            LLVM.LLVMValueRef value = LLVMUtils.getVal(input);
            LLVM.LLVMValueRef sin = this.builder.buildSin(value);
            LLVM.LLVMValueRef cos = this.builder.buildCos(value);
            LLVM.LLVMValueRef tan = this.builder.buildDiv(sin, cos);
            return new LLVMUtils.LLVMVariable(tan);
        }

        public Value emitMathExp(Value input) {
            LLVM.LLVMValueRef exp = this.builder.buildExp(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(exp);
        }

        public Value emitMathPow(Value x, Value y) {
            LLVM.LLVMValueRef pow = this.builder.buildPow(LLVMUtils.getVal(x), LLVMUtils.getVal(y));
            return new LLVMUtils.LLVMVariable(pow);
        }

        public Value emitMathCeil(Value input) {
            LLVM.LLVMValueRef ceil = this.builder.buildCeil(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(ceil);
        }

        public Value emitMathFloor(Value input) {
            LLVM.LLVMValueRef floor = this.builder.buildFloor(LLVMUtils.getVal(input));
            return new LLVMUtils.LLVMVariable(floor);
        }

        public Value emitCountLeadingZeros(Value input) {
            LLVM.LLVMValueRef ctlz = this.builder.buildCtlz(LLVMUtils.getVal(input));
            ctlz = this.builder.buildIntegerConvert(ctlz, 32);
            return new LLVMUtils.LLVMVariable(ctlz);
        }

        public Value emitCountTrailingZeros(Value input) {
            LLVM.LLVMValueRef cttz = this.builder.buildCttz(LLVMUtils.getVal(input));
            cttz = this.builder.buildIntegerConvert(cttz, 32);
            return new LLVMUtils.LLVMVariable(cttz);
        }

        public Value emitBitCount(Value operand) {
            LLVM.LLVMValueRef op = LLVMUtils.getVal(operand);
            LLVM.LLVMValueRef answer = this.builder.buildCtpop(op);
            answer = this.builder.buildIntegerConvert(answer, LLVMIRBuilder.integerTypeWidth(this.builder.intType()));
            return new LLVMUtils.LLVMVariable(answer);
        }

        public Value emitBitScanForward(Value operand) {
            int expectedSize;
            LLVM.LLVMValueRef op = LLVMUtils.getVal(operand);
            LLVM.LLVMValueRef trailingZeros = this.builder.buildCttz(op);
            int resultSize = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(trailingZeros));
            if (resultSize < (expectedSize = JavaKind.Int.getBitCount())) {
                trailingZeros = this.builder.buildZExt(trailingZeros, expectedSize);
            } else if (resultSize > expectedSize) {
                trailingZeros = this.builder.buildTrunc(trailingZeros, expectedSize);
            }
            return new LLVMUtils.LLVMVariable(trailingZeros);
        }

        public Value emitBitScanReverse(Value operand) {
            LLVM.LLVMValueRef op = LLVMUtils.getVal(operand);
            int opSize = LLVMIRBuilder.integerTypeWidth(LLVMIRBuilder.typeOf(op));
            int expectedSize = JavaKind.Int.getBitCount();
            LLVM.LLVMValueRef leadingZeros = this.builder.buildCtlz(op);
            if (opSize < expectedSize) {
                leadingZeros = this.builder.buildZExt(leadingZeros, expectedSize);
            } else if (opSize > expectedSize) {
                leadingZeros = this.builder.buildTrunc(leadingZeros, expectedSize);
            }
            LLVM.LLVMValueRef result = this.builder.buildSub(this.builder.constantInt(opSize - 1), leadingZeros);
            return new LLVMUtils.LLVMVariable(result);
        }

        public Value emitFusedMultiplyAdd(Value a, Value b, Value c) {
            LLVM.LLVMValueRef fma = this.builder.buildFma(LLVMUtils.getVal(a), LLVMUtils.getVal(b), LLVMUtils.getVal(c));
            return new LLVMUtils.LLVMVariable(fma);
        }

        public Value emitMathMin(Value a, Value b) {
            LLVM.LLVMValueRef min = this.builder.buildMin(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(min);
        }

        public Value emitMathMax(Value a, Value b) {
            LLVM.LLVMValueRef max = this.builder.buildMax(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(max);
        }

        public Value emitMathCopySign(Value a, Value b) {
            LLVM.LLVMValueRef copySign = this.builder.buildCopysign(LLVMUtils.getVal(a), LLVMUtils.getVal(b));
            return new LLVMUtils.LLVMVariable(copySign);
        }

        public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state) {
            LLVM.LLVMValueRef load = this.builder.buildLoad(LLVMUtils.getVal(address), LLVMUtils.getType(kind));
            return new LLVMUtils.LLVMVariable(load);
        }

        public void emitStore(ValueKind<?> kind, Value address, Value input, LIRFrameState state) {
            this.builder.buildStore(LLVMUtils.getVal(input), LLVMUtils.getVal(address));
        }
    }
}

