/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.llvm;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.llvm.LLVMBinaryIntrinsicNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1, nameTemplate="LLVMIntrinsic#{p#op}")
public class LLVMCopySignNode
extends LLVMBinaryIntrinsicNode {
    public static final NodeClass<LLVMCopySignNode> TYPE = NodeClass.create(LLVMCopySignNode.class);

    public LLVMCopySignNode(JavaKind kind, ValueNode arg1, ValueNode arg2) {
        super(TYPE, LLVMUtils.LLVMIntrinsicOperation.COPYSIGN, kind, arg1, arg2);
    }

    @Override
    protected Value emitIntrinsic(LLVMGenerator.ArithmeticLLVMGenerator gen, Value arg1, Value arg2) {
        return gen.emitMathCopySign(arg1, arg2);
    }

    public static ConstantNode fold(JavaConstant constant1, JavaConstant constant2) {
        assert (constant1.getJavaKind() == constant2.getJavaKind());
        if (constant1.getJavaKind() == JavaKind.Float) {
            return ConstantNode.forFloat((float)Math.copySign(constant1.asFloat(), constant2.asFloat()));
        }
        return ConstantNode.forDouble((double)Math.copySign(constant1.asDouble(), constant2.asDouble()));
    }
}

