/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sa;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.sa.Arguments;
import org.graalvm.visualvm.sa.SAObject;
import org.graalvm.visualvm.sa.SAWrapper;
import org.graalvm.visualvm.sa.VM;

class Agent {
    private static Map<File, Agent> agentMap = new HashMap<File, Agent>();
    private SAWrapper saClassLoader;
    private final SAObject hotspotAgent;
    private VM vm;
    private Arguments args;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Agent getAgent(File jdkHome, File saJarFile) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        Map<File, Agent> map = agentMap;
        synchronized (map) {
            Agent agent = agentMap.get(saJarFile);
            if (agent == null) {
                agent = new Agent(jdkHome, saJarFile);
                agentMap.put(saJarFile, agent);
            }
            return agent;
        }
    }

    private Agent(File jdkHome, File saJarFile) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        this.saClassLoader = new SAWrapper(jdkHome, saJarFile);
        this.hotspotAgent = new SAObject(this.saClassLoader.HotSpotAgent().newInstance());
    }

    boolean attach(int pid) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.hotspotAgent.invoke("attach", pid);
        return true;
    }

    boolean attach(String executable, String coredump) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.hotspotAgent.invoke("attach", executable, coredump);
        return true;
    }

    boolean attach(String remoteServer) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.hotspotAgent.invoke("attach", remoteServer);
        return true;
    }

    void detach() throws IllegalAccessException, InvocationTargetException {
        this.hotspotAgent.invoke("detach", new Object[0]);
    }

    VM getVM() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.vm == null) {
            Class vmClass = this.saClassLoader.VM();
            Object saVM = vmClass.getMethod("getVM", new Class[0]).invoke(null, new Object[0]);
            this.vm = new VM(saVM);
        }
        return this.vm;
    }

    Arguments getArguments() throws ClassNotFoundException {
        if (this.args == null) {
            this.args = new Arguments(this.saClassLoader.Arguments());
        }
        return this.args;
    }

    SAObject getHeapHprofBinWriter() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new SAObject(this.saClassLoader.HeapHprofBinWriter().newInstance());
    }
}

