/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sa;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Logger;

class SAWrapper {
    private static final Logger LOGGER = Logger.getLogger(SAWrapper.class.getName());
    URLClassLoader loader;
    File libraryPath;

    SAWrapper(File jdkHome, File saJarFile) throws MalformedURLException {
        System.setProperty("sun.jvm.hotspot.debugger.useProcDebugger", "true");
        System.setProperty("sun.jvm.hotspot.debugger.useWindbgDebugger", "true");
        URL[] saJarUrls = new URL[]{saJarFile.toURI().toURL()};
        String osArch = System.getProperty("os.arch");
        if ("x86".equals(osArch)) {
            osArch = "i386";
        }
        this.libraryPath = new File(jdkHome, "jre/lib/" + osArch);
        LOGGER.fine("Path " + this.libraryPath.getAbsolutePath());
        this.loader = new URLClassLoader(saJarUrls){

            @Override
            protected String findLibrary(String libname) {
                String name = System.mapLibraryName(libname);
                File library = new File(SAWrapper.this.libraryPath, name);
                LOGGER.fine("Library " + library.getAbsolutePath());
                if (library.exists() && library.canRead()) {
                    return library.getAbsolutePath();
                }
                return super.findLibrary(libname);
            }
        };
    }

    Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.loader);
    }

    Class Tool() throws ClassNotFoundException {
        return this.classForName("sun.jvm.hotspot.tools.Tool");
    }

    Class VM() throws ClassNotFoundException {
        return this.classForName("sun.jvm.hotspot.runtime.VM");
    }

    Class HotSpotAgent() throws ClassNotFoundException {
        return this.classForName("sun.jvm.hotspot.HotSpotAgent");
    }

    Class HeapHprofBinWriter() throws ClassNotFoundException {
        return this.classForName("sun.jvm.hotspot.utilities.HeapHprofBinWriter");
    }

    Class Arguments() throws ClassNotFoundException {
        return this.classForName("sun.jvm.hotspot.runtime.Arguments");
    }
}

