/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.ErrorNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeWrapper;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsWrapper;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.ExcludingIterator;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.heapviewer.utils.InterruptibleIterator;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;

abstract class TruffleObjectMergedReferences<O extends TruffleObject> {
    private final Heap heap;
    private final TruffleObjectsWrapper<O> objects;

    TruffleObjectMergedReferences(TruffleObjectsWrapper<O> objects, Heap heap) {
        this.objects = objects;
        this.heap = heap;
    }

    protected abstract String getMoreNodesString(String var1);

    protected abstract String getSamplesContainerString(String var1);

    protected abstract String getNodesContainerString(String var1, String var2);

    protected abstract TruffleLanguage getLanguage();

    protected abstract boolean filtersReferences();

    protected abstract boolean includeReference(FieldValue var1);

    protected abstract Collection<FieldValue> getReferences(O var1) throws InterruptedException;

    protected abstract HeapViewerNode createForeignReferenceNode(Instance var1, FieldValue var2);

    private int objectsCount() {
        return this.objects.getObjectsCount();
    }

    private Iterator<O> objectsIterator() {
        return new InterruptibleIterator(this.objects.getObjectsIterator());
    }

    private HeapViewerNode createObjectNode(O object) {
        return (HeapViewerNode)this.getLanguage().createObjectNode(object, ((TruffleObject)object).getType(this.heap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HeapViewerNode[] getNodes(HeapViewerNode parent, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        boolean filtersReferences = this.filtersReferences();
        final HashMap<Long, Integer> values = new HashMap<Long, Integer>();
        FieldValue refFV = null;
        Iterator<O> objectsI = this.objectsIterator();
        try {
            progress.setupKnownSteps((long)this.objectsCount());
            while (objectsI.hasNext()) {
                TruffleObject object = (TruffleObject)objectsI.next();
                progress.step();
                Collection<FieldValue> references = this.getReferences(object);
                HashSet<Instance> referers = new HashSet<Instance>();
                if (references.isEmpty()) {
                    referers.add(null);
                } else {
                    for (FieldValue reference : references) {
                        if (refFV == null) {
                            refFV = reference;
                        }
                        if (filtersReferences && !this.includeReference(reference)) continue;
                        referers.add(reference.getDefiningInstance());
                    }
                }
                for (Instance referer : referers) {
                    long refererID = referer == null ? -1L : referer.getInstanceId();
                    Integer count = (Integer)values.get(refererID);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    values.put(refererID, count);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory in TruffleObjectMergedReferences: " + e.getMessage());
            HeapUtils.handleOOME((boolean)true, (OutOfMemoryError)e);
            HeapViewerNode[] references = new HeapViewerNode[]{new ErrorNode.OOME()};
            return references;
        }
        finally {
            progress.finish();
        }
        final TruffleLanguage language = this.getLanguage();
        final FieldValue refFVF = refFV;
        NodesComputer<Map.Entry<Long, Integer>> computer = new NodesComputer<Map.Entry<Long, Integer>>(values.size(), UIThresholds.MAX_CLASS_INSTANCES){

            protected boolean sorts(DataType dataType) {
                return true;
            }

            protected HeapViewerNode createNode(final Map.Entry<Long, Integer> node) {
                InstanceNode.IncludingNull ref;
                Instance instance;
                long refererID = node.getKey();
                Instance instance2 = instance = refererID == -1L ? null : TruffleObjectMergedReferences.this.heap.getInstanceByID(refererID);
                if (instance == null) {
                    ref = new InstanceNode.IncludingNull(null);
                } else if (language.isLanguageObject(instance)) {
                    ref = TruffleObjectMergedReferences.this.createObjectNode(language.createObject(instance));
                } else {
                    ref = TruffleObjectMergedReferences.this.createForeignReferenceNode(instance, refFVF);
                    if (ref instanceof TruffleObjectReferenceNode.InstanceBased) {
                        Instance i = ((TruffleObjectReferenceNode.InstanceBased)ref).getInstance();
                        ref = TruffleObjectMergedReferences.this.createObjectNode(language.createObject(i));
                    } else {
                        ref = new InstanceNode(instance);
                    }
                }
                return new MergedObjectReferenceNode((HeapViewerNode)ref){

                    @Override
                    public Instance getInstance() {
                        return instance;
                    }

                    @Override
                    public int getCount() {
                        return (Integer)node.getValue();
                    }
                };
            }

            protected ProgressIterator<Map.Entry<Long, Integer>> objectsIterator(int index, Progress progress) {
                Iterator iterator = values.entrySet().iterator();
                return new ProgressIterator(iterator, index, true, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return TruffleObjectMergedReferences.this.getMoreNodesString(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return TruffleObjectMergedReferences.this.getSamplesContainerString(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return TruffleObjectMergedReferences.this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, this.heap, viewID, null, dataTypes, sortOrders, progress);
    }

    public static class MergedReferencesNodeRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            renderers.put(MergedObjectReferenceNode.class, new MergedObjectReferenceNodeRenderer());
        }
    }

    private static class MergedObjectReferenceNodeRenderer
    extends NormalBoldGrayRenderer
    implements HeapViewerRenderer {
        private HeapViewerRenderer renderer;

        private MergedObjectReferenceNodeRenderer() {
        }

        public void setValue(Object value, int row) {
            MergedObjectReferenceNode vnode = (MergedObjectReferenceNode)((Object)value);
            HeapViewerNode node = vnode.getNode();
            this.renderer = RootNode.get((HeapViewerNode)vnode).resolveRenderer(node);
            this.renderer.setValue((Object)node, row);
            if (node instanceof InstanceNode.IncludingNull) {
                this.setNormalValue(Bundle.TruffleObjectMergedReferences_NoReferences());
                this.setBoldValue("");
                this.setGrayValue("");
            } else if (this.renderer instanceof NormalBoldGrayRenderer) {
                NormalBoldGrayRenderer r = (NormalBoldGrayRenderer)this.renderer;
                this.setNormalValue(r.getNormalValue());
                this.setBoldValue(r.getBoldValue());
                this.setGrayValue(r.getGrayValue());
            } else {
                HeapViewerRenderer r = this.renderer;
                this.setNormalValue(r.getShortName());
                this.setBoldValue("");
                this.setGrayValue("");
            }
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.NodeForward"));
        }

        public int getHorizontalAlignment() {
            return this.renderer.getHorizontalAlignment();
        }
    }

    private abstract class MergedObjectReferenceNode
    extends HeapViewerNodeWrapper {
        MergedObjectReferenceNode(HeapViewerNode reference) {
            super(reference);
        }

        public abstract Instance getInstance();

        public abstract int getCount();

        protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, final Progress progress) throws InterruptedException {
            NodesComputer computer = new NodesComputer<O>(this.getCount(), UIThresholds.MAX_MERGED_OBJECTS){

                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                protected HeapViewerNode createNode(O object) {
                    return TruffleObjectMergedReferences.this.createObjectNode(object);
                }

                protected ProgressIterator<O> objectsIterator(int index, Progress _progress) {
                    final Instance referer = MergedObjectReferenceNode.this.getInstance();
                    progress.setupUnknownSteps();
                    ExcludingIterator referencesIt = new ExcludingIterator<O>((Iterator)new InterruptibleIterator(TruffleObjectMergedReferences.this.objectsIterator())){

                        protected boolean exclude(O object) {
                            progress.step();
                            try {
                                Collection<FieldValue> references = TruffleObjectMergedReferences.this.getReferences(object);
                                if (referer == null) {
                                    return !references.isEmpty();
                                }
                                for (FieldValue reference : references) {
                                    if (!referer.equals(reference.getDefiningInstance())) continue;
                                    return false;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            return true;
                        }
                    };
                    return new ProgressIterator((Iterator)referencesIt, index, true, _progress);
                }

                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.TruffleObjectPropertyProvider_IMoreNodes(moreNodesCount);
                }

                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.TruffleObjectPropertyProvider_ISamplesContainer(objectsCount);
                }

                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.TruffleObjectPropertyProvider_INodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
        }

        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.COUNT) {
                return this.getCount();
            }
            return super.getValue(type, heap);
        }
    }
}

