/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.JavaFrameGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectGCRoot;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class TruffleStackTraces {
    private Collection<StackTrace> truffleStackTraces;

    public TruffleStackTraces(Heap heap) {
        HotSpotTruffleRuntime hotSpotImpl;
        DefaultTruffleRuntime defaultImpl = new DefaultTruffleRuntime(heap);
        if (defaultImpl.isDefaultTruffleRuntime()) {
            this.truffleStackTraces = defaultImpl.getStackTraces();
        }
        if ((hotSpotImpl = new HotSpotTruffleRuntime(heap)).isHotSpotTruffleRuntime()) {
            this.truffleStackTraces = hotSpotImpl.getStackTraces();
        }
    }

    public Collection<StackTrace> getStackTraces() {
        return this.truffleStackTraces;
    }

    private static String getFileName(Instance source, Heap heap) {
        String fileName;
        int slash;
        Object key = source.getValueOfField("key");
        if (key instanceof Instance) {
            source = (Instance)key;
        }
        if ((slash = (fileName = DetailsUtils.getInstanceFieldString((Instance)source, (String)"name", (Heap)heap)).lastIndexOf(47)) != -1) {
            fileName = fileName.substring(slash + 1);
        }
        return fileName;
    }

    private static Instance getSourceSection(Instance rootNode) {
        if (rootNode == null) {
            return null;
        }
        for (Object fv : rootNode.getFieldValues()) {
            Instance sc;
            FieldValue fieldVal = (FieldValue)fv;
            if (!"sourceSection".equals(fieldVal.getField().getName()) || (sc = ((ObjectFieldValue)fieldVal).getInstance()) == null) continue;
            return sc;
        }
        return null;
    }

    private static String getLineNumber(Instance sourceSection, Instance source) {
        Integer charIndex = (Integer)sourceSection.getValueOfField("charIndex");
        Instance textmap = (Instance)source.getValueOfField("textMap");
        if (textmap != null) {
            PrimitiveArrayInstance nlOffsets = (PrimitiveArrayInstance)textmap.getValueOfField("nlOffsets");
            List vals = nlOffsets.getValues();
            for (int i = 0; i < vals.size(); ++i) {
                Integer off = Integer.valueOf((String)vals.get(i));
                if (off < charIndex) continue;
                return String.valueOf(i);
            }
            return String.valueOf(vals.size());
        }
        return "0";
    }

    private static Instance getSingleton(String javaClass, Heap heap) {
        List instances;
        JavaClass jcls = heap.getJavaClassByName(javaClass);
        if (jcls != null && (instances = jcls.getInstances()).size() == 1) {
            return (Instance)instances.get(0);
        }
        return null;
    }

    private static final class FrameVisitor {
        private static final String GRAAL_FRAME_INSTANCE_FQN = "org.graalvm.compiler.truffle.GraalFrameInstance";
        private static final String GRAAL_FRAME_INSTANCE1_FQN = "org.graalvm.compiler.truffle.runtime.GraalFrameInstance";
        private final HotSpotTruffleRuntime visitor;
        private final JavaMethod callOSRMethod;
        private final JavaMethod callTargetMethod;
        private final JavaMethod callNodeMethod;
        private int skipFrames;
        private List<JavaFrameGCRoot> callNodeFrame;

        FrameVisitor(HotSpotTruffleRuntime visitor, Heap heap, int skip) {
            this.visitor = visitor;
            JavaClass frameClass = FrameVisitor.getFrameClass(heap);
            this.callOSRMethod = new JavaMethod(heap, frameClass, "CALL_OSR_METHOD");
            this.callTargetMethod = new JavaMethod(heap, frameClass, "CALL_TARGET_METHOD");
            this.callNodeMethod = new JavaMethod(heap, frameClass, "CALL_NODE_METHOD");
            this.skipFrames = skip;
        }

        private static JavaClass getFrameClass(Heap heap) {
            JavaClass frameClass = heap.getJavaClassByName(GRAAL_FRAME_INSTANCE_FQN);
            if (frameClass == null) {
                frameClass = heap.getJavaClassByName(GRAAL_FRAME_INSTANCE1_FQN);
            }
            return frameClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame visitFrame(StackTraceElement frame, List<JavaFrameGCRoot> locals) {
            if (this.callOSRMethod.isMethod(frame)) {
                ++this.skipFrames;
            } else if (this.callTargetMethod.isMethod(frame)) {
                try {
                    if (this.skipFrames == 0) {
                        Frame frame2 = this.visitor.visitFrame(locals, this.callNodeFrame);
                        return frame2;
                    }
                    --this.skipFrames;
                }
                finally {
                    this.callNodeFrame = null;
                }
            } else if (this.callNodeMethod.isMethod(frame)) {
                this.callNodeFrame = locals;
            }
            return null;
        }
    }

    private static class JavaMethod {
        private final String className;
        private final String methodName;
        private final String signature;

        private JavaMethod(Heap heap, JavaClass frameClass, String field) {
            this(heap, (Instance)frameClass.getValueOfStaticField(field));
        }

        private JavaMethod(Heap heap, Instance method) {
            Instance javaClass = (Instance)method.getValueOfField("clazz");
            this.className = heap.getJavaClassByID(javaClass.getInstanceId()).getName();
            this.methodName = DetailsUtils.getInstanceFieldString((Instance)method, (String)"name", (Heap)heap);
            this.signature = DetailsUtils.getInstanceFieldString((Instance)method, (String)"signature", (Heap)heap);
        }

        private boolean isMethod(StackTraceElement frame) {
            return frame.getClassName().equals(this.className) && frame.getMethodName().equals(this.methodName);
        }
    }

    private static class HotSpotStackTrace
    extends StackTrace {
        List<Frame> frames = new ArrayList<Frame>();

        public HotSpotStackTrace(Heap h, Instance t) {
            super(h, t);
        }

        @Override
        public List<Frame> getFrames() {
            return this.frames;
        }

        private void addFrame(Frame frame) {
            this.frames.add(frame);
        }
    }

    private static class HotSpotTruffleRuntime {
        private static final String HOTSPOT_TRUFFLE_RUNTIME_FQN = "org.graalvm.compiler.truffle.hotspot.HotSpotTruffleRuntime";
        private static final String HOTSPOT_TRUFFLE_RUNTIME1_FQN = "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotTruffleRuntime";
        private static final String DEFAULT_CALL_TARGET_FQN = "com.oracle.truffle.api.impl.DefaultCallTarget";
        private static final String OPTIMIZED_CALL_TARGET_FQN = "org.graalvm.compiler.truffle.OptimizedCallTarget";
        private static final String ENT_OPTIMIZED_CALL_TARGET_FQN = "com.oracle.graal.truffle.OptimizedCallTarget";
        private static final String OPTIMIZED_CALL_TARGET1_FQN = "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget";
        private static final String OPTIMIZED_CALL_TARGET2_FQN = "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget";
        private Collection<StackTrace> truffleStackTraces;
        private Instance hotSpotRuntime;
        private Heap heap;

        private HotSpotTruffleRuntime(Heap h) {
            this.heap = h;
            this.hotSpotRuntime = TruffleStackTraces.getSingleton(HOTSPOT_TRUFFLE_RUNTIME_FQN, this.heap);
            if (this.hotSpotRuntime == null) {
                this.hotSpotRuntime = TruffleStackTraces.getSingleton(HOTSPOT_TRUFFLE_RUNTIME1_FQN, this.heap);
            }
        }

        private boolean isHotSpotTruffleRuntime() {
            return this.hotSpotRuntime != null && FrameVisitor.getFrameClass(this.heap) != null;
        }

        private void computeStackTrace(Heap heap, FrameVisitor visitor) {
            Collection roots = heap.getGCRoots();
            Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = this.computeJavaFrameMap(roots);
            for (GCRoot root : roots) {
                Map<Integer, List<JavaFrameGCRoot>> localsMap;
                StackTraceElement[] stack;
                ThreadObjectGCRoot threadRoot;
                Instance threadInstance;
                if (!root.getKind().equals("thread object") || (threadInstance = (threadRoot = (ThreadObjectGCRoot)root).getInstance()) == null || (stack = threadRoot.getStackTrace()) == null || (localsMap = javaFrameMap.get(threadRoot)) == null) continue;
                HotSpotStackTrace hsStackTrace = new HotSpotStackTrace(heap, threadInstance);
                for (int i = 0; i < stack.length; ++i) {
                    StackTraceElement stackElement = stack[i];
                    List<JavaFrameGCRoot> locals = localsMap.get(i);
                    Frame frame = visitor.visitFrame(stackElement, locals);
                    if (frame == null) continue;
                    hsStackTrace.addFrame(frame);
                }
                if (hsStackTrace.getFrames().isEmpty()) continue;
                this.truffleStackTraces.add(hsStackTrace);
            }
        }

        private Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
            HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
            for (GCRoot root : roots) {
                ArrayList<JavaFrameGCRoot> locals;
                if (!"Java frame".equals(root.getKind())) continue;
                JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
                ThreadObjectGCRoot threadObj = frameGCroot.getThreadGCRoot();
                Integer frameNo = frameGCroot.getFrameNumber();
                HashMap<Integer, ArrayList<JavaFrameGCRoot>> stackMap = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)javaFrameMap.get(threadObj);
                if (stackMap == null) {
                    stackMap = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                    javaFrameMap.put(threadObj, stackMap);
                }
                if ((locals = (ArrayList<JavaFrameGCRoot>)stackMap.get(frameNo)) == null) {
                    locals = new ArrayList<JavaFrameGCRoot>(2);
                    stackMap.put(frameNo, locals);
                }
                locals.add(frameGCroot);
            }
            return javaFrameMap;
        }

        private Instance findLocalInstance(List<JavaFrameGCRoot> locals, String ... classes) {
            if (locals != null) {
                for (JavaFrameGCRoot local : locals) {
                    Instance i = local.getInstance();
                    String className = i.getJavaClass().getName();
                    for (String cls : classes) {
                        if (!cls.equals(className)) continue;
                        return i;
                    }
                }
            }
            return null;
        }

        private TruffleFrame findLocalFrame(List<JavaFrameGCRoot> locals) {
            if (locals != null) {
                for (JavaFrameGCRoot local : locals) {
                    Instance i = local.getInstance();
                    TruffleFrame localFrame = new TruffleFrame(i);
                    if (!localFrame.isTruffleFrame()) continue;
                    return localFrame;
                }
            }
            return null;
        }

        private Frame visitFrame(List<JavaFrameGCRoot> callTargetFrame, List<JavaFrameGCRoot> callNodeFrame) {
            Instance callTarget = this.findLocalInstance(callTargetFrame, DEFAULT_CALL_TARGET_FQN, OPTIMIZED_CALL_TARGET_FQN, ENT_OPTIMIZED_CALL_TARGET_FQN, OPTIMIZED_CALL_TARGET1_FQN, OPTIMIZED_CALL_TARGET2_FQN);
            TruffleFrame localFrame = this.findLocalFrame(callNodeFrame);
            if (callTarget != null && localFrame != null) {
                return new Frame(this.heap, callTarget, localFrame);
            }
            callTarget = this.findLocalInstance(callNodeFrame, DEFAULT_CALL_TARGET_FQN, OPTIMIZED_CALL_TARGET_FQN, ENT_OPTIMIZED_CALL_TARGET_FQN, OPTIMIZED_CALL_TARGET1_FQN, OPTIMIZED_CALL_TARGET2_FQN);
            localFrame = this.findLocalFrame(callTargetFrame);
            if (callTarget != null && localFrame != null) {
                return new Frame(this.heap, callTarget, localFrame);
            }
            return null;
        }

        private synchronized Collection<StackTrace> getStackTraces() {
            if (this.isHotSpotTruffleRuntime() && this.truffleStackTraces == null) {
                FrameVisitor visitor = new FrameVisitor(this, this.heap, 0);
                this.truffleStackTraces = new ArrayList<StackTrace>();
                this.computeStackTrace(this.heap, visitor);
            }
            return this.truffleStackTraces;
        }
    }

    private static class DefaultFrame
    extends Frame {
        private DefaultFrame(Heap heap, Instance frame) {
            super(heap, (Instance)frame.getValueOfField("target"), (Instance)frame.getValueOfField("frame"));
        }
    }

    private static class DefaultStackTrace
    extends StackTrace {
        private final Instance topFrame;
        private List<Frame> frames;

        private DefaultStackTrace(Heap h, Instance t, Instance f) {
            super(h, t);
            this.topFrame = f;
        }

        @Override
        public synchronized List<Frame> getFrames() {
            if (this.frames == null) {
                Instance frame = this.topFrame;
                this.frames = new ArrayList<Frame>();
                do {
                    this.frames.add(new DefaultFrame(this.heap, frame));
                } while ((frame = (Instance)frame.getValueOfField("callerFrame")) != null);
            }
            return this.frames;
        }
    }

    private static class DefaultTruffleRuntime {
        private static final String TRUFFLE_RUNTIME_FQN = "com.oracle.truffle.api.impl.DefaultTruffleRuntime";
        private static final String THREAD_FQN = "java.lang.Thread";
        private Collection<StackTrace> truffleStackTraces;

        private DefaultTruffleRuntime(Heap heap) {
            Instance runtime = TruffleStackTraces.getSingleton(TRUFFLE_RUNTIME_FQN, heap);
            if (runtime != null) {
                Instance stackTraces = (Instance)runtime.getValueOfField("stackTraces");
                this.truffleStackTraces = this.getStackTraces(heap, stackTraces);
            }
        }

        private boolean isDefaultTruffleRuntime() {
            return this.truffleStackTraces != null;
        }

        private Collection<StackTrace> getStackTraces() {
            return this.truffleStackTraces;
        }

        private Collection<StackTrace> getStackTraces(Heap heap, Instance stackTraces) {
            ArrayList<DefaultStackTrace> traces = new ArrayList<DefaultStackTrace>();
            JavaClass threadCls = heap.getJavaClassByName(THREAD_FQN);
            Collection allThreadCls = threadCls.getSubClasses();
            allThreadCls.add(threadCls);
            for (JavaClass threadSubCls : allThreadCls) {
                List threads = threadSubCls.getInstances();
                for (Instance thread : threads) {
                    Instance topFrame = this.getTruffleFrameInstance(thread, stackTraces);
                    if (topFrame == null) continue;
                    traces.add(new DefaultStackTrace(heap, thread, topFrame));
                }
            }
            return Collections.unmodifiableCollection(traces);
        }

        private Instance getTruffleFrameInstance(Instance thread, Instance stackTraces) {
            Instance threadLocals = (Instance)thread.getValueOfField("threadLocals");
            if (threadLocals != null) {
                List<Instance> mapTable = this.getObjectArray(threadLocals, "table");
                return this.searchTable(mapTable, stackTraces);
            }
            return null;
        }

        private Instance searchTable(List<Instance> entries, Instance item) {
            Iterator<Instance> iterator = entries.iterator();
            while (iterator.hasNext()) {
                for (Instance entry = iterator.next(); entry != null; entry = (Instance)entry.getValueOfField("next")) {
                    Instance key = (Instance)entry.getValueOfField("referent");
                    if (!item.equals(key)) continue;
                    return (Instance)entry.getValueOfField("value");
                }
            }
            return null;
        }

        private List<Instance> getObjectArray(Instance instance, String field) {
            Object localsInst = instance.getValueOfField(field);
            if (localsInst instanceof ObjectArrayInstance) {
                return ((ObjectArrayInstance)localsInst).getValues();
            }
            return null;
        }
    }

    public static class Frame {
        private final String name;
        private final List<FieldValue> fieldValues;

        private Frame(Heap heap, Instance callTarget, TruffleFrame localFrame) {
            this.name = Frame.getFrameName(callTarget, heap);
            this.fieldValues = localFrame.getFieldValues();
        }

        private Frame(Heap heap, Instance callTarget, Instance localFrame) {
            this.name = Frame.getFrameName(callTarget, heap);
            this.fieldValues = new TruffleFrame(localFrame).getFieldValues();
        }

        public String getName() {
            return this.name;
        }

        public List<FieldValue> getFieldValues() {
            return this.fieldValues;
        }

        private static String getFrameName(Instance callTarget, Heap heap) {
            Instance rootNode = (Instance)callTarget.getValueOfField("rootNode");
            if (rootNode != null) {
                Instance source;
                String name = DetailsUtils.getInstanceString((Instance)rootNode, (Heap)heap);
                Instance sourceSection = TruffleStackTraces.getSourceSection(rootNode);
                if (sourceSection != null && (source = (Instance)sourceSection.getValueOfField("source")) != null) {
                    String fileName = TruffleStackTraces.getFileName(source, heap);
                    return name + " (" + fileName + ":" + TruffleStackTraces.getLineNumber(sourceSection, source) + ")";
                }
                return name;
            }
            return DetailsUtils.getInstanceString((Instance)callTarget, (Heap)heap);
        }
    }

    public static abstract class StackTrace {
        private final Instance thread;
        final Heap heap;

        private StackTrace(Heap h, Instance t) {
            this.heap = h;
            this.thread = t;
        }

        public Instance getThread() {
            return this.thread;
        }

        public abstract List<Frame> getFrames();
    }
}

