/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.LocalObjectNode;
import org.graalvm.visualvm.heapviewer.java.ThreadNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleStackTraces;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.LocalDynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleStackFrameNode;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

public class TruffleThreadsProvider<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>> {
    private final L language;

    public TruffleThreadsProvider(L language) {
        this.language = language;
    }

    public HeapViewerNode[] getThreadsObjects(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        ArrayList<1> threadNodes = new ArrayList<1>();
        TruffleStackTraces tst = new TruffleStackTraces(heap);
        Collection<TruffleStackTraces.StackTrace> threads = tst.getStackTraces();
        if (threads != null) {
            Thread worker = Thread.currentThread();
            for (TruffleStackTraces.StackTrace st : threads) {
                Instance threadInstance = st.getThread();
                String threadName = Bundle.TruffleThreadsProvider_ThreadNamePrefix(DetailsSupport.getDetailsString((Instance)threadInstance, (Heap)heap));
                if (threadName == null) continue;
                final ArrayList<TruffleStackFrameNode> stackFrameNodes = new ArrayList<TruffleStackFrameNode>();
                ThreadNode threadNode = new ThreadNode(threadName, threadInstance){

                    protected HeapViewerNode[] computeChildren(RootNode root) {
                        return stackFrameNodes.toArray(HeapViewerNode.NO_NODES);
                    }
                };
                threadNodes.add(threadNode);
                for (TruffleStackTraces.Frame f : st.getFrames()) {
                    HashSet<Object> localObjects = new HashSet<Object>();
                    for (FieldValue fv : f.getFieldValues()) {
                        Instance instance;
                        if (worker.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        if (!(fv instanceof ObjectFieldValue) || (instance = ((ObjectFieldValue)fv).getInstance()) == null) continue;
                        if (((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) {
                            Object object = ((TruffleLanguage)((Object)this.language)).createObject(instance);
                            localObjects.add((HeapViewerNode)((TruffleLanguage)((Object)this.language)).createLocalObjectNode(object, ((TruffleObject)object).getType(heap)));
                            continue;
                        }
                        if (DynamicObject.isDynamicObject(instance)) {
                            DynamicObject dobj = new DynamicObject(instance);
                            localObjects.add(new LocalDynamicObjectNode<DynamicObject>(dobj, dobj.getType(heap)));
                            continue;
                        }
                        localObjects.add(new LocalObjectNode(instance));
                    }
                    String stackFrameName = f.getName();
                    if (stackFrameName == null) {
                        stackFrameName = Bundle.TruffleThreadsProvider_Unknown();
                    }
                    stackFrameNodes.add(new TruffleStackFrameNode(stackFrameName, localObjects.toArray(HeapViewerNode.NO_NODES)));
                }
            }
        } else {
            threadNodes.add(new TextNode(Bundle.TruffleThreadsProvider_ThreadNotAvailable()));
        }
        return threadNodes.toArray(HeapViewerNode.NO_NODES);
    }

    public HeapViewerNode getNodeForURL(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance((String)urls)) {
            Heap heap = context.getFragment().getHeap();
            Instance instance = HeapUtils.instanceFromHtml((String)urls, (Heap)heap);
            if (((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) {
                Object object = ((TruffleLanguage)((Object)this.language)).createObject(instance);
                return (HeapViewerNode)((TruffleLanguage)((Object)this.language)).createObjectNode(object, ((TruffleObject)object).getType(heap));
            }
            if (DynamicObject.isDynamicObject(instance)) {
                DynamicObject dobj = new DynamicObject(instance);
                return new LocalDynamicObjectNode<DynamicObject>(dobj, dobj.getType(heap));
            }
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.TruffleThreadsProvider_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass((String)urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml((String)urls, (Heap)context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.TruffleThreadsProvider_CannotResolveClassMsg());
        }
        return null;
    }

    public String getThreadsHTML(HeapContext context) {
        StringBuilder sb = new StringBuilder();
        Heap heap = context.getFragment().getHeap();
        JavaClass javaClassClass = heap.getJavaClassByName(Class.class.getName());
        TruffleStackTraces tst = new TruffleStackTraces(heap);
        Collection<TruffleStackTraces.StackTrace> threads = tst.getStackTraces();
        sb.append("<pre>");
        if (threads != null) {
            for (TruffleStackTraces.StackTrace st : threads) {
                sb.append("<b>&nbsp;&nbsp;" + Bundle.TruffleThreadsProvider_ThreadNamePrefix(DetailsSupport.getDetailsString((Instance)st.getThread(), (Heap)heap)) + "</b>");
                sb.append("<br>");
                List<TruffleStackTraces.Frame> frames = st.getFrames();
                for (TruffleStackTraces.Frame f : frames) {
                    List<FieldValue> fields = f.getFieldValues();
                    String fname = f.getName();
                    if (fname == null) {
                        fname = Bundle.TruffleThreadsProvider_Unknown();
                    }
                    sb.append("    " + Bundle.TruffleThreadsProvider_StackFramePrefix() + " " + HeapUtils.htmlize((String)fname));
                    sb.append("<br>");
                    for (FieldValue fv : fields) {
                        Instance instance;
                        if (!(fv instanceof ObjectFieldValue) || (instance = ((ObjectFieldValue)fv).getInstance()) == null) continue;
                        sb.append("       <span style=\"color: #666666\">" + Bundle.TruffleThreadsProvider_LocalObjectPrefix() + "</span> " + this.printInstance(instance, heap, javaClassClass));
                        sb.append("<br>");
                    }
                }
            }
        } else {
            sb.append("<b>&nbsp;&nbsp;" + Bundle.TruffleThreadsProvider_ThreadNotAvailable());
        }
        sb.append("<br>");
        sb.append("</pre>");
        return sb.toString();
    }

    private String printInstance(Instance instance, Heap heap, JavaClass javaClassClass) {
        if (((TruffleLanguage)((Object)this.language)).isLanguageObject(instance)) {
            Object object = ((TruffleLanguage)((Object)this.language)).createObject(instance);
            TruffleObjectNode node = ((TruffleLanguage)((Object)this.language)).createObjectNode(object, ((TruffleObject)object).getType(heap));
            String instanceString = HeapUtils.instanceToHtml((Instance)instance, (boolean)false, (Heap)heap, (JavaClass)javaClassClass);
            String type = node.getTypeName();
            instanceString = instanceString.replace(">" + instance.getJavaClass().getName() + "#", ">" + HeapUtils.htmlize((String)type) + "#");
            String logValue = node.getLogicalValue(heap);
            if (logValue != null) {
                instanceString = instanceString + " <span style=\"color: #666666\">: " + HeapUtils.htmlize((String)logValue) + "</span>";
            }
            return instanceString;
        }
        if (DynamicObject.isDynamicObject(instance)) {
            DynamicObject dobj = new DynamicObject(instance);
            DynamicObjectNode<DynamicObject> node = new DynamicObjectNode<DynamicObject>(dobj, dobj.getType(heap));
            String instanceString = HeapUtils.instanceToHtml((Instance)instance, (boolean)false, (Heap)heap, (JavaClass)javaClassClass);
            String type = node.getTypeName();
            instanceString = instanceString.replace(">" + instance.getJavaClass().getName() + "#", ">" + HeapUtils.htmlize((String)type) + "#");
            String logValue = node.getLogicalValue(heap);
            if (logValue != null) {
                instanceString = instanceString + " <span style=\"color: #666666\">: " + HeapUtils.htmlize((String)logValue) + "</span>";
            }
            return instanceString;
        }
        return HeapUtils.instanceToHtml((Instance)instance, (boolean)true, (Heap)heap, (JavaClass)javaClassClass);
    }
}

