/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectArrayItemNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.LocalDynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectArrayItemNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleOpenNodeActionProvider;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.ui.Formatters;

public class RubyNodes
extends TruffleOpenNodeActionProvider<RubyObject, RubyType, RubyHeapFragment, RubyLanguage> {
    private static final int MAX_LOGVALUE_LENGTH = 160;

    public boolean supportsView(HeapContext context, String viewID) {
        return RubyHeapFragment.isRubyHeap(context);
    }

    @Override
    protected boolean supportsNode(HeapViewerNode node) {
        return node instanceof RubyNode;
    }

    @Override
    protected RubyLanguage getLanguage() {
        return RubyLanguage.instance();
    }

    static String getLogicalValue(RubyObject object, String type, Heap heap) {
        String logicalValue = null;
        if ("Proc".equals(type)) {
            Instance info;
            FieldValue infoField = object.getFieldValue("sharedMethodInfo (hidden)");
            Instance instance = info = infoField instanceof ObjectFieldValue ? ((ObjectFieldValue)infoField).getInstance() : null;
            if (info != null) {
                String name = DetailsUtils.getInstanceFieldString((Instance)info, (String)"name", (Heap)heap);
                String notes = DetailsUtils.getInstanceFieldString((Instance)info, (String)"notes", (Heap)heap);
                if (name != null && notes != null) {
                    logicalValue = name + " (" + notes + ")";
                } else if (name != null) {
                    logicalValue = name;
                } else if (notes != null) {
                    logicalValue = notes;
                }
            }
        } else if ("Method".equals(type) || "UnboundMethod".equals(type)) {
            Instance info;
            FieldValue methodField = object.getFieldValue("method (hidden)");
            Instance method = methodField instanceof ObjectFieldValue ? ((ObjectFieldValue)methodField).getInstance() : null;
            Object infoField = method == null ? null : method.getValueOfField("sharedMethodInfo");
            Instance instance = info = infoField instanceof Instance ? (Instance)infoField : null;
            if (info != null) {
                String name = DetailsUtils.getInstanceFieldString((Instance)info, (String)"name", (Heap)heap);
                String notes = DetailsUtils.getInstanceFieldString((Instance)info, (String)"notes", (Heap)heap);
                if (name != null && notes != null) {
                    logicalValue = name + " (" + notes + ")";
                } else if (name != null) {
                    logicalValue = name;
                } else if (notes != null) {
                    logicalValue = notes;
                }
            }
        } else if ("Symbol".equals(type)) {
            Instance symbol;
            FieldValue symbolField = object.getFieldValue("string (hidden)");
            Instance instance = symbol = symbolField instanceof ObjectFieldValue ? ((ObjectFieldValue)symbolField).getInstance() : null;
            if (symbol != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)symbol, (Heap)heap);
            }
        } else if ("Class".equals(type) || "Module".equals(type)) {
            Instance name;
            FieldValue fieldsField = object.getFieldValue("fields (hidden)");
            Instance fields = fieldsField instanceof ObjectFieldValue ? ((ObjectFieldValue)fieldsField).getInstance() : null;
            Object nameField = fields == null ? null : fields.getValueOfField("name");
            Instance instance = name = nameField instanceof Instance ? (Instance)nameField : null;
            if (name != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)name, (Heap)heap);
            }
        } else if ("BasicObject".equals(type)) {
            String head = "fields [";
            String sep = ", ";
            StringBuilder sb = new StringBuilder();
            sb.append(head);
            List<FieldValue> fields = object.getFieldValues();
            for (FieldValue field : fields) {
                String name = field.getField().getName();
                if (name.contains("(hidden)")) continue;
                sb.append(name).append(sep);
            }
            int length = sb.length();
            if (length > head.length()) {
                sb.delete(length - sep.length(), length);
            }
            sb.append("]");
            logicalValue = sb.toString();
        } else if ("Array".equals(type)) {
            FieldValue sizeField = object.getFieldValue("size (hidden)");
            if (sizeField != null) {
                Integer size = Integer.parseInt(sizeField.getValue());
                logicalValue = Formatters.numberFormat().format(size) + (size == 1 ? " item" : " items");
            }
        } else if ("String".equals(type)) {
            Instance rope;
            FieldValue ropeField = object.getFieldValue("rope (hidden)");
            Instance instance = rope = ropeField instanceof ObjectFieldValue ? ((ObjectFieldValue)ropeField).getInstance() : null;
            if (rope != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)rope, (Heap)heap);
            }
        } else if ("Regexp".equals(type)) {
            Instance source;
            FieldValue sourceField = object.getFieldValue("source (hidden)");
            Instance instance = source = sourceField instanceof ObjectFieldValue ? ((ObjectFieldValue)sourceField).getInstance() : null;
            if (source != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)source, (Heap)heap);
            }
        } else if ("Encoding".equals(type)) {
            Instance encoding;
            FieldValue encodingField = object.getFieldValue("encoding (hidden)");
            Instance instance = encoding = encodingField instanceof ObjectFieldValue ? ((ObjectFieldValue)encodingField).getInstance() : null;
            if (encoding != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)encoding, (Heap)heap);
            }
        } else if ("Integer".equals(type)) {
            Instance value;
            FieldValue valueField = object.getFieldValue("value (hidden)");
            Instance instance = value = valueField instanceof ObjectFieldValue ? ((ObjectFieldValue)valueField).getInstance() : null;
            if (value != null) {
                logicalValue = DetailsUtils.getInstanceString((Instance)value, (Heap)heap);
            }
        } else if ("Rational".equals(type)) {
            Instance denominator;
            FieldValue numField = object.getFieldValue("@numerator");
            Instance numerator = numField instanceof ObjectFieldValue ? ((ObjectFieldValue)numField).getInstance() : null;
            FieldValue denomField = object.getFieldValue("@denominator");
            Instance instance = denominator = denomField instanceof ObjectFieldValue ? ((ObjectFieldValue)denomField).getInstance() : null;
            if (numField != null && denomField != null) {
                String numeratorValue = numerator != null ? DetailsUtils.getInstanceString((Instance)numerator, (Heap)heap) : numField.getValue();
                String denominatorValue = denominator != null ? DetailsUtils.getInstanceString((Instance)denominator, (Heap)heap) : denomField.getValue();
                if (numeratorValue != null && denominatorValue != null) {
                    logicalValue = "(" + numeratorValue + "/" + denominatorValue + ")";
                }
            }
        } else if ("Complex".equals(type)) {
            String imag;
            FieldValue realField = object.getFieldValue("@real");
            String real = realField != null ? realField.getValue() : null;
            FieldValue imagField = object.getFieldValue("@imag");
            String string = imag = imagField != null ? imagField.getValue() : null;
            if (real != null && imag != null) {
                logicalValue = "(" + real + (imag.startsWith("-") ? imag : "+" + imag) + "i)";
            }
        } else if ("Range".equals(type)) {
            FieldValue beginField = object.getFieldValue("begin (hidden)");
            FieldValue endField = object.getFieldValue("end (hidden)");
            FieldValue excludedField = object.getFieldValue("excludedEnd (hidden)");
            if (beginField != null && endField != null && excludedField != null) {
                Instance beginInstance = beginField instanceof ObjectFieldValue ? ((ObjectFieldValue)beginField).getInstance() : null;
                String begin = beginInstance != null ? RubyNodes.logicalValue(beginInstance, heap) : beginField.getValue();
                Instance endInstance = endField instanceof ObjectFieldValue ? ((ObjectFieldValue)endField).getInstance() : null;
                String end = endInstance != null ? RubyNodes.logicalValue(endInstance, heap) : endField.getValue();
                boolean excluded = "1".equals(excludedField.getValue());
                logicalValue = "(" + begin + (excluded ? "..." : "..") + end + ")";
            }
        }
        if (logicalValue != null && logicalValue.length() > 160) {
            logicalValue = logicalValue.substring(0, 160) + "...";
        }
        return logicalValue;
    }

    private static String logicalValue(Instance instance, Heap heap) {
        if (RubyObject.isRubyObject(instance)) {
            RubyObject object = new RubyObject(instance);
            return RubyNodes.getLogicalValue(object, object.getType(heap), heap);
        }
        return DetailsUtils.getInstanceString((Instance)instance, (Heap)heap);
    }

    private static RubyObjectNode createCopy(TruffleObjectNode.InstanceBased<RubyObject> node) {
        return new RubyObjectNode((RubyObject)node.getTruffleObject(), node.getTypeName());
    }

    public static class RubyNodesRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            RubyLanguage language = RubyLanguage.instance();
            Icon instanceIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Instance"));
            Icon packageIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Package"));
            Heap heap = context.getFragment().getHeap();
            renderers.put(RubyObjectNode.class, new TruffleObjectNode.Renderer(heap, instanceIcon));
            renderers.put(RubyTypeNode.class, new TruffleTypeNode.Renderer(packageIcon));
            renderers.put(RubyObjectFieldNode.class, new TruffleObjectFieldNode.Renderer(heap, instanceIcon));
            renderers.put(RubyObjectArrayItemNode.class, new TruffleObjectArrayItemNode.Renderer(heap, instanceIcon));
            renderers.put(RubyObjectReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon));
            renderers.put(RubyLocalObjectNode.class, new TruffleLocalObjectNode.Renderer(heap, instanceIcon));
        }
    }

    static class RubyObjectReferenceNode
    extends DynamicObjectReferenceNode<RubyObject>
    implements RubyNode {
        RubyObjectReferenceNode(RubyObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeLogicalValue(RubyObject object, String type, Heap heap) {
            String logicalValue = RubyNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public RubyObjectNode createCopy() {
            return RubyNodes.createCopy(this);
        }
    }

    static class RubyObjectArrayItemNode
    extends DynamicObjectArrayItemNode<RubyObject>
    implements RubyNode {
        RubyObjectArrayItemNode(RubyObject object, String type, ArrayItemValue item) {
            super(object, type, item);
        }

        @Override
        protected String computeLogicalValue(RubyObject object, String type, Heap heap) {
            String logicalValue = RubyNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public RubyObjectNode createCopy() {
            return RubyNodes.createCopy(this);
        }
    }

    static class RubyObjectFieldNode
    extends DynamicObjectFieldNode<RubyObject>
    implements RubyNode {
        RubyObjectFieldNode(RubyObject object, String type, FieldValue field) {
            super(object, type, field);
        }

        @Override
        protected String computeLogicalValue(RubyObject object, String type, Heap heap) {
            String logicalValue = RubyNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public RubyObjectNode createCopy() {
            return RubyNodes.createCopy(this);
        }
    }

    static class RubyTypeNode
    extends TruffleTypeNode<RubyObject, RubyType>
    implements RubyNode {
        RubyTypeNode(RubyType type) {
            super(type);
        }

        @Override
        public HeapViewerNode createNode(RubyObject object, Heap heap) {
            String type = ((RubyType)this.getType()).getName();
            return new RubyObjectNode(object, type);
        }

        @Override
        public TruffleTypeNode createCopy() {
            RubyTypeNode copy = new RubyTypeNode((RubyType)this.getType());
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(RubyTypeNode copy) {
            super.setupCopy(copy);
        }
    }

    static class RubyLocalObjectNode
    extends LocalDynamicObjectNode<RubyObject>
    implements RubyNode {
        RubyLocalObjectNode(RubyObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeLogicalValue(RubyObject object, String type, Heap heap) {
            String logicalValue = RubyNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public RubyObjectNode createCopy() {
            return RubyNodes.createCopy(this);
        }
    }

    static class RubyObjectNode
    extends DynamicObjectNode<RubyObject>
    implements RubyNode {
        RubyObjectNode(RubyObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeLogicalValue(RubyObject object, String type, Heap heap) {
            String logicalValue = RubyNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        public RubyObjectNode createCopy() {
            RubyObjectNode copy = RubyNodes.createCopy(this);
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(RubyObjectNode copy) {
            super.setupCopy(copy);
        }
    }

    static interface RubyNode {
    }
}

