/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.log.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import sun.misc.Signal;
import sun.misc.SignalHandler;

class DumpHeapReport
implements SignalHandler {
    DumpHeapReport() {
    }

    static void install() {
        Signal.handle(new Signal("USR1"), new DumpHeapReport());
    }

    @NeverInline(value="Ensure ClassCastException gets caught")
    private static void performHeapDump(FileOutputStream fileOutputStream) throws Exception {
        Object[] args = new Object[]{"HeapDump.dumpHeap(FileOutputStream, Boolean)Boolean", fileOutputStream, Boolean.TRUE};
        if (!((Boolean)Compiler.command((Object)args)).booleanValue()) {
            throw new RuntimeException();
        }
    }

    @Override
    public void handle(Signal arg0) {
        Path heapDumpFilePath = null;
        FileOutputStream fileOutputStream = null;
        try {
            heapDumpFilePath = Files.createTempFile(Paths.get(".", new String[0]), "svm-heapdump-", ".hprof", new FileAttribute[0]);
            fileOutputStream = new FileOutputStream(heapDumpFilePath.toFile());
            DumpHeapReport.performHeapDump(fileOutputStream);
        }
        catch (Exception e) {
            Log.log().string("svm-heapdump failed").newline().flush();
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (heapDumpFilePath != null) {
                    Files.deleteIfExists(heapDumpFilePath);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

