/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GreyObjectsWalker {
    private Space space;
    private AlignedHeapChunk.AlignedHeader alignedHeapChunk;
    private Pointer alignedTop;
    private UnalignedHeapChunk.UnalignedHeader unalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static GreyObjectsWalker factory() {
        return new GreyObjectsWalker();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private GreyObjectsWalker() {
    }

    void setScanStart(Space s) {
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.setScanStart:").string("  s: ").string(s.getName());
        this.space = s;
        AlignedHeapChunk.AlignedHeader aChunk = s.getLastAlignedHeapChunk();
        this.setAlignedHeapChunk(aChunk);
        trace.string("  alignedHeapChunk: ").hex((WordBase)this.getAlignedHeapChunk()).string("  isNull: ").bool(aChunk.isNull());
        this.alignedTop = aChunk.isNonNull() ? aChunk.getTop() : (Pointer)WordFactory.nullPointer();
        trace.string("  alignedTop: ").hex((WordBase)this.alignedTop);
        UnalignedHeapChunk.UnalignedHeader uChunk = s.getLastUnalignedHeapChunk();
        this.setUnalignedHeapChunk(uChunk);
        trace.string("  unalignedChunkPointer: ").hex((WordBase)this.getUnalignedHeapChunk()).string("]").newline();
    }

    private boolean haveGreyObjects() {
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.haveGreyObjects:");
        boolean result = false;
        result |= this.getAlignedHeapChunk().notEqual((ComparableWord)this.space.getLastAlignedHeapChunk());
        result |= this.getAlignedHeapChunk().isNonNull() && this.alignedTop.notEqual((UnsignedWord)this.getAlignedHeapChunk().getTop());
        trace.string("  returns: ").bool(result |= this.getUnalignedHeapChunk().notEqual((ComparableWord)this.space.getLastUnalignedHeapChunk())).string("]").newline();
        return result;
    }

    boolean walkGreyObjects(ObjectVisitor visitor) {
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.walkGreyObjects:");
        while (this.haveGreyObjects()) {
            trace.newline();
            if (!this.walkAlignedGreyObjects(visitor)) {
                Log.log().string("[Space.GreyObjectsWalker.walkGreyObjects:  walkAlignedGreyObjects fails.]").newline();
                return false;
            }
            if (this.walkUnalignedGreyObjects(visitor)) continue;
            Log.log().string("[Space.GreyObjectsWalker.walkGreyObjects:  walkUnalignedGreyObjects fails.]").newline();
            return false;
        }
        trace.string("  returns true").string("]").newline();
        return true;
    }

    private boolean walkAlignedGreyObjects(ObjectVisitor visitor) {
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.walkAlignedGreyObjects:");
        AlignedHeapChunk.AlignedHeader aChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        Pointer aOffset = (Pointer)WordFactory.nullPointer();
        if (this.getAlignedHeapChunk().isNull() && this.getAlignedTop().isNull()) {
            aChunk = this.space.getFirstAlignedHeapChunk();
            aOffset = aChunk.isNonNull() ? AlignedHeapChunk.getAlignedHeapChunkStart(aChunk) : (Pointer)WordFactory.nullPointer();
        } else {
            aChunk = this.getAlignedHeapChunk();
            aOffset = this.getAlignedTop();
        }
        while (aChunk.isNonNull()) {
            trace.newline().string("  aChunk: ").hex((WordBase)aChunk).string("  aOffset: ").hex((WordBase)aOffset);
            if (!AlignedHeapChunk.walkObjectsFrom(aChunk, aOffset, visitor)) {
                Log.log().string("[Space.GreyObjectsWalker.walkAlignedGreyObjects:  aChunk.walkObject fails.]").newline();
                return false;
            }
            this.setAlignedHeapChunk(aChunk);
            this.setAlignedTop(aChunk.getTop());
            trace.string("  moved aligned scan point to: ").string("  alignedChunk: ").hex((WordBase)this.getAlignedHeapChunk()).string("  alignedTop: ").hex((WordBase)this.getAlignedTop());
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
            aOffset = aChunk.isNonNull() ? AlignedHeapChunk.getAlignedHeapChunkStart(aChunk) : (Pointer)WordFactory.nullPointer();
        }
        trace.string("  returns true").string("]").newline();
        return true;
    }

    private boolean walkUnalignedGreyObjects(ObjectVisitor visitor) {
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.walkUnalignedGreyObjects:");
        UnalignedHeapChunk.UnalignedHeader uChunk = this.getUnalignedHeapChunk().isNull() ? this.space.getFirstUnalignedHeapChunk() : (UnalignedHeapChunk.UnalignedHeader)this.getUnalignedHeapChunk().getNext();
        while (uChunk.isNonNull()) {
            trace.newline();
            trace.string("  uChunk: ").hex((WordBase)uChunk);
            if (!UnalignedHeapChunk.walkObjectsFrom(uChunk, UnalignedHeapChunk.getUnalignedHeapChunkStart(uChunk), visitor)) {
                Log.log().string("[Space.GreyObjectsWalker.walkUnalignedGreyObjects:  uChunk.walkObject fails.]").newline();
                return false;
            }
            this.setUnalignedHeapChunk(uChunk);
            trace.string("  moved unaligned scan point to: ").string("  unalignedChunk: ").hex((WordBase)this.getUnalignedHeapChunk());
            uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext();
        }
        trace.string("  returns true").string("]").newline();
        return true;
    }

    private AlignedHeapChunk.AlignedHeader getAlignedHeapChunk() {
        return this.alignedHeapChunk;
    }

    private void setAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        this.alignedHeapChunk = aChunk;
    }

    private UnalignedHeapChunk.UnalignedHeader getUnalignedHeapChunk() {
        return this.unalignedHeapChunk;
    }

    private void setUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        this.unalignedHeapChunk = uChunk;
    }

    private Pointer getAlignedTop() {
        return this.alignedTop;
    }

    private void setAlignedTop(Pointer value) {
        this.alignedTop = value;
    }
}

