/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64BlockEndOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="FAR_RETURN")
public final class AArch64FarReturnOp
extends AArch64BlockEndOp {
    public static final LIRInstructionClass<AArch64FarReturnOp> TYPE = LIRInstructionClass.create(AArch64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;

    public AArch64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        masm.mov(this.sp.getPlatformKind().getSizeInBytes() * 8, AArch64.sp, ValueUtil.asRegister((Value)this.sp));
        masm.ret(ValueUtil.asRegister((Value)this.ip));
    }
}

