/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class RealLog
extends Log {
    private boolean autoflush = false;
    private int indent = 0;
    private static final byte[] trueString = Boolean.TRUE.toString().getBytes();
    private static final byte[] falseString = Boolean.FALSE.toString().getBytes();
    private static final char spaceChar = ' ';

    protected RealLog() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Log string(String value) {
        if (value != null) {
            this.rawString(value);
        } else {
            this.rawString("null");
        }
        return this;
    }

    @Override
    public Log string(String str, int fill, int align) {
        int spaces = fill - str.length();
        if (align == 2) {
            this.spaces(spaces);
        }
        this.string(str);
        if (align == 1) {
            this.spaces(spaces);
        }
        return this;
    }

    @Override
    public Log string(char[] value) {
        if (value != null) {
            this.rawString(value);
        } else {
            this.rawString("null");
        }
        return this;
    }

    @Override
    public Log string(byte[] value, int offset, int length) {
        if (value == null) {
            this.rawString("null");
        } else if (offset < 0 || offset > value.length || length < 0 || offset + length > value.length || offset + length < 0) {
            this.rawString("OUT OF BOUNDS");
        } else {
            this.rawBytes(value, offset, length);
        }
        return this;
    }

    private void rawBytes(Object value, int offset, int length) {
        int chunkLength;
        int chunkSize = 256;
        CCharPointer bytes = (CCharPointer)StackValue.get((int)256);
        int chunkOffset = offset;
        for (int inputLength = length; inputLength > 0; inputLength -= chunkLength) {
            chunkLength = Math.min(inputLength, 256);
            for (int i = 0; i < chunkLength; ++i) {
                int index = chunkOffset + i;
                byte b = value instanceof String ? (byte)RealLog.charAt((String)value, index) : (value instanceof char[] ? (byte)((char[])value)[index] : ((byte[])value)[index]);
                bytes.write(i, b);
            }
            this.rawBytes(bytes, WordFactory.unsigned((int)chunkLength));
            chunkOffset += chunkLength;
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="String.charAt can allocate exception, but we know that our access is in bounds")
    private static char charAt(String s, int index) {
        return s.charAt(index);
    }

    @Override
    public Log string(CCharPointer value) {
        if (value.notEqual((ComparableWord)WordFactory.nullPointer())) {
            this.rawBytes(value, SubstrateUtil.strlen(value));
        } else {
            this.rawString("null");
        }
        return this;
    }

    @Override
    public Log character(char value) {
        CCharPointer bytes = (CCharPointer)StackValue.get(CCharPointer.class);
        bytes.write((byte)value);
        this.rawBytes(bytes, WordFactory.unsigned((int)1));
        return this;
    }

    @Override
    public Log newline() {
        this.character('\n');
        if (this.autoflush) {
            this.flush();
        }
        this.spaces(this.indent);
        return this;
    }

    @Override
    public Log number(long value, int radix, boolean signed) {
        return this.number(value, radix, signed, 0, 0);
    }

    private Log number(long value, int radix, boolean signed, int fill, int align) {
        int spaces;
        if (radix < 2 || radix > 36) {
            return this;
        }
        int chunkSize = 65;
        CCharPointer bytes = (CCharPointer)StackValue.get((int)65, CCharPointer.class);
        int charPos = 65;
        boolean negative = signed && value < 0L;
        long curValue = negative ? -value : value;
        while (UnsignedMath.aboveOrEqual((long)curValue, (long)radix)) {
            bytes.write(--charPos, RealLog.digit(Long.remainderUnsigned(curValue, radix)));
            curValue = Long.divideUnsigned(curValue, radix);
        }
        bytes.write(--charPos, RealLog.digit(curValue));
        if (negative) {
            bytes.write(--charPos, (byte)45);
        }
        int length = 65 - charPos;
        if (align == 2) {
            spaces = fill - length;
            this.spaces(spaces);
        }
        this.rawBytes(bytes.addressOf(charPos), WordFactory.unsigned((int)length));
        if (align == 1) {
            spaces = fill - length;
            this.spaces(spaces);
        }
        return this;
    }

    @Override
    public Log signed(WordBase value) {
        return this.number(value.rawValue(), 10, true);
    }

    @Override
    public Log signed(int value) {
        return this.number(value, 10, true);
    }

    @Override
    public Log signed(long value) {
        return this.number(value, 10, true);
    }

    @Override
    public Log unsigned(WordBase value) {
        return this.number(value.rawValue(), 10, false);
    }

    @Override
    public Log unsigned(WordBase value, int fill, int align) {
        return this.number(value.rawValue(), 10, false, fill, align);
    }

    @Override
    public Log unsigned(int value) {
        return this.number((long)value & 0xFFFFFFFFL, 10, false);
    }

    @Override
    public Log unsigned(long value) {
        return this.number(value, 10, false);
    }

    @Override
    public Log unsigned(long value, int fill, int align) {
        return this.number(value, 10, false, fill, align);
    }

    @Override
    public Log rational(long numerator, long denominator, long decimals) {
        if (denominator == 0L) {
            throw VMError.shouldNotReachHere("Division by zero");
        }
        if (decimals < 0L) {
            throw VMError.shouldNotReachHere("Number of decimals smaller than 0");
        }
        long value = numerator / denominator;
        this.unsigned(value);
        if (decimals > 0L) {
            this.character('.');
            long positiveNumerator = Math.abs(numerator);
            long positiveDenominator = Math.abs(denominator);
            long remainder = positiveNumerator % positiveDenominator;
            int i = 0;
            while ((long)i < decimals) {
                this.unsigned((remainder *= 10L) / positiveDenominator);
                remainder %= positiveDenominator;
                ++i;
            }
        }
        return this;
    }

    @Override
    public Log hex(WordBase value) {
        return this.string("0x").number(value.rawValue(), 16, false);
    }

    @Override
    public Log hex(int value) {
        return this.string("0x").number((long)value & 0xFFFFFFFFL, 16, false);
    }

    @Override
    public Log hex(long value) {
        return this.string("0x").number(value, 16, false);
    }

    @Override
    public Log bool(boolean value) {
        return this.string(value ? trueString : falseString);
    }

    @Override
    public Log object(Object value) {
        return value == null ? this.string("null") : this.string(value.getClass().getName()).string("@").hex((WordBase)Word.objectToUntrackedPointer((Object)value));
    }

    @Override
    public Log spaces(int value) {
        for (int i = 0; i < value; ++i) {
            this.character(' ');
        }
        return this;
    }

    @Override
    public Log flush() {
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).flush();
        return this;
    }

    @Override
    public Log autoflush(boolean onOrOff) {
        this.autoflush = onOrOff;
        return this;
    }

    @Override
    public Log redent(boolean addOrRemove) {
        int delta = addOrRemove ? 2 : -2;
        this.indent = Math.max(0, this.indent + delta);
        return this;
    }

    private static byte digit(long d) {
        return (byte)(d + (long)(d < 10L ? 48 : 87));
    }

    protected Log rawBytes(CCharPointer bytes, UnsignedWord length) {
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).log(bytes, length);
        return this;
    }

    private void rawString(String value) {
        this.rawBytes(value, 0, value.length());
    }

    private void rawString(char[] value) {
        this.rawBytes(value, 0, value.length);
    }

    @Override
    public Log zhex(long value) {
        int zeros = Long.numberOfLeadingZeros(value);
        int hexZeros = zeros / 4;
        for (int i = 0; i < hexZeros; ++i) {
            this.character('0');
        }
        if (value != 0L) {
            this.number(value, 16, false);
        }
        return this;
    }

    private Log zhex(int value, int wordSizeInBytes) {
        int zeros = Integer.numberOfLeadingZeros(value) - 32 + wordSizeInBytes * 8;
        int hexZeros = zeros / 4;
        for (int i = 0; i < hexZeros; ++i) {
            this.character('0');
        }
        if (value != 0) {
            this.number((long)value & 0xFFFFFFFFL, 16, false);
        }
        return this;
    }

    @Override
    public Log zhex(int value) {
        return this.zhex(value, 4);
    }

    @Override
    public Log zhex(short value) {
        short intValue = value;
        return this.zhex(intValue & 0xFFFF, 2);
    }

    @Override
    public Log zhex(byte value) {
        byte intValue = value;
        return this.zhex(intValue & 0xFF, 1);
    }

    @Override
    public Log hexdump(PointerBase from, int wordSize, int numWords) {
        Pointer base = (Pointer)WordFactory.pointer((long)from.rawValue());
        int sanitizedWordsize = wordSize > 0 ? Integer.highestOneBit(Math.min(wordSize, 8)) : 2;
        for (int offset = 0; offset < sanitizedWordsize * numWords; offset += sanitizedWordsize) {
            if (offset % 16 == 0) {
                this.zhex(base.add(offset).rawValue());
                this.string(":");
            }
            this.string(" ");
            switch (sanitizedWordsize) {
                case 1: {
                    this.zhex(base.readByte(offset));
                    break;
                }
                case 2: {
                    this.zhex(base.readShort(offset));
                    break;
                }
                case 4: {
                    this.zhex(base.readInt(offset));
                    break;
                }
                case 8: {
                    this.zhex(base.readLong(offset));
                }
            }
            if ((offset + sanitizedWordsize) % 16 != 0) continue;
            this.newline();
        }
        return this;
    }
}

