/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class WindowsVirtualMemoryProvider
implements VirtualMemoryProvider {
    private static final CGlobalData<WordPointer> CACHED_PAGE_SIZE = CGlobalDataFactory.createWord();
    private static final CGlobalData<WordPointer> CACHED_ALLOC_GRAN = CGlobalDataFactory.createWord();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void initCaches() {
        WinBase.SYSTEM_INFO sysInfo = (WinBase.SYSTEM_INFO)StackValue.get(WinBase.SYSTEM_INFO.class);
        WinBase.GetSystemInfo(sysInfo);
        int pageSize = sysInfo.dwPageSize();
        Word value = (Word)WordFactory.unsigned((int)pageSize);
        CACHED_PAGE_SIZE.get().write((WordBase)value);
        int granularity = sysInfo.dwAllocationGranularity();
        value = (Word)WordFactory.unsigned((int)granularity);
        CACHED_ALLOC_GRAN.get().write((WordBase)value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPageSize() {
        Word value = (Word)CACHED_PAGE_SIZE.get().read();
        if (value.equal((Word)WordFactory.zero())) {
            WindowsVirtualMemoryProvider.initCaches();
            value = (Word)CACHED_PAGE_SIZE.get().read();
        }
        return value;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getGranularity() {
        Word value = (Word)CACHED_ALLOC_GRAN.get().read();
        if (value.equal((Word)WordFactory.zero())) {
            WindowsVirtualMemoryProvider.initCaches();
            value = (Word)CACHED_ALLOC_GRAN.get().read();
        }
        return value;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static int accessAsProt(int access) {
        if (access == 0) {
            return WinBase.PAGE_NOACCESS();
        }
        if ((access & 4) != 0) {
            if ((access & 1) != 0) {
                if ((access & 2) != 0) {
                    return WinBase.PAGE_EXECUTE_READWRITE();
                }
                return WinBase.PAGE_EXECUTE_READ();
            }
            if ((access & 2) != 0) {
                return WinBase.PAGE_EXECUTE_READWRITE();
            }
            return WinBase.PAGE_EXECUTE();
        }
        if ((access & 1) != 0) {
            if ((access & 2) != 0) {
                return WinBase.PAGE_READWRITE();
            }
            return WinBase.PAGE_READONLY();
        }
        if ((access & 2) != 0) {
            return WinBase.PAGE_READWRITE();
        }
        return WinBase.PAGE_NOACCESS();
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static int accessForMap(int access) {
        int prot = 0;
        if ((access & 4) != 0) {
            prot |= WinBase.FILE_MAP_EXECUTE();
        }
        if ((access & 2) != 0) {
            prot |= WinBase.FILE_MAP_WRITE();
        }
        if ((access & 1) != 0) {
            prot |= WinBase.FILE_MAP_READ();
        }
        return prot;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer reserve(UnsignedWord nbytes) {
        return WinBase.VirtualAlloc(WordFactory.nullPointer(), nbytes, WinBase.MEM_RESERVE(), WinBase.PAGE_READWRITE());
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase start, UnsignedWord nbytes, WordBase fileHandle, UnsignedWord offset, int access) {
        int sizeLo;
        int sizeHi;
        int prot;
        long fHandle = fileHandle.rawValue();
        Pointer fileMapping = WinBase.CreateFileMapping(fHandle, null, prot = WindowsVirtualMemoryProvider.accessAsProt(access), sizeHi = (int)(nbytes.rawValue() >>> 32), sizeLo = (int)(nbytes.rawValue() & 0xFFFFFFFFFFFFFFFFL), null);
        if (fileMapping.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        int offsetHi = (int)(offset.rawValue() >>> 32);
        int offsetLo = (int)(offset.rawValue() & 0xFFFFFFFFFFFFFFFFL);
        Pointer addr = WinBase.MapViewOfFile(fileMapping, WindowsVirtualMemoryProvider.accessForMap(access), offsetHi, offsetLo, nbytes);
        return fileMapping.isNull() ? (Pointer)WordFactory.nullPointer() : addr;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase start, UnsignedWord nbytes, int access) {
        Pointer addr = WinBase.VirtualAlloc(start, nbytes, WinBase.MEM_COMMIT(), WindowsVirtualMemoryProvider.accessAsProt(access));
        return addr.isNull() ? (Pointer)WordFactory.nullPointer() : addr;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase start, UnsignedWord nbytes, int access) {
        CIntPointer oldProt = (CIntPointer)StackValue.get(CIntPointer.class);
        int result = WinBase.VirtualProtect(start, nbytes, WindowsVirtualMemoryProvider.accessAsProt(access), oldProt);
        return result != 0 ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int uncommit(PointerBase start, UnsignedWord nbytes) {
        int result = WinBase.VirtualFree(start, nbytes, WinBase.MEM_DECOMMIT());
        return result != 0 ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int free(PointerBase start, UnsignedWord nbytes) {
        return WinBase.VirtualFree(start, nbytes, WinBase.MEM_RELEASE());
    }
}

