/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.util.ModuleSupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ClassLoaderFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(JavaLangSubstitutions.ClassLoaderSupport.class, (Object)new JavaLangSubstitutions.ClassLoaderSupport());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JavaLangSubstitutions.ClassLoaderSupport.getInstance().createClassLoaders(ClassLoader.getSystemClassLoader());
        JavaLangSubstitutions.ClassLoaderSupport.getInstance().systemClassLoader = JavaLangSubstitutions.ClassLoaderSupport.getInstance().classLoaders.get(ClassLoader.getSystemClassLoader());
        JavaLangSubstitutions.ClassLoaderSupport.getInstance().platformClassLoader = JavaLangSubstitutions.ClassLoaderSupport.getInstance().classLoaders.get(ModuleSupport.getPlatformClassLoader());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(object -> {
            if (object instanceof ClassLoader) {
                JavaLangSubstitutions.ClassLoaderSupport.getInstance().createClassLoaders((ClassLoader)object);
                return JavaLangSubstitutions.ClassLoaderSupport.getInstance().classLoaders.get(object);
            }
            return object;
        });
    }
}

