/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.hosted.annotation.CustomSubstitutionField;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.GraalAccess;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public abstract class CustomSubstitutionType<F extends CustomSubstitutionField, M extends CustomSubstitutionMethod>
implements ResolvedJavaType,
OriginalClassProvider {
    protected final ResolvedJavaType original;
    protected final List<F> fields;
    protected final Map<ResolvedJavaMethod, M> methods;

    public CustomSubstitutionType(ResolvedJavaType original) {
        this.original = original;
        this.fields = new ArrayList<F>();
        this.methods = new HashMap<ResolvedJavaMethod, M>();
    }

    public ResolvedJavaType getOriginal() {
        return this.original;
    }

    public M getSubstitutionMethod(ResolvedJavaMethod method) {
        return (M)((CustomSubstitutionMethod)this.methods.get(method));
    }

    public F getSubstitutionField(ResolvedJavaField field) {
        assert (this.fields.size() > 0);
        for (CustomSubstitutionField f : this.fields) {
            if (!f.getName().equals(field.getName())) continue;
            return (F)f;
        }
        throw new IllegalArgumentException("No matching field foundf or " + field);
    }

    public void addSubstitutionMethod(ResolvedJavaMethod originalMethod, M substitution) {
        this.methods.put(originalMethod, substitution);
    }

    public void addSubstitutionField(F field) {
        this.fields.add(field);
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public boolean hasFinalizer() {
        return false;
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isInstanceClass() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isEnum() {
        return this.original.isEnum();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public boolean isInitialized() {
        return true;
    }

    public void initialize() {
        assert (this.isInitialized());
    }

    public boolean isLinked() {
        return true;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.original.isAssignableFrom(other);
    }

    public boolean isInstance(JavaConstant obj) {
        return this.original.isInstance(obj);
    }

    public ResolvedJavaType getSuperclass() {
        return this.original.getSuperclass();
    }

    public ResolvedJavaType[] getInterfaces() {
        return this.original.getInterfaces();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.original.findLeastCommonAncestor(otherType);
    }

    public ResolvedJavaType getSingleImplementor() {
        return this.original.getSingleImplementor();
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        return this.original.findLeafConcreteSubtype();
    }

    public ResolvedJavaType getComponentType() {
        return this.original.getComponentType();
    }

    public ResolvedJavaType getArrayClass() {
        return this.original.getArrayClass();
    }

    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return this.original.resolveConcreteMethod(method, callerType);
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return this.original.resolveMethod(method, callerType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return this.original.findUniqueConcreteMethod(method);
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return this.fields.toArray(new ResolvedJavaField[this.fields.size()]);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.original.getStaticFields();
    }

    public Annotation[] getAnnotations() {
        return this.original.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.original.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.original.getAnnotation(annotationClass);
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return null;
    }

    public String getSourceFileName() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public ResolvedJavaType getEnclosingType() {
        return null;
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return new ResolvedJavaMethod[0];
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.original.getDeclaredMethods();
    }

    public ResolvedJavaMethod getClassInitializer() {
        return null;
    }

    public boolean isCloneableWithAllocation() {
        throw JVMCIError.unimplemented();
    }

    public ResolvedJavaType getHostClass() {
        throw JVMCIError.unimplemented();
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)this.original);
    }
}

