/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.function.Consumer;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticFeature
class JNIRegistrationJavaNet
extends JNIRegistrationUtil
implements Feature {
    JNIRegistrationJavaNet() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.NetworkInterface", "java.net.DefaultInterface", "java.net.InetAddress", "java.net.Inet4AddressImpl", "java.net.Inet6AddressImpl", "java.net.SocketInputStream", "java.net.SocketOutputStream", "java.net.DatagramPacket", "java.net.AbstractPlainSocketImpl", "java.net.AbstractPlainDatagramSocketImpl");
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "java.net.PlainDatagramSocketImpl");
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl");
            }
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "java.net.TwoStacksPlainDatagramSocketImpl");
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.PlainSocketImpl");
            } else {
                JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "java.net.DualStackPlainSocketImpl", "java.net.TwoStacksPlainSocketImpl");
            }
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            JNIRegistrationJavaNet.rerunClassInit((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions", "sun.net.ext.ExtendedSocketOptions", "jdk.net.ExtendedSocketOptions$PlatformSocketOptions");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRegistrationJavaNet.registerForThrowNew((Feature.FeatureAccess)a, "java.net.SocketException", "java.net.ConnectException", "java.net.BindException", "java.net.UnknownHostException", "java.net.SocketTimeoutException", "java.net.PortUnreachableException", "sun.net.ConnectionResetException");
        Consumer<Feature.DuringAnalysisAccess> registerInitInetAddressIDs = JNIRegistrationJavaNet::registerInitInetAddressIDs;
        a.registerReachabilityHandler(registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet4Address", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.Inet6Address", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.nio.ch.IOUtil", "initIDs", new Class[0]), JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl"), JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl")});
        if (JNIRegistrationJavaNet.isPosix()) {
            a.registerReachabilityHandler(registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "initProto", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            String plainSocketImpl = JavaVersionUtil.JAVA_SPEC >= 11 ? "PlainSocketImpl" : "DualStackPlainSocketImpl";
            a.registerReachabilityHandler(registerInitInetAddressIDs, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainSocketImpl, "initIDs", new Class[0]), JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "initIDs", new Class[0])});
        }
        Consumer<Feature.DuringAnalysisAccess> registerNetworkInterfaceInit = JNIRegistrationJavaNet::registerNetworkInterfaceInit;
        a.registerReachabilityHandler(registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.NetworkInterface", "init", new Class[0])});
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDatagramPacketInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DatagramPacket", "init", new Class[0])});
        if (JNIRegistrationJavaNet.isPosix()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainDatagramSocketImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
            a.registerReachabilityHandler(registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainDatagramSocketImpl", "init", new Class[0])});
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainSocketImplInitProto, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.PlainSocketImpl", "initProto", new Class[0])});
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                a.registerReachabilityHandler(JNIRegistrationJavaNet::registerExtendedOptionsImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "sun.net.ExtendedOptionsImpl", "init", new Class[0])});
            }
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainDatagramSocketImplInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "initIDs", new Class[0])});
            a.registerReachabilityHandler(registerNetworkInterfaceInit, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl", "initIDs", new Class[0])});
            String plainSocketImpl = JavaVersionUtil.JAVA_SPEC >= 11 ? "PlainSocketImpl" : "DualStackPlainSocketImpl";
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlainSocketImplInitProto, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net." + plainSocketImpl, "initIDs", new Class[0])});
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            a.registerReachabilityHandler(JNIRegistrationJavaNet::registerPlatformSocketOptionsCreate, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "jdk.net.ExtendedSocketOptions$PlatformSocketOptions", "create", new Class[0])});
        }
    }

    private static void registerInitInetAddressIDs(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.InetAddress", "anyLocalAddress", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress", "holder", "preferIPv6Address"));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.InetAddressImpl")});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4AddressImpl", new Class[0])});
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl")});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6AddressImpl", new Class[0])});
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddress$InetAddressHolder", "address", "family", "hostName", "originalHostName"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InetAddressContainer", "addr"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InetSocketAddress", InetAddress.class, Integer.TYPE));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet4Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet4Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6Address"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.Inet6Address", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "holder6"));
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address", "cached_scope_id"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.Inet6Address$Inet6AddressHolder", "ipaddress", "scope_id", "scope_id_set", "scope_ifname"));
    }

    private static void registerNetworkInterfaceInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.NetworkInterface", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "name", "displayName", "index", "addrs", "bindings", "childs"));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "[Ljava.net.NetworkInterface;")});
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.NetworkInterface", "virtual", "parent", "defaultIndex"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, "java.net.InterfaceAddress", new Class[0]));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.InterfaceAddress", "address", "broadcast", "maskLength"));
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "[Ljava.net.InterfaceAddress;")});
    }

    private static void registerDatagramPacketInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramPacket", "address", "port", "buf", "offset", "length", "bufLength"));
    }

    private static void registerPlainDatagramSocketImplInit(Feature.DuringAnalysisAccess a) {
        a.registerReachabilityHandler(JNIRegistrationJavaNet::registerDatagramSocketImplPeekData, new Object[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)a, "java.net.DatagramSocket", "checkOldImpl", new Class[0])});
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainDatagramSocketImpl", "timeout", "trafficClass", "connected", "connectedAddress", "connectedPort"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl", "fd", "localPort"));
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.DualStackPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.TwoStacksPlainDatagramSocketImpl", "fd1", "fduse", "lastfd"));
        }
    }

    private static void registerDatagramSocketImplPeekData(Feature.DuringAnalysisAccess a) {
        a.registerSubtypeReachabilityHandler((access, clazz) -> {
            if (!Modifier.isAbstract(clazz.getModifiers())) {
                RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.method((Feature.FeatureAccess)access, clazz.getName(), "peekData", DatagramPacket.class)});
            }
        }, JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.DatagramSocketImpl"));
    }

    private static void registerPlainSocketImplInitProto(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.SocketImpl", "fd", "address", "port", "localport", "serverSocket"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "timeout", "trafficClass"));
        if (JNIRegistrationJavaNet.isPosix()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.AbstractPlainSocketImpl", "fdLock", "closePending"));
        }
        if (JNIRegistrationJavaNet.isWindows()) {
            JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "java.net.TwoStacksPlainSocketImpl", "fd1", "lastfd"));
        }
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.SocketInputStream"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "java.net.SocketOutputStream"));
    }

    private static void registerExtendedOptionsImplInit(Feature.DuringAnalysisAccess a) {
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow", "status", "priority", "bandwidth"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status"));
        JNIRuntimeAccess.register(JNIRegistrationJavaNet.fields((Feature.FeatureAccess)a, "jdk.net.SocketFlow$Status", "NO_STATUS", "OK", "NO_PERMISSION", "NOT_CONNECTED", "NOT_SUPPORTED", "ALREADY_CREATED", "IN_PROGRESS", "OTHER"));
    }

    private static void registerPlatformSocketOptionsCreate(Feature.DuringAnalysisAccess a) {
        String implClassName;
        assert (JavaVersionUtil.JAVA_SPEC >= 11);
        if (JNIRegistrationJavaNet.isLinux()) {
            implClassName = "jdk.net.LinuxSocketOptions";
        } else if (JNIRegistrationJavaNet.isDarwin()) {
            implClassName = "jdk.net.MacOSXSocketOptions";
        } else {
            if (JNIRegistrationJavaNet.isWindows()) {
                return;
            }
            throw VMError.shouldNotReachHere("Unexpected platform");
        }
        RuntimeReflection.register((Class[])new Class[]{JNIRegistrationJavaNet.clazz((Feature.FeatureAccess)a, implClassName)});
        RuntimeReflection.register((Executable[])new Executable[]{JNIRegistrationJavaNet.constructor((Feature.FeatureAccess)a, implClassName, new Class[0])});
    }
}

