/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFILibrary;
import com.oracle.truffle.nfi.NFIPreBindException;
import com.oracle.truffle.nfi.NFIRootNodeFactory;
import com.oracle.truffle.nfi.NativeSource;

class NFIRootNode
extends RootNode {
    @Node.Child
    DirectCallNode loadLibrary;
    @Node.Children
    LookupAndBindNode[] lookupAndBind;

    NFIRootNode(NFILanguage language, CallTarget loadLibrary, NativeSource source) {
        super((TruffleLanguage)language);
        this.loadLibrary = DirectCallNode.create((CallTarget)loadLibrary);
        this.lookupAndBind = new LookupAndBindNode[source.preBoundSymbolsLength()];
        for (int i = 0; i < this.lookupAndBind.length; ++i) {
            this.lookupAndBind[i] = NFIRootNodeFactory.LookupAndBindNodeGen.create(source.getPreBoundSymbol(i), source.getPreBoundSignature(i));
        }
    }

    public boolean isInternal() {
        return true;
    }

    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Object library = this.loadLibrary.call(new Object[0]);
        if (this.lookupAndBind.length == 0) {
            return library;
        }
        NFILibrary ret = new NFILibrary(library);
        for (LookupAndBindNode l : this.lookupAndBind) {
            ret.preBindSymbol(l.name, l.execute(library));
        }
        return ret;
    }

    static abstract class LookupAndBindNode
    extends Node {
        private final String name;
        private final String signature;

        LookupAndBindNode(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        abstract Object execute(Object var1);

        @Specialization(limit="1")
        Object doLookupAndBind(Object library, @CachedLibrary(value="library") InteropLibrary libInterop, @Cached.Shared(value="symInterop") @CachedLibrary(limit="1") InteropLibrary symInterop) {
            try {
                Object symbol = libInterop.readMember(library, this.name);
                return symInterop.invokeMember(symbol, "bind", new Object[]{this.signature});
            }
            catch (InteropException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIPreBindException(ex.getMessage(), this);
            }
        }
    }
}

