/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.nfi.Lexer;
import com.oracle.truffle.nfi.NativeSource;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.spi.types.NativeTypeMirror;
import com.oracle.truffle.nfi.spi.types.TypeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Parser
extends TypeFactory {
    private final Lexer lexer;

    static NativeSignature parseSignature(CharSequence source) {
        Parser parser = new Parser(source);
        NativeSignature ret = parser.parseSignature();
        parser.expect(Lexer.Token.EOF);
        return ret;
    }

    static NativeSource parseNFISource(CharSequence source) {
        Parser parser = new Parser(source);
        NativeSource ret = parser.parseNFISource();
        parser.expect(Lexer.Token.EOF);
        return ret;
    }

    private Parser(CharSequence source) {
        this.lexer = new Lexer(source);
    }

    private void expect(Lexer.Token token) {
        if (this.lexer.next() != token) {
            throw new IllegalArgumentException(String.format("unexpected token: expected '%s', but got '%s'", token.getName(), this.lexer.currentValue()));
        }
    }

    private NativeSource parseNFISource() {
        String nfiId = null;
        if (this.lexer.peek() == Lexer.Token.IDENTIFIER && this.lexer.peekValue().equalsIgnoreCase("with")) {
            this.lexer.next();
            if (this.lexer.next() != Lexer.Token.IDENTIFIER) {
                throw new IllegalArgumentException("Expecting NFI impementation identifier");
            }
            nfiId = this.lexer.currentValue();
        }
        NativeLibraryDescriptor descriptor = this.parseLibraryDescriptor();
        NativeSource ret = new NativeSource(nfiId, descriptor);
        if (this.lexer.next() == Lexer.Token.OPENBRACE) {
            Lexer.Token closeOrId;
            while ((closeOrId = this.lexer.next()) != Lexer.Token.CLOSEBRACE) {
                if (closeOrId != Lexer.Token.IDENTIFIER) {
                    throw new IllegalArgumentException("Expecting identifier in library body");
                }
                String ident = this.lexer.currentValue();
                this.lexer.mark();
                this.parseSignature();
                ret.register(ident, this.lexer.markedValue());
                if (this.lexer.next() == Lexer.Token.SEMICOLON) continue;
                throw new IllegalArgumentException("Expecting semicolon");
            }
        }
        return ret;
    }

    private NativeLibraryDescriptor parseLibraryDescriptor() {
        Lexer.Token token = this.lexer.next();
        String keyword = this.lexer.currentValue();
        if (token == Lexer.Token.IDENTIFIER) {
            switch (keyword) {
                case "load": {
                    return this.parseLoadLibrary();
                }
                case "default": {
                    return Parser.createDefaultLibrary();
                }
            }
        }
        throw new IllegalArgumentException(String.format("expected 'load' or 'default', but got '%s'", keyword));
    }

    private String parseIdentOrString() {
        if (this.lexer.peek() == Lexer.Token.IDENTIFIER) {
            this.lexer.next();
        } else {
            this.expect(Lexer.Token.STRING);
        }
        return this.lexer.currentValue();
    }

    private NativeLibraryDescriptor parseLoadLibrary() {
        List<String> flags = null;
        if (this.lexer.peek() == Lexer.Token.OPENPAREN) {
            flags = this.parseFlags();
        }
        String filename = this.parseIdentOrString();
        return Parser.createLibraryDescriptor(filename, flags);
    }

    private List<String> parseFlags() {
        Lexer.Token nextToken;
        this.expect(Lexer.Token.OPENPAREN);
        ArrayList<String> flags = new ArrayList<String>();
        do {
            this.expect(Lexer.Token.IDENTIFIER);
            flags.add(this.lexer.currentValue());
        } while ((nextToken = this.lexer.next()) == Lexer.Token.OR);
        if (nextToken != Lexer.Token.CLOSEPAREN) {
            throw new IllegalArgumentException(String.format("unexpected token: expected '|' or ')', but got '%s'", this.lexer.currentValue()));
        }
        return flags;
    }

    private NativeTypeMirror parseType() {
        switch (this.lexer.peek()) {
            case OPENPAREN: {
                return Parser.createFunctionTypeMirror(this.parseSignature());
            }
            case OPENBRACKET: {
                return this.parseArrayType();
            }
            case IDENTIFIER: {
                return this.parseSimpleType(true);
            }
        }
        throw new IllegalArgumentException(String.format("expected type, but got '%s'", this.lexer.currentValue()));
    }

    private NativeSignature parseSignature() {
        List<Object> args;
        this.expect(Lexer.Token.OPENPAREN);
        int fixedArgCount = -1;
        if (this.lexer.peek() == Lexer.Token.CLOSEPAREN) {
            this.lexer.next();
            args = Collections.emptyList();
        } else {
            Lexer.Token nextToken;
            args = new ArrayList();
            do {
                if (this.lexer.peek() == Lexer.Token.ELLIPSIS) {
                    this.lexer.next();
                    fixedArgCount = args.size();
                }
                args.add(this.parseType());
            } while ((nextToken = this.lexer.next()) == Lexer.Token.COMMA);
            if (nextToken != Lexer.Token.CLOSEPAREN) {
                throw new IllegalArgumentException(String.format("unexpected token: expected ',' or ')', but got '%s'", this.lexer.currentValue()));
            }
        }
        this.expect(Lexer.Token.COLON);
        NativeTypeMirror retType = this.parseType();
        if (fixedArgCount >= 0) {
            return Parser.createVarargsSignature(retType, fixedArgCount, args);
        }
        return Parser.createSignature(retType, args);
    }

    private NativeTypeMirror parseArrayType() {
        this.expect(Lexer.Token.OPENBRACKET);
        NativeTypeMirror elementType = this.parseSimpleType(false);
        this.expect(Lexer.Token.CLOSEBRACKET);
        return Parser.createArrayTypeMirror(elementType);
    }

    private NativeTypeMirror parseSimpleType(boolean envAllowed) {
        this.expect(Lexer.Token.IDENTIFIER);
        String identifier = this.lexer.currentValue();
        if (envAllowed && "env".equalsIgnoreCase(identifier)) {
            return Parser.createEnvTypeMirror();
        }
        NativeSimpleType simpleType = NativeSimpleType.valueOf(identifier.toUpperCase());
        return Parser.createSimpleTypeMirror(simpleType);
    }
}

