/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import org.graalvm.component.installer.InstallerStopException;

public class DependencyException
extends InstallerStopException {
    private static final long serialVersionUID = 1L;
    private final String component;
    private final String version;
    private final String installedVersion;

    public DependencyException(String component, String version, String installedVersion, String message) {
        super(message);
        this.component = component;
        this.version = version;
        this.installedVersion = installedVersion;
    }

    public DependencyException(String component, String version, String message) {
        super(message);
        this.component = component;
        this.version = version;
        this.installedVersion = null;
    }

    public String getComponent() {
        return this.component;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public static class Mismatch
    extends DependencyException {
        private static final long serialVersionUID = 1L;
        private final String capability;

        public Mismatch(String component, String capability, String version, String installedVersion, String message) {
            super(component, version, installedVersion, message);
            this.capability = capability;
        }

        public String getCapability() {
            return this.capability;
        }
    }

    public static class Conflict
    extends DependencyException {
        private static final long serialVersionUID = 1L;

        public Conflict(String component, String version, String installedVersion, String message) {
            super(component, version, installedVersion, message);
        }
    }
}

