/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.concurrent.Callable;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.os.DefaultFileOperations;
import org.graalvm.component.installer.os.WindowsFileOperations;

public abstract class FileOperations {
    private Feedback feedback;
    private Path rootPath;

    public void init(Feedback fb) {
        this.feedback = fb;
    }

    protected final Feedback feedback() {
        return this.feedback;
    }

    protected final Path rootPath() {
        return this.rootPath;
    }

    public abstract boolean flush() throws IOException;

    public Path materialize(Path p, boolean write) {
        return p;
    }

    protected void performDelete(Path p) throws IOException {
        Files.deleteIfExists(p);
    }

    protected abstract boolean doWithPermissions(Path var1, Callable<Void> var2) throws IOException;

    protected void handleUndeletableFile(IOException ex, Path p) throws IOException {
        throw ex;
    }

    protected Path handleUnmodifiableFile(IOException ex, Path p, InputStream content) throws IOException {
        throw ex;
    }

    private void deleteOneFile(Path p, Path rp) throws IOException {
        try {
            if (p.equals(rp)) {
                return;
            }
            this.performDelete(p);
        }
        catch (AccessDeniedException ex) {
            if (!this.doWithPermissions(p, () -> {
                this.performDelete(p);
                return null;
            })) {
                throw ex;
            }
        }
        catch (FileSystemException ex) {
            this.handleUndeletableFile(ex, p);
        }
    }

    public void deleteFile(Path p) throws IOException {
        this.deleteOneFile(p, this.rootPath);
    }

    protected void performInstall(Path target, InputStream contents) throws IOException {
        Files.copy(contents, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public Path installFile(Path target, InputStream contents) throws IOException {
        Path ret = target;
        try {
            this.performInstall(target, contents);
        }
        catch (AccessDeniedException ex) {
            this.doWithPermissions(target, () -> {
                this.performInstall(target, contents);
                return null;
            });
        }
        catch (FileSystemException ex) {
            ret = this.handleUnmodifiableFile(ex, target, contents);
        }
        return ret;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(Path rootPath) {
        this.rootPath = rootPath;
    }

    public abstract void setPermissions(Path var1, Set<PosixFilePermission> var2) throws IOException;

    public static FileOperations createPlatformInstance(Feedback f, Path rootPath) {
        FileOperations inst;
        if (SystemUtils.isWindows()) {
            WindowsFileOperations w = new WindowsFileOperations();
            inst = w;
            w.setDelayDeletedList(SystemUtils.fromUserString(System.getenv("GU_POST_DELETE_LIST")));
            w.setCopyContents(SystemUtils.fromUserString(System.getenv("GU_POST_COPY_CONTENTS")));
        } else {
            inst = new DefaultFileOperations();
        }
        inst.init(f);
        inst.setRootPath(rootPath);
        return inst;
    }
}

